/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.commands.StopGatewaySenderOnMemberWithBeanImpl;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class StopGatewaySenderCommand
extends GfshCommand {
    private final ExecutorService executorService;
    private final StopGatewaySenderOnMember stopperOnMember;

    public StopGatewaySenderCommand() {
        this(LoggingExecutors.newCachedThreadPool((String)"Stop Sender Command Thread ", (boolean)true), new StopGatewaySenderOnMemberWithBeanImpl());
    }

    @VisibleForTesting
    StopGatewaySenderCommand(ExecutorService executorService, StopGatewaySenderOnMember stopperOnMember) {
        this.executorService = executorService;
        this.stopperOnMember = stopperOnMember;
    }

    @ShellMethod(value="Stop the Gateway Sender on a member or members.", key={"stop gateway-sender"})
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.GATEWAY)
    public ResultModel stopGatewaySender(@ShellOption(value={"id"}, help="ID of the Gateway Sender.") String senderId, @ShellOption(value={"group", "groups"}, help="Group(s) of members on which to stop the Gateway Sender.") String[] onGroup, @ShellOption(value={"member", "members"}, help="Name/Id of the member on which to stop the Gateway Sender.") String[] onMember) {
        if (senderId == null) {
            return ResultModel.createError("You must specify a gateway sender id.");
        }
        Set<DistributedMember> dsMembers = this.findMembers(onGroup, onMember);
        if (dsMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        return this.executeStopGatewaySender(senderId.trim(), this.getCache(), dsMembers);
    }

    public ResultModel executeStopGatewaySender(String id, Cache cache, Set<DistributedMember> dsMembers) {
        List<Future<List<String>>> futures;
        ArrayList<DistributedMember> dsMembersList = new ArrayList<DistributedMember>(dsMembers);
        ArrayList<Callable<List>> callables = new ArrayList<Callable<List>>();
        for (DistributedMember member : dsMembersList) {
            callables.add(() -> this.stopperOnMember.executeStopGatewaySenderOnMember(id, cache, (SystemManagementService)this.getManagementService(), member));
        }
        try {
            futures = this.executorService.invokeAll(callables);
        }
        catch (InterruptedException ite) {
            Thread.currentThread().interrupt();
            return ResultModel.createError(CliStrings.format((String)"Could not invoke stop gateway sender {0} operation on members due to {1}", (Object[])new Object[]{id, ite.getMessage()}));
        }
        return this.buildResultModelFromMembersResponses(id, dsMembersList, futures);
    }

    private ResultModel buildResultModelFromMembersResponses(String id, List<DistributedMember> dsMembers, List<Future<List<String>>> futures) {
        ResultModel resultModel = new ResultModel();
        TabularResultModel resultData = resultModel.addTable("stop gateway-sender");
        Iterator<DistributedMember> memberIterator = dsMembers.iterator();
        for (Future<List<String>> future : futures) {
            DistributedMember member = memberIterator.next();
            try {
                List<String> memberStatus = future.get();
                resultData.addMemberStatusResultRow(memberStatus.get(0), memberStatus.get(1), memberStatus.get(2));
            }
            catch (InterruptedException | ExecutionException ite) {
                resultData.addMemberStatusResultRow(member.getId(), "Error", CliStrings.format((String)"Could not stop gateway sender {0} on member due to {1}", (Object[])new Object[]{id, ite.getMessage()}));
            }
        }
        return resultModel;
    }

    @FunctionalInterface
    static interface StopGatewaySenderOnMember {
        public List<String> executeStopGatewaySenderOnMember(String var1, Cache var2, SystemManagementService var3, DistributedMember var4);
    }
}

