/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Set;
import javax.management.ObjectName;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.GatewayReceiverMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class StopGatewayReceiverCommand
extends GfshCommand {
    @ShellMethod(value="Stop the Gateway Receiver on a member or members.", key={"stop gateway-receiver"})
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.GATEWAY)
    public ResultModel stopGatewayReceiver(@ShellOption(value={"group", "groups"}, help="Group(s) of members on which to stop the Gateway Receiver.") String[] onGroup, @ShellOption(value={"member", "members"}, help="Name/Id of the member on which to stop the Gateway Receiver.") String[] onMember) throws Exception {
        SystemManagementService service = (SystemManagementService)this.getManagementService();
        Set<DistributedMember> dsMembers = this.findMembers(onGroup, onMember);
        if (dsMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        ResultModel resultModel = new ResultModel();
        TabularResultModel resultData = resultModel.addTable("stop gateway-receiver");
        for (DistributedMember member : dsMembers) {
            ObjectName gatewayReceiverObjectName = MBeanJMXAdapter.getGatewayReceiverMBeanName((DistributedMember)member);
            if (gatewayReceiverObjectName != null) {
                GatewayReceiverMXBean receiverBean = (GatewayReceiverMXBean)service.getMBeanProxy(gatewayReceiverObjectName, GatewayReceiverMXBean.class);
                if (receiverBean != null) {
                    if (receiverBean.isRunning()) {
                        receiverBean.stop();
                        resultData.addMemberStatusResultRow(member.getId(), "OK", CliStrings.format((String)"GatewayReceiver is stopped on member {0}", (Object[])new Object[]{member.getId()}));
                        continue;
                    }
                    resultData.addMemberStatusResultRow(member.getId(), "Error", CliStrings.format((String)"GatewayReceiver is not running on member {0}", (Object[])new Object[]{member.getId()}));
                    continue;
                }
                resultData.addMemberStatusResultRow(member.getId(), "Error", CliStrings.format((String)"GatewayReceiver is not available on member {0}", (Object[])new Object[]{member.getId()}));
                continue;
            }
            resultData.addMemberStatusResultRow(member.getId(), "Error", CliStrings.format((String)"GatewayReceiver is not available on member {0}", (Object[])new Object[]{member.getId()}));
        }
        return resultModel;
    }
}

