/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Set;
import javax.management.ObjectName;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.GatewayReceiverMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class StatusGatewayReceiverCommand
extends GfshCommand {
    @ShellMethod(value="Display the status of a Gateway Receiver.", key={"status gateway-receiver"})
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel statusGatewayReceiver(@ShellOption(value={"group", "groups"}, help="Group(s) of Gateway Receivers for which to display status.") String[] onGroup, @ShellOption(value={"member", "members"}, help="Name/Id of the Gateway Receiver for which to display status.") String[] onMember) {
        SystemManagementService service = (SystemManagementService)this.getManagementService();
        Set<DistributedMember> dsMembers = this.findMembers(onGroup, onMember);
        if (dsMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        ResultModel crd = new ResultModel();
        TabularResultModel availableReceiverData = crd.addTable("Available GatewayReceiver Section");
        TabularResultModel notAvailableReceiverData = crd.addTable("Not Available GatewayReceiver Section");
        for (DistributedMember member : dsMembers) {
            GatewayReceiverMXBean receiverBean;
            ObjectName gatewayReceiverObjectName = MBeanJMXAdapter.getGatewayReceiverMBeanName((DistributedMember)member);
            if (gatewayReceiverObjectName != null && (receiverBean = (GatewayReceiverMXBean)service.getMBeanProxy(gatewayReceiverObjectName, GatewayReceiverMXBean.class)) != null) {
                this.buildReceiverStatus(member.getId(), receiverBean, availableReceiverData);
                continue;
            }
            this.buildReceiverStatus(member.getId(), null, notAvailableReceiverData);
        }
        return crd;
    }

    private TabularResultModel buildReceiverStatus(String memberId, GatewayReceiverMXBean bean, TabularResultModel resultData) {
        resultData.accumulate("Member", memberId);
        if (bean != null) {
            resultData.accumulate("Port", Integer.toString(bean.getPort()));
            resultData.accumulate("Status", bean.isRunning() ? "Running" : "Not Running");
        } else {
            resultData.accumulate("Error", "GatewayReceiver is not available or already stopped");
        }
        return resultData;
    }
}

