/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.commands.OfflineGfshCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class SetVariableCommand
extends OfflineGfshCommand {
    @ShellMethod(value="Set GFSH variables that can be used by commands. For example: if variable \"CACHE_SERVERS_GROUP\" is set then to use it with \"list members\", use \"list members --group=${CACHE_SERVERS_GROUP}\". The \"echo\" command can be used to know the value of a variable.", key={"set variable"})
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH"})
    public ResultModel setVariable(@ShellOption(value={"name"}, help="Name for the variable. Name must only be composed of letters, numbers and the \"_\" character and may not start with a number.") String var, @ShellOption(value={"value"}, help="Value that the variable will be set to.") String value) {
        this.getGfsh().setEnvProperty(var, String.valueOf(value));
        return ResultModel.createInfo("Value for variable " + var + " is now: " + value + ".");
    }
}

