/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.functions.ResumeAsyncEventQueueDispatcherFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class ResumeAsyncEventQueueDispatcherCommand
extends GfshCommand {
    @ShellMethod(value="Resume the processing of the events in the Async Event Queue on a member or members.", key={"resume async-event-queue-dispatcher"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel resumeAsyncEventQueueDispatcher(@ShellOption(value={"id"}, help="ID of the Async Event Queue.") String queueId, @ShellOption(value={"group", "groups"}, help="Group(s) of members on which to resume processing of the events.") String[] onGroup, @ShellOption(value={"member", "members"}, help="Name/Id of the member on which to resume processing of the events.") String[] onMember) {
        if (queueId != null) {
            queueId = queueId.trim();
        }
        Set<DistributedMember> targetMembers = this.findMembers(onGroup, onMember);
        List<CliFunctionResult> results = this.executeAndGetFunctionResult((Function<?>)new ResumeAsyncEventQueueDispatcherFunction(), queueId, targetMembers);
        return this.constructResultModel(results);
    }

    ResultModel constructResultModel(List<CliFunctionResult> results) {
        return ResultModel.createMemberStatusResult(results);
    }
}

