/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.commands.DataCommandsUtils;
import org.apache.geode.management.internal.cli.domain.DataCommandRequest;
import org.apache.geode.management.internal.cli.domain.DataCommandResult;
import org.apache.geode.management.internal.cli.functions.DataCommandFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class PutCommand
extends GfshCommand {
    @CliMetaData(relatedTopic={"Data", "Region"})
    @ShellMethod(value="Add/Update an entry in a region. If using a region whose key and value classes have been set, then specifying --key-class and --value-class is unnecessary.", key={"put"})
    public ResultModel put(@ShellOption(value={"key"}, help="String or JSON text from which to create the key.  Examples include: \"James\", \"100L\" and \"('id': 'l34s')\".") String key, @ShellOption(value={"value"}, help="String or JSON text from which to create the value.  Examples include: \"manager\", \"100L\" and \"('value': 'widget')\".") String value, @ShellOption(value={"region"}, help="Region into which the entry will be put.") String regionPath, @ShellOption(value={"key-class"}, help="Fully qualified class name of the key's type. The default is java.lang.String.") String keyClass, @ShellOption(value={"value-class"}, help="Fully qualified class name of the value's type. The default is java.lang.String.") String valueClass, @ShellOption(value={"skip-if-exists"}, help="(Deprecated: Use --if-not-exists). Skip the put operation when an entry with the same key already exists. The default is to overwrite the entry (false).", defaultValue="false") boolean putIfAbsent, @ShellOption(value={"if-not-exists"}, help="Skip the put operation when an entry with the same key already exists. The default is to overwrite the entry (false).", defaultValue="false") boolean putIfNotExists) {
        DataCommandResult dataResult;
        Cache cache = this.getCache();
        this.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionPath);
        key = DataCommandsUtils.makeBrokenJsonCompliant(key);
        value = DataCommandsUtils.makeBrokenJsonCompliant(value);
        LogService.getLogger().info("Cache instance for put: " + cache.toString());
        Region region = cache.getRegion(regionPath);
        DataCommandFunction putfn = new DataCommandFunction();
        if (region == null) {
            Set<DistributedMember> memberList = this.findAnyMembersForRegion(regionPath);
            if (CollectionUtils.isNotEmpty(memberList)) {
                DataCommandRequest request = new DataCommandRequest();
                request.setCommand("put");
                request.setValue(value);
                request.setKey(key);
                request.setKeyClass(keyClass);
                request.setRegionName(regionPath);
                request.setValueClass(valueClass);
                request.setPutIfAbsent(putIfNotExists || putIfAbsent);
                dataResult = DataCommandsUtils.callFunctionForRegion(request, putfn, memberList);
            } else {
                dataResult = DataCommandResult.createPutInfoResult(key, value, null, CliStrings.format((String)"Region <{0}> not found in any of the members", (Object)regionPath), false);
            }
        } else {
            dataResult = putfn.put(key, value, putIfNotExists || putIfAbsent, keyClass, valueClass, regionPath, (InternalCache)cache);
        }
        dataResult.setKeyClass(keyClass);
        if (valueClass != null) {
            dataResult.setValueClass(valueClass);
        }
        return dataResult.toResultModel();
    }
}

