/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.commands.DataCommandsUtils;
import org.apache.geode.management.internal.cli.domain.DataCommandRequest;
import org.apache.geode.management.internal.cli.domain.DataCommandResult;
import org.apache.geode.management.internal.cli.functions.DataCommandFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class LocateEntryCommand
extends GfshCommand {
    @CliMetaData(relatedTopic={"Data", "Region"})
    @ShellMethod(value="Identifies the location, including host, member and region, of entries that have the specified key.", key={"locate entry"})
    public ResultModel locateEntry(@ShellOption(value={"key"}, help="String or JSON text from which to create a key.  Examples include: \"James\", \"100L\" and \"('id': 'l34s')\".") String key, @ShellOption(value={"region"}, help="Region in which to locate values.") String regionPath, @ShellOption(value={"key-class"}, help="Fully qualified class name of the key's type. The default is java.lang.String.") String keyClass, @ShellOption(value={"value-class"}, help="Fully qualified class name of the value's type. The default is java.lang.String.") String valueClass, @ShellOption(value={"recursive"}, help="Whether to traverse regions and subregions recursively.", defaultValue="false") boolean recursive) {
        DataCommandResult dataResult;
        this.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionPath, key);
        key = DataCommandsUtils.makeBrokenJsonCompliant(key);
        DataCommandFunction locateEntry = new DataCommandFunction();
        Set<DistributedMember> memberList = this.findMembersForRegion(regionPath);
        if (CollectionUtils.isNotEmpty(memberList)) {
            DataCommandRequest request = new DataCommandRequest();
            request.setCommand("locate entry");
            request.setKey(key);
            request.setKeyClass(keyClass);
            request.setRegionName(regionPath);
            request.setValueClass(valueClass);
            request.setRecursive(recursive);
            dataResult = DataCommandsUtils.callFunctionForRegion(request, locateEntry, memberList);
        } else {
            dataResult = DataCommandResult.createLocateEntryInfoResult(key, null, null, CliStrings.format((String)"Region <{0}> not found in any of the members", (Object)regionPath), false);
        }
        dataResult.setKeyClass(keyClass);
        if (valueClass != null) {
            dataResult.setValueClass(valueClass);
        }
        return dataResult.toResultModel();
    }
}

