/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.management.ObjectName;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.GatewayReceiverMXBean;
import org.apache.geode.management.GatewaySenderMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class ListGatewayCommand
extends GfshCommand {
    @ShellMethod(value="Display the Gateway Senders and Receivers for a member or members.", key={"list gateways"})
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel listGateway(@ShellOption(value={"member", "members"}, help="Member(s) for which Gateway Senders and Receivers will be displayed.") String[] onMember, @ShellOption(value={"group", "groups"}, help="Group(s) of members for which Gateway Senders and Receivers will be displayed.") String[] onGroup, @ShellOption(value={"receivers-only"}, defaultValue="false", help="Display gateway receivers only.") boolean showReceiversOnly, @ShellOption(value={"senders-only"}, defaultValue="false", help="Display gateway senders only.") boolean showSendersOnly) throws Exception {
        if (showReceiversOnly && showSendersOnly) {
            return ResultModel.createError("Options --senders-only and --receivers-only cannot be used together.");
        }
        ResultModel result = new ResultModel();
        SystemManagementService service = (SystemManagementService)this.getManagementService();
        Set<DistributedMember> dsMembers = this.findMembers(onGroup, onMember);
        if (dsMembers.isEmpty()) {
            return ResultModel.createInfo("No Members Found");
        }
        TreeMap<String, Map<String, GatewaySenderMXBean>> gatewaySenderBeans = new TreeMap<String, Map<String, GatewaySenderMXBean>>();
        TreeMap<String, GatewayReceiverMXBean> gatewayReceiverBeans = new TreeMap<String, GatewayReceiverMXBean>();
        DistributedSystemMXBean dsMXBean = service.getDistributedSystemMXBean();
        for (DistributedMember member : dsMembers) {
            GatewayReceiverMXBean receiverBean;
            ObjectName gatewayReceiverObjectName;
            ObjectName[] gatewaySenderObjectNames;
            String memberNameOrId;
            String memberName = member.getName();
            String string = memberNameOrId = memberName != null && !memberName.isEmpty() ? memberName : member.getId();
            if (!showReceiversOnly && (gatewaySenderObjectNames = dsMXBean.listGatewaySenderObjectNames(memberNameOrId)) != null) {
                for (ObjectName name : gatewaySenderObjectNames) {
                    Map<String, GatewaySenderMXBean> memberToBeanMap;
                    GatewaySenderMXBean senderBean = (GatewaySenderMXBean)service.getMBeanProxy(name, GatewaySenderMXBean.class);
                    if (senderBean == null) continue;
                    if (gatewaySenderBeans.containsKey(senderBean.getSenderId())) {
                        memberToBeanMap = (Map)gatewaySenderBeans.get(senderBean.getSenderId());
                        memberToBeanMap.put(member.getId(), senderBean);
                        continue;
                    }
                    memberToBeanMap = new TreeMap<String, GatewaySenderMXBean>();
                    memberToBeanMap.put(member.getId(), senderBean);
                    gatewaySenderBeans.put(senderBean.getSenderId(), memberToBeanMap);
                }
            }
            if (showSendersOnly || (gatewayReceiverObjectName = MBeanJMXAdapter.getGatewayReceiverMBeanName((DistributedMember)member)) == null || (receiverBean = (GatewayReceiverMXBean)service.getMBeanProxy(gatewayReceiverObjectName, GatewayReceiverMXBean.class)) == null) continue;
            gatewayReceiverBeans.put(member.getId(), receiverBean);
        }
        if (gatewaySenderBeans.isEmpty() && gatewayReceiverBeans.isEmpty()) {
            return ResultModel.createInfo("GatewaySenders or GatewayReceivers are not available in cluster");
        }
        this.accumulateListGatewayResult(result, gatewaySenderBeans, gatewayReceiverBeans);
        return result;
    }

    static String getStatus(GatewaySenderMXBean mbean) {
        if (!mbean.isRunning()) {
            return "Not Running";
        }
        if (mbean.isPaused()) {
            return "Paused";
        }
        if (mbean.isConnected()) {
            return "Running and Connected";
        }
        return "Running, not Connected";
    }

    protected void accumulateListGatewayResult(ResultModel result, Map<String, Map<String, GatewaySenderMXBean>> gatewaySenderBeans, Map<String, GatewayReceiverMXBean> gatewayReceiverBeans) {
        TabularResultModel gatewaySenders;
        if (!gatewaySenderBeans.isEmpty()) {
            gatewaySenders = result.addTable("gatewaySenders");
            gatewaySenders.setHeader("GatewaySender Section");
            for (Map.Entry<String, Map<String, GatewaySenderMXBean>> entry : gatewaySenderBeans.entrySet()) {
                for (Map.Entry<String, GatewaySenderMXBean> memberToBean : entry.getValue().entrySet()) {
                    gatewaySenders.accumulate("GatewaySender Id", entry.getKey());
                    gatewaySenders.accumulate("Member", memberToBean.getKey());
                    gatewaySenders.accumulate("Remote Cluster Id", "" + memberToBean.getValue().getRemoteDSId());
                    gatewaySenders.accumulate("Type", memberToBean.getValue().isParallel() ? "Parallel" : "Serial");
                    gatewaySenders.accumulate("Status", ListGatewayCommand.getStatus(memberToBean.getValue()));
                    gatewaySenders.accumulate("Queued Events", "" + memberToBean.getValue().getEventQueueSize());
                    gatewaySenders.accumulate("Receiver Location", memberToBean.getValue().getGatewayReceiver());
                }
            }
        }
        if (!gatewayReceiverBeans.isEmpty()) {
            gatewaySenders = result.addTable("gatewayReceivers");
            gatewaySenders.setHeader("GatewayReceiver Section");
            for (Map.Entry<String, Map<String, GatewaySenderMXBean>> entry : gatewayReceiverBeans.entrySet()) {
                gatewaySenders.accumulate("Member", entry.getKey());
                gatewaySenders.accumulate("Port", "" + ((GatewayReceiverMXBean)entry.getValue()).getPort());
                gatewaySenders.accumulate("Sender Count", "" + ((GatewayReceiverMXBean)entry.getValue()).getClientConnectionCount());
                if (entry.getValue() == null || ((GatewayReceiverMXBean)entry.getValue()).getConnectedGatewaySenders() == null) {
                    gatewaySenders.accumulate("Senders Connected", "");
                    continue;
                }
                gatewaySenders.accumulate("Senders Connected", Arrays.stream(((GatewayReceiverMXBean)entry.getValue()).getConnectedGatewaySenders()).collect(Collectors.joining(", ")));
            }
        }
    }
}

