/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.domain.AsyncEventQueueDetails;
import org.apache.geode.management.internal.cli.functions.ListAsyncEventQueuesFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;

public class ListAsyncEventQueuesCommand
extends GfshCommand {
    private static final String[] DETAILS_OUTPUT_COLUMNS = new String[]{"Member", "ID", "Batch Size", "Persistent", "Disk Store", "Max Memory", "Listener", "Created with paused event processing", "Currently Paused"};
    private static final String ASYNC_EVENT_QUEUES_TABLE_SECTION = "Async Event Queues";
    private static final String MEMBER_ERRORS_TABLE_SECTION = "Member Errors";

    @ShellMethod(value="Display the Async Event Queues for all members.", key={"list async-event-queues"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel listAsyncEventQueues() {
        Set<DistributedMember> targetMembers = this.getAllNormalMembers();
        if (targetMembers.isEmpty()) {
            return ResultModel.createInfo("No Members Found");
        }
        List<CliFunctionResult> results = this.executeAndGetFunctionResult((Function<?>)new ListAsyncEventQueuesFunction(), new Object[0], targetMembers);
        ResultModel result = this.buildAsyncEventQueueInfo(results);
        if (results.stream().anyMatch(r -> !r.isSuccessful())) {
            TabularResultModel errors = result.addTable(MEMBER_ERRORS_TABLE_SECTION);
            errors.setColumnHeader("Member", "Error");
            results.stream().filter(r -> !r.isSuccessful()).forEach(errorResult -> errors.addRow(errorResult.getMemberIdOrName(), errorResult.getStatusMessage()));
        }
        return result;
    }

    private ResultModel buildAsyncEventQueueInfo(List<CliFunctionResult> results) {
        if (results.stream().filter(CliFunctionResult::isSuccessful).noneMatch(r -> {
            List resultObject = (List)r.getResultObject();
            return resultObject.size() > 0;
        })) {
            return ResultModel.createInfo("No Async Event Queues Found");
        }
        ResultModel result = new ResultModel();
        TabularResultModel detailsTable = result.addTable(ASYNC_EVENT_QUEUES_TABLE_SECTION);
        detailsTable.setColumnHeader(DETAILS_OUTPUT_COLUMNS);
        results.stream().filter(CliFunctionResult::isSuccessful).forEach(successfulResult -> {
            String memberName = successfulResult.getMemberIdOrName();
            List resultObject = (List)successfulResult.getResultObject();
            resultObject.forEach(entry -> detailsTable.addRow(memberName, entry.getId(), String.valueOf(entry.getBatchSize()), String.valueOf(entry.isPersistent()), String.valueOf(entry.getDiskStoreName()), String.valueOf(entry.getMaxQueueMemory()), this.getListenerEntry((AsyncEventQueueDetails)entry), String.valueOf(entry.isCreatedWithPausedEventProcessing()), String.valueOf(entry.isPausedEventProcessing())));
        });
        return result;
    }

    private String getListenerEntry(AsyncEventQueueDetails entry) {
        return entry.getListener() + ListAsyncEventQueuesCommand.propertiesToString(entry.getListenerProperties());
    }

    static String propertiesToString(Properties props) {
        if (props == null || props.isEmpty()) {
            return "";
        }
        ObjectMapper mapper = new ObjectMapper();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            mapper.writeValue((OutputStream)baos, (Object)props);
        }
        catch (IOException e) {
            return e.getMessage();
        }
        return baos.toString();
    }
}

