/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.CliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.functions.UserFunctionExecution;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.shiro.subject.Subject;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class ExecuteFunctionCommand
extends GfshCommand {
    @ShellMethod(value="Execute the function with the specified ID. By default will execute on all members.", key={"execute function"})
    @CliMetaData(relatedTopic={"Function Execution"}, interceptor="org.apache.geode.management.internal.cli.commands.ExecuteFunctionCommand$ExecuteFunctionCommandInterceptor")
    public ResultModel executeFunction(@ShellOption(value={"id"}, help="ID of the function to execute.") String functionId, @ShellOption(value={"group", "groups"}, help="Groups of members on which the function will be executed.") String[] onGroups, @ShellOption(value={"member", "members"}, help="Name/Id of the member on which the function will be executed.") String[] onMembers, @ShellOption(value={"region"}, help="Region on which the data dependent function will be executed.") String onRegion, @ShellOption(value={"arguments"}, help="Arguments to the function in comma separated String format.") String[] arguments, @ShellOption(value={"result-collector"}, help="Fully qualified class name of the ResultCollector to instantiate for gathering results.") String resultCollector, @ShellOption(value={"filter"}, help="Key list which causes the function to only be executed on members which have entries with these keys.") String filterString) {
        ResultModel resultModel = new ResultModel();
        TabularResultModel resultTable = resultModel.addTable("Table1");
        String headerText = "Execution summary";
        resultTable.setHeader(headerText);
        Set<DistributedMember> dsMembers = onRegion == null ? this.findMembers(onGroups, onMembers) : this.findAnyMembersForRegion(onRegion);
        if (dsMembers.size() == 0) {
            return ResultModel.createError("No members found.");
        }
        Object[] args = new Object[6];
        args[0] = functionId;
        if (filterString != null) {
            args[1] = filterString;
        }
        if (resultCollector != null) {
            args[2] = resultCollector;
        }
        if (arguments != null && arguments.length > 0) {
            args[3] = "";
            for (String str : arguments) {
                if (str == null) continue;
                args[3] = String.valueOf(args[3]) + str + ",";
            }
        }
        args[4] = onRegion;
        Subject currentUser = this.getSubject();
        args[5] = currentUser != null ? currentUser.getSession().getAttribute((Object)"credentials") : null;
        List<CliFunctionResult> results = this.executeAndGetFunctionResult((Function<?>)new UserFunctionExecution(), args, dsMembers);
        return ResultModel.createMemberStatusResult(results, false, false);
    }

    public static class ExecuteFunctionCommandInterceptor
    implements CliAroundInterceptor {
        @Override
        public ResultModel preExecution(GfshParseResult parseResult) {
            String onRegion = parseResult.getParamValueAsString("region");
            String onMember = parseResult.getParamValueAsString("member");
            String onGroup = parseResult.getParamValueAsString("group");
            String filter = parseResult.getParamValueAsString("filter");
            boolean moreThanOne = Stream.of(onRegion, onMember, onGroup).filter(Objects::nonNull).count() > 1L;
            ResultModel result = new ResultModel();
            if (moreThanOne) {
                return ResultModel.createError("Provide Only one of region/member/groups");
            }
            if (onRegion == null && filter != null) {
                return ResultModel.createError("Filters for executing on member or group is not supported.");
            }
            return result;
        }
    }
}

