/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Map;
import java.util.Set;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.commands.OfflineGfshCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class EchoCommand
extends OfflineGfshCommand {
    @ShellMethod(value="Echo the given text which may include system and user variables.", key={"echo"})
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH"})
    public ResultModel echo(@ShellOption(value={"string", ""}, help="String to be echoed. For example, \"SYS_USER variable is set to ${SYS_USER}\".", defaultValue="") String stringToEcho) {
        if (stringToEcho != null && stringToEcho.equals("$*")) {
            Gfsh gfshInstance = this.getGfsh();
            Map<String, String> envMap = gfshInstance.getEnv();
            Set<Map.Entry<String, String>> setEnvMap = envMap.entrySet();
            return this.buildResultForEcho(setEnvMap);
        }
        return ResultModel.createInfo(stringToEcho == null ? "" : stringToEcho);
    }

    private ResultModel buildResultForEcho(Set<Map.Entry<String, String>> propertyMap) {
        ResultModel result = new ResultModel();
        TabularResultModel echoResult = result.addTable("echoResult");
        echoResult.setColumnHeader("Property", "Value");
        for (Map.Entry<String, String> setEntry : propertyMap) {
            echoResult.addRow(setEntry.getKey(), String.valueOf(setEntry.getValue()));
        }
        return result;
    }
}

