/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.OfflineGfshCommand;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.shell.OperationInvoker;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;

@ShellComponent
public class DisconnectCommand
extends OfflineGfshCommand {
    @ShellMethod(value="Close the current connection, if one is open.", key={"disconnect"})
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH", "JMX", "Manager"})
    public ResultModel disconnect() {
        if (this.getGfsh() != null && !this.getGfsh().isConnectedAndReady()) {
            return ResultModel.createInfo("Not connected.");
        }
        ResultModel result = new ResultModel();
        InfoResultModel infoResultData = result.addInfo();
        Gfsh gfshInstance = this.getGfsh();
        if (gfshInstance.isConnectedAndReady()) {
            OperationInvoker operationInvoker = gfshInstance.getOperationInvoker();
            Gfsh.println("Disconnecting from: " + String.valueOf(operationInvoker));
            operationInvoker.stop();
            infoResultData.addLine(CliStrings.format((String)"Disconnected from : {0}", (Object)operationInvoker.toString()));
            LogWrapper.getInstance().info(CliStrings.format((String)"Disconnected from : {0}", (Object)operationInvoker.toString()));
            if (!gfshInstance.isHeadlessMode()) {
                gfshInstance.setEnvProperty("APP_CONTEXT_PATH", gfshInstance.getEnvAppContextPath());
            }
        } else {
            infoResultData.addLine("Not connected!");
        }
        return result;
    }
}

