/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.result.model.DataResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.functions.GetMemberInformationFunction;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.management.runtime.CacheServerInfo;
import org.apache.geode.management.runtime.MemberInformation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class DescribeMemberCommand
extends GfshCommand {
    @Immutable
    private static final GetMemberInformationFunction getMemberInformation = new GetMemberInformationFunction();

    @ShellMethod(value="Display information about a member, including name, id, groups, regions, etc.", key={"describe member"})
    @CliMetaData(relatedTopic={"Server"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel describeMember(@ShellOption(value={"name"}, help="Display information about a member, including name, id, groups, regions, etc.") String memberNameOrId) {
        List csList;
        DistributedMember memberToBeDescribed = this.getMember(memberNameOrId);
        ResultCollector<?, ?> rc = this.executeFunction((Function<?>)getMemberInformation, (Object)null, memberToBeDescribed);
        ArrayList output = (ArrayList)rc.getResult();
        Object obj = output.get(0);
        if (!(obj instanceof MemberInformation)) {
            return ResultModel.createInfo(String.format("Information for the member %s could not be retrieved.", memberNameOrId));
        }
        ResultModel result = new ResultModel();
        DataResultModel memberInfo = result.addData("memberInfo");
        MemberInformation memberInformation = (MemberInformation)obj;
        memberInfo.addData("Name", memberInformation.getMemberName());
        memberInfo.addData("Id", memberInformation.getId());
        memberInfo.addData("Host", memberInformation.getHost());
        memberInfo.addData("Regions", StringUtils.join((Iterable)memberInformation.getHostedRegions(), (char)'\n'));
        memberInfo.addData("PID", memberInformation.getProcessId());
        memberInfo.addData("Groups", memberInformation.getGroups());
        memberInfo.addData("Used Heap", memberInformation.getHeapUsage() + "M");
        memberInfo.addData("Max Heap", memberInformation.getMaxHeapSize() + "M");
        String offHeapMemorySize = memberInformation.getOffHeapMemorySize();
        if (offHeapMemorySize != null && !offHeapMemorySize.isEmpty()) {
            memberInfo.addData("Off Heap Size", offHeapMemorySize);
        }
        memberInfo.addData("Working Dir", memberInformation.getWorkingDirPath());
        memberInfo.addData("Log file", memberInformation.getLogFilePath());
        memberInfo.addData("Locators", memberInformation.getLocators());
        if (memberInformation.isServer() && (csList = memberInformation.getCacheServerInfo()) != null) {
            int serverCount = 0;
            for (CacheServerInfo cacheServerInfo : csList) {
                DataResultModel serverInfo = result.addData("serverInfo" + serverCount++);
                if (csList.size() == 1) {
                    serverInfo.setHeader("Cache Server Information");
                } else {
                    serverInfo.setHeader("Cache Server " + serverCount + " Information");
                }
                serverInfo.addData("Server Bind", cacheServerInfo.getBindAddress());
                serverInfo.addData("Server Port", cacheServerInfo.getPort());
                serverInfo.addData("Running", cacheServerInfo.isRunning());
            }
            DataResultModel connectionInfo = result.addData("connectionInfo");
            connectionInfo.addData("Client Connections", memberInformation.getClientCount());
        }
        return result;
    }
}

