/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import com.healthmarketscience.rmiio.RemoteInputStream;
import com.healthmarketscience.rmiio.RemoteStreamServer;
import com.healthmarketscience.rmiio.SimpleRemoteInputStream;
import com.healthmarketscience.rmiio.exporter.RemoteStreamExporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.ManagementAgent;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.domain.DeploymentInfo;
import org.apache.geode.management.internal.cli.functions.DeployFunction;
import org.apache.geode.management.internal.cli.remote.CommandExecutionContext;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.cli.security.SecurePathResolver;
import org.apache.geode.management.internal.cli.util.DeploymentInfoTableUtil;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.management.internal.util.ManagementUtils;
import org.apache.geode.management.internal.utils.JarFileUtils;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class DeployCommand
extends GfshCommand {
    private final DeployFunction deployFunction = new DeployFunction();
    private final SecurePathResolver pathResolver = new SecurePathResolver(null);

    @ShellMethod(value="Deploy JARs to a member or members.  Only one of either --jar or --dir may be specified.", key={"deploy"})
    @CliMetaData(interceptor="org.apache.geode.management.internal.cli.commands.DeployCommand$Interceptor", isFileUploaded=true, relatedTopic={"Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.DEPLOY)
    public ResultModel deploy(@ShellOption(value={"group", "groups"}, help="Group(s) to which the specified JARs will be deployed. If not specified, deploy will occur on all members.") String[] groups, @ShellOption(value={"jar", "jars"}, help="Path of the JAR to deploy.") String[] jars, @ShellOption(value={"dir"}, help="Directory from which to deploy the JARs.") String dir) throws IOException {
        ResultModel result = new ResultModel();
        TabularResultModel deployResult = result.addTable("deployResult");
        List<String> jarFullPaths = CommandExecutionContext.getFilePathFromShell();
        this.verifyJarContent(jarFullPaths);
        Set<DistributedMember> targetMembers = this.findMembers(groups, null);
        List<List<Object>> results = new LinkedList<List<Object>>();
        ManagementAgent agent = ((SystemManagementService)this.getManagementService()).getManagementAgent();
        RemoteStreamExporter exporter = agent.getRemoteStreamExporter();
        results = this.deployJars(jarFullPaths, targetMembers, results, exporter);
        LinkedList<Object> flatResults = new LinkedList<Object>();
        for (List<Object> memberResults : results) {
            flatResults.addAll(memberResults);
        }
        List cleanedResults = CliFunctionResult.cleanResults(flatResults);
        List<DeploymentInfo> deploymentInfos = DeploymentInfoTableUtil.getDeploymentInfoFromFunctionResults(cleanedResults);
        DeploymentInfoTableUtil.writeDeploymentInfoToTable(new String[]{"Member", "JAR", "JAR Location"}, deployResult, deploymentInfos);
        if (result.getStatus() == Result.Status.OK) {
            InternalConfigurationPersistenceService sc = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService();
            if (sc == null) {
                result.addInfo().addLine("Cluster configuration service is not running. Configuration change is not persisted.");
            } else {
                sc.addJarsToThisLocator(jarFullPaths, groups);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<List<Object>> deployJars(List<String> jarFullPaths, Set<DistributedMember> targetMembers, List<List<Object>> results, RemoteStreamExporter exporter) throws FileNotFoundException, RemoteException {
        for (DistributedMember member : targetMembers) {
            ArrayList<RemoteInputStream> remoteStreams = new ArrayList<RemoteInputStream>();
            ArrayList<String> jarNames = new ArrayList<String>();
            ArrayList memberResults = new ArrayList();
            try {
                for (String jarFullPath : jarFullPaths) {
                    this.validateJarPath(jarFullPath);
                    Path validatedPath = this.pathResolver.resolveSecurePath(jarFullPath, true, true);
                    FileInputStream fileInputStream = null;
                    try {
                        fileInputStream = new FileInputStream(validatedPath.toFile());
                        remoteStreams.add((RemoteInputStream)exporter.export((RemoteStreamServer)new SimpleRemoteInputStream((InputStream)fileInputStream)));
                        jarNames.add(validatedPath.getFileName().toString());
                    }
                    catch (Exception ex) {
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw ex;
                    }
                }
                ResultCollector<?, ?> resultCollector = this.executeFunction((Function<?>)this.deployFunction, (Object)new Object[]{jarNames, remoteStreams}, member);
                List resultCollectorResult = (List)resultCollector.getResult();
                memberResults.addAll(resultCollectorResult);
                results.add(memberResults);
            }
            finally {
                for (RemoteInputStream ris : remoteStreams) {
                    try {
                        ris.close(true);
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return results;
    }

    private void verifyJarContent(List<String> jarNames) {
        for (String jarName : jarNames) {
            Path validatedPath;
            try {
                validatedPath = this.pathResolver.resolveSecurePath(jarName, true, true);
            }
            catch (SecurityException e) {
                throw new IllegalArgumentException("Invalid JAR path: " + e.getMessage(), e);
            }
            File jar = validatedPath.toFile();
            if (JarFileUtils.hasValidJarContent((File)jar)) continue;
            throw new IllegalArgumentException("File does not contain valid JAR content: " + jar.getName());
        }
    }

    @Override
    public boolean affectsClusterConfiguration() {
        return true;
    }

    private void validateJarPath(String jarPath) {
        try {
            Path validatedPath = this.pathResolver.resolveSecurePath(jarPath, true, true);
            String filename = validatedPath.getFileName().toString().toLowerCase();
            if (!filename.endsWith(".jar")) {
                throw new SecurityException("File is not a JAR file: " + filename);
            }
            if (!JarFileUtils.hasValidJarContent((File)validatedPath.toFile())) {
                throw new SecurityException("File does not contain valid JAR content");
            }
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Invalid JAR file path: " + e.getMessage(), e);
        }
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        private final DecimalFormat numFormatter = new DecimalFormat("###,##0.00");
        private final SecurePathResolver pathResolver = new SecurePathResolver(null);

        @Override
        public ResultModel preExecution(GfshParseResult parseResult) {
            String message;
            Object[] jars = (String[])parseResult.getParamValue("jar");
            String dir = (String)parseResult.getParamValue("dir");
            if (ArrayUtils.isEmpty((Object[])jars) && StringUtils.isBlank((CharSequence)dir)) {
                return ResultModel.createError("Parameter \"jar\" or \"dir\" is required. Use \"help <command name>\" for assistance.");
            }
            if (ArrayUtils.isNotEmpty((Object[])jars) && StringUtils.isNotBlank((CharSequence)dir)) {
                return ResultModel.createError("Parameters \"jar\" and \"dir\" can not both be specified.");
            }
            ResultModel result = new ResultModel();
            if (jars != null) {
                for (Object jar : jars) {
                    Path validatedJarPath;
                    try {
                        validatedJarPath = this.pathResolver.resolveSecurePath((String)jar, true, true);
                    }
                    catch (SecurityException e) {
                        if (e.getMessage().contains("does not exist")) {
                            return ResultModel.createError((String)jar + " not found.");
                        }
                        return ResultModel.createError("Invalid JAR path: " + e.getMessage());
                    }
                    File jarFile = validatedJarPath.toFile();
                    if (!jarFile.exists()) {
                        return ResultModel.createError((String)jar + " not found.");
                    }
                    result.addFile(jarFile, 2);
                }
            } else {
                File[] childJarFile;
                Path validatedDirPath;
                try {
                    validatedDirPath = this.pathResolver.resolveSecurePath(dir, true, false);
                }
                catch (SecurityException e) {
                    if (e.getMessage().contains("does not exist")) {
                        return ResultModel.createError(dir + " not a directory");
                    }
                    return ResultModel.createError("Invalid directory path: " + e.getMessage());
                }
                File fileDir = validatedDirPath.toFile();
                if (!fileDir.isDirectory()) {
                    return ResultModel.createError(dir + " is not a directory");
                }
                for (File file : childJarFile = fileDir.listFiles(ManagementUtils.JAR_FILE_FILTER)) {
                    result.addFile(file, 2);
                }
            }
            if (this.readYesNo(message = "\nDeploying files: " + result.getFormattedFileList() + "\nTotal file size is: " + this.numFormatter.format((double)result.computeFileSizeTotal() / 1048576.0) + "MB\n\nContinue? ", AbstractCliAroundInterceptor.Response.YES) == AbstractCliAroundInterceptor.Response.NO) {
                return ResultModel.createError("Aborted deploy of " + result.getFormattedFileList() + ".");
            }
            return result;
        }
    }
}

