/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Set;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.commands.IndexDefinition;
import org.apache.geode.management.internal.cli.functions.ManageIndexDefinitionFunction;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class DefineIndexCommand
extends GfshCommand {
    @ShellMethod(value="Define an index that can be used when executing queries.", key={"define index"})
    @CliMetaData(relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.QUERY)
    public ResultModel defineIndex(@ShellOption(value={"name"}, help="Define an index that can be used when executing queries.") String indexName, @ShellOption(value={"expression"}, help="Field of the region values that are referenced by the index.") String indexedExpression, @ShellOption(value={"region"}, help="Name/Path of the region which corresponds to the \"from\" clause in a query.") String regionPath, @ShellOption(value={"type"}, defaultValue="range", help="Type of the index. Valid values are: range and key. Deprecated: Since Geode 1.4, hash should not be used.") IndexType indexType) {
        ResultModel result = new ResultModel();
        Object normalizedRegionPath = regionPath.startsWith("/") ? regionPath : "/" + regionPath;
        RegionConfig.Index indexInfo = new RegionConfig.Index();
        indexInfo.setName(indexName);
        indexInfo.setExpression(indexedExpression);
        indexInfo.setFromClause((String)normalizedRegionPath);
        indexInfo.setType(indexType.getName());
        IndexDefinition.indexDefinitions.add(indexInfo);
        Set<DistributedMember> allOtherLocators = this.findAllOtherLocators();
        if (allOtherLocators.size() > 0) {
            this.executeAndGetFunctionResult((Function<?>)new ManageIndexDefinitionFunction(), indexInfo, allOtherLocators);
        }
        InfoResultModel infoResult = result.addInfo();
        infoResult.addLine("Index successfully defined with following details");
        infoResult.addLine(CliStrings.format((String)"Name       : {0}", (Object)indexName));
        infoResult.addLine(CliStrings.format((String)"Expression : {0}", (Object)indexedExpression));
        infoResult.addLine(CliStrings.format((String)"RegionPath : {0}", (Object)normalizedRegionPath));
        return result;
    }
}

