/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Arrays;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.DeclarableType;
import org.apache.geode.cache.configuration.PdxType;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.pdx.ReflectionBasedAutoSerializer;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class ConfigurePDXCommand
extends SingleGfshCommand {
    protected ReflectionBasedAutoSerializer createReflectionBasedAutoSerializer(boolean checkPortability, String[] patterns) {
        return new ReflectionBasedAutoSerializer(checkPortability, patterns);
    }

    @ShellMethod(value="Configures Geode's Portable Data eXchange for all the cache(s) in the cluster. This command would not take effect on the running members in the system.\n This command persists the pdx configuration in the locator with cluster configuration service. \n This command should be issued before starting any data members.", key={"configure pdx"})
    @CliMetaData(relatedTopic={"Region"}, interceptor="org.apache.geode.management.internal.cli.commands.ConfigurePDXCommand$Interceptor")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel configurePDX(@ShellOption(value={"read-serialized"}, defaultValue="false", help="Set to true to have PDX deserialization produce a PdxInstance instead of an instance of the domain class. The default value for this options is \"false\"") Boolean readSerialized, @ShellOption(value={"ignore-unread-fields"}, defaultValue="false", help="Control whether pdx ignores fields that were unread during deserialization. The default is to preserve unread fields be including their data during serialization. But if you configure the cache to ignore unread fields then their data will be lost during serialization. You should only set this attribute to true if you know this member will only be reading cache data. In this use case you do not need to pay the cost of preserving the unread fields since you will never be reserializing pdx data.") Boolean ignoreUnreadFields, @ShellOption(value={"disk-store"}, defaultValue="__NULL__", help="Named disk store where the PDX type data will be stored. The default value for this options is \"DEFAULT\"") String diskStore, @ShellOption(value={"auto-serializable-classes"}, defaultValue="__NULL__", help="The patterns that are matched against domain class names to determine whether they should be auto-serialized. Serialization done by the auto-serializer will not throw an exception if the object of these classes are not portable to non-java languages (check-portability=false).") String[] nonPortableClassesPatterns, @ShellOption(value={"portable-auto-serializable-classes"}, defaultValue="__NULL__", help="The patterns that are matched against domain class names to determine whether they should be serialized. Serialization done by the auto-serializer will throw an exception if the object of these classes are not portable to non-java languages (check-portability=true).") String[] portableClassesPatterns) {
        if (this.getConfigurationPersistenceService() == null) {
            return ResultModel.createError("Configure pdx failed because cluster configuration is disabled.");
        }
        ResultModel result = new ResultModel();
        InfoResultModel infoSection = result.addInfo();
        if (!this.getAllNormalMembers().isEmpty()) {
            infoSection.addLine("The command would only take effect on new data members joining the distributed system. It won't affect the existing data members");
        }
        PdxType pdxType = new PdxType();
        pdxType.setIgnoreUnreadFields(ignoreUnreadFields);
        pdxType.setReadSerialized(readSerialized);
        infoSection.addLine("read-serialized = " + readSerialized);
        infoSection.addLine("ignore-unread-fields = " + ignoreUnreadFields);
        String effectiveDiskStore = diskStore;
        if (diskStore != null && diskStore.isEmpty()) {
            effectiveDiskStore = "DEFAULT";
        }
        pdxType.setDiskStoreName(effectiveDiskStore);
        pdxType.setPersistent(Boolean.valueOf(effectiveDiskStore != null));
        if (effectiveDiskStore != null) {
            infoSection.addLine("persistent = true");
            infoSection.addLine("disk-store = " + effectiveDiskStore);
        } else {
            infoSection.addLine("persistent = false");
        }
        ReflectionBasedAutoSerializer autoSerializer = null;
        if (portableClassesPatterns != null) {
            autoSerializer = this.createReflectionBasedAutoSerializer(true, portableClassesPatterns);
            infoSection.addLine("PDX Serializer = " + autoSerializer.getClass().getName());
            infoSection.addLine("Portable Classes = " + Arrays.toString(portableClassesPatterns));
        } else if (nonPortableClassesPatterns != null) {
            autoSerializer = this.createReflectionBasedAutoSerializer(false, nonPortableClassesPatterns);
            infoSection.addLine("PDX Serializer = " + autoSerializer.getClass().getName());
            infoSection.addLine("Non Portable Classes = " + Arrays.toString(nonPortableClassesPatterns));
        }
        if (autoSerializer != null) {
            pdxType.setPdxSerializer(new DeclarableType(ReflectionBasedAutoSerializer.class.getName(), autoSerializer.getConfig()));
        }
        result.setConfigObject(pdxType);
        return result;
    }

    @Override
    public boolean updateConfigForGroup(String group, CacheConfig config, Object configObject) {
        config.setPdx((PdxType)configObject);
        return true;
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public ResultModel preExecution(GfshParseResult parseResult) {
            String[] portableClassesPatterns = (String[])parseResult.getParamValue("portable-auto-serializable-classes");
            String[] nonPortableClassesPatterns = (String[])parseResult.getParamValue("auto-serializable-classes");
            if (nonPortableClassesPatterns != null && nonPortableClassesPatterns.length > 0 && portableClassesPatterns != null && portableClassesPatterns.length > 0) {
                return ResultModel.createError("The autoserializer cannot support both portable and non-portable classes at the same time.");
            }
            return ResultModel.createInfo("");
        }
    }
}

