/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.backup.BackupOperation;
import org.apache.geode.management.BackupStatus;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.commands.DiskStoreCommandsUtils;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

public class BackupDiskStoreCommand
extends GfshCommand {
    public static final String BACKED_UP_DISKSTORES_SECTION = "backed-up-diskstores";
    public static final String OFFLINE_DISKSTORES_SECTION = "offline-diskstores";

    @ShellMethod(value="Perform a backup on all members with persistent data. The target directory must exist on all members, but can be either local or shared. This command can safely be executed on active members and is strongly recommended over copying files via operating system commands.", key={"backup disk-store"})
    @CliMetaData(relatedTopic={"Disk Store"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.READ)
    public ResultModel backupDiskStore(@ShellOption(value={"dir"}, help="Directory to which backup files will be written.") String targetDir, @ShellOption(value={"baseline-dir"}, help="Directory which contains the baseline backup used for comparison during an incremental backup.") String baselineDir, @ShellOption(value={"include-disk-stores"}, help="List of disk-stores to include.") String[] includeDiskStores) {
        this.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.WRITE, ResourcePermission.Target.DISK);
        ResultModel result = new ResultModel();
        try {
            BackupStatus backupStatus;
            Map backedupMemberDiskstoreMap;
            Set backedupMembers;
            InternalCache cache = (InternalCache)this.getCache();
            DistributionManager dm = cache.getDistributionManager();
            String includeDiskStoresString = null;
            if (includeDiskStores != null && includeDiskStores.length > 0) {
                for (String name : includeDiskStores) {
                    if (name != null && !name.isEmpty()) {
                        if (this.diskStoreExists(name)) continue;
                        return ResultModel.createError(CliStrings.format((String)"Specify valid include-disk-stores. Unknown Disk Store : \"{0}\".", (Object[])new Object[]{name}));
                    }
                    return ResultModel.createError(CliStrings.format((String)"Specify valid include-disk-stores. Blank name added in list of disk-stores", (Object[])new Object[0]));
                }
                includeDiskStoresString = StringUtils.join((Object[])includeDiskStores, (String)",");
            }
            if (!(backedupMembers = (backedupMemberDiskstoreMap = (backupStatus = baselineDir != null && !baselineDir.isEmpty() ? new BackupOperation(dm, dm.getCache()).backupAllMembers(targetDir, baselineDir, includeDiskStoresString) : new BackupOperation(dm, dm.getCache()).backupAllMembers(targetDir, null, includeDiskStoresString)).getBackedUpDiskStores()).keySet()).isEmpty()) {
                TabularResultModel backedupDiskStoresTable = result.addTable(BACKED_UP_DISKSTORES_SECTION);
                backedupDiskStoresTable.setHeader("The following disk stores were backed up successfully");
                for (DistributedMember member : backedupMembers) {
                    Set backedupDiskStores = (Set)backedupMemberDiskstoreMap.get(member);
                    boolean printMember = true;
                    String memberName = member.getName();
                    if (memberName == null || memberName.isEmpty()) {
                        memberName = member.getId();
                    }
                    for (PersistentID persistentId : backedupDiskStores) {
                        if (persistentId == null) continue;
                        String UUID2 = persistentId.getUUID().toString();
                        String hostName = persistentId.getHost().getHostName();
                        String directory = persistentId.getDirectory();
                        if (printMember) {
                            this.writeToBackupDiskStoreTable(backedupDiskStoresTable, memberName, UUID2, hostName, directory);
                            printMember = false;
                            continue;
                        }
                        this.writeToBackupDiskStoreTable(backedupDiskStoresTable, "", UUID2, hostName, directory);
                    }
                }
            } else {
                result.addInfo().addLine("No disk store(s) were backed up.");
            }
            Set offlineDiskStores = backupStatus.getOfflineDiskStores();
            if (!offlineDiskStores.isEmpty()) {
                TabularResultModel offlineDiskStoresTable = result.addTable(OFFLINE_DISKSTORES_SECTION);
                offlineDiskStoresTable.setHeader("The backup may be incomplete. The following disk stores are not online");
                for (PersistentID offlineDiskStore : offlineDiskStores) {
                    offlineDiskStoresTable.accumulate("UUID", offlineDiskStore.getUUID().toString());
                    offlineDiskStoresTable.accumulate("Host", offlineDiskStore.getHost().getHostName());
                    offlineDiskStoresTable.accumulate("Directory", offlineDiskStore.getDirectory());
                }
            }
        }
        catch (Exception e) {
            return ResultModel.createError(e.getMessage());
        }
        return result;
    }

    private void writeToBackupDiskStoreTable(TabularResultModel table, String memberId, String UUID2, String host, String directory) {
        table.accumulate("Member", memberId);
        table.accumulate("UUID", UUID2);
        table.accumulate("Directory", directory);
        table.accumulate("Host", host);
    }

    private boolean diskStoreExists(String diskStoreName) {
        Object managementService = this.getManagementService();
        DistributedSystemMXBean dsMXBean = managementService.getDistributedSystemMXBean();
        return Arrays.stream(dsMXBean.listMembers()).anyMatch(member -> DiskStoreCommandsUtils.diskStoreBeanAndMemberBeanDiskStoreExists(dsMXBean, member, diskStoreName));
    }
}

