/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.springframework.shell.standard.ShellOption;

public class MandatoryParameterValidationInterceptor
extends AbstractCliAroundInterceptor {
    @Override
    public ResultModel preExecution(GfshParseResult parseResult) {
        Method method = parseResult.getMethod();
        Parameter[] parameters = method.getParameters();
        Object[] arguments = parseResult.getArguments();
        for (int i = 0; i < parameters.length; ++i) {
            boolean required;
            ShellOption option = parameters[i].getAnnotation(ShellOption.class);
            Object value = arguments[i];
            if (option == null || !(required = this.isRequired(option)) || !this.isNullOrEmpty(value)) continue;
            return ResultModel.createError("Invalid command");
        }
        return ResultModel.createInfo("");
    }

    private boolean isRequired(ShellOption option) {
        String defaultValue = option.defaultValue();
        return defaultValue == null || defaultValue.isEmpty() || "__NONE__".equals(defaultValue) || "__NULL__".equals(defaultValue);
    }

    private boolean isNullOrEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            String strValue = ((String)value).trim();
            return strValue.isEmpty() || "null".equals(strValue) || strValue.equals("__OPTION_NOT_VALUED__") || strValue.equals("/__OPTION_NOT_VALUED__");
        }
        return false;
    }
}

