/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.Cache;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.cli.shell.GfshConfig;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class LogWrapper {
    private static final Object INSTANCE_LOCK = new Object();
    @MakeNotStatic
    private static volatile LogWrapper INSTANCE = null;
    private final Logger logger = LogService.getLogger();

    private LogWrapper(Cache cache) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogWrapper getInstance(Cache cache) {
        if (INSTANCE == null) {
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new LogWrapper(cache);
                }
            }
        }
        return INSTANCE;
    }

    public static LogWrapper getInstance() {
        return LogWrapper.getInstance(null);
    }

    public void configure(GfshConfig config) {
        if (config.isLoggingEnabled()) {
            System.setProperty("gfsh.log.file", config.getLogFilePath());
            System.setProperty("gfsh.log.level", this.mapJulLevelToLog4jLevel(config.getLogLevel()).name());
            this.logger.debug("GFSH logging configured: file={}, level={}", (Object)config.getLogFilePath(), (Object)config.getLogLevel());
        }
    }

    private Level mapJulLevelToLog4jLevel(java.util.logging.Level julLevel) {
        if (julLevel == java.util.logging.Level.SEVERE) {
            return Level.ERROR;
        }
        if (julLevel == java.util.logging.Level.WARNING) {
            return Level.WARN;
        }
        if (julLevel == java.util.logging.Level.INFO) {
            return Level.INFO;
        }
        if (julLevel == java.util.logging.Level.CONFIG) {
            return Level.DEBUG;
        }
        if (julLevel == java.util.logging.Level.FINE) {
            return Level.DEBUG;
        }
        if (julLevel == java.util.logging.Level.FINER) {
            return Level.TRACE;
        }
        if (julLevel == java.util.logging.Level.FINEST) {
            return Level.TRACE;
        }
        if (julLevel == java.util.logging.Level.OFF) {
            return Level.OFF;
        }
        return Level.INFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            INSTANCE = null;
        }
    }

    @Deprecated
    public void setParentFor(Logger otherLogger) {
    }

    public void setLogLevel(Level newLevel) {
        this.logger.debug("Log level change requested: {}", (Object)newLevel);
    }

    public Level getLogLevel() {
        return this.logger.getLevel();
    }

    Logger getLogger() {
        return this.logger;
    }

    public boolean severeEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void severe(String message) {
        this.logger.error(message);
    }

    public void severe(String message, Throwable t) {
        this.logger.error(message, t);
    }

    public boolean warningEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void warning(String message) {
        this.logger.warn(message);
    }

    public void warning(String message, Throwable t) {
        this.logger.warn(message, t);
    }

    public boolean infoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String message) {
        this.logger.info(message);
    }

    public void info(String message, Throwable t) {
        this.logger.info(message, t);
    }

    public boolean configEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void config(String message) {
        this.logger.debug(message);
    }

    public void config(String message, Throwable t) {
        this.logger.debug(message, t);
    }

    public boolean fineEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void fine(String message) {
        this.logger.debug(message);
    }

    public void fine(String message, Throwable t) {
        this.logger.debug(message, t);
    }

    public boolean finerEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void finer(String message) {
        this.logger.trace(message);
    }

    public void finer(String message, Throwable t) {
        this.logger.trace(message, t);
    }

    public boolean finestEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void finest(String message) {
        this.logger.trace(message);
    }

    public void finest(String message, Throwable t) {
        this.logger.trace(message, t);
    }
}

