/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.configuration.JndiBindingsType;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.management.configuration.ClassName;
import org.apache.geode.management.internal.cli.CommandManager;
import org.apache.geode.management.internal.cli.Completion;
import org.apache.geode.management.internal.cli.CompletionContext;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.completion.CompletionProviderRegistry;
import org.apache.geode.management.internal.cli.converters.ConfigPropertyConverter;
import org.apache.geode.management.internal.cli.converters.PoolPropertyConverter;
import org.apache.geode.management.internal.cli.domain.PoolProperty;
import org.apache.geode.management.internal.cli.util.ConnectionEndpoint;
import org.springframework.shell.standard.ShellOption;

public class GfshParser {
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String OPTION_VALUE_SPECIFIER = "=";
    public static final String OPTION_SEPARATOR = " ";
    public static final String SHORT_OPTION_SPECIFIER = "-";
    public static final String LONG_OPTION_SPECIFIER = "--";
    public static final String COMMAND_DELIMITER = ";";
    public static final String CONTINUATION_CHARACTER = "\\";
    private static final String OPTION_NOT_VALUED = "__OPTION_NOT_VALUED__";
    private static final char ASCII_UNIT_SEPARATOR = '\u001f';
    public static final String J_ARGUMENT_DELIMITER = "\u001f";
    public static final String J_OPTION_CONTEXT = "splittingRegex=\u001f";
    private final CommandManager commandManager;
    private final CompletionProviderRegistry completionProviderRegistry;

    public GfshParser(CommandManager commandManager) {
        this.commandManager = commandManager;
        this.completionProviderRegistry = new CompletionProviderRegistry();
    }

    static String convertToSimpleParserInput(String userInput) {
        List<String> inputTokens = GfshParser.splitUserInput(userInput);
        return GfshParser.getSimpleParserInputFromTokens(inputTokens);
    }

    private static List<String> splitWithWhiteSpace(String input) {
        ArrayList<String> tokensList = new ArrayList<String>();
        StringBuilder token = new StringBuilder();
        char insideQuoteOf = '\u0000';
        for (char c : input.toCharArray()) {
            if (Character.isWhitespace(c)) {
                if (insideQuoteOf != '\u0000') {
                    token.append(c);
                    continue;
                }
                if (token.length() > 0) {
                    tokensList.add(token.toString());
                }
                token = new StringBuilder();
                continue;
            }
            token.append(c);
            if (c != '\'' && c != '\"') continue;
            if (insideQuoteOf == '\u0000') {
                insideQuoteOf = c;
                continue;
            }
            if (insideQuoteOf != c) continue;
            insideQuoteOf = '\u0000';
        }
        if (token.length() > 0) {
            tokensList.add(token.toString());
        }
        return tokensList;
    }

    static List<String> splitUserInput(String userInput) {
        List<String> splitWithWhiteSpaces = GfshParser.splitWithWhiteSpace(userInput);
        ArrayList<String> furtherSplitWithEquals = new ArrayList<String>();
        for (String token : splitWithWhiteSpaces) {
            if (token.startsWith("'") || token.startsWith("\"") || token.startsWith("-D")) {
                furtherSplitWithEquals.add(token);
                continue;
            }
            int indexOfFirstEqual = token.indexOf(61);
            if (indexOfFirstEqual < 0) {
                furtherSplitWithEquals.add(token);
                continue;
            }
            String left = token.substring(0, indexOfFirstEqual);
            String right = token.substring(indexOfFirstEqual + 1);
            if (left.length() > 0) {
                furtherSplitWithEquals.add(left);
            }
            if (right.length() <= 0) continue;
            furtherSplitWithEquals.add(right);
        }
        return furtherSplitWithEquals;
    }

    static String getSimpleParserInputFromTokens(List<String> tokens) {
        ArrayList<String> inputTokens = new ArrayList<String>();
        int firstJIndex = -1;
        ArrayList<String> jArguments = new ArrayList<String>();
        for (int i = 0; i < tokens.size(); ++i) {
            String token = tokens.get(i);
            if ("--J".equals(token)) {
                if (firstJIndex < 1) {
                    firstJIndex = i;
                }
                if (++i >= tokens.size()) continue;
                String jArg = tokens.get(i);
                if (jArg.charAt(0) == '\"' || jArg.charAt(0) == '\'') {
                    jArg = jArg.substring(1, jArg.length() - 1);
                }
                if (jArg.length() <= 0) continue;
                jArguments.add(jArg);
                continue;
            }
            inputTokens.add(token);
        }
        StringBuilder rawInput = new StringBuilder();
        for (int i = 0; i <= inputTokens.size(); ++i) {
            if (i == firstJIndex) {
                rawInput.append("--J ");
                if (jArguments.size() > 0) {
                    rawInput.append("\"").append(StringUtils.join(jArguments, (String)J_ARGUMENT_DELIMITER)).append("\" ");
                }
            }
            if (i >= inputTokens.size()) continue;
            rawInput.append((String)inputTokens.get(i)).append(OPTION_SEPARATOR);
        }
        return rawInput.toString().trim();
    }

    public GfshParseResult parse(String userInput) {
        Object[] arguments;
        int i;
        if (userInput == null || userInput.trim().isEmpty()) {
            return null;
        }
        String trimmedInput = GfshParser.convertToSimpleParserInput(userInput).trim();
        List<String> tokens = this.tokenize(trimmedInput);
        if (tokens.isEmpty()) {
            return null;
        }
        Method commandMethod = null;
        int commandTokenCount = 0;
        int maxCommandTokens = tokens.size();
        for (i = 0; i < tokens.size(); ++i) {
            if (!tokens.get(i).startsWith(LONG_OPTION_SPECIFIER)) continue;
            maxCommandTokens = i;
            break;
        }
        for (i = Math.min(maxCommandTokens, 5); i >= 1; --i) {
            StringBuilder cmdBuilder = new StringBuilder();
            for (int j = 0; j < i; ++j) {
                if (j > 0) {
                    cmdBuilder.append(OPTION_SEPARATOR);
                }
                cmdBuilder.append(tokens.get(j));
            }
            String candidateCommand = cmdBuilder.toString();
            Method method = this.commandManager.getHelper().getCommandMethod(candidateCommand);
            if (method == null) continue;
            commandMethod = method;
            commandTokenCount = i;
            break;
        }
        if (commandMethod == null) {
            return null;
        }
        Object commandInstance = this.findCommandInstance(commandMethod);
        if (commandInstance == null) {
            return null;
        }
        try {
            List<String> argTokens = tokens.subList(commandTokenCount, tokens.size());
            arguments = this.bindArguments(commandMethod, argTokens);
            if (arguments == null) {
                return null;
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            return null;
        }
        return new GfshParseResult(commandMethod, commandInstance, arguments, trimmedInput);
    }

    private List<String> tokenize(String input) {
        return GfshParser.splitUserInput(input);
    }

    private Object findCommandInstance(Method method) {
        for (Object commandMarker : this.commandManager.getCommandMarkers()) {
            if (!commandMarker.getClass().equals(method.getDeclaringClass())) continue;
            return commandMarker;
        }
        return null;
    }

    private Object[] bindArguments(Method method, List<String> tokens) throws Exception {
        Parameter[] parameters = method.getParameters();
        Object[] arguments = new Object[parameters.length];
        Map<String, String> optionValues = this.parseOptions(tokens);
        if (!this.validateOptions(optionValues, parameters)) {
            return null;
        }
        for (int i = 0; i < parameters.length; ++i) {
            Parameter param = parameters[i];
            ShellOption option = param.getAnnotation(ShellOption.class);
            if (option == null) {
                arguments[i] = null;
                continue;
            }
            String value = null;
            for (String alias : option.value()) {
                if (!optionValues.containsKey(alias)) continue;
                value = optionValues.get(alias);
                break;
            }
            if (value != null && !value.isEmpty() && this.isRegionNameParameter(method, option)) {
                value = this.convertToRegionPath(value);
            }
            try {
                String optionName = option.value().length > 0 ? option.value()[0] : "";
                arguments[i] = this.convertValue(value, param.getType(), option.defaultValue(), optionName);
                continue;
            }
            catch (IllegalArgumentException e) {
                String optionName = option.value().length > 0 ? option.value()[0] : "unknown";
                String typeName = param.getType().getSimpleName();
                String errorMsg = "Failed to convert '" + value + "' to type " + typeName + " for option '" + optionName + "'";
                throw new IllegalArgumentException(errorMsg, e);
            }
        }
        return arguments;
    }

    private boolean validateOptions(Map<String, String> optionValues, Parameter[] parameters) {
        HashMap<String, Integer> optionToParameter = new HashMap<String, Integer>();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter param = parameters[i];
            ShellOption option = param.getAnnotation(ShellOption.class);
            if (option == null) continue;
            for (String alias : option.value()) {
                optionToParameter.put(alias, i);
            }
        }
        HashSet<Integer> usedParameters = new HashSet<Integer>();
        for (String optionName : optionValues.keySet()) {
            Integer paramIndex = (Integer)optionToParameter.get(optionName);
            if (paramIndex == null) {
                return false;
            }
            if (usedParameters.contains(paramIndex)) {
                return false;
            }
            usedParameters.add(paramIndex);
        }
        return true;
    }

    private Map<String, String> parseOptions(List<String> tokens) {
        HashMap<String, String> options = new HashMap<String, String>();
        for (int i = 0; i < tokens.size(); ++i) {
            String token = tokens.get(i);
            if (token.startsWith(LONG_OPTION_SPECIFIER)) {
                String value;
                String optionPart = token.substring(LONG_OPTION_SPECIFIER.length());
                if (optionPart.contains(OPTION_VALUE_SPECIFIER)) {
                    String[] parts = optionPart.split(OPTION_VALUE_SPECIFIER, 2);
                    value = parts.length > 1 ? parts[1] : "";
                    value = this.stripQuotes(value);
                    options.put(parts[0], value);
                    continue;
                }
                String optionName = optionPart;
                if (i + 1 < tokens.size()) {
                    boolean isLongOption;
                    String nextToken = tokens.get(i + 1);
                    boolean isJvmProperty = nextToken.startsWith("-D") || nextToken.startsWith("-X");
                    boolean isJOptionValue = optionName.equals("J") && (nextToken.startsWith(LONG_OPTION_SPECIFIER) || nextToken.startsWith(SHORT_OPTION_SPECIFIER));
                    boolean isNegativeNumber = nextToken.matches("^-\\d+(\\.\\d+)?$");
                    boolean isShortOption = nextToken.startsWith(SHORT_OPTION_SPECIFIER) && !isJvmProperty && !isJOptionValue && !isNegativeNumber;
                    boolean bl = isLongOption = nextToken.startsWith(LONG_OPTION_SPECIFIER) && !isJOptionValue;
                    value = !isShortOption && !isLongOption ? this.stripQuotes(tokens.get(++i)) : OPTION_NOT_VALUED;
                } else {
                    value = OPTION_NOT_VALUED;
                }
                options.put(optionName, value);
                continue;
            }
            if (!token.startsWith(SHORT_OPTION_SPECIFIER)) continue;
            String optionName = token.substring(SHORT_OPTION_SPECIFIER.length());
            String value = i + 1 < tokens.size() && !tokens.get(i + 1).startsWith(SHORT_OPTION_SPECIFIER) && !tokens.get(i + 1).startsWith(LONG_OPTION_SPECIFIER) ? this.stripQuotes(tokens.get(++i)) : OPTION_NOT_VALUED;
            options.put(optionName, value);
        }
        return options;
    }

    private String stripQuotes(String value) {
        if (value == null) {
            return null;
        }
        if ((value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\"")) && value.length() >= 2) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    private Object convertValue(String value, Class<?> targetType, String defaultValue, String optionName) {
        boolean hasDefaultValue;
        if (OPTION_NOT_VALUED.equals(value)) {
            if (targetType == Boolean.TYPE || targetType == Boolean.class) {
                return true;
            }
            if (targetType == String.class) {
                value = "";
            } else {
                return null;
            }
        }
        if ((targetType == Boolean.TYPE || targetType == Boolean.class) && "".equals(value)) {
            return true;
        }
        boolean bl = hasDefaultValue = defaultValue != null && !defaultValue.isEmpty() && !"__NONE__".equals(defaultValue) && !"__NULL__".equals(defaultValue);
        if (targetType == String.class && "".equals(value)) {
            if (hasDefaultValue) {
                value = defaultValue;
            } else {
                return "";
            }
        }
        if (value == null || value.isEmpty()) {
            if (hasDefaultValue) {
                value = defaultValue;
            } else if (!targetType.isArray() && targetType != ClassName.class) {
                return null;
            }
        }
        if (targetType != String.class && !targetType.isArray() && targetType != ClassName.class && (value == null || value.isEmpty())) {
            return null;
        }
        if (targetType == String.class) {
            if (value == null || "__NONE__".equals(value) || "__NULL__".equals(value)) {
                return null;
            }
            return value;
        }
        if (targetType == Integer.TYPE || targetType == Integer.class) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid integer value: " + value, e);
            }
        }
        if (targetType == Long.TYPE || targetType == Long.class) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid long value: " + value, e);
            }
        }
        if (targetType == Float.TYPE || targetType == Float.class) {
            try {
                return Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid float value: " + value, e);
            }
        }
        if (targetType == Double.TYPE || targetType == Double.class) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid double value: " + value, e);
            }
        }
        if (targetType == Boolean.TYPE || targetType == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (targetType.isEnum()) {
            try {
                if (targetType == IndexType.class) {
                    IndexType indexType = IndexType.valueOfSynonym((String)value);
                    return indexType;
                }
                Object enumValue = Enum.valueOf(targetType, value.toUpperCase());
                return enumValue;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid enum value: " + value + " for type " + targetType.getSimpleName(), e);
            }
        }
        if (targetType == JndiBindingsType.JndiBinding.ConfigProperty[].class) {
            if (value == null || value.isEmpty()) {
                return new JndiBindingsType.JndiBinding.ConfigProperty[0];
            }
            ConfigPropertyConverter converter = new ConfigPropertyConverter();
            return converter.convert(value);
        }
        if (targetType == PoolProperty[].class) {
            if (value == null || value.isEmpty()) {
                return new PoolProperty[0];
            }
            PoolPropertyConverter converter = new PoolPropertyConverter();
            return converter.convert(value);
        }
        if (targetType.isArray()) {
            if (value == null) {
                return null;
            }
            Class<?> componentType = targetType.getComponentType();
            String delimiter = ",";
            if ("authorizer-parameters".equals(optionName)) {
                delimiter = COMMAND_DELIMITER;
            }
            String[] parts = value.split(delimiter);
            Object array = Array.newInstance(componentType, parts.length);
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i].trim();
                Object element = this.convertValue(part, componentType, "", "");
                Array.set(array, i, element);
            }
            return array;
        }
        if (targetType == File.class) {
            return new File(value);
        }
        if (targetType == ConnectionEndpoint.class) {
            return this.parseConnectionEndpoint(value);
        }
        if (targetType == ClassName.class) {
            return this.parseClassName(value);
        }
        if (targetType == ExpirationAction.class) {
            return this.parseExpirationAction(value);
        }
        return value;
    }

    private ConnectionEndpoint parseConnectionEndpoint(String value) {
        int bracketEnd;
        int bracketStart;
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (value.contains("[") && value.contains("]") && (bracketStart = value.indexOf(91)) < (bracketEnd = value.indexOf(93))) {
            String host = value.substring(0, bracketStart);
            String portStr = value.substring(bracketStart + 1, bracketEnd);
            try {
                int port = Integer.parseInt(portStr);
                return new ConnectionEndpoint(host, port);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (value.contains(":")) {
            int colonIndex = value.lastIndexOf(58);
            String host = value.substring(0, colonIndex);
            String portStr = value.substring(colonIndex + 1);
            try {
                int port = Integer.parseInt(portStr);
                return new ConnectionEndpoint(host, port);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private ClassName parseClassName(String value) {
        if (value == null) {
            return null;
        }
        if (value.isEmpty()) {
            return ClassName.EMPTY;
        }
        if (value.contains("{")) {
            int braceIndex = value.indexOf(123);
            String className = value.substring(0, braceIndex).trim();
            String jsonProperties = value.substring(braceIndex);
            if (!ClassName.isClassNameValid((String)className)) {
                throw new IllegalArgumentException("Invalid class name: " + className);
            }
            try {
                return new ClassName(className, jsonProperties);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid ClassName format: " + value + ". " + e.getMessage(), e);
            }
        }
        if (!ClassName.isClassNameValid((String)value)) {
            throw new IllegalArgumentException("Invalid class name: " + value);
        }
        return new ClassName(value);
    }

    private ExpirationAction parseExpirationAction(String value) {
        String upperValue;
        if (value == null || value.isEmpty()) {
            return null;
        }
        switch (upperValue = value.toUpperCase().trim()) {
            case "INVALIDATE": {
                return ExpirationAction.INVALIDATE;
            }
            case "DESTROY": {
                return ExpirationAction.DESTROY;
            }
            case "LOCAL_INVALIDATE": 
            case "LOCAL-INVALIDATE": {
                return ExpirationAction.LOCAL_INVALIDATE;
            }
            case "LOCAL_DESTROY": 
            case "LOCAL-DESTROY": {
                return ExpirationAction.LOCAL_DESTROY;
            }
        }
        throw new IllegalArgumentException("Invalid ExpirationAction: " + value + ". Valid values are: INVALIDATE, DESTROY, LOCAL_INVALIDATE, LOCAL_DESTROY");
    }

    private boolean isRegionNameParameter(Method method, ShellOption option) {
        String className = method.getDeclaringClass().getSimpleName();
        boolean isRegionCommand = className.contains("Region");
        if (!isRegionCommand) {
            return false;
        }
        for (String optionName : option.value()) {
            if (!"name".equals(optionName) && !"region".equals(optionName) && !"regionName".equals(optionName)) continue;
            return true;
        }
        return false;
    }

    private String convertToRegionPath(String value) {
        if (value == null || ((String)value).isEmpty()) {
            return value;
        }
        if (OPTION_NOT_VALUED.equals(value)) {
            return value;
        }
        String SEPARATOR = "/";
        if (((String)value).equals("/")) {
            throw new IllegalArgumentException("invalid region path: " + (String)value);
        }
        if (!((String)value).startsWith("/")) {
            value = "/" + (String)value;
        }
        return value;
    }

    private CompletionContext analyzeContext(String userInput, int cursor) {
        String secondToLast;
        String token;
        if (userInput == null || userInput.trim().isEmpty()) {
            return CompletionContext.commandName("");
        }
        List<String> tokens = GfshParser.splitUserInput(userInput);
        if (tokens.isEmpty()) {
            return CompletionContext.commandName("");
        }
        StringBuilder commandNameBuilder = new StringBuilder();
        for (int i = 0; i < tokens.size() && !(token = tokens.get(i)).startsWith(LONG_OPTION_SPECIFIER); ++i) {
            if (i > 0) {
                commandNameBuilder.append(OPTION_SEPARATOR);
            }
            commandNameBuilder.append(token);
        }
        String commandName = commandNameBuilder.toString();
        String lastToken = tokens.get(tokens.size() - 1);
        if (tokens.size() >= 2 && !userInput.endsWith(OPTION_SEPARATOR) && (secondToLast = tokens.get(tokens.size() - 2)).startsWith(LONG_OPTION_SPECIFIER)) {
            return CompletionContext.optionValue(commandName, secondToLast, lastToken);
        }
        if (userInput.endsWith(OPTION_VALUE_SPECIFIER)) {
            String optionName = lastToken;
            return CompletionContext.optionValue(commandName, optionName, "");
        }
        if (lastToken.contains(OPTION_VALUE_SPECIFIER)) {
            int equalsIndex = lastToken.indexOf(OPTION_VALUE_SPECIFIER);
            String optionName = lastToken.substring(0, equalsIndex);
            String partialValue = lastToken.substring(equalsIndex + 1);
            return CompletionContext.optionValue(commandName, optionName, partialValue);
        }
        if (lastToken.startsWith(LONG_OPTION_SPECIFIER) && lastToken.length() > LONG_OPTION_SPECIFIER.length()) {
            boolean isValidOption;
            block17: {
                isValidOption = false;
                try {
                    Parameter[] parameters;
                    Method method = this.commandManager.getHelper().getCommandMethod(commandName);
                    if (method == null) break block17;
                    for (Parameter parameter : parameters = method.getParameters()) {
                        ShellOption annotation = parameter.getAnnotation(ShellOption.class);
                        if (annotation != null) {
                            for (String optName : annotation.value()) {
                                if (!lastToken.equals(LONG_OPTION_SPECIFIER + optName)) continue;
                                isValidOption = true;
                                break;
                            }
                        }
                        if (!isValidOption) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception method) {
                    // empty catch block
                }
            }
            if (isValidOption) {
                return CompletionContext.optionValue(commandName, lastToken, "");
            }
            boolean isFirstOption = tokens.stream().limit(tokens.size() - 1).noneMatch(t -> t.startsWith(LONG_OPTION_SPECIFIER));
            return CompletionContext.optionName(commandName, lastToken.substring(LONG_OPTION_SPECIFIER.length()), isFirstOption);
        }
        if (lastToken.equals(LONG_OPTION_SPECIFIER)) {
            boolean isFirstOption = tokens.stream().filter(t -> !t.equals(LONG_OPTION_SPECIFIER)).noneMatch(t -> t.startsWith(LONG_OPTION_SPECIFIER));
            return CompletionContext.optionName(commandName, "", isFirstOption);
        }
        if (!commandName.isEmpty() && userInput.endsWith(OPTION_SEPARATOR)) {
            String partialOption = "";
            boolean isFirstOption = tokens.stream().noneMatch(t -> t.startsWith(LONG_OPTION_SPECIFIER));
            return CompletionContext.optionName(commandName, partialOption, isFirstOption);
        }
        return CompletionContext.commandName(commandName);
    }

    private List<Completion> completeOptionValue(String commandName, String optionName, String partialValue) {
        try {
            Parameter[] parameters;
            Method method = this.commandManager.getHelper().getCommandMethod(commandName);
            if (method == null) {
                return new ArrayList<Completion>();
            }
            for (Parameter parameter : parameters = method.getParameters()) {
                ShellOption annotation = parameter.getAnnotation(ShellOption.class);
                if (annotation == null) continue;
                for (String optName : annotation.value()) {
                    String fullOptionName = LONG_OPTION_SPECIFIER + optName;
                    if (!fullOptionName.equals(optionName)) continue;
                    Class<?> parameterType = parameter.getType();
                    CompletionContext context = CompletionContext.optionValue(commandName, optionName, partialValue).withCommandManager(this.commandManager);
                    List<Completion> completions = this.completionProviderRegistry.getCompletions(parameterType, partialValue, context);
                    return completions;
                }
            }
        }
        catch (Exception e) {
            return new ArrayList<Completion>();
        }
        return new ArrayList<Completion>();
    }

    private Set<String> extractProvidedOptions(String userInput) {
        HashSet<String> providedOptions = new HashSet<String>();
        if (userInput == null || userInput.trim().isEmpty()) {
            return providedOptions;
        }
        List<String> tokens = GfshParser.splitUserInput(userInput);
        for (String token : tokens) {
            if (!token.startsWith(LONG_OPTION_SPECIFIER)) continue;
            String optionName = token.contains(OPTION_VALUE_SPECIFIER) ? token.substring(0, token.indexOf(OPTION_VALUE_SPECIFIER)) : token;
            providedOptions.add(optionName);
        }
        return providedOptions;
    }

    private CompletionWithIndex completeOptionName(String commandName, String partialOption, CompletionContext context, String userInput) {
        ArrayList<Completion> completions = new ArrayList<Completion>();
        HashMap<String, Integer> completionToParameterIndex = new HashMap<String, Integer>();
        Set<String> providedOptions = this.extractProvidedOptions(userInput);
        try {
            Method method = this.commandManager.getHelper().getCommandMethod(commandName);
            if (method == null) {
                return new CompletionWithIndex(completions, completionToParameterIndex);
            }
            Parameter[] parameters = method.getParameters();
            boolean foundNonMandatory = false;
            boolean foundConsecutiveStrings = false;
            boolean foundNonStringAfterStrings = false;
            for (int paramIndex = 0; paramIndex < parameters.length; ++paramIndex) {
                Parameter parameter = parameters[paramIndex];
                ShellOption annotation = parameter.getAnnotation(ShellOption.class);
                if (annotation == null) continue;
                boolean includeThisOption = true;
                if (context.isFirstOption()) {
                    String defaultValue = annotation.defaultValue();
                    Class<?> paramType = parameter.getType();
                    String[] optionNames = annotation.value();
                    boolean isTargetingParam = false;
                    boolean isArrayType = parameter.getType().isArray();
                    if (isArrayType && paramIndex > 0) {
                        for (String optName : optionNames) {
                            if (!optName.equals("group") && !optName.equals("groups") && !optName.equals("member") && !optName.equals("members")) continue;
                            isTargetingParam = true;
                            break;
                        }
                    }
                    if (isTargetingParam) {
                        includeThisOption = false;
                    }
                }
                if (!includeThisOption) continue;
                for (String optName : annotation.value()) {
                    String fullOptionName = LONG_OPTION_SPECIFIER + optName;
                    if (!partialOption.isEmpty() && !fullOptionName.startsWith(LONG_OPTION_SPECIFIER + partialOption)) continue;
                    completions.add(new Completion(fullOptionName));
                    completionToParameterIndex.put(fullOptionName, paramIndex);
                }
            }
        }
        catch (Exception e) {
            return new CompletionWithIndex(new ArrayList<Completion>(), new HashMap<String, Integer>());
        }
        if (!providedOptions.isEmpty()) {
            completions.removeIf(completion -> {
                boolean shouldRemove = providedOptions.contains(completion.getValue());
                if (shouldRemove) {
                    completionToParameterIndex.remove(completion.getValue());
                }
                return shouldRemove;
            });
        }
        return new CompletionWithIndex(completions, completionToParameterIndex);
    }

    public int completeAdvanced(String userInput, int cursor, List<Completion> candidates) {
        if (userInput == null || userInput.trim().isEmpty()) {
            return -1;
        }
        CompletionContext context = this.analyzeContext(userInput, cursor);
        if (context.getType() == CompletionContext.Type.COMMAND_NAME) {
            String partialCommand = context.getPartialInput();
            Set<String> allCommands = this.commandManager.getHelper().getCommands();
            List matchingCommands = allCommands.stream().filter(cmd -> partialCommand.isEmpty() || cmd.startsWith(partialCommand)).map(Completion::new).sorted(Comparator.comparing(Completion::getValue)).collect(Collectors.toList());
            if (matchingCommands.isEmpty() && partialCommand.contains(OPTION_SEPARATOR)) {
                String restOfInput;
                String[] parts = partialCommand.split(OPTION_SEPARATOR, 2);
                String firstWord = parts[0];
                String string = restOfInput = parts.length > 1 ? parts[1] : "";
                if (allCommands.contains(firstWord)) {
                    try {
                        Parameter firstParam;
                        ShellOption annotation;
                        Parameter[] parameters;
                        Method method = this.commandManager.getHelper().getCommandMethod(firstWord);
                        if (method != null && (parameters = method.getParameters()).length > 0 && (annotation = (firstParam = parameters[0]).getAnnotation(ShellOption.class)) != null && firstParam.getType().equals(String.class)) {
                            boolean isCompletableStringParam;
                            String defaultValue = annotation.defaultValue();
                            int arity = annotation.arity();
                            boolean bl = isCompletableStringParam = arity == -1 && "__NULL__".equals(defaultValue) || "".equals(defaultValue);
                            if (isCompletableStringParam) {
                                CompletionContext valueContext = CompletionContext.optionValue(firstWord, annotation.value()[0], restOfInput).withCommandManager(this.commandManager);
                                List<Completion> valueCompletions = this.completionProviderRegistry.getCompletions(firstParam.getType(), restOfInput, valueContext);
                                for (Completion valueCompletion : valueCompletions) {
                                    candidates.add(new Completion(firstWord + OPTION_SEPARATOR + valueCompletion.getValue()));
                                }
                                if (!candidates.isEmpty()) {
                                    return 0;
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (matchingCommands.size() == 1 && ((Completion)matchingCommands.get(0)).getValue().equals(partialCommand)) {
                CompletionContext optionContext = CompletionContext.optionName(partialCommand, "", true);
                CompletionWithIndex result = this.completeOptionName(optionContext.getCommandName(), optionContext.getPartialInput(), optionContext, userInput);
                if (!result.completions.isEmpty()) {
                    boolean hasLeadingSpace = result.completions.get(0).getValue().startsWith(OPTION_SEPARATOR);
                    for (Completion completion : result.completions) {
                        if (hasLeadingSpace) {
                            candidates.add(completion);
                            continue;
                        }
                        candidates.add(new Completion(OPTION_SEPARATOR + completion.getValue()));
                    }
                    return userInput.length();
                }
                return -1;
            }
            if (!matchingCommands.isEmpty()) {
                candidates.addAll(matchingCommands);
                return userInput.length() - partialCommand.length();
            }
            return -1;
        }
        if (context.getType() == CompletionContext.Type.OPTION_NAME) {
            Set<String> allCommands;
            List matchingCommands;
            CompletionWithIndex result = this.completeOptionName(context.getCommandName(), context.getPartialInput(), context, userInput);
            List<Completion> completions = result.completions;
            Map<String, Integer> parameterIndices = result.parameterIndices;
            if (completions.isEmpty() && context.getCommandName() != null && !(matchingCommands = (allCommands = this.commandManager.getHelper().getCommands()).stream().filter(cmd -> cmd.startsWith(context.getCommandName())).map(Completion::new).sorted(Comparator.comparing(Completion::getValue)).collect(Collectors.toList())).isEmpty()) {
                candidates.addAll(matchingCommands);
                return 0;
            }
            if (!completions.isEmpty()) {
                String partialWithPrefix;
                int partialStart;
                if (userInput.endsWith(LONG_OPTION_SPECIFIER) && context.getPartialInput().isEmpty()) {
                    if (context.isFirstOption()) {
                        int firstParamIndex = completions.isEmpty() ? 0 : parameterIndices.getOrDefault(completions.get(0).getValue(), 0);
                        List firstParamCompletions = completions.stream().filter(c -> parameterIndices.getOrDefault(c.getValue(), -1) == firstParamIndex).sorted(Comparator.comparing(Completion::getValue)).collect(Collectors.toList());
                        candidates.addAll(firstParamCompletions);
                    } else {
                        completions.sort(Comparator.comparing(Completion::getValue));
                        candidates.addAll(completions);
                    }
                    return userInput.length() - LONG_OPTION_SPECIFIER.length();
                }
                if (userInput.endsWith(OPTION_SEPARATOR)) {
                    if (context.isFirstOption()) {
                        completions.sort(Comparator.comparing(Completion::getValue));
                        for (Completion completion : completions) {
                            candidates.add(new Completion(OPTION_SEPARATOR + completion.getValue()));
                        }
                    } else {
                        completions.sort(Comparator.comparing(Completion::getValue));
                        for (Completion completion : completions) {
                            candidates.add(new Completion(OPTION_SEPARATOR + completion.getValue()));
                        }
                    }
                    return userInput.length() - 1;
                }
                completions.sort(Comparator.comparing(Completion::getValue));
                candidates.addAll(completions);
                if (!context.getPartialInput().isEmpty() && (partialStart = userInput.lastIndexOf(partialWithPrefix = LONG_OPTION_SPECIFIER + context.getPartialInput())) >= 0) {
                    return partialStart;
                }
                return userInput.length();
            }
        }
        if (context.getType() == CompletionContext.Type.OPTION_VALUE) {
            String optionName;
            List<Completion> completions = this.completeOptionValue(context.getCommandName(), context.getOptionName(), context.getPartialInput());
            if (!completions.isEmpty()) {
                int optionPos;
                if (userInput.endsWith(OPTION_VALUE_SPECIFIER)) {
                    candidates.addAll(completions);
                    return userInput.length();
                }
                optionName = context.getOptionName();
                boolean hasEqualsAfterOption = false;
                if (optionName != null && (optionPos = userInput.lastIndexOf(optionName)) >= 0) {
                    String afterOption = userInput.substring(optionPos + optionName.length());
                    hasEqualsAfterOption = afterOption.startsWith(OPTION_VALUE_SPECIFIER);
                }
                if (!hasEqualsAfterOption) {
                    for (Completion completion : completions) {
                        candidates.add(new Completion(OPTION_VALUE_SPECIFIER + completion.getValue()));
                    }
                    return userInput.length();
                }
                int optionPos2 = userInput.lastIndexOf(optionName);
                int equalsPos = optionPos2 + optionName.length();
                candidates.addAll(completions);
                return equalsPos + 1;
            }
            optionName = context.getOptionName();
            if (userInput.endsWith(OPTION_VALUE_SPECIFIER) || optionName != null && userInput.endsWith(optionName)) {
                if (optionName != null) {
                    candidates.add(new Completion(optionName));
                    int optionStartPos = userInput.lastIndexOf(optionName);
                    if (optionStartPos >= 0) {
                        if (userInput.endsWith(OPTION_VALUE_SPECIFIER)) {
                            return optionStartPos + 1;
                        }
                        return optionStartPos;
                    }
                }
                return -1;
            }
            CompletionContext optionNameContext = CompletionContext.optionName(context.getCommandName(), "", false);
            CompletionWithIndex result = this.completeOptionName(context.getCommandName(), "", optionNameContext, userInput);
            if (!result.completions.isEmpty()) {
                result.completions.sort(Comparator.comparing(Completion::getValue));
                for (Completion completion : result.completions) {
                    candidates.add(new Completion(OPTION_SEPARATOR + completion.getValue()));
                }
                return userInput.length();
            }
            return -1;
        }
        return -1;
    }

    private static class CompletionWithIndex {
        final List<Completion> completions;
        final Map<String, Integer> parameterIndices;

        CompletionWithIndex(List<Completion> completions, Map<String, Integer> parameterIndices) {
            this.completions = completions;
            this.parameterIndices = parameterIndices;
        }
    }
}

