/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

public class CompletionContext {
    private final Type type;
    private final String commandName;
    private final String optionName;
    private final String partialInput;
    private final int cursorPosition;
    private final boolean isFirstOption;
    private final Object commandManager;

    private CompletionContext(Type type, String commandName, String optionName, String partialInput, int cursorPosition, boolean isFirstOption, Object commandManager) {
        this.type = type;
        this.commandName = commandName;
        this.optionName = optionName;
        this.partialInput = partialInput != null ? partialInput : "";
        this.cursorPosition = cursorPosition;
        this.isFirstOption = isFirstOption;
        this.commandManager = commandManager;
    }

    public static CompletionContext commandName(String partialInput) {
        return new CompletionContext(Type.COMMAND_NAME, null, null, partialInput, 0, false, null);
    }

    public static CompletionContext optionName(String commandName, String partialOption, boolean isFirstOption) {
        return new CompletionContext(Type.OPTION_NAME, commandName, null, partialOption, 0, isFirstOption, null);
    }

    public static CompletionContext optionValue(String commandName, String optionName, String partialValue) {
        return new CompletionContext(Type.OPTION_VALUE, commandName, optionName, partialValue, 0, false, null);
    }

    public static CompletionContext unknown() {
        return new CompletionContext(Type.UNKNOWN, null, null, "", 0, false, null);
    }

    public Type getType() {
        return this.type;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getOptionName() {
        return this.optionName;
    }

    public String getPartialInput() {
        return this.partialInput;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public boolean isFirstOption() {
        return this.isFirstOption;
    }

    public Object getCommandManager() {
        return this.commandManager;
    }

    public CompletionContext withCommandManager(Object newCommandManager) {
        return new CompletionContext(this.type, this.commandName, this.optionName, this.partialInput, this.cursorPosition, this.isFirstOption, newCommandManager);
    }

    public String toString() {
        return "CompletionContext{type=" + String.valueOf((Object)this.type) + ", commandName='" + this.commandName + "', optionName='" + this.optionName + "', partialInput='" + this.partialInput + "', cursorPosition=" + this.cursorPosition + "}";
    }

    public static enum Type {
        COMMAND_NAME,
        OPTION_NAME,
        OPTION_VALUE,
        UNKNOWN;

    }
}

