/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.geode.cache.Cache;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.classloader.ClassPathLoader;
import org.apache.geode.management.cli.Disabled;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.CommandManagerAware;
import org.apache.geode.management.internal.cli.CommandMarker;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.help.Helper;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.util.ClasspathScanLoadHelper;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellMethodAvailability;

public class CommandManager {
    private static final String USER_CMD_PACKAGES_PROPERTY = "gemfire.user-command-packages";
    private static final String USER_CMD_PACKAGES_ENV_VARIABLE = "GEMFIRE_USER_COMMAND_PACKAGES";
    private final Helper helper = new Helper();
    private final List<Object> converters = new ArrayList<Object>();
    private final List<Object> commandMarkers = new ArrayList<Object>();
    private final Properties cacheProperties = new Properties();
    private final LogWrapper logWrapper;
    private final InternalCache cache;

    public CommandManager() {
        this.cache = null;
        this.logWrapper = LogWrapper.getInstance(null);
        this.loadCommands();
        this.loadConverters();
    }

    public CommandManager(Properties newCacheProperties, InternalCache cache) {
        if (newCacheProperties != null) {
            this.cacheProperties.putAll((Map<?, ?>)newCacheProperties);
        }
        this.cache = cache;
        this.logWrapper = LogWrapper.getInstance((Cache)cache);
        this.loadCommands();
        this.loadConverters();
    }

    private static void raiseExceptionIfEmpty(Set<?> foundClasses, String errorFor) throws IllegalStateException {
        if (foundClasses == null || foundClasses.isEmpty()) {
            throw new IllegalStateException("Required " + errorFor + " classes were not loaded. Check logs for errors.");
        }
    }

    private Set<String> getUserCommandPackages() {
        String cacheUserCmdPackages;
        HashSet<String> userCommandPackages = new HashSet<String>();
        ArrayList<String> userCommandSources = new ArrayList<String>();
        if (System.getProperty(USER_CMD_PACKAGES_PROPERTY) != null) {
            userCommandSources.add(System.getProperty(USER_CMD_PACKAGES_PROPERTY));
        }
        if (System.getenv().containsKey(USER_CMD_PACKAGES_ENV_VARIABLE)) {
            userCommandSources.add(System.getenv().get(USER_CMD_PACKAGES_ENV_VARIABLE));
        }
        if (!(cacheUserCmdPackages = this.cacheProperties.getProperty("user-command-packages", "")).isEmpty()) {
            userCommandSources.add(cacheUserCmdPackages);
        }
        for (String source : userCommandSources) {
            userCommandPackages.addAll(Arrays.asList(source.split(",")));
        }
        return userCommandPackages;
    }

    private void loadUserDefinedCommands() {
        String[] userCommandPackages = this.getUserCommandPackages().toArray(new String[0]);
        if (userCommandPackages.length == 0) {
            return;
        }
        try (ClasspathScanLoadHelper scanner = new ClasspathScanLoadHelper(userCommandPackages);){
            Set foundClasses = scanner.scanPackagesForClassesImplementing(CommandMarker.class, userCommandPackages);
            for (Class klass : foundClasses) {
                try {
                    this.add((CommandMarker)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception e) {
                    this.logWrapper.warning("Could not load User Commands from: " + String.valueOf(klass) + " due to " + e.getLocalizedMessage());
                }
            }
            CommandManager.raiseExceptionIfEmpty(foundClasses, "User Command");
        }
        catch (IllegalStateException e) {
            this.logWrapper.warning(e.getMessage(), e);
            throw e;
        }
    }

    private void loadGeodeCommands() {
        boolean loadedAtLeastOneCommand = false;
        ServiceLoader<CommandMarker> serviceLoaderCommands = ServiceLoader.load(CommandMarker.class, ClassPathLoader.getLatest().asClassLoader());
        for (CommandMarker commandMarker : serviceLoaderCommands) {
            this.add(commandMarker);
            loadedAtLeastOneCommand = true;
        }
        String[] commandPackages = new String[]{"org.apache.geode.management.internal.cli.commands", "org.apache.geode.management.cli", "org.apache.geode.cache.wan.internal.cli.commands", "org.apache.geode.connectors.jdbc.internal.cli", "org.apache.geode.cache.lucene.internal.cli.commands"};
        try (ClasspathScanLoadHelper scanner = new ClasspathScanLoadHelper(commandPackages);){
            HashSet foundClasses = new HashSet();
            Set shellComponentClasses = scanner.scanClasspathForAnnotation(ShellComponent.class, commandPackages);
            HashSet<Class> allShellComponentClasses = new HashSet<Class>();
            for (Class klass : shellComponentClasses) {
                Set concreteSubclasses = scanner.scanPackagesForSubclassesOf(klass, commandPackages);
                if (!concreteSubclasses.isEmpty()) {
                    allShellComponentClasses.addAll(concreteSubclasses);
                    continue;
                }
                if (Modifier.isAbstract(klass.getModifiers())) continue;
                allShellComponentClasses.add(klass);
            }
            foundClasses.addAll(allShellComponentClasses);
            Set commandMarkerClasses = scanner.scanPackagesForClassesImplementing(CommandMarker.class, commandPackages);
            foundClasses.addAll(commandMarkerClasses);
            for (Class klass : foundClasses) {
                try {
                    Object commandInstance = klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.add(commandInstance);
                    loadedAtLeastOneCommand = true;
                }
                catch (Exception e) {
                    this.logWrapper.warning("Could not load Command from: " + String.valueOf(klass) + " due to " + e.getLocalizedMessage());
                    e.printStackTrace();
                }
            }
            if (!loadedAtLeastOneCommand) {
                throw new IllegalStateException("Required Command classes were not loaded. Check logs for errors.");
            }
        }
        catch (IllegalStateException e) {
            this.logWrapper.warning(e.getMessage(), e);
            throw e;
        }
    }

    private void loadConverters() {
        this.loadGeodeDefinedConverters();
        this.loadSpringDefinedConverters();
    }

    private void loadCommands() {
        this.loadGeodeCommands();
        this.loadUserDefinedCommands();
    }

    private void loadSpringDefinedConverters() {
    }

    private void loadGeodeDefinedConverters() {
    }

    public List<Object> getCommandMarkers() {
        return this.commandMarkers;
    }

    public void add(Object commandMarker) {
        GfshCommand gfshCommand;
        Disabled classDisabled = commandMarker.getClass().getAnnotation(Disabled.class);
        if (classDisabled != null && (classDisabled.unlessPropertyIsSet().isEmpty() || System.getProperty(classDisabled.unlessPropertyIsSet()) == null)) {
            return;
        }
        if (GfshCommand.class.isAssignableFrom(commandMarker.getClass()) && !(gfshCommand = (GfshCommand)commandMarker).hasCacheSet()) {
            gfshCommand.setCache((Cache)this.cache);
        }
        if (CommandManagerAware.class.isAssignableFrom(commandMarker.getClass())) {
            ((CommandManagerAware)commandMarker).setCommandManager(this);
        }
        this.commandMarkers.add(commandMarker);
        for (Method method : commandMarker.getClass().getMethods()) {
            ShellMethod shellMethod = method.getAnnotation(ShellMethod.class);
            ShellMethodAvailability availability = method.getAnnotation(ShellMethodAvailability.class);
            if (shellMethod == null && availability == null) continue;
            if (shellMethod != null) {
                this.helper.addCommand(shellMethod, method);
            }
            if (availability == null) continue;
            this.helper.addAvailabilityIndicator(availability, method, commandMarker);
        }
    }

    public Helper getHelper() {
        return this.helper;
    }

    public String obtainHelp(String buffer) {
        int terminalWidth = -1;
        Gfsh gfsh = Gfsh.getCurrentInstance();
        if (gfsh != null) {
            terminalWidth = gfsh.getTerminalWidth();
        }
        return this.helper.getHelp(buffer, terminalWidth);
    }

    public String obtainHint(String topic) {
        return this.helper.getHint(topic);
    }
}

