/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheForClientAccess;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.functions.CliFunctionResult;

public class RegionDestroyFunction
implements InternalFunction<String> {
    private static final long serialVersionUID = 9172773671865750685L;
    @Immutable
    public static final RegionDestroyFunction INSTANCE = new RegionDestroyFunction();
    private static final String ID = RegionDestroyFunction.class.getName();

    public boolean hasResult() {
        return true;
    }

    public void execute(FunctionContext<String> context) {
        String regionPath = (String)context.getArguments();
        String memberName = context.getMemberName();
        try {
            String functionId = context.getFunctionId();
            if (!this.getId().equals(functionId) || regionPath == null) {
                context.getResultSender().lastResult((Object)new CliFunctionResult("", false, "Function Id mismatch or arguments is not available."));
                return;
            }
            InternalCacheForClientAccess cache = ((InternalCache)context.getCache()).getCacheForProcessingClientRequests();
            Region region = cache.getRegion(regionPath);
            if (region == null) {
                context.getResultSender().lastResult((Object)new CliFunctionResult(memberName, true, String.format("Region '%s' already destroyed", regionPath)));
                return;
            }
            region.destroyRegion();
            String regionName = regionPath.startsWith("/") ? regionPath.substring(1) : regionPath;
            XmlEntity xmlEntity = new XmlEntity("region", "name", regionName);
            context.getResultSender().lastResult((Object)new CliFunctionResult(memberName, xmlEntity, String.format("Region '%s' destroyed successfully", regionPath)));
        }
        catch (IllegalStateException ex) {
            context.getResultSender().lastResult((Object)new CliFunctionResult(memberName, false, ex.getMessage()));
        }
        catch (RegionDestroyedException ex) {
            context.getResultSender().lastResult((Object)new CliFunctionResult(memberName, true, String.format("Region '%s' already destroyed", regionPath)));
        }
        catch (Exception ex) {
            LogService.getLogger().error(ex.getMessage(), (Throwable)ex);
            context.getResultSender().lastResult((Object)new CliFunctionResult(memberName, (Object)ex, ex.getMessage()));
        }
    }

    public String getId() {
        return ID;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public boolean isHA() {
        return false;
    }
}

