/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Set;
import javax.management.ObjectName;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.GatewayReceiverMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class StartGatewayReceiverCommand
extends GfshCommand {
    @CliCommand(value={"start gateway-receiver"}, help="Start the Gateway Receiver on a member or members.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.GATEWAY)
    public ResultModel startGatewayReceiver(@CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) of members on which to start the Gateway Receiver.") String[] onGroup, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the member on which to start the Gateway Receiver.") String[] onMember) throws Exception {
        SystemManagementService service = (SystemManagementService)this.getManagementService();
        Set<DistributedMember> dsMembers = this.findMembers(onGroup, onMember);
        if (dsMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        ResultModel resultModel = new ResultModel();
        TabularResultModel resultData = resultModel.addTable("start gateway-receiver");
        for (DistributedMember member : dsMembers) {
            ObjectName gatewayReceiverObjectName = MBeanJMXAdapter.getGatewayReceiverMBeanName((DistributedMember)member);
            if (gatewayReceiverObjectName != null) {
                GatewayReceiverMXBean receiverBean = (GatewayReceiverMXBean)service.getMBeanProxy(gatewayReceiverObjectName, GatewayReceiverMXBean.class);
                if (receiverBean != null) {
                    if (receiverBean.isRunning()) {
                        resultData.addMemberStatusResultRow(member.getId(), "Error", CliStrings.format((String)"GatewayReceiver is already started on member {0}", (Object[])new Object[]{member.getId()}));
                        continue;
                    }
                    receiverBean.start();
                    resultData.addMemberStatusResultRow(member.getId(), "OK", CliStrings.format((String)"GatewayReceiver is started on member {0}", (Object[])new Object[]{member.getId()}));
                    continue;
                }
                resultData.addMemberStatusResultRow(member.getId(), "Error", CliStrings.format((String)"GatewayReceiver is not available on member {0}", (Object[])new Object[]{member.getId()}));
                continue;
            }
            resultData.addMemberStatusResultRow(member.getId(), "Error", CliStrings.format((String)"GatewayReceiver is not available on member {0}", (Object[])new Object[]{member.getId()}));
        }
        return resultModel;
    }
}

