/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.commands.OfflineGfshCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DebugCommand
extends OfflineGfshCommand {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CliCommand(value={"debug"}, help="Enable/Disable debugging output in GFSH.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH", "Debug-Utility"})
    public ResultModel debug(@CliOption(key={"state"}, unspecifiedDefaultValue="OFF", mandatory=true, optionContext="debug", help="ON or OFF to enable or disable debugging output.") String state) {
        Gfsh gfshInstance = Gfsh.getCurrentInstance();
        if (gfshInstance == null) return ResultModel.createError("Could not get GFSH Instance");
        if (state.equalsIgnoreCase("ON")) {
            gfshInstance.setDebug(true);
            return ResultModel.createInfo("Debug is " + state);
        } else {
            if (!state.equalsIgnoreCase("OFF")) return ResultModel.createError(CliStrings.format((String)"Invalid state value : {0}. It should be \"ON\" or \"OFF\" ", (Object)state));
            gfshInstance.setDebug(false);
        }
        return ResultModel.createInfo("Debug is " + state);
    }
}

