/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.cache.Cache;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.functions.CliFunctionResult;

public class ResumeAsyncEventQueueDispatcherFunction
extends CliFunction {
    public CliFunctionResult executeFunction(FunctionContext context) {
        String AEQId = (String)context.getArguments();
        Cache cache = context.getCache();
        DistributedMember member = cache.getDistributedSystem().getDistributedMember();
        AsyncEventQueue queue = cache.getAsyncEventQueue(AEQId);
        if (queue == null) {
            return new CliFunctionResult(member.getId(), CliFunctionResult.StatusState.ERROR, "Async Event Queue \"" + AEQId + " cannot be found");
        }
        if (queue.isDispatchingPaused()) {
            queue.resumeEventDispatching();
            return new CliFunctionResult(member.getId(), CliFunctionResult.StatusState.OK, "Async Event Queue \"" + AEQId + "\" dispatching was resumed successfully");
        }
        return new CliFunctionResult(member.getId(), CliFunctionResult.StatusState.OK, "Async Event Queue \"" + AEQId + "\" dispatching was not paused.");
    }
}

