/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.query.management.configuration.QueryConfigService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.functions.AlterQueryServiceFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class AlterQueryServiceCommand
extends SingleGfshCommand {
    static final String COMMAND_NAME = "alter query-service";
    private static final String COMMAND_HELP = "Alter configuration parameters for the query service";
    static final String AUTHORIZER_NAME = "method-authorizer";
    private static final String METHOD_AUTHORIZER_NAME_HELP = "The name of the class to be used for OQL method authorization";
    static final String AUTHORIZER_PARAMETERS = "authorizer-parameters";
    private static final String AUTHORIZER_PARAMETERS_HELP = "A semicolon separated list of all parameter values for the specified method authorizer.";
    static final String FORCE_UPDATE = "force-update";
    private static final String FORCE_UPDATE_HELP = "Flag to indicate whether to forcibly update the currently configured authorizer, even when there are continuous queries registered (use with caution)";
    static final String NO_MEMBERS_FOUND_MESSAGE = "No members found.";
    public static final String PARTIAL_FAILURE_MESSAGE = "In the event of a partial failure of this command, re-running the command or restarting failing members should restore consistency.";
    static final String SPLITTING_REGEX = ";";
    private final AlterQueryServiceFunction alterQueryServiceFunction = new AlterQueryServiceFunction();

    @CliCommand(value={"alter query-service"}, help="Alter configuration parameters for the query service")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel execute(@CliOption(key={"method-authorizer"}, help="The name of the class to be used for OQL method authorization", mandatory=true) String methodAuthorizerName, @CliOption(key={"authorizer-parameters"}, help="A semicolon separated list of all parameter values for the specified method authorizer.", optionContext="splittingRegex=;") String[] authorizerParameters, @CliOption(key={"force-update"}, help="Flag to indicate whether to forcibly update the currently configured authorizer, even when there are continuous queries registered (use with caution)", specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean forceUpdate) {
        ResultModel result;
        HashSet<String> parametersSet = new HashSet<String>();
        QueryConfigService queryConfigService = this.getQueryConfigService();
        if (authorizerParameters != null) {
            parametersSet.addAll(Arrays.asList(authorizerParameters));
        }
        this.populateMethodAuthorizer(methodAuthorizerName, parametersSet, queryConfigService);
        Set<DistributedMember> targetMembers = this.findMembers(null, null);
        if (targetMembers.isEmpty()) {
            result = ResultModel.createInfo(NO_MEMBERS_FOUND_MESSAGE);
        } else {
            String footer = null;
            Object[] args = new Object[]{forceUpdate, methodAuthorizerName, parametersSet};
            List<CliFunctionResult> functionResults = this.executeAndGetFunctionResult((Function)this.alterQueryServiceFunction, args, targetMembers);
            if (functionResults.stream().anyMatch(CliFunctionResult::isSuccessful) && functionResults.stream().anyMatch(functionResult -> !functionResult.isSuccessful())) {
                footer = PARTIAL_FAILURE_MESSAGE;
            }
            result = ResultModel.createMemberStatusResult(functionResults, null, footer, false, true);
        }
        result.setConfigObject(queryConfigService);
        return result;
    }

    void populateMethodAuthorizer(String methodAuthorizerName, Set<String> parameterSet, QueryConfigService queryConfigService) {
        QueryConfigService.MethodAuthorizer methodAuthorizer = new QueryConfigService.MethodAuthorizer();
        methodAuthorizer.setClassName(methodAuthorizerName);
        if (!parameterSet.isEmpty()) {
            ArrayList<QueryConfigService.MethodAuthorizer.Parameter> parameterList = new ArrayList<QueryConfigService.MethodAuthorizer.Parameter>();
            for (String value : parameterSet) {
                QueryConfigService.MethodAuthorizer.Parameter parameter = new QueryConfigService.MethodAuthorizer.Parameter();
                parameter.setParameterValue(value);
                parameterList.add(parameter);
            }
            methodAuthorizer.setParameters(parameterList);
        }
        queryConfigService.setMethodAuthorizer(methodAuthorizer);
    }

    QueryConfigService getQueryConfigService() {
        QueryConfigService queryConfigService;
        CacheConfig cacheConfig;
        Object configService = this.getConfigurationPersistenceService();
        if (configService != null && (cacheConfig = configService.getCacheConfig(null)) != null && (queryConfigService = (QueryConfigService)cacheConfig.findCustomCacheElement("query-config-service", QueryConfigService.class)) != null) {
            return queryConfigService;
        }
        return new QueryConfigService();
    }

    @Override
    public boolean updateConfigForGroup(String group, CacheConfig config, Object configObject) {
        if (configObject instanceof QueryConfigService) {
            List elements = config.getCustomCacheElements();
            elements.removeIf(e -> e instanceof QueryConfigService);
            elements.add((QueryConfigService)configObject);
            return true;
        }
        return false;
    }
}

