/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.i18n.CliStrings;

public class CloseDurableClientFunction
implements InternalFunction {
    private static final long serialVersionUID = 1L;

    public void execute(FunctionContext context) {
        String durableClientId = (String)context.getArguments();
        Cache cache = context.getCache();
        String memberNameOrId = CliUtil.getMemberNameOrId(cache.getDistributedSystem().getDistributedMember());
        context.getResultSender().lastResult((Object)this.createFunctionResult(memberNameOrId, durableClientId));
    }

    private CliFunctionResult createFunctionResult(String memberNameOrId, String durableClientId) {
        try {
            CacheClientNotifier cacheClientNotifier = CacheClientNotifier.getInstance();
            if (cacheClientNotifier == null) {
                return new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.ERROR, "No client found on this server");
            }
            CacheClientProxy ccp = cacheClientNotifier.getClientProxy(durableClientId);
            if (ccp == null) {
                return new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.ERROR, CliStrings.format((String)"No client found with client-id : {0}", (Object)durableClientId));
            }
            boolean isClosed = cacheClientNotifier.closeDurableClientProxy(durableClientId);
            if (isClosed) {
                return new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.OK, CliStrings.format((String)"Closed the durable client : \"{0}\".", (Object)durableClientId));
            }
            return new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.ERROR, CliStrings.format((String)"No client found with client-id : {0}", (Object)durableClientId));
        }
        catch (Exception e) {
            return new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.ERROR, e.getMessage());
        }
    }
}

