/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.rules.AbstractDistributedRule;
import org.apache.geode.util.internal.UncheckedUtils;

public class DistributedMap<K, V>
extends AbstractDistributedRule
implements Map<K, V> {
    private static final AtomicReference<Map<Integer, Map<?, ?>>> MAPS = new AtomicReference(new HashMap());
    private final AtomicReference<VM> controller = new AtomicReference();
    private final Map<K, V> initialEntries = new HashMap();
    private final int identity;

    public static Builder builder() {
        return new Builder();
    }

    public DistributedMap() {
        this(new Builder());
    }

    public DistributedMap(int vmCount) {
        this(new Builder().vmCount(vmCount));
    }

    private DistributedMap(Builder<K, V> builder) {
        this(builder.vmCount, builder.initialEntries);
    }

    private DistributedMap(int vmCount, Map<K, V> initialEntries) {
        super(vmCount);
        this.initialEntries.putAll(initialEntries);
        this.identity = System.identityHashCode(this);
    }

    @Override
    protected void before() {
        this.controller.set(VM.getController());
        MAPS.get().put(this.identity, new HashMap());
        this.map().clear();
        this.map().putAll(this.initialEntries);
    }

    @Override
    protected void after() {
        for (Map<?, ?> map : MAPS.get().values()) {
            map.clear();
        }
        MAPS.get().clear();
    }

    @Override
    public int size() {
        return (Integer)this.controller().invoke(() -> this.map().size());
    }

    @Override
    public boolean isEmpty() {
        return (Boolean)this.controller().invoke(() -> this.map().isEmpty());
    }

    @Override
    public boolean containsKey(Object key) {
        return (Boolean)this.controller().invoke(() -> this.map().containsKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return (Boolean)this.controller().invoke(() -> this.map().containsValue(value));
    }

    @Override
    public V get(Object key) {
        return this.controller().invoke(() -> this.map().get(key));
    }

    @Override
    public V put(K key, V value) {
        return this.controller().invoke(() -> this.map().put(key, value));
    }

    @Override
    public V remove(Object key) {
        return this.controller().invoke(() -> this.map().remove(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.controller().invoke(() -> this.map().putAll(m));
    }

    @Override
    public void clear() {
        this.controller().invoke(() -> this.map().clear());
    }

    @Override
    public Set<K> keySet() {
        return (Set)this.controller().invoke(() -> this.map().keySet());
    }

    @Override
    public Collection<V> values() {
        return (Collection)this.controller().invoke(() -> this.map().values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return (Set)this.controller().invoke(() -> this.map().entrySet());
    }

    @Override
    public boolean equals(Object obj) {
        return (Boolean)this.controller().invoke(() -> this.map().equals(obj));
    }

    @Override
    public int hashCode() {
        return (Integer)this.controller().invoke(() -> this.map().hashCode());
    }

    public String toString() {
        return (String)this.controller().invoke(() -> this.map().toString());
    }

    public Map<K, V> map() {
        return (Map)UncheckedUtils.uncheckedCast(MAPS.get().get(this.identity));
    }

    private VM controller() {
        VM vm = this.controller.get();
        if (vm == null) {
            String message = this.getClass().getSimpleName() + " has not been initialized by JUnit";
            throw new IllegalStateException(message);
        }
        return vm;
    }

    public static class Builder<K, V> {
        private final Map<K, V> initialEntries = new HashMap();
        private int vmCount = VM.DEFAULT_VM_COUNT;

        public Builder<K, V> vmCount(int vmCount) {
            this.vmCount = vmCount;
            return this;
        }

        public Builder<K, V> put(K key, V value) {
            this.initialEntries.put(key, value);
            return this;
        }

        public Builder<K, V> putAll(Map<? extends K, ? extends V> m) {
            this.initialEntries.putAll(m);
            return this;
        }

        public DistributedMap<K, V> build() {
            return new DistributedMap(this);
        }
    }
}

