/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.rules.AbstractDistributedRule;
import org.apache.geode.test.junit.rules.accessible.AccessibleErrorCollector;
import org.hamcrest.Matcher;

public class DistributedErrorCollector
extends AbstractDistributedRule {
    private static volatile AccessibleErrorCollector errorCollector;
    private final Map<Integer, List<Throwable>> beforeBounceErrors = new HashMap<Integer, List<Throwable>>();

    @Override
    protected void before() {
        this.invoker().invokeInEveryVMAndController(this::invokeBefore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void after() throws Throwable {
        AccessibleErrorCollector allErrors = errorCollector;
        try {
            for (VM vm : VM.getAllVMs()) {
                ArrayList remoteFailures = new ArrayList((Collection)vm.invoke(() -> errorCollector.errors()));
                for (Throwable t : remoteFailures) {
                    allErrors.addError(t);
                }
            }
            this.invoker().invokeInEveryVMAndController(() -> {
                errorCollector = null;
            });
        }
        finally {
            allErrors.verify();
        }
    }

    @Override
    protected void afterCreateVM(VM vm) {
        vm.invoke(this::invokeBefore);
    }

    @Override
    protected void beforeBounceVM(VM vm) {
        this.beforeBounceErrors.put(vm.getId(), (List)vm.invoke(() -> errorCollector.errors()));
    }

    @Override
    protected void afterBounceVM(VM vm) {
        List<Throwable> beforeBounceErrorsForVM = this.beforeBounceErrors.remove(vm.getId());
        vm.invoke(() -> {
            this.invokeBefore();
            errorCollector.addErrors((Collection)beforeBounceErrorsForVM);
        });
    }

    public void addError(Throwable error) {
        errorCollector.addError(error);
    }

    public <T> void checkThat(T value, Matcher<T> matcher) {
        errorCollector.checkThat(value, matcher);
    }

    public <T> void checkThat(String reason, T value, Matcher<T> matcher) {
        errorCollector.checkThat(reason, value, matcher);
    }

    public <T> T checkSucceeds(Callable<T> callable) {
        return (T)errorCollector.checkSucceeds(callable);
    }

    private void invokeBefore() {
        errorCollector = new AccessibleErrorCollector();
    }
}

