/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security.templates;

import java.security.Principal;
import java.util.Properties;
import javax.naming.directory.InitialDirContext;
import org.apache.geode.LogWriter;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.Authenticator;
import org.apache.geode.security.templates.UsernamePrincipal;
import org.apache.logging.log4j.Logger;

public class LdapUserAuthenticator
implements Authenticator {
    private static final Logger logger = LogService.getLogger();
    public static final String LDAP_SERVER_NAME = "security-ldap-server";
    public static final String LDAP_BASEDN_NAME = "security-ldap-basedn";
    public static final String LDAP_SSL_NAME = "security-ldap-usessl";
    private String ldapServer = null;
    private String baseDomainName = null;
    private String ldapUrlScheme = null;

    public static Authenticator create() {
        return new LdapUserAuthenticator();
    }

    public void init(Properties securityProps, LogWriter systemLogWriter, LogWriter securityLogWriter) throws AuthenticationFailedException {
        logger.info("Initializing LdapUserAuthenticator with {}", (Object)securityProps);
        this.ldapServer = securityProps.getProperty(LDAP_SERVER_NAME);
        if (this.ldapServer == null || this.ldapServer.length() == 0) {
            throw new AuthenticationFailedException("LdapUserAuthenticator: LDAP server property [security-ldap-server] not specified");
        }
        this.baseDomainName = securityProps.getProperty(LDAP_BASEDN_NAME);
        if (this.baseDomainName == null || this.baseDomainName.length() == 0) {
            throw new AuthenticationFailedException("LdapUserAuthenticator: LDAP base DN property [security-ldap-basedn] not specified");
        }
        String sslName = securityProps.getProperty(LDAP_SSL_NAME);
        this.ldapUrlScheme = sslName != null && sslName.equalsIgnoreCase("true") ? "ldaps://" : "ldap://";
    }

    public Principal authenticate(Properties credentials, DistributedMember member) {
        String userName = credentials.getProperty("security-username");
        if (userName == null) {
            throw new AuthenticationFailedException("LdapUserAuthenticator: user name property [security-username] not provided");
        }
        String password = credentials.getProperty("security-password");
        if (password == null) {
            password = "";
        }
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.ldapUrlScheme + this.ldapServer + "/" + this.baseDomainName);
        env.put("java.naming.security.principal", "uid=" + userName + "," + this.baseDomainName);
        env.put("java.naming.security.credentials", password);
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            ctx.close();
        }
        catch (Exception e) {
            throw new AuthenticationFailedException("LdapUserAuthenticator: Failure with provided username, password combination for user name: " + userName, (Throwable)e);
        }
        return new UsernamePrincipal(userName);
    }

    public void close() {
    }
}

