/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Properties;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.functions.TestFunction;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.internal.cli.commands.ToUpperResultCollector;
import org.apache.geode.test.awaitility.GeodeAwaitility;
import org.apache.geode.test.dunit.rules.ClusterStartupRule;
import org.apache.geode.test.dunit.rules.MemberVM;
import org.apache.geode.test.junit.rules.GfshCommandRule;
import org.apache.geode.test.junit.rules.MemberStarterRule;
import org.assertj.core.util.Strings;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class FunctionCommandsDistributedTestBase {
    private static MemberVM locator;
    private static MemberVM server1;
    private static MemberVM server2;
    private static final String REGION_ONE = "RegionOne";
    private static final String REGION_TWO = "RegionTwo";
    @ClassRule
    public static ClusterStartupRule lsRule;
    @ClassRule
    public static GfshCommandRule gfsh;

    @BeforeClass
    public static void before() {
        locator = lsRule.startLocatorVM(0, MemberStarterRule::withHttpService);
        Properties props = new Properties();
        props.setProperty("groups", "group-1");
        server1 = lsRule.startServerVM(1, props, locator.getPort());
        server2 = lsRule.startServerVM(2, locator.getPort());
        server1.invoke(() -> {
            int i;
            InternalCache cache = ClusterStartupRule.getCache();
            RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
            Region region = dataRegionFactory.create(REGION_ONE);
            for (i = 0; i < 10; ++i) {
                region.put((Object)("key" + (i + 200)), (Object)("value" + (i + 200)));
            }
            region = dataRegionFactory.create(REGION_TWO);
            for (i = 0; i < 1000; ++i) {
                region.put((Object)("key" + (i + 200)), (Object)("value" + (i + 200)));
            }
        });
        server2.invoke(() -> {
            int i;
            InternalCache cache = ClusterStartupRule.getCache();
            RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
            Region region = dataRegionFactory.create(REGION_ONE);
            for (i = 0; i < 10000; ++i) {
                region.put((Object)("key" + (i + 400)), (Object)("value" + (i + 400)));
            }
            region = dataRegionFactory.create(REGION_TWO);
            for (i = 0; i < 10; ++i) {
                region.put((Object)("key" + (i + 200)), (Object)("value" + (i + 200)));
            }
        });
        locator.invoke(() -> {
            InternalCache cache = ClusterStartupRule.getCache();
            ManagementService managementService = ManagementService.getManagementService((Cache)cache);
            DistributedSystemMXBean dsMXBean = managementService.getDistributedSystemMXBean();
            GeodeAwaitility.await().until(() -> dsMXBean.getMemberCount() == 3);
        });
    }

    @Before
    public void setup() throws Exception {
        FunctionCommandsDistributedTestBase.registerFunction(new TestFunction(true, "TestFunction1"), locator, server1, server2);
        FunctionCommandsDistributedTestBase.registerFunction(new TestFunction(true, "executeFunctionToReturnArgs"), locator, server1, server2);
        FunctionCommandsDistributedTestBase.registerFunction(new TestFunction(true, "TestFunctionAlwaysThrowsException"), locator, server1, server2);
        FunctionCommandsDistributedTestBase.registerFunction(new TestFunction(true, "executeFunctionOnOneMemberToReturnArgs"), locator, server1);
        this.connectGfsh();
    }

    public void connectGfsh() throws Exception {
        gfsh.connectAndVerify(this.getLocator().getJmxPort(), GfshCommandRule.PortType.jmxManager, new String[0]);
    }

    public MemberVM getLocator() {
        return locator;
    }

    private static void registerFunction(Function<?> function, MemberVM ... vms) {
        for (MemberVM vm : vms) {
            vm.invoke(() -> FunctionService.registerFunction((Function)function));
        }
    }

    @Test
    public void testExecuteFunctionOnRegion() {
        gfsh.executeAndAssertThat("execute function --id=TestFunction1 --region=/RegionOne").statusIsSuccess().hasTableSection().hasRowSize(1).hasAnyRow().contains(new String[]{"OK", "[false, false]"});
    }

    @Test
    public void testExecuteFunctionOnUnknownRegion() {
        gfsh.executeAndAssertThat("execute function --id=TestFunction1 --region=/UNKNOWN").statusIsError().containsOutput(new String[]{"No members found"});
    }

    @Test
    public void testExecuteUnknownFunction() {
        gfsh.executeAndAssertThat("execute function --id=UNKNOWN_FUNCTION").statusIsError().containsOutput(new String[]{"UNKNOWN_FUNCTION is not registered on member"});
    }

    @Test
    public void testExecuteFunctionOnRegionWithCustomResultCollector() {
        gfsh.executeAndAssertThat("execute function --id=executeFunctionToReturnArgs --region=RegionOne --arguments=arg1 --result-collector=" + ToUpperResultCollector.class.getName()).statusIsSuccess().hasTableSection().hasRowSize(1).hasAnyRow().contains(new String[]{"OK", "[ARG1, ARG1]"});
    }

    @Test
    public void testExecuteFunctionOnMember() {
        gfsh.executeAndAssertThat("execute function --id=TestFunction1 --member=" + server1.getMember().getName()).statusIsSuccess().hasTableSection().hasRowSize(1).hasAnyRow().contains(new String[]{"server-1", "OK", "[false]"});
    }

    @Test
    public void testExecuteFunctionOnInvalidMember() {
        gfsh.executeAndAssertThat("execute function --id=TestFunction1 --member=INVALID_MEMBER").statusIsError();
    }

    @Test
    public void testExecuteFunctionOnAllMembers() {
        gfsh.executeAndAssertThat("execute function --id=TestFunction1").statusIsSuccess().hasTableSection().hasRowSize(2).hasAnyRow().contains(new String[]{"server-1", "OK", "[false]"}).hasAnyRow().contains(new String[]{"server-2", "OK", "[false]"});
    }

    @Test
    public void testExecuteFunctionOnMultipleMembers() {
        gfsh.executeAndAssertThat("execute function --id=TestFunction1 --member=" + Strings.join((String[])new String[]{server1.getName(), server2.getName()}).with(",")).statusIsSuccess().hasTableSection().hasRowSize(2).hasAnyRow().contains(new String[]{"server-1", "OK", "[false]"}).hasAnyRow().contains(new String[]{"server-2", "OK", "[false]"});
    }

    @Test
    public void testExecuteFunctionOnMultipleMembersWithArgsAndResultCollector() {
        gfsh.executeAndAssertThat("execute function --id=executeFunctionToReturnArgs --arguments=arg1 --result-collector=" + ToUpperResultCollector.class.getName()).statusIsSuccess().hasTableSection().hasRowSize(2).hasAnyRow().contains(new String[]{"server-1", "OK", "[ARG1]"}).hasAnyRow().contains(new String[]{"server-2", "OK", "[ARG1]"});
    }

    @Test
    public void testFunctionOnlyRegisteredOnOneMember() {
        gfsh.executeAndAssertThat("execute function --id=executeFunctionOnOneMemberToReturnArgs").statusIsError().hasTableSection().hasRowSize(2).hasAnyRow().contains(new String[]{"server-1", "OK", "[false]"}).hasAnyRow().contains(new String[]{"server-2", "ERROR", "Function : executeFunctionOnOneMemberToReturnArgs is not registered on member."});
    }

    @Test
    public void testExecuteFunctionOnGroup() {
        gfsh.executeAndAssertThat("execute function --id=TestFunction1 --groups=group-1").statusIsSuccess().hasTableSection().hasRowSize(1).hasAnyRow().contains(new String[]{"server-1", "OK", "[false]"});
    }

    @Test
    public void testDestroyFunctionOnMember() {
        gfsh.executeAndAssertThat("destroy function --id=TestFunction1 --member=" + server1.getName()).statusIsSuccess();
        gfsh.executeAndAssertThat("list functions").statusIsSuccess().hasTableSection().hasColumn("Function").containsExactlyInAnyOrder((Object[])new String[]{"executeFunctionToReturnArgs", "TestFunction1", "executeFunctionToReturnArgs", "TestFunctionAlwaysThrowsException", "TestFunctionAlwaysThrowsException", "executeFunctionOnOneMemberToReturnArgs"});
        gfsh.executeAndAssertThat("destroy function --id=TestFunction1 --member=" + server2.getName()).statusIsSuccess();
        gfsh.executeAndAssertThat("list functions").statusIsSuccess().hasTableSection().hasColumn("Function").containsExactlyInAnyOrder((Object[])new String[]{"executeFunctionToReturnArgs", "executeFunctionToReturnArgs", "TestFunctionAlwaysThrowsException", "TestFunctionAlwaysThrowsException", "executeFunctionOnOneMemberToReturnArgs"});
    }

    @Test
    public void testDestroyFunctionOnGroup() {
        gfsh.executeAndAssertThat("destroy function --id=TestFunction1 --groups=group-1").statusIsSuccess();
        gfsh.executeAndAssertThat("list functions").statusIsSuccess().hasTableSection().hasColumn("Function").contains((Object[])new String[]{"executeFunctionToReturnArgs", "TestFunction1", "executeFunctionToReturnArgs", "TestFunctionAlwaysThrowsException", "TestFunctionAlwaysThrowsException", "executeFunctionOnOneMemberToReturnArgs"});
    }

    @Test
    public void testListFunctions() {
        gfsh.executeAndAssertThat("list functions").statusIsSuccess().hasTableSection().hasColumn("Function").containsExactlyInAnyOrder((Object[])new String[]{"TestFunction1", "TestFunction1", "executeFunctionToReturnArgs", "executeFunctionToReturnArgs", "TestFunctionAlwaysThrowsException", "TestFunctionAlwaysThrowsException", "executeFunctionOnOneMemberToReturnArgs"});
        gfsh.executeAndAssertThat("list functions --matches=Test.*").statusIsSuccess().hasTableSection().hasColumn("Function").containsExactlyInAnyOrder((Object[])new String[]{"TestFunction1", "TestFunction1", "TestFunctionAlwaysThrowsException", "TestFunctionAlwaysThrowsException"});
        gfsh.executeAndAssertThat("list functions --matches=Test.* --groups=group-1").statusIsSuccess().hasTableSection().hasColumn("Function").containsExactlyInAnyOrder((Object[])new String[]{"TestFunction1", "TestFunctionAlwaysThrowsException"});
        gfsh.executeAndAssertThat("list functions --matches=Test.* --members=" + server1.getName()).statusIsSuccess().hasTableSection().hasColumn("Function").containsExactlyInAnyOrder((Object[])new String[]{"TestFunction1", "TestFunctionAlwaysThrowsException"});
    }

    @Test
    public void testFunctionException() {
        String errorMessage = "Exception: org.apache.geode.internal.cache.execute.MyFunctionExecutionException: I have been thrown from TestFunction";
        gfsh.executeAndAssertThat("execute function --id=TestFunctionAlwaysThrowsException").statusIsError().hasTableSection().hasRowSize(2).hasAnyRow().contains(new String[]{"server-1", "ERROR", errorMessage}).hasAnyRow().contains(new String[]{"server-2", "ERROR", errorMessage});
    }

    static {
        lsRule = new ClusterStartupRule();
        gfsh = new GfshCommandRule();
    }
}

