/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security.templates;

import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.Properties;
import org.apache.geode.LogWriter;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.security.AuthInitialize;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.logging.log4j.Logger;

public class PKCSAuthInit
implements AuthInitialize {
    private static final Logger logger = LogService.getLogger();
    public static final String KEYSTORE_FILE_PATH = "security-keystorepath";
    public static final String KEYSTORE_ALIAS = "security-alias";
    public static final String KEYSTORE_PASSWORD = "security-keystorepass";
    public static final String SIGNATURE_DATA = "security-signature";
    protected LogWriter systemLogWriter;
    protected LogWriter securityLogWriter;

    public static AuthInitialize create() {
        return new PKCSAuthInit();
    }

    public void init(LogWriter systemLogWriter, LogWriter securityLogWriter) throws AuthenticationFailedException {
        this.systemLogWriter = systemLogWriter;
        this.securityLogWriter = securityLogWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getCredentials(Properties securityProperties, DistributedMember server, boolean isPeer) throws AuthenticationFailedException {
        String keyStorePath = securityProperties.getProperty(KEYSTORE_FILE_PATH);
        if (keyStorePath == null) {
            throw new AuthenticationFailedException("PKCSAuthInit: key-store file path property [security-keystorepath] not set.");
        }
        String alias = securityProperties.getProperty(KEYSTORE_ALIAS);
        if (alias == null) {
            throw new AuthenticationFailedException("PKCSAuthInit: key alias name property [security-alias] not set.");
        }
        String keyStorePass = securityProperties.getProperty(KEYSTORE_PASSWORD);
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12");
            char[] passPhrase = keyStorePass != null ? keyStorePass.toCharArray() : null;
            try (FileInputStream certificatefile = new FileInputStream(keyStorePath);){
                ks.load(certificatefile, passPhrase);
            }
            Key key = ks.getKey(alias, passPhrase);
            if (key instanceof PrivateKey) {
                PrivateKey privKey = (PrivateKey)key;
                X509Certificate cert = (X509Certificate)ks.getCertificate(alias);
                Signature sig = Signature.getInstance(cert.getSigAlgName());
                sig.initSign(privKey);
                sig.update(alias.getBytes("UTF-8"));
                byte[] signatureBytes = sig.sign();
                Properties newprops = new Properties();
                newprops.put(KEYSTORE_ALIAS, alias);
                newprops.put(SIGNATURE_DATA, signatureBytes);
                return newprops;
            }
            throw new AuthenticationFailedException("PKCSAuthInit: Failed to load private key from the given file: " + keyStorePath);
        }
        catch (Exception ex) {
            throw new AuthenticationFailedException("PKCSAuthInit: Exception while getting credentials: " + ex, (Throwable)ex);
        }
    }

    public void close() {
    }
}

