/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security.query;

import java.util.Collection;
import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.security.SecurityTestUtil;
import org.apache.geode.security.TestSecurityManager;
import org.apache.geode.security.query.UserPermissions;
import org.apache.geode.test.dunit.Host;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.internal.JUnit4DistributedTestCase;
import org.apache.geode.test.junit.rules.ServerStarterRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;

public abstract class QuerySecurityBase
extends JUnit4DistributedTestCase {
    protected String regionName = "region";
    protected Object[] keys;
    protected Object[] values;
    @Rule
    public ServerStarterRule server = ((ServerStarterRule)((ServerStarterRule)new ServerStarterRule().withProperty("security-manager", TestSecurityManager.class.getName())).withProperty("security-json", "org/apache/geode/management/internal/security/clientServer.json")).withRegion(this.getRegionType(), this.regionName);
    private static ClientCache clientCache;
    protected transient UserPermissions userPerms = new UserPermissions();
    protected Host host;
    protected VM superUserClient;
    protected VM specificUserClient;

    public RegionShortcut getRegionType() {
        return RegionShortcut.REPLICATE;
    }

    @Before
    public void configureTest() {
        this.host = Host.getHost(0);
        this.superUserClient = this.host.getVM(1);
        this.specificUserClient = this.host.getVM(2);
        this.createClientCache(this.superUserClient, "super-user", this.userPerms.getUserPassword("super-user"));
        this.createProxyRegion(this.superUserClient, this.regionName);
    }

    public void closeAnyPollutedCache() {
        if (GemFireCacheImpl.getInstance() != null) {
            GemFireCacheImpl.getInstance().close();
        }
    }

    public void setClientCache(ClientCache cache) {
        clientCache = cache;
    }

    public ClientCache getClientCache() {
        return clientCache;
    }

    public void createClientCache(VM vm, String userName, String password) {
        vm.invoke(() -> {
            this.closeAnyPollutedCache();
            ClientCache cache = SecurityTestUtil.createClientCache(userName, password, this.server.getPort());
            this.setClientCache(cache);
        });
    }

    public void createProxyRegion(VM vm, String regionName) {
        vm.invoke(() -> SecurityTestUtil.createProxyRegion(this.getClientCache(), regionName));
    }

    @After
    public void closeClientCaches() {
        this.closeClientCache(this.superUserClient);
        this.closeClientCache(this.specificUserClient);
    }

    public void closeClientCache(VM vm) {
        vm.invoke(() -> {
            if (this.getClientCache() != null) {
                this.getClientCache().close();
            }
        });
    }

    protected void assertExceptionOccurred(QueryService qs, String query, String authErrorRegexp) {
        block3: {
            try {
                qs.newQuery(query).execute();
                Assert.fail();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e.getMessage().matches(authErrorRegexp)) break block3;
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    if (!cause.getMessage().matches(authErrorRegexp)) continue;
                    return;
                }
                e.printStackTrace();
                Assert.fail();
            }
        }
    }

    protected void assertExceptionOccurred(QueryService qs, String query, Object[] bindParams, String authErrorRegexp) {
        block3: {
            System.out.println("Execution exception should match:" + authErrorRegexp);
            try {
                qs.newQuery(query).execute(bindParams);
                Assert.fail();
            }
            catch (Exception e) {
                if (e.getMessage().matches(authErrorRegexp)) break block3;
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    if (!cause.getMessage().matches(authErrorRegexp)) continue;
                    return;
                }
                e.printStackTrace();
                Assert.fail();
            }
        }
    }

    protected void assertQueryResults(ClientCache clientCache, String query, List<Object> expectedResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        this.assertQueryResults(clientCache, query, null, expectedResults);
    }

    protected void assertQueryResults(ClientCache clientCache, String queryString, Object[] bindParameters, List<Object> expectedResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Query query = clientCache.getQueryService().newQuery(queryString);
        Collection results = bindParameters == null ? (Collection)query.execute() : (Collection)query.execute(bindParameters);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((String)("Query results size did not match expected for " + query), (long)expectedResults.size(), (long)results.size());
        results.forEach(i -> Assert.assertTrue((String)("Result:" + i + " was not found in the expectedResults"), (boolean)expectedResults.contains(i)));
    }

    public void executeAndConfirmRegionMatches(VM vm, String regionName, List<Object> expectedRegionResults) throws Exception {
        vm.invoke(() -> this.assertQueryResults(this.getClientCache(), "select * from /" + regionName, expectedRegionResults));
    }

    protected void putIntoRegion(VM vm, Object[] keys, Object[] values, String regionName) {
        vm.invoke(() -> {
            Region region = this.getClientCache().getRegion(regionName);
            Assert.assertEquals((String)"Bad region put. The list of keys does not have the same length as the list of values.", (long)keys.length, (long)values.length);
            for (int i = 0; i < keys.length; ++i) {
                region.put(keys[i], values[i]);
            }
        });
    }

    protected void executeQueryWithCheckForAccessPermissions(VM vm, String query, String regionName, List<Object> expectedSuccessfulQueryResults) {
        vm.invoke(() -> {
            Region region = this.getClientCache().getRegion(regionName);
            this.assertQueryResults(this.getClientCache(), query, expectedSuccessfulQueryResults);
        });
    }

    protected void executeQueryWithCheckForAccessPermissions(VM vm, String query, String regionName, String regexForExpectedExceptions) {
        vm.invoke(() -> {
            Region region = this.getClientCache().getRegion(regionName);
            this.assertExceptionOccurred(this.getClientCache().getQueryService(), query, regexForExpectedExceptions);
            Pool pool = PoolManager.find((Region)region);
            this.assertExceptionOccurred(pool.getQueryService(), query, regexForExpectedExceptions);
        });
    }
}

