/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.management.ObjectName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.gms.MembershipManagerHelper;
import org.apache.geode.internal.UniquePortSupplier;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.management.CacheServerMXBean;
import org.apache.geode.management.DistributedRegionMXBean;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.security.SecurityManager;
import org.apache.geode.test.awaitility.GeodeAwaitility;
import org.apache.geode.test.junit.rules.Member;
import org.apache.geode.test.junit.rules.ServerStarterRule;
import org.apache.geode.test.junit.rules.serializable.SerializableExternalResource;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.awaitility.core.ConditionTimeoutException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public abstract class MemberStarterRule<T>
extends SerializableExternalResource
implements Member {
    protected int memberPort = 0;
    protected int jmxPort = -1;
    protected int httpPort = -1;
    protected String name;
    protected boolean logFile = false;
    protected Properties properties = new Properties();
    protected boolean autoStart = false;
    private final transient UniquePortSupplier portSupplier;
    private List<File> firstLevelChildrenFile = new ArrayList<File>();
    private boolean cleanWorkingDir = true;
    private static int WAIT_UNTIL_TIMEOUT = 30;

    public static void setWaitUntilTimeout(int waitUntilTimeout) {
        WAIT_UNTIL_TIMEOUT = waitUntilTimeout;
    }

    public MemberStarterRule() {
        this(new UniquePortSupplier());
    }

    public MemberStarterRule(UniquePortSupplier portSupplier) {
        this.portSupplier = portSupplier;
        this.properties.setProperty("mcast-port", "0");
        this.properties.setProperty("locators", "");
        this.properties.setProperty("max-wait-time-reconnect", "5000");
    }

    public void before() {
        this.normalizeProperties();
        if (this.httpPort < 0) {
            this.properties.putIfAbsent("http-service-port", "0");
        }
        this.firstLevelChildrenFile = Arrays.asList(this.getWorkingDir().listFiles());
    }

    public void after() {
        this.stopMember();
        MemberStarterRule.disconnectDSIfAny();
        SocketCreatorFactory.close();
        if (this.cleanWorkingDir) {
            Arrays.stream(this.getWorkingDir().listFiles()).filter(f -> !this.firstLevelChildrenFile.contains(f)).filter(f -> !f.isDirectory() || !f.getName().equals("dunit")).forEach(FileUtils::deleteQuietly);
        }
    }

    public T withPort(int memberPort) {
        this.memberPort = memberPort;
        return (T)this;
    }

    public T withLogFile() {
        this.logFile = true;
        return (T)this;
    }

    public static void disconnectDSIfAny() {
        InternalDistributedSystem ds = InternalDistributedSystem.getConnectedInstance();
        if (ds != null) {
            ds.disconnect();
        }
    }

    public T withProperty(String key, String value) {
        this.properties.setProperty(key, value);
        return (T)this;
    }

    public T withProperties(Properties props) {
        if (props != null) {
            this.properties.putAll((Map<?, ?>)props);
        }
        return (T)this;
    }

    public T withSecurityManager(Class<? extends SecurityManager> securityManager) {
        this.properties.setProperty("security-manager", securityManager.getName());
        return (T)this;
    }

    public T withAutoStart() {
        this.autoStart = true;
        return (T)this;
    }

    public T withName(String name) {
        if (!this.properties.containsKey("name")) {
            this.name = name;
            this.properties.putIfAbsent("name", name);
        }
        return (T)this;
    }

    public T withConnectionToLocator(int ... locatorPorts) {
        if (locatorPorts.length == 0) {
            return (T)this;
        }
        String locators = Arrays.stream(locatorPorts).mapToObj(i -> "localhost[" + i + "]").collect(Collectors.joining(","));
        this.properties.setProperty("locators", locators);
        return (T)this;
    }

    public T withJMXManager(boolean useProductDefaultPorts) {
        if (!useProductDefaultPorts) {
            this.properties.putIfAbsent("jmx-manager-port", this.portSupplier.getAvailablePort() + "");
            this.jmxPort = Integer.parseInt(this.properties.getProperty("jmx-manager-port"));
        } else {
            this.jmxPort = 0;
        }
        this.properties.putIfAbsent("jmx-manager", "true");
        this.properties.putIfAbsent("jmx-manager-start", "true");
        return (T)this;
    }

    public T withHttpService(boolean useDefaultPort) {
        this.properties.setProperty("http-service-bind-address", "localhost");
        if (!useDefaultPort) {
            this.properties.putIfAbsent("http-service-port", this.portSupplier.getAvailablePort() + "");
            this.httpPort = Integer.parseInt(this.properties.getProperty("http-service-port"));
        } else {
            this.httpPort = 0;
        }
        return (T)this;
    }

    public void setCleanWorkingDir(boolean cleanWorkingDir) {
        this.cleanWorkingDir = cleanWorkingDir;
    }

    public T withJMXManager() {
        return this.withJMXManager(false);
    }

    public T withHttpService() {
        return this.withHttpService(false);
    }

    protected void normalizeProperties() {
        if (this.name == null) {
            this.name = this.properties.containsKey("name") ? this.properties.getProperty("name") : (this instanceof ServerStarterRule ? "server" : "locator");
            this.withName(this.name);
        }
        if (this.jmxPort < 0 && this.properties.containsKey("jmx-manager-port")) {
            this.withJMXManager(false);
        }
        if (this.logFile) {
            this.properties.putIfAbsent("log-file", new File(this.name + ".log").getAbsolutePath());
        }
    }

    public DistributedRegionMXBean getRegionMBean(String regionName) {
        return this.getManagementService().getDistributedRegionMXBean(regionName);
    }

    public ManagementService getManagementService() {
        ManagementService managementService = ManagementService.getExistingManagementService((Cache)this.getCache());
        if (managementService == null) {
            throw new IllegalStateException("Management service is not available on this member");
        }
        return managementService;
    }

    public abstract InternalCache getCache();

    public void waitUntilRegionIsReadyOnExactlyThisManyServers(String regionName, int exactServerCount) throws Exception {
        if (exactServerCount == 0) {
            this.waitUntilEqual(() -> this.getRegionMBean(regionName), Objects::isNull, true, String.format("Expecting to not find an mbean for region '%s'", regionName), WAIT_UNTIL_TIMEOUT, TimeUnit.SECONDS);
            return;
        }
        this.waitUntilEqual(() -> this.getRegionMBean(regionName), Objects::nonNull, true, String.format("Expecting to find an mbean for region '%s'", regionName), WAIT_UNTIL_TIMEOUT, TimeUnit.SECONDS);
        String assertionConditionDescription = String.format("Expecting region '%s' to be found on exactly %d servers", regionName, exactServerCount);
        this.waitUntilSatisfied(() -> Arrays.asList(this.getRegionMBean(regionName).getMembers()), Function.identity(), members -> {
            ListAssert cfr_ignored_0 = (ListAssert)((ListAssert)Assertions.assertThat((List)members).isNotNull()).hasSize(exactServerCount);
        }, assertionConditionDescription, WAIT_UNTIL_TIMEOUT, TimeUnit.SECONDS);
    }

    public void waitTillClientsAreReadyOnServer(String serverName, int serverPort, int clientCount) {
        this.waitTillCacheServerIsReady(serverName, serverPort);
        CacheServerMXBean bean = this.getCacheServerMXBean(serverName, serverPort);
        GeodeAwaitility.await().until(() -> bean.getClientIds().length == clientCount);
    }

    public void waitTillCacheClientProxyHasBeenPaused() {
        GeodeAwaitility.await().until(() -> {
            CacheClientNotifier clientNotifier = CacheClientNotifier.getInstance();
            Collection clientProxies = clientNotifier.getClientProxies();
            for (CacheClientProxy clientProxy : clientProxies) {
                if (!clientProxy.isPaused()) continue;
                return true;
            }
            return false;
        });
    }

    public void waitTillCacheServerIsReady(String serverName, int serverPort) {
        GeodeAwaitility.await().until(() -> this.getCacheServerMXBean(serverName, serverPort) != null);
    }

    public CacheServerMXBean getCacheServerMXBean(String serverName, int serverPort) {
        SystemManagementService managementService = (SystemManagementService)this.getManagementService();
        String objectName = MessageFormat.format("GemFire:service=CacheServer,port={0},type=Member,member={1}", String.valueOf(serverPort), serverName);
        ObjectName cacheServerMBeanName = MBeanJMXAdapter.getObjectName((String)objectName);
        return (CacheServerMXBean)managementService.getMBeanProxy(cacheServerMBeanName, CacheServerMXBean.class);
    }

    public void waitUntilGatewaySendersAreReadyOnExactlyThisManyServers(int exactGatewaySenderCount) throws Exception {
        DistributedSystemMXBean dsMXBean = this.getManagementService().getDistributedSystemMXBean();
        String predicateDescription = String.format("Expecting to find exactly %d gateway sender beans.", exactGatewaySenderCount);
        this.waitUntilEqual(() -> dsMXBean.listGatewaySenderObjectNames(), array -> ((ObjectName[])array).length, exactGatewaySenderCount, predicateDescription, WAIT_UNTIL_TIMEOUT, TimeUnit.SECONDS);
    }

    public void waitUntilDiskStoreIsReadyOnExactlyThisManyServers(String diskStoreName, int exactServerCount) throws Exception {
        Supplier<DistributedSystemMXBean> distributedSystemMXBeanSupplier = () -> this.getManagementService().getDistributedSystemMXBean();
        this.waitUntilSatisfied(distributedSystemMXBeanSupplier, Function.identity(), bean -> Assert.assertThat((Object)bean, (Matcher)CoreMatchers.notNullValue()), "Distributed System MXBean should not be null", WAIT_UNTIL_TIMEOUT, TimeUnit.SECONDS);
        DistributedSystemMXBean dsMXBean = distributedSystemMXBeanSupplier.get();
        String predicateDescription = String.format("Expecting exactly %d servers to present mbeans for a disk store with name %s.", exactServerCount, diskStoreName);
        Supplier<List> diskStoreSupplier = () -> dsMXBean.listMemberDiskstore().values().stream().filter(x1 -> ArrayUtils.contains((Object[])x1, (Object)diskStoreName)).collect(Collectors.toList());
        this.waitUntilEqual(diskStoreSupplier, x -> x.size(), exactServerCount, predicateDescription, WAIT_UNTIL_TIMEOUT, TimeUnit.SECONDS);
    }

    public void waitUntilAsyncEventQueuesAreReadyOnExactlyThisManyServers(String queueId, int exactServerCount) throws Exception {
        String examinerDescription = String.format("Expecting exactly %d servers to have an AEQ with id '%s'.", exactServerCount, queueId);
        this.waitUntilEqual(() -> CliUtil.getMembersWithAsyncEventQueue((InternalCache)this.getCache(), (String)queueId), membersWithAEQ -> membersWithAEQ.size(), exactServerCount, examinerDescription, WAIT_UNTIL_TIMEOUT, TimeUnit.SECONDS);
    }

    public <K, J> void waitUntilSatisfied(Supplier<K> supplier, Function<K, J> examiner, Consumer<J> assertionConsumer, String assertionConsumerDescription, long timeout, TimeUnit unit) throws Exception {
        try {
            GeodeAwaitility.await((String)assertionConsumerDescription).untilAsserted(() -> assertionConsumer.accept(examiner.apply(supplier.get())));
        }
        catch (ConditionTimeoutException e) {
            throw new ConditionTimeoutException("The observed result '" + String.valueOf(supplier.get()) + "' does not satisfy the provided assertionConsumer. \n" + e.getMessage());
        }
    }

    public <K, J> void waitUntilEqual(Supplier<K> provider, Function<K, J> examiner, J expectation, String expectationDesription, long timeout, TimeUnit unit) throws Exception {
        Consumer<Object> assertionConsumer = examined -> Assert.assertThat((Object)examined, (Matcher)CoreMatchers.is((Object)expectation));
        this.waitUntilSatisfied(provider, examiner, assertionConsumer, expectationDesription, timeout, unit);
    }

    abstract void stopMember();

    public void forceDisconnectMember() {
        MembershipManagerHelper.crashDistributedSystem((DistributedSystem)InternalDistributedSystem.getConnectedInstance());
    }

    @Override
    public File getWorkingDir() {
        return new File(System.getProperty("user.dir"));
    }

    @Override
    public int getPort() {
        return this.memberPort;
    }

    @Override
    public int getJmxPort() {
        return this.jmxPort;
    }

    @Override
    public int getHttpPort() {
        return this.httpPort;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

