/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.standalone;

import java.io.InputStream;

public class ProcessHolder {
    private final Process process;
    private volatile boolean killed = false;

    public ProcessHolder(Process process) {
        this.process = process;
    }

    public void kill() {
        this.killed = true;
        this.process.destroy();
    }

    public void killForcibly() {
        this.killed = true;
        this.process.destroyForcibly();
    }

    public void waitFor() throws InterruptedException {
        this.process.waitFor();
    }

    public InputStream getErrorStream() {
        return this.process.getErrorStream();
    }

    public InputStream getInputStream() {
        return this.process.getInputStream();
    }

    public boolean isKilled() {
        return this.killed;
    }

    public boolean isAlive() {
        return !this.killed && this.process.isAlive();
    }
}

