/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.rules;

import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.rules.RemoteInvoker;
import org.apache.geode.test.dunit.standalone.DUnitLauncher;
import org.apache.geode.test.junit.rules.UseJacksonForJsonPathRule;
import org.assertj.core.api.Assertions;

public class DistributedUseJacksonForJsonPathRule
extends UseJacksonForJsonPathRule {
    private static volatile UseJacksonForJsonPathRule instance = new UseJacksonForJsonPathRule();
    private final RemoteInvoker invoker;
    private volatile int beforeVmCount;

    public DistributedUseJacksonForJsonPathRule() {
        this(new RemoteInvoker());
    }

    public DistributedUseJacksonForJsonPathRule(RemoteInvoker invoker) {
        this.invoker = invoker;
    }

    public void before() {
        DUnitLauncher.launchIfNeeded();
        this.beforeVmCount = VM.getVMCount();
        this.invoker.invokeInEveryVMAndController(() -> DistributedUseJacksonForJsonPathRule.invokeBefore());
    }

    public void after() {
        int afterVmCount = VM.getVMCount();
        Assertions.assertThat((int)afterVmCount).isEqualTo(this.beforeVmCount);
        this.invoker.invokeInEveryVMAndController(() -> DistributedUseJacksonForJsonPathRule.invokeAfter());
    }

    private static void invokeBefore() {
        instance = new UseJacksonForJsonPathRule();
        instance.before();
    }

    private static void invokeAfter() {
        instance.after();
        instance = null;
    }
}

