/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit;

import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.test.dunit.Assert;
import org.apache.geode.test.dunit.Jitter;
import org.apache.geode.test.dunit.StoppableWaitCriterion;
import org.apache.geode.test.dunit.WaitCriterion;
import org.apache.logging.log4j.Logger;

@Deprecated
public class Wait {
    private static final Logger logger = LogService.getLogger();

    protected Wait() {
    }

    public static void pause() {
        Wait.pause(250);
    }

    public static void pause(int milliseconds) {
        if (milliseconds >= 1000 || logger.isDebugEnabled()) {
            logger.info("Pausing for {} ms...", (Object)milliseconds);
        }
        long target = System.currentTimeMillis() + (long)milliseconds;
        try {
            long msLeft;
            while ((msLeft = target - System.currentTimeMillis()) > 0L) {
                Thread.sleep(msLeft);
            }
        }
        catch (InterruptedException e) {
            Assert.fail("interrupted", e);
        }
    }

    @Deprecated
    public static void waitForCriterion(WaitCriterion waitCriterion, long timeoutMillis, long pollingInterval, boolean throwOnTimeout) {
        long waitThisTime = Jitter.jitterInterval(pollingInterval);
        long tilt = System.currentTimeMillis() + timeoutMillis;
        while (!waitCriterion.done()) {
            StoppableWaitCriterion ev2;
            if (waitCriterion instanceof StoppableWaitCriterion && (ev2 = (StoppableWaitCriterion)waitCriterion).stopWaiting()) {
                if (throwOnTimeout) {
                    org.junit.Assert.fail((String)("stopWaiting returned true: " + waitCriterion.description()));
                }
                return;
            }
            long timeLeft = tilt - System.currentTimeMillis();
            if (timeLeft <= 0L) {
                if (!throwOnTimeout) {
                    return;
                }
                org.junit.Assert.fail((String)("Event never occurred after " + timeoutMillis + " ms: " + waitCriterion.description()));
            }
            if (waitThisTime > timeLeft) {
                waitThisTime = timeLeft;
            }
            Thread.yield();
            try {
                Thread.sleep(waitThisTime);
                continue;
            }
            catch (InterruptedException e) {
                org.junit.Assert.fail((String)"interrupted");
                continue;
            }
            break;
        }
        return;
    }

    public static long waitForExpiryClockToChange(LocalRegion cacheTimeMillisSource) {
        return Wait.waitForExpiryClockToChange(cacheTimeMillisSource, cacheTimeMillisSource.cacheTimeMillis());
    }

    public static long waitForExpiryClockToChange(LocalRegion cacheTimeMillisSource, long baseTime) {
        long nowTime;
        do {
            Thread.yield();
        } while ((nowTime = cacheTimeMillisSource.cacheTimeMillis()) - baseTime <= 0L);
        return nowTime;
    }
}

