/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security.generator;

import java.security.Principal;
import java.util.Properties;
import java.util.Random;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.security.generator.CredentialGenerator;
import org.apache.geode.security.generator.PKCSCredentialGenerator;
import org.apache.geode.security.templates.LdapUserAuthenticator;
import org.apache.geode.security.templates.UserPasswordAuthInit;
import org.apache.geode.test.dunit.Assert;
import org.apache.geode.util.test.TestUtil;
import org.apache.logging.log4j.Logger;

public class LdapUserCredentialGenerator
extends CredentialGenerator {
    private static final Logger logger = LogService.getLogger();
    private static final String USER_PREFIX = "gemfire";
    private static final Random RANDOM = new Random();
    private static final String[] CIPHERS = new String[]{"", "DESede", "AES:128", "Blowfish:128"};
    private static boolean enableServerAuthentication = false;
    private boolean serverAuthEnabled = enableServerAuthentication = !enableServerAuthentication;

    @Override
    protected Properties initialize() throws IllegalArgumentException {
        String ldapServer = System.getProperty("gf.ldap.server", "ldap");
        String ldapBaseDN = System.getProperty("gf.ldap.basedn", "ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
        String ldapUseSSL = System.getProperty("gf.ldap.usessl");
        Properties extraProps = new Properties();
        extraProps.setProperty("security-ldap-server", ldapServer);
        extraProps.setProperty("security-ldap-basedn", ldapBaseDN);
        if (ldapUseSSL != null && ldapUseSSL.length() > 0) {
            extraProps.setProperty("security-ldap-usessl", ldapUseSSL);
        }
        if (this.serverAuthEnabled) {
            String keyStoreFile = TestUtil.getResourcePath(LdapUserCredentialGenerator.class, (String)(PKCSCredentialGenerator.keyStoreDir + "/gemfire1.keystore"));
            extraProps.setProperty("security-server-kspath", keyStoreFile);
            extraProps.setProperty("security-server-ksalias", "gemfire.");
            extraProps.setProperty("security-server-kspasswd", USER_PREFIX);
        }
        Assert.assertNotNull((Object)extraProps.getProperty("security-ldap-basedn"));
        logger.info("Generating LdapUserCredentialGenerator with {}", (Object)extraProps);
        return extraProps;
    }

    @Override
    public CredentialGenerator.ClassCode classCode() {
        return CredentialGenerator.ClassCode.LDAP;
    }

    @Override
    public String getAuthInit() {
        return UserPasswordAuthInit.class.getName() + ".create";
    }

    @Override
    public String getAuthenticator() {
        return LdapUserAuthenticator.class.getName() + ".create";
    }

    @Override
    public Properties getValidCredentials(int index) {
        Properties props = new Properties();
        props.setProperty("security-username", USER_PREFIX + (index % 10 + 1));
        props.setProperty("security-password", USER_PREFIX + (index % 10 + 1));
        props.setProperty("security-client-dhalgo", CIPHERS[RANDOM.nextInt(CIPHERS.length)]);
        if (this.serverAuthEnabled) {
            String keyStoreFile = TestUtil.getResourcePath(PKCSCredentialGenerator.class, (String)(PKCSCredentialGenerator.keyStoreDir + "/publickeyfile"));
            props.setProperty("security-client-kspath", keyStoreFile);
            props.setProperty("security-client-kspasswd", USER_PREFIX);
        }
        return props;
    }

    @Override
    public Properties getValidCredentials(Principal principal) {
        Properties props = null;
        String userName = principal.getName();
        if (userName != null && userName.startsWith(USER_PREFIX)) {
            boolean isValid;
            try {
                int suffix = Integer.parseInt(userName.substring(USER_PREFIX.length()));
                isValid = suffix >= 1 && suffix <= 10;
            }
            catch (Exception ex) {
                isValid = false;
            }
            if (isValid) {
                props = new Properties();
                props.setProperty("security-username", userName);
                props.setProperty("security-password", userName);
            }
        }
        if (props == null) {
            throw new IllegalArgumentException("LDAP: [" + userName + "] not a valid user");
        }
        props.setProperty("security-client-dhalgo", CIPHERS[RANDOM.nextInt(CIPHERS.length)]);
        if (this.serverAuthEnabled) {
            String keyStoreFile = TestUtil.getResourcePath(PKCSCredentialGenerator.class, (String)(PKCSCredentialGenerator.keyStoreDir + "/publickeyfile"));
            props.setProperty("security-client-kspath", keyStoreFile);
            props.setProperty("security-client-kspasswd", USER_PREFIX);
        }
        return props;
    }

    @Override
    public Properties getInvalidCredentials(int index) {
        Properties props = new Properties();
        props.setProperty("security-username", "invalid" + index);
        props.setProperty("security-password", "none");
        props.setProperty("security-client-dhalgo", CIPHERS[RANDOM.nextInt(CIPHERS.length)]);
        if (this.serverAuthEnabled) {
            String keyStoreFile = TestUtil.getResourcePath(PKCSCredentialGenerator.class, (String)(PKCSCredentialGenerator.keyStoreDir + "/publickeyfile"));
            props.setProperty("security-client-kspath", keyStoreFile);
            props.setProperty("security-client-kspasswd", USER_PREFIX);
        }
        return props;
    }
}

