/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache30;

import java.io.IOException;
import java.util.Properties;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.LoaderHelper;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolFactory;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache30.CacheSerializableRunnable;
import org.apache.geode.cache30.TestCacheLoader;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.AvailablePortHelper;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.test.awaitility.GeodeAwaitility;
import org.apache.geode.test.dunit.Assert;
import org.apache.geode.test.dunit.DistributedTestUtils;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.cache.internal.JUnit4CacheTestCase;

public abstract class ClientServerTestCase
extends JUnit4CacheTestCase {
    public static String NON_EXISTENT_KEY = "NON_EXISTENT_KEY";
    public static boolean AUTO_LOAD_BALANCE = false;
    public static final String BridgeServerKey = "BridgeServerKey";

    @Override
    public final void postSetUp() throws Exception {
        ClientServerTestCase.disconnectAllFromDS();
        this.postSetUpClientServerTestCase();
    }

    protected void postSetUpClientServerTestCase() throws Exception {
    }

    @Override
    public final void preTearDownCacheTestCase() throws Exception {
        this.preTearDownClientServerTestCase();
        ClientServerTestCase.disconnectAllFromDS();
    }

    protected void preTearDownClientServerTestCase() throws Exception {
    }

    public int startBridgeServer(int port) throws IOException {
        InternalCache cache = this.getCache();
        CacheServer bridge = cache.addCacheServer();
        bridge.setPort(port);
        bridge.setMaxThreads(this.getMaxThreads());
        bridge.start();
        return bridge.getPort();
    }

    protected int getMaxThreads() {
        return 0;
    }

    public void stopBridgeServers(Cache cache) {
        CacheServer bridge2 = null;
        for (CacheServer bridge2 : cache.getCacheServers()) {
            bridge2.stop();
            Assert.assertFalse((boolean)bridge2.isRunning());
        }
    }

    protected RegionAttributes getRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        return factory.create();
    }

    public static String createBridgeClientConnection(String host, int[] ports) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ports.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("name" + i + "=");
            sb.append(host + ":" + ports[i]);
        }
        return sb.toString();
    }

    public static Pool configureConnectionPool(AttributesFactory factory, String host, int port1, int port2, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, int pingInterval, int idleTimeout, boolean threadLocalCnxs, int lifetimeTimeout) {
        int[] ports = port2 != -1 ? new int[]{port1, port2} : new int[]{port1};
        return ClientServerTestCase.configureConnectionPool(factory, host, ports, establish, redundancy, connectionsPerServer, serverGroup, pingInterval, idleTimeout, threadLocalCnxs, lifetimeTimeout);
    }

    public static Pool configureConnectionPool(AttributesFactory factory, String host, int port1, int port2, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, int pingInterval, int idleTimeout, boolean threadLocalCnxs) {
        return ClientServerTestCase.configureConnectionPool(factory, host, port1, port2, establish, redundancy, connectionsPerServer, serverGroup, pingInterval, idleTimeout, threadLocalCnxs, -2);
    }

    public static Pool configureConnectionPool(AttributesFactory factory, String host, int port1, int port2, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, int pingInterval) {
        return ClientServerTestCase.configureConnectionPool(factory, host, port1, port2, establish, redundancy, connectionsPerServer, serverGroup, pingInterval, -1, false);
    }

    public static Pool configureConnectionPool(AttributesFactory factory, String host, int port1, int port2, boolean establish, int redundancy, int connectionsPerServer, String serverGroup) {
        return ClientServerTestCase.configureConnectionPool(factory, host, port1, port2, establish, redundancy, connectionsPerServer, serverGroup, -1);
    }

    public static Pool configureConnectionPoolWithName(AttributesFactory factory, String host, int[] ports, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, String poolName) {
        return ClientServerTestCase.configureConnectionPoolWithNameAndFactory(factory, host, ports, establish, redundancy, connectionsPerServer, serverGroup, poolName, PoolManager.createFactory(), -1, -1, false, -2, -1);
    }

    public static Pool configureConnectionPoolWithName(AttributesFactory factory, String host, int[] ports, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, String poolName, int pingInterval, int idleTimeout, boolean threadLocalCnxs, int lifetimeTimeout, int statisticInterval) {
        return ClientServerTestCase.configureConnectionPoolWithNameAndFactory(factory, host, ports, establish, redundancy, connectionsPerServer, serverGroup, poolName, PoolManager.createFactory(), pingInterval, idleTimeout, threadLocalCnxs, lifetimeTimeout, statisticInterval);
    }

    public static Pool configureConnectionPoolWithNameAndFactory(AttributesFactory factory, String host, int[] ports, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, String poolName, PoolFactory pf) {
        return ClientServerTestCase.configureConnectionPoolWithNameAndFactory(factory, host, ports, establish, redundancy, connectionsPerServer, serverGroup, poolName, pf, -1, -1, false, -2, -1);
    }

    public static Pool configureConnectionPoolWithNameAndFactory(AttributesFactory factory, String host, int[] ports, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, String poolName, PoolFactory pf, int pingInterval, int idleTimeout, boolean threadLocalCnxs, int lifetimeTimeout, int statisticInterval) {
        if (AUTO_LOAD_BALANCE || ports.length == 0) {
            pf.addLocator(host, DistributedTestUtils.getDUnitLocatorPort());
        } else {
            for (int z = 0; z < ports.length; ++z) {
                pf.addServer(host, ports[z]);
            }
        }
        if (connectionsPerServer != -1 && ports != null) {
            pf.setMinConnections(connectionsPerServer * ports.length);
        }
        if (threadLocalCnxs) {
            pf.setThreadLocalConnections(true);
        }
        if (pingInterval != -1) {
            pf.setPingInterval((long)pingInterval);
        }
        if (idleTimeout != -1) {
            pf.setIdleTimeout((long)idleTimeout);
        }
        if (statisticInterval != -1) {
            pf.setStatisticInterval(statisticInterval);
        }
        if (lifetimeTimeout != -2) {
            pf.setLoadConditioningInterval(lifetimeTimeout);
        }
        if (establish) {
            pf.setSubscriptionEnabled(true);
            pf.setSubscriptionRedundancy(redundancy);
            pf.setSubscriptionAckInterval(1);
        }
        if (serverGroup != null) {
            pf.setServerGroup(serverGroup);
        }
        String rpoolName = "testPool";
        if (poolName != null) {
            rpoolName = poolName;
        }
        Pool pool = pf.create(rpoolName);
        if (factory != null) {
            factory.setPoolName(rpoolName);
        }
        return pool;
    }

    public static Pool configureConnectionPool(AttributesFactory factory, String host, int[] ports, boolean establish, int redundancy, int connectionsPerServer, String serverGroup) {
        return ClientServerTestCase.configureConnectionPool(factory, host, ports, establish, redundancy, connectionsPerServer, serverGroup, -1, -1, false, -2);
    }

    public static Pool configureConnectionPool(AttributesFactory factory, String host, int[] ports, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, int pingInterval, int idleTimeout, boolean threadLocalCnxs, int lifetimeTimeout) {
        return ClientServerTestCase.configureConnectionPoolWithName(factory, host, ports, establish, redundancy, connectionsPerServer, serverGroup, null, pingInterval, idleTimeout, threadLocalCnxs, lifetimeTimeout, -1);
    }

    public static Pool configureConnectionPool(AttributesFactory factory, String host, int[] ports, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, int pingInterval, int idleTimeout, boolean threadLocalCnxs, int lifetimeTimeout, int statisticInterval) {
        return ClientServerTestCase.configureConnectionPoolWithName(factory, host, ports, establish, redundancy, connectionsPerServer, serverGroup, null, pingInterval, idleTimeout, threadLocalCnxs, lifetimeTimeout, statisticInterval);
    }

    protected static DistributedMember getMemberId() {
        GeodeAwaitility.await((String)("Waiting for client to connect " + ClientServerTestCase.getSystemStatic().getMemberId())).until(() -> ClientServerTestCase.getSystemStatic().getDistributedMember().getPort() > 0);
        return ClientServerTestCase.getSystemStatic().getDistributedMember();
    }

    public void createBridgeServer(VM vm, final String rName, final int port) {
        vm.invoke(new CacheSerializableRunnable("Create Region on Server"){

            @Override
            public void run2() {
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setCacheLoader((CacheLoader)new CacheServerCacheLoader());
                    JUnit4CacheTestCase.beginCacheXml();
                    ClientServerTestCase.this.createRootRegion(rName, factory.create());
                    ClientServerTestCase.this.startBridgeServer(port);
                    ClientServerTestCase.this.finishCacheXml(rName + "-" + port);
                    Region region = ClientServerTestCase.this.getRootRegion(rName);
                    Assert.assertNotNull(region);
                    region.put((Object)ClientServerTestCase.BridgeServerKey, (Object)new Integer(port));
                }
                catch (Exception e) {
                    ClientServerTestCase.this.getSystem().getLogWriter().severe((Throwable)e);
                    Assert.fail((String)("Failed to start CacheServer " + e));
                }
            }
        });
    }

    public static int[] createUniquePorts(int numToCreate) {
        return AvailablePortHelper.getRandomAvailableTCPPorts((int)numToCreate);
    }

    public static class CacheServerCacheLoader
    extends TestCacheLoader
    implements Declarable {
        public Object load2(LoaderHelper helper) {
            Object ret;
            if (helper.getArgument() instanceof Integer) {
                try {
                    Thread.sleep(((Integer)helper.getArgument()).intValue());
                }
                catch (InterruptedException ugh) {
                    Assert.fail((String)"interrupted");
                }
            }
            if ((ret = helper.getKey()) instanceof String && ret != null && ret.equals(NON_EXISTENT_KEY)) {
                return null;
            }
            return ret;
        }

        public void init(Properties props) {
        }
    }
}

