/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache30;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.geode.cache.Cache;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.apache.geode.internal.cache.xmlcache.CacheXmlGenerator;
import org.apache.geode.internal.cache.xmlcache.ClientCacheCreation;
import org.apache.geode.test.awaitility.GeodeAwaitility;
import org.apache.geode.test.dunit.Assert;
import org.apache.geode.test.dunit.Invoke;
import org.apache.geode.test.dunit.cache.internal.JUnit4CacheTestCase;
import org.apache.geode.test.dunit.rules.DistributedRestoreSystemProperties;
import org.apache.geode.test.junit.rules.serializable.SerializableTemporaryFolder;
import org.apache.geode.test.junit.rules.serializable.SerializableTestName;
import org.junit.Rule;

public class CacheXmlTestCase
extends JUnit4CacheTestCase {
    private File xmlFile;
    static boolean lonerDistributedSystem = true;
    @Rule
    public DistributedRestoreSystemProperties restoreSystemProperties = new DistributedRestoreSystemProperties();
    @Rule
    public SerializableTemporaryFolder temporaryFolder = new SerializableTemporaryFolder();
    @Rule
    public SerializableTestName testName = new SerializableTestName();

    @Override
    public final void postSetUp() throws Exception {
        CacheXmlTestCase.disconnectAllFromDS();
    }

    @Override
    public final void preTearDownCacheTestCase() throws Exception {
        this.xmlFile = null;
        GemFireCacheImpl.testCacheXml = null;
        CacheXmlTestCase.waitForNoRebalancing();
        Invoke.invokeInEveryVM(CacheXmlTestCase::waitForNoRebalancing);
        super.preTearDownCacheTestCase();
    }

    private static void waitForNoRebalancing() {
        if (cache != null && !cache.isClosed()) {
            GeodeAwaitility.await().until(() -> cache.getResourceManager().getRebalanceOperations().size() == 0);
        }
    }

    @Override
    public final void postTearDownCacheTestCase() throws Exception {
        CacheXmlTestCase.disconnectAllFromDS();
    }

    protected String getGemFireVersion() {
        return "3_0";
    }

    protected boolean getUseSchema() {
        return false;
    }

    protected void setXmlFile(File xmlFile) {
        this.xmlFile = xmlFile;
    }

    protected File findFile(String fileName) throws IOException {
        return this.copyResourceToDirectory(this.temporaryFolder.getRoot(), fileName);
    }

    protected File copyResourceToDirectory(File directory, String fileName) throws IOException {
        URL url = this.getClass().getResource(fileName);
        File file = new File(directory, fileName);
        FileUtils.copyURLToFile((URL)url, (File)file);
        return file;
    }

    @Override
    public Properties getDistributedSystemProperties() {
        Properties props = super.getDistributedSystemProperties();
        if (this.xmlFile != null) {
            props.setProperty("cache-xml-file", this.xmlFile.toString());
        }
        if (lonerDistributedSystem) {
            props.setProperty("mcast-port", "0");
            props.setProperty("locators", "");
        }
        return props;
    }

    protected void testXml(CacheCreation creation) throws IOException {
        this.testXml(creation, true);
    }

    protected void testXml(CacheCreation creation, boolean checkSame) throws IOException {
        File root = this.temporaryFolder.getRoot();
        File dir = new File(root, "XML_" + this.getGemFireVersion());
        dir.mkdirs();
        File file = new File(dir, this.getUniqueName() + ".xml");
        boolean useSchema = this.getUseSchema();
        String version = this.getGemFireVersion();
        PrintWriter pw = new PrintWriter((Writer)new FileWriter(file), true);
        CacheXmlGenerator.generate((Cache)creation, (PrintWriter)pw, (boolean)useSchema, (String)version);
        pw.close();
        this.setXmlFile(file);
        boolean client = creation instanceof ClientCacheCreation;
        InternalCache cache = this.getCache(client);
        try {
            if (checkSame && !creation.sameAs((Cache)cache)) {
                StringWriter sw = new StringWriter();
                CacheXmlGenerator.generate((Cache)creation, (PrintWriter)new PrintWriter((Writer)sw, true), (boolean)useSchema, (String)version);
                CacheXmlGenerator.generate((Cache)cache, (PrintWriter)new PrintWriter((Writer)sw, true), (boolean)useSchema, (String)version);
                Assert.fail((String)sw.toString());
            }
        }
        catch (RuntimeException re) {
            StringWriter sw = new StringWriter();
            CacheXmlGenerator.generate((Cache)creation, (PrintWriter)new PrintWriter((Writer)sw, true), (boolean)useSchema, (String)version);
            CacheXmlGenerator.generate((Cache)cache, (PrintWriter)new PrintWriter((Writer)sw, true), (boolean)useSchema, (String)version);
            Assert.fail(sw.toString(), re);
        }
    }
}

