/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.standalone;

import batterytest.greplogs.ExpectedStrings;
import batterytest.greplogs.LogConsumer;
import hydra.MethExecutorResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import java.util.Properties;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.internal.AvailablePortHelper;
import org.apache.geode.test.dunit.DUnitEnv;
import org.apache.geode.test.dunit.Host;
import org.apache.geode.test.dunit.SerializableCallable;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.internal.JUnit4DistributedTestCase;
import org.apache.geode.test.dunit.standalone.BounceResult;
import org.apache.geode.test.dunit.standalone.ProcessManager;
import org.apache.geode.test.dunit.standalone.RemoteDUnitVM;
import org.apache.geode.test.dunit.standalone.RemoteDUnitVMIF;
import org.apache.geode.test.dunit.standalone.StandAloneDUnitEnv;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.junit.Assert;

public class DUnitLauncher {
    public static final String logLevel = System.getProperty("logLevel", "info");
    public static final String LOG4J = System.getProperty("log4j.configurationFile");
    public static final boolean MAKE_NEW_WORKING_DIRS = Boolean.getBoolean("makeNewWorkingDirsOnBounce");
    static int locatorPort;
    public static int NUM_VMS;
    private static final int DEBUGGING_VM_NUM = -1;
    private static final int LOCATOR_VM_NUM = -2;
    static final long STARTUP_TIMEOUT = 120000L;
    private static final String STARTUP_TIMEOUT_MESSAGE = "VMs did not start up within 120 seconds";
    private static final String SUSPECT_FILENAME = "dunit_suspect.log";
    private static File DUNIT_SUSPECT_FILE;
    public static final String DUNIT_DIR = "dunit";
    public static final String WORKSPACE_DIR_PARAM = "WORKSPACE_DIR";
    public static final boolean LOCATOR_LOG_TO_DISK;
    static final String MASTER_PARAM = "DUNIT_MASTER";
    public static final String RMI_PORT_PARAM = "gemfire.DUnitLauncher.RMI_PORT";
    public static final String VM_NUM_PARAM = "gemfire.DUnitLauncher.VM_NUM";
    static final String VM_VERSION_PARAM = "gemfire.DUnitLauncher.VM_VERSION";
    private static final String LAUNCHED_PROPERTY = "gemfire.DUnitLauncher.LAUNCHED";
    private static Master master;

    private DUnitLauncher() {
    }

    private static boolean isHydra() {
        try {
            Class<?> clazz = Class.forName("hydra.TestConfig");
            Method getInstance = clazz.getMethod("getInstance", new Class[0]);
            getInstance.invoke(null, new Object[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void launchIfNeeded() {
        if (System.getProperties().contains(VM_NUM_PARAM)) {
            return;
        }
        if (!DUnitLauncher.isHydra() && !DUnitLauncher.isLaunched()) {
            try {
                DUnitLauncher.launch();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to launch dunit VMs", e);
            }
        }
        Host.setAllVMsToCurrentVersion();
    }

    public static void launchIfNeeded(int vmCount) {
        NUM_VMS = vmCount;
        DUnitLauncher.launchIfNeeded();
    }

    public static boolean isLaunched() {
        return Boolean.getBoolean(LAUNCHED_PROPERTY);
    }

    public static String getLocatorString() {
        return "localhost[" + locatorPort + "]";
    }

    private static void launch() throws URISyntaxException, AlreadyBoundException, IOException, InterruptedException, NotBoundException {
        DUNIT_SUSPECT_FILE = new File(SUSPECT_FILENAME);
        DUNIT_SUSPECT_FILE.delete();
        DUNIT_SUSPECT_FILE.deleteOnExit();
        int namingPort = AvailablePortHelper.getRandomAvailableTCPPort();
        Registry registry = LocateRegistry.createRegistry(namingPort);
        System.setProperty(RMI_PORT_PARAM, "" + namingPort);
        JUnit4DistributedTestCase.initializeBlackboard();
        final ProcessManager processManager = new ProcessManager(namingPort, registry);
        master = new Master(registry, processManager);
        registry.bind(MASTER_PARAM, master);
        System.setProperty("Locator.inhibitDMBanner", "true");
        System.setProperty("gemfire.use-ephemeral-ports", "true");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                processManager.killVMs();
            }
        });
        processManager.launchVM(-2);
        if (!processManager.waitForVMs(120000L)) {
            throw new RuntimeException(STARTUP_TIMEOUT_MESSAGE);
        }
        locatorPort = DUnitLauncher.startLocator(registry);
        DUnitLauncher.init(master);
        for (int i = 0; i < NUM_VMS; ++i) {
            processManager.launchVM(i);
        }
        if (!processManager.waitForVMs(120000L)) {
            throw new RuntimeException(STARTUP_TIMEOUT_MESSAGE);
        }
        DUnitHost host = new DUnitHost(InetAddress.getLocalHost().getCanonicalHostName(), processManager);
        host.init(registry, NUM_VMS);
    }

    public static Properties getDistributedSystemProperties() {
        Properties p = new Properties();
        p.setProperty("locators", DUnitLauncher.getLocatorString());
        p.setProperty("mcast-port", "0");
        p.setProperty("enable-cluster-configuration", "false");
        p.setProperty("use-cluster-configuration", "false");
        p.setProperty("validate-serializable-objects", "true");
        p.setProperty("log-level", logLevel);
        return p;
    }

    private static void addSuspectFileAppender(String workspaceDir) {
        String suspectFilename = new File(workspaceDir, SUSPECT_FILENAME).getAbsolutePath();
        LoggerContext appenderContext = ((Logger)LogManager.getLogger((String)"org.apache.geode")).getContext();
        PatternLayout layout = PatternLayout.createLayout((String)"[%level{lowerCase=true} %date{yyyy/MM/dd HH:mm:ss.SSS z} <%thread> tid=%tid] %message%n%throwable%n", null, null, null, (Charset)Charset.defaultCharset(), (boolean)true, (boolean)false, (String)"", (String)"");
        FileAppender fileAppender = FileAppender.createAppender((String)suspectFilename, (String)"true", (String)"false", (String)DUnitLauncher.class.getName(), (String)"true", (String)"false", (String)"false", (String)"0", (Layout)layout, null, null, null, (Configuration)appenderContext.getConfiguration());
        fileAppender.start();
        LoggerConfig loggerConfig = appenderContext.getConfiguration().getLoggerConfig("org.apache.geode");
        loggerConfig.addAppender((Appender)fileAppender, Level.INFO, null);
    }

    private static int startLocator(Registry registry) throws IOException, NotBoundException {
        File locatorLogFile;
        RemoteDUnitVMIF remote = (RemoteDUnitVMIF)registry.lookup("vm-2");
        MethExecutorResult result = remote.executeMethodOnObject(new SerializableCallable(locatorLogFile = LOCATOR_LOG_TO_DISK ? new File("locator-" + locatorPort + ".log") : new File("")){
            final /* synthetic */ File val$locatorLogFile;
            {
                this.val$locatorLogFile = file;
            }

            @Override
            public Object call() throws IOException {
                Properties p = DUnitLauncher.getDistributedSystemProperties();
                p.setProperty("jmx-manager", "false");
                p.setProperty("enable-cluster-configuration", "false");
                System.setProperty("gemfire.bypass-discovery", "true");
                p.setProperty("disable-auto-reconnect", "true");
                try {
                    Locator.startLocatorAndDS((int)0, (File)this.val$locatorLogFile, (Properties)p);
                    InternalLocator internalLocator = (InternalLocator)Locator.getLocator();
                    locatorPort = internalLocator.getPort();
                }
                finally {
                    System.getProperties().remove("gemfire.bypass-discovery");
                }
                return locatorPort;
            }
        }, "call");
        if (result.getException() != null) {
            RuntimeException ex = new RuntimeException("Failed to start locator", result.getException());
            ex.printStackTrace();
            throw ex;
        }
        return (Integer)result.getResult();
    }

    public static void init(MasterRemote master) {
        DUnitEnv.set(new StandAloneDUnitEnv(master));
        String workspaceDir = System.getProperty(WORKSPACE_DIR_PARAM);
        workspaceDir = workspaceDir == null ? new File(".").getAbsolutePath() : workspaceDir;
        DUnitLauncher.addSuspectFileAppender(workspaceDir);
        System.setProperty("gemfire.free-off-heap-memory", "true");
        System.setProperty(LAUNCHED_PROPERTY, "true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAndCheckForSuspects() {
        if (DUnitLauncher.isLaunched()) {
            boolean skipLogMsgs = ExpectedStrings.skipLogMsgs(DUNIT_DIR);
            List expectedStrings = ExpectedStrings.create(DUNIT_DIR);
            LogConsumer logConsumer = new LogConsumer(skipLogMsgs, expectedStrings, "log4j", 5);
            StringBuilder suspectStringBuilder = new StringBuilder();
            BufferedReader buffReader = null;
            FileChannel fileChannel = null;
            try {
                fileChannel = new FileOutputStream(DUNIT_SUSPECT_FILE, true).getChannel();
                buffReader = new BufferedReader(new FileReader(DUNIT_SUSPECT_FILE));
            }
            catch (FileNotFoundException e) {
                System.err.println("Could not find the suspect string output file: " + e);
                return;
            }
            try {
                try {
                    String line;
                    while ((line = buffReader.readLine()) != null) {
                        StringBuilder builder = logConsumer.consume(line);
                        if (builder == null) continue;
                        suspectStringBuilder.append((CharSequence)builder);
                    }
                }
                catch (IOException e) {
                    System.err.println("Could not read the suspect string output file: " + e);
                }
                try {
                    fileChannel.truncate(0L);
                }
                catch (IOException e) {
                    System.err.println("Could not truncate the suspect string output file: " + e);
                }
            }
            finally {
                try {
                    buffReader.close();
                    fileChannel.close();
                }
                catch (IOException e) {
                    System.err.println("Could not close the suspect string output file: " + e);
                }
            }
            if (suspectStringBuilder.length() != 0) {
                System.err.println("Suspicious strings were written to the log during this run.\nFix the strings or use IgnoredException.addIgnoredException to ignore.\n" + suspectStringBuilder);
                Assert.fail((String)("Suspicious strings were written to the log during this run.\nFix the strings or use IgnoredException.addIgnoredException to ignore.\n" + suspectStringBuilder));
            }
        }
    }

    static {
        NUM_VMS = 4;
        LOCATOR_LOG_TO_DISK = Boolean.getBoolean("locatorLogToDisk");
    }

    private static class DUnitHost
    extends Host {
        private static final long serialVersionUID = -8034165624503666383L;
        private final transient VM debuggingVM = new VM(this, -1, new RemoteDUnitVM());
        private transient ProcessManager processManager;

        public DUnitHost(String hostName, ProcessManager processManager) throws RemoteException {
            super(hostName);
            this.processManager = processManager;
        }

        public void init(Registry registry, int numVMs) throws AccessException, RemoteException, NotBoundException, InterruptedException {
            for (int i = 0; i < numVMs; ++i) {
                RemoteDUnitVMIF remote = this.processManager.getStub(i);
                this.addVM(i, remote);
            }
            this.addLocator(-2, this.processManager.getStub(-2));
            DUnitHost.addHost(this);
        }

        @Override
        public VM getVM(int n) {
            if (n < this.getVMCount() && n != -1) {
                VM current = super.getVM(n);
                return this.getVM(current.getVersion(), n);
            }
            return this.getVM("000", n);
        }

        @Override
        public VM getVM(String version, int n) {
            if (n == -1) {
                return this.debuggingVM;
            }
            if (n < this.getVMCount()) {
                VM current = super.getVM(n);
                if (!current.getVersion().equals(version)) {
                    System.out.println("Bouncing VM" + n + " from version " + current.getVersion() + " to " + version);
                    current.bounce(version);
                }
                return current;
            }
            int oldVMCount = this.getVMCount();
            if (n >= oldVMCount) {
                try {
                    int i;
                    for (i = oldVMCount; i < n; ++i) {
                        this.processManager.launchVM(i);
                    }
                    this.processManager.waitForVMs(120000L);
                    for (i = oldVMCount; i < n; ++i) {
                        this.addVM(i, this.processManager.getStub(i));
                    }
                    this.processManager.launchVM(version, n, false);
                    this.processManager.waitForVMs(120000L);
                    this.addVM(n, this.processManager.getStub(n));
                }
                catch (IOException | InterruptedException | NotBoundException e) {
                    throw new RuntimeException("Could not dynamically launch vm + " + n, e);
                }
            }
            return super.getVM(n);
        }
    }

    public static class Master
    extends UnicastRemoteObject
    implements MasterRemote {
        private static final long serialVersionUID = 1178600200232603119L;
        private final Registry registry;
        private final ProcessManager processManager;

        public Master(Registry registry, ProcessManager processManager) throws RemoteException {
            this.processManager = processManager;
            this.registry = registry;
        }

        @Override
        public int getLocatorPort() throws RemoteException {
            return locatorPort;
        }

        @Override
        public synchronized void signalVMReady() {
            this.processManager.signalVMReady();
        }

        @Override
        public void ping() {
        }

        @Override
        public BounceResult bounce(int pid) {
            return this.bounce("000", pid, false);
        }

        @Override
        public BounceResult bounce(String version, int pid, boolean force) {
            this.processManager.bounce(version, pid, force);
            try {
                if (!this.processManager.waitForVMs(120000L)) {
                    throw new RuntimeException(DUnitLauncher.STARTUP_TIMEOUT_MESSAGE);
                }
                RemoteDUnitVMIF remote = (RemoteDUnitVMIF)this.registry.lookup(VM.getVMName("000", pid));
                return new BounceResult(pid, remote);
            }
            catch (NotBoundException | RemoteException e) {
                throw new RuntimeException("could not lookup name", e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Failed waiting for VM", e);
            }
        }
    }

    public static interface MasterRemote
    extends Remote {
        public int getLocatorPort() throws RemoteException;

        public void signalVMReady() throws RemoteException;

        public void ping() throws RemoteException;

        public BounceResult bounce(int var1) throws RemoteException;

        public BounceResult bounce(String var1, int var2, boolean var3) throws RemoteException;
    }
}

