/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit;

import hydra.MethExecutorResult;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.util.List;
import org.apache.geode.internal.process.ProcessUtils;
import org.apache.geode.test.dunit.AsyncInvocation;
import org.apache.geode.test.dunit.DUnitEnv;
import org.apache.geode.test.dunit.Host;
import org.apache.geode.test.dunit.NamedCallable;
import org.apache.geode.test.dunit.NamedRunnable;
import org.apache.geode.test.dunit.RMIException;
import org.apache.geode.test.dunit.RepeatableRunnable;
import org.apache.geode.test.dunit.SerializableCallableIF;
import org.apache.geode.test.dunit.SerializableRunnableIF;
import org.apache.geode.test.dunit.standalone.BounceResult;
import org.apache.geode.test.dunit.standalone.DUnitLauncher;
import org.apache.geode.test.dunit.standalone.RemoteDUnitVMIF;
import org.apache.geode.test.dunit.standalone.VersionManager;

public class VM
implements Serializable {
    public static final int CONTROLLER_VM = -1;
    public static final int DEFAULT_VM_COUNT = DUnitLauncher.NUM_VMS;
    private final Host host;
    private int id;
    private String version;
    private RemoteDUnitVMIF client;
    private volatile boolean available;

    public static int getCurrentVMNum() {
        return DUnitEnv.get().getVMID();
    }

    public static boolean isControllerVM() {
        return VM.getCurrentVMNum() == -1;
    }

    public static boolean isVM() {
        return VM.getCurrentVMNum() != -1;
    }

    public static VM getVM(int whichVM) {
        return Host.getHost(0).getVM(whichVM);
    }

    public static List<VM> getAllVMs() {
        return Host.getHost(0).getAllVMs();
    }

    public static int getVMCount() {
        return Host.getHost(0).getVMCount();
    }

    public static VM getLocator() {
        return Host.getLocator();
    }

    public static VM getController() {
        return VM.getVM(-1);
    }

    public static String getHostName() {
        return Host.getHost(0).getHostName();
    }

    public static String getVMName(String version, int pid) {
        if (pid == -2) {
            return "locator";
        }
        if (pid < 0 || VersionManager.isCurrentVersion((String)version)) {
            return "vm" + pid;
        }
        return "vm" + pid + "_v" + version;
    }

    public static VM[] toArray(VM ... vms) {
        return vms;
    }

    public VM(Host host, int id, RemoteDUnitVMIF client) {
        this(host, "000", id, client);
    }

    public VM(Host host, String version, int id, RemoteDUnitVMIF client) {
        this.host = host;
        this.id = id;
        this.version = version;
        this.client = client;
        this.available = true;
    }

    public Host getHost() {
        return this.host;
    }

    public String getVersion() {
        return this.version;
    }

    public int getId() {
        return this.id;
    }

    public int getPid() {
        return (Integer)this.invoke(() -> ProcessUtils.identifyPid());
    }

    @Deprecated
    public <V> V invoke(Class<?> targetClass, String methodName) {
        return this.invoke(targetClass, methodName, new Object[0]);
    }

    @Deprecated
    public <V> AsyncInvocation<V> invokeAsync(Class<?> targetClass, String methodName) {
        return this.invokeAsync(targetClass, methodName, null);
    }

    @Deprecated
    public <V> V invoke(Class<?> targetClass, String methodName, Object[] args) {
        if (!this.available) {
            throw new RMIException(this, targetClass.getName(), methodName, new IllegalStateException("VM not available: " + this));
        }
        MethExecutorResult result = this.execute(targetClass, methodName, args);
        if (!result.exceptionOccurred()) {
            return (V)result.getResult();
        }
        throw new RMIException(this, targetClass.getName(), methodName, result.getException(), result.getStackTrace());
    }

    @Deprecated
    public <V> AsyncInvocation<V> invokeAsync(Object targetObject, String methodName, Object[] args) {
        return new AsyncInvocation<Object>(targetObject, methodName, () -> this.invoke(targetObject, methodName, args)).start();
    }

    @Deprecated
    public <V> AsyncInvocation<V> invokeAsync(Class<?> targetClass, String methodName, Object[] args) {
        return new AsyncInvocation<Object>(targetClass, methodName, () -> this.invoke(targetClass, methodName, args)).start();
    }

    public <V> AsyncInvocation<V> invokeAsync(SerializableRunnableIF runnable) {
        return this.invokeAsync(runnable, "run", new Object[0]);
    }

    public <V> AsyncInvocation<V> invokeAsync(String name, SerializableRunnableIF runnable) {
        return this.invokeAsync(new NamedRunnable(name, runnable), "run", new Object[0]);
    }

    public <V> AsyncInvocation<V> invokeAsync(String name, SerializableCallableIF<V> callable) {
        return this.invokeAsync(new NamedCallable<V>(name, callable), "call", new Object[0]);
    }

    public <V> AsyncInvocation<V> invokeAsync(SerializableCallableIF<V> callable) {
        return this.invokeAsync(callable, "call", new Object[0]);
    }

    public void invoke(String name, SerializableRunnableIF runnable) {
        this.invoke(new NamedRunnable(name, runnable), "run");
    }

    public void invoke(SerializableRunnableIF runnable) {
        this.invoke(runnable, "run");
    }

    public <V> V invoke(String name, SerializableCallableIF<V> callable) {
        return this.invoke(new NamedCallable<V>(name, callable), "call");
    }

    public <V> V invoke(SerializableCallableIF<V> callable) {
        return this.invoke(callable, "call");
    }

    @Deprecated
    public void invokeRepeatingIfNecessary(RepeatableRunnable runnable, long repeatTimeoutMs) {
        this.invoke(runnable, "runRepeatingIfNecessary", new Object[]{repeatTimeoutMs});
    }

    @Deprecated
    public <V> V invoke(Object targetObject, String methodName) {
        return this.invoke(targetObject, methodName, new Object[0]);
    }

    @Deprecated
    public <V> V invoke(Object targetObject, String methodName, Object[] args) {
        if (!this.available) {
            throw new RMIException(this, targetObject.getClass().getName(), methodName, new IllegalStateException("VM not available: " + this));
        }
        MethExecutorResult result = this.execute(targetObject, methodName, args);
        if (!result.exceptionOccurred()) {
            return (V)result.getResult();
        }
        throw new RMIException(this, targetObject.getClass().getName(), methodName, result.getException(), result.getStackTrace());
    }

    public synchronized void makeAvailable() {
        if (!this.available) {
            this.available = true;
            this.bounce();
        }
    }

    public void bounce() {
        this.bounce(this.version, false);
    }

    public void bounceForcibly() {
        this.bounce(this.version, true);
    }

    public void bounce(String targetVersion) {
        this.bounce(targetVersion, false);
    }

    private synchronized void bounce(String targetVersion, boolean force) {
        if (!this.available) {
            throw new RMIException(this, this.getClass().getName(), "bounceVM", new IllegalStateException("VM not available: " + this));
        }
        this.available = false;
        try {
            BounceResult result = DUnitEnv.get().bounce(targetVersion, this.id, force);
            this.id = result.getNewId();
            this.client = result.getNewClient();
            this.version = targetVersion;
            this.available = true;
        }
        catch (UnsupportedOperationException e) {
            this.available = true;
            throw e;
        }
        catch (RemoteException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            throw new RMIException(this, this.getClass().getName(), "bounceVM", e, sw.toString());
        }
    }

    public File getWorkingDirectory() {
        return DUnitEnv.get().getWorkingDirectory(this.getVersion(), this.getId());
    }

    public String toString() {
        return "VM " + this.getId() + " running on " + this.getHost() + (VersionManager.isCurrentVersion((String)this.version) ? "" : " with version " + this.version);
    }

    private MethExecutorResult execute(Class<?> targetClass, String methodName, Object[] args) {
        try {
            return this.client.executeMethodOnClass(targetClass.getName(), methodName, args);
        }
        catch (RemoteException exception) {
            throw new RMIException(this, targetClass.getName(), methodName, exception);
        }
    }

    private MethExecutorResult execute(Object targetObject, String methodName, Object[] args) {
        try {
            if (args == null) {
                return this.client.executeMethodOnObject(targetObject, methodName);
            }
            return this.client.executeMethodOnObject(targetObject, methodName, args);
        }
        catch (RemoteException exception) {
            throw new RMIException(this, targetObject.getClass().getName(), methodName, exception);
        }
    }
}

