/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit;

import hydra.MethExecutor;
import hydra.MethExecutorResult;
import java.io.Serializable;
import java.rmi.RemoteException;
import org.apache.geode.test.dunit.Host;
import org.apache.geode.test.dunit.RMIException;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.standalone.RemoteDUnitVMIF;

public class LocalVM
extends VM {
    public LocalVM(VM vm) {
        this(vm.getHost(), vm.getId());
    }

    public LocalVM(Host host, int id) {
        this(host, "000", id);
    }

    public LocalVM(Host host, String version, int id) {
        super(host, version, id, new LocalDUnitVMIF());
    }

    public Object invoke(Class targetClass, String methodName, Object[] args) {
        MethExecutorResult result = LocalVM.execute(targetClass.getName(), methodName, args);
        if (!result.exceptionOccurred()) {
            return result.getResult();
        }
        throw new RMIException(this, targetClass.getName(), methodName, result.getException(), result.getStackTrace());
    }

    @Override
    public void bounce(String targetVersion) {
        LocalVM.throwUnsupportedOperationException();
    }

    protected static MethExecutorResult execute(String targetClass, String methodName, Object[] args) {
        return MethExecutor.execute(targetClass, methodName, args);
    }

    protected static void throwUnsupportedOperationException() {
        throw new UnsupportedOperationException("Not supported by LocalVM");
    }

    protected static class LocalDUnitVMIF
    implements RemoteDUnitVMIF,
    Serializable {
        protected LocalDUnitVMIF() {
        }

        @Override
        public MethExecutorResult executeMethodOnObject(Object target, String methodName) throws RemoteException {
            return MethExecutor.executeObject(target, methodName, new Object[0]);
        }

        @Override
        public MethExecutorResult executeMethodOnObject(Object target, String methodName, Object[] args) throws RemoteException {
            return MethExecutor.executeObject(target, methodName, args);
        }

        @Override
        public MethExecutorResult executeMethodOnClass(String className, String methodName, Object[] args) throws RemoteException {
            return MethExecutor.executeObject(className, methodName, args);
        }

        @Override
        public void shutDownVM() throws RemoteException {
            LocalVM.throwUnsupportedOperationException();
        }
    }
}

