/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.ShowLogCommand;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.test.dunit.rules.ClusterStartupRule;
import org.apache.geode.test.dunit.rules.MemberVM;
import org.apache.geode.test.junit.rules.GfshCommandRule;
import org.apache.geode.test.junit.rules.LocatorStarterRule;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class ShowLogCommandDUnitTestBase
implements Serializable {
    private static final String MANAGER_NAME = "Manager";
    private static final String SERVER1_NAME = "Server1";
    private static final String SERVER2_NAME = "Server2";
    private static final String GROUP0 = "Group0";
    private static final String GROUP1 = "Group1";
    private static final String GROUP2 = "Group2";
    private static final String MESSAGE_ON_MANAGER = "someLogMessageOnManager";
    private static final String MESSAGE_ON_SERVER1 = "someLogMessageOnServer1";
    private static final String MESSAGE_ON_SERVER2 = "someLogMessageOnServer2";
    protected static MemberVM locator;
    private static MemberVM server1;
    private static MemberVM server2;
    @ClassRule
    public static ClusterStartupRule clusterStartupRule;
    @ClassRule
    public static GfshCommandRule gfsh;

    @BeforeClass
    public static void setup() throws Exception {
        Properties managerProps = new Properties();
        managerProps.setProperty("name", MANAGER_NAME);
        managerProps.setProperty("groups", GROUP0);
        managerProps.setProperty("log-file", "Manager.log");
        managerProps.setProperty("log-level", "info");
        locator = clusterStartupRule.startLocatorVM(0, l -> (LocatorStarterRule)((LocatorStarterRule)l.withHttpService()).withProperties(managerProps));
        Properties server1Props = new Properties();
        server1Props.setProperty("name", SERVER1_NAME);
        server1Props.setProperty("groups", GROUP1);
        server1Props.setProperty("log-file", "Server1.log");
        managerProps.setProperty("log-level", "info");
        server1 = clusterStartupRule.startServerVM(1, server1Props, locator.getPort());
        Properties server2Props = new Properties();
        server2Props.setProperty("name", SERVER2_NAME);
        server2Props.setProperty("groups", GROUP2);
        server2Props.setProperty("log-file", "Server2.log");
        managerProps.setProperty("log-level", "info");
        server2 = clusterStartupRule.startServerVM(2, server2Props, locator.getPort());
    }

    @Before
    public void before() throws Exception {
        gfsh.connectAndVerify(locator.getJmxPort(), GfshCommandRule.PortType.jmxManager, new String[0]);
        Awaitility.await().atMost(2L, TimeUnit.MINUTES).until(ShowLogCommandDUnitTestBase::allMembersAreConnected);
    }

    @After
    public void after() throws Exception {
        gfsh.disconnect();
    }

    private void writeLogMessages() {
        locator.invoke(() -> LogService.getLogger().info(MESSAGE_ON_MANAGER));
        server1.invoke(() -> LogService.getLogger().info(MESSAGE_ON_SERVER1));
        server2.invoke(() -> LogService.getLogger().info(MESSAGE_ON_SERVER2));
    }

    @Test
    public void testShowLogDefault() {
        this.writeLogMessages();
        String command = "show log --member=Manager";
        gfsh.executeAndAssertThat(command).statusIsSuccess();
        Assertions.assertThat((String)gfsh.getGfshOutput()).contains(new CharSequence[]{MESSAGE_ON_MANAGER});
        Assertions.assertThat((String)gfsh.getGfshOutput()).doesNotContain(new CharSequence[]{MESSAGE_ON_SERVER1});
        Assertions.assertThat((String)gfsh.getGfshOutput()).doesNotContain(new CharSequence[]{MESSAGE_ON_SERVER2});
    }

    @Test
    public void testShowLogNumLines() throws InterruptedException {
        this.writeLogMessages();
        String command = "show log --member=Server1 --lines=50";
        gfsh.executeAndAssertThat(command).statusIsSuccess();
        String output = gfsh.getGfshOutput();
        Assertions.assertThat((String)output).contains(new CharSequence[]{MESSAGE_ON_SERVER1});
        Assertions.assertThat((String)gfsh.getGfshOutput()).doesNotContain(new CharSequence[]{MESSAGE_ON_MANAGER});
        Assertions.assertThat((String)gfsh.getGfshOutput()).doesNotContain(new CharSequence[]{MESSAGE_ON_SERVER2});
        Assertions.assertThat((Object[])output.split(System.getProperty("line.separator"))).hasSize(51);
    }

    @Test
    public void testShowLogInvalidMember() throws Exception {
        this.writeLogMessages();
        String command = "show log --member=NotAValidMember";
        CommandResult result = gfsh.executeCommand(command);
        Assertions.assertThat((Comparable)result.getStatus()).isEqualTo((Object)Result.Status.ERROR);
        String output = gfsh.getGfshOutput();
        Assertions.assertThat((String)output).contains(new CharSequence[]{"Member NotAValidMember could not be found"});
    }

    protected static boolean allMembersAreConnected() {
        return (Boolean)locator.getVM().invoke(() -> {
            DistributedMember server1 = CliUtil.getDistributedMemberByNameOrId((String)SERVER1_NAME, (InternalCache)ClusterStartupRule.getCache());
            DistributedMember server2 = CliUtil.getDistributedMemberByNameOrId((String)SERVER2_NAME, (InternalCache)ClusterStartupRule.getCache());
            ShowLogCommand showLogCommand = new ShowLogCommand();
            showLogCommand.setCache((Cache)ClusterStartupRule.getCache());
            boolean server1isConnected = showLogCommand.getMemberMxBean(server1) != null;
            boolean server2isConnected = showLogCommand.getMemberMxBean(server2) != null;
            return server1isConnected && server2isConnected;
        });
    }

    static {
        clusterStartupRule = new ClusterStartupRule();
        gfsh = new GfshCommandRule();
    }
}

