/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.internal.AvailablePortHelper;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.DistributedRegionMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.test.dunit.rules.ClusterStartupRule;
import org.apache.geode.test.dunit.rules.MemberVM;
import org.apache.geode.test.junit.rules.GfshCommandRule;
import org.apache.geode.test.junit.rules.LocatorStarterRule;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Java6Assertions;
import org.awaitility.Awaitility;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class RegionMembershipMBeanDUnitTestBase {
    private static final String DATA_REGION_NAME = "GemfireDataCommandsTestRegion";
    private static final String DATA_REGION_NAME_VM1 = "GemfireDataCommandsTestRegion_Vm1";
    private static final String DATA_REGION_NAME_VM2 = "GemfireDataCommandsTestRegion_Vm2";
    private static final String DATA_REGION_NAME_PATH = "/GemfireDataCommandsTestRegion";
    private static final String DATA_REGION_NAME_VM1_PATH = "/GemfireDataCommandsTestRegion_Vm1";
    private static final String DATA_REGION_NAME_VM2_PATH = "/GemfireDataCommandsTestRegion_Vm2";
    private static final String DATA_PAR_REGION_NAME = "GemfireDataCommandsTestParRegion";
    private static final String DATA_PAR_REGION_NAME_VM1 = "GemfireDataCommandsTestParRegion_Vm1";
    private static final String DATA_PAR_REGION_NAME_VM2 = "GemfireDataCommandsTestParRegion_Vm2";
    private static final String DATA_PAR_REGION_NAME_PATH = "/GemfireDataCommandsTestParRegion";
    private static final String DATA_PAR_REGION_NAME_VM1_PATH = "/GemfireDataCommandsTestParRegion_Vm1";
    private static final String DATA_PAR_REGION_NAME_VM2_PATH = "/GemfireDataCommandsTestParRegion_Vm2";
    private static final String DATA_REGION_NAME_CHILD_1 = "ChildRegionRegion1";
    private static final String DATA_REGION_NAME_CHILD_1_PATH = "/GemfireDataCommandsTestRegion/ChildRegionRegion1";
    private static final String DATA_REGION_NAME_CHILD_1_2 = "ChildRegionRegion12";
    private static final String DATA_REGION_NAME_CHILD_1_2_PATH = "/GemfireDataCommandsTestRegion/ChildRegionRegion1/ChildRegionRegion12";
    private static final String SERIALIZATION_FILTER = "org.apache.geode.management.internal.cli.**";
    @Rule
    public GfshCommandRule gfsh = new GfshCommandRule();
    @Rule
    public ClusterStartupRule cluster = new ClusterStartupRule();
    protected MemberVM locator;
    protected MemberVM server1;
    protected MemberVM server2;

    @Before
    public void before() throws Exception {
        Properties props = this.locatorProperties();
        props.setProperty("serializable-object-filter", SERIALIZATION_FILTER);
        props.setProperty("name", "locator");
        Properties serverProps = new Properties();
        serverProps.setProperty("serializable-object-filter", SERIALIZATION_FILTER);
        this.locator = this.cluster.startLocatorVM(0, l -> (LocatorStarterRule)((LocatorStarterRule)l.withHttpService()).withProperties(props));
        this.server1 = this.cluster.startServerVM(1, serverProps, this.locator.getPort());
        this.server2 = this.cluster.startServerVM(2, serverProps, this.locator.getPort());
        this.connectToLocator();
    }

    public void connectToLocator() throws Exception {
        this.gfsh.connectAndVerify(this.locator.getJmxPort(), GfshCommandRule.PortType.jmxManager, new String[0]);
    }

    private static void setupDataRegionAndSubregions() {
        InternalCache cache = ClusterStartupRule.getCache();
        RegionFactory regionFactory = cache.createRegionFactory(RegionShortcut.REPLICATE);
        Region dataRegion = regionFactory.create(DATA_REGION_NAME);
        Java6Assertions.assertThat((Map)dataRegion).isNotNull();
        Region dataSubRegion = regionFactory.createSubregion(dataRegion, DATA_REGION_NAME_CHILD_1);
        Java6Assertions.assertThat((Map)dataSubRegion).isNotNull();
        dataSubRegion = regionFactory.createSubregion(dataSubRegion, DATA_REGION_NAME_CHILD_1_2);
        Java6Assertions.assertThat((Map)dataSubRegion).isNotNull();
        Java6Assertions.assertThat((Map)dataRegion).isNotNull();
    }

    private static void setupReplicatedRegion(String regionName) {
        InternalCache cache = ClusterStartupRule.getCache();
        RegionFactory regionFactory = cache.createRegionFactory(RegionShortcut.REPLICATE);
        Region dataRegion = regionFactory.create(regionName);
        Java6Assertions.assertThat((Map)dataRegion).isNotNull();
        Java6Assertions.assertThat((String)dataRegion.getFullPath()).contains(new CharSequence[]{regionName});
    }

    private static void setupPartitionedRegion(String regionName) {
        InternalCache cache = ClusterStartupRule.getCache();
        PartitionAttributes partitionAttrs = new PartitionAttributesFactory().setRedundantCopies(2).create();
        RegionFactory partitionRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
        partitionRegionFactory.setPartitionAttributes(partitionAttrs);
        Region dataParRegion = partitionRegionFactory.create(regionName);
        Java6Assertions.assertThat((Map)dataParRegion).isNotNull();
        Java6Assertions.assertThat((String)dataParRegion.getFullPath()).contains(new CharSequence[]{regionName});
    }

    @Test
    public void testReplicatedRegionOnOneMember() {
        this.server1.invoke(() -> RegionMembershipMBeanDUnitTestBase.setupReplicatedRegion(DATA_REGION_NAME));
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_NAME_PATH, 1);
        Integer memSizeFromMBean = this.distributedRegionMembersSizeFromMBean(DATA_REGION_NAME_PATH);
        Integer memSizeFromFunctionCall = this.distributedRegionMembersSizeFromFunction(DATA_REGION_NAME_PATH);
        ((AbstractIntegerAssert)Java6Assertions.assertThat((Integer)memSizeFromFunctionCall).isEqualTo((Object)memSizeFromMBean)).isEqualTo(1);
    }

    @Test
    public void testMultipleReplicatedRegionsAndSubregions() {
        this.server1.invoke(() -> RegionMembershipMBeanDUnitTestBase.setupDataRegionAndSubregions());
        this.server1.invoke(() -> RegionMembershipMBeanDUnitTestBase.setupReplicatedRegion(DATA_REGION_NAME_VM1));
        this.server2.invoke(() -> RegionMembershipMBeanDUnitTestBase.setupDataRegionAndSubregions());
        this.server2.invoke(() -> RegionMembershipMBeanDUnitTestBase.setupReplicatedRegion(DATA_REGION_NAME_VM2));
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_NAME_PATH, 2);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_NAME_CHILD_1_PATH, 2);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_NAME_CHILD_1_2_PATH, 2);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_NAME_VM1_PATH, 1);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_NAME_VM2_PATH, 1);
        Integer memSizeFromMBean = this.distributedRegionMembersSizeFromMBean(DATA_REGION_NAME_PATH);
        Integer memSizeFromFunctionCall = this.distributedRegionMembersSizeFromFunction(DATA_REGION_NAME_PATH);
        Java6Assertions.assertThat((Integer)memSizeFromFunctionCall).isEqualTo((Object)memSizeFromMBean);
        memSizeFromMBean = this.distributedRegionMembersSizeFromMBean(DATA_REGION_NAME_CHILD_1_PATH);
        memSizeFromFunctionCall = this.distributedRegionMembersSizeFromFunction(DATA_REGION_NAME_CHILD_1_PATH);
        Java6Assertions.assertThat((Integer)memSizeFromFunctionCall).isEqualTo((Object)memSizeFromMBean);
        memSizeFromMBean = this.distributedRegionMembersSizeFromMBean(DATA_REGION_NAME_CHILD_1_2_PATH);
        memSizeFromFunctionCall = this.distributedRegionMembersSizeFromFunction(DATA_REGION_NAME_CHILD_1_2_PATH);
        Java6Assertions.assertThat((Integer)memSizeFromFunctionCall).isEqualTo((Object)memSizeFromMBean);
        memSizeFromMBean = this.distributedRegionMembersSizeFromMBean(DATA_REGION_NAME_VM1_PATH);
        memSizeFromFunctionCall = this.distributedRegionMembersSizeFromFunction(DATA_REGION_NAME_VM1_PATH);
        Java6Assertions.assertThat((Integer)memSizeFromFunctionCall).isEqualTo((Object)memSizeFromMBean);
        memSizeFromMBean = this.distributedRegionMembersSizeFromMBean(DATA_REGION_NAME_VM2_PATH);
        memSizeFromFunctionCall = this.distributedRegionMembersSizeFromFunction(DATA_REGION_NAME_VM2_PATH);
        Java6Assertions.assertThat((Integer)memSizeFromFunctionCall).isEqualTo((Object)memSizeFromMBean);
    }

    @Test
    public void testAddRmNewMemberWithReplicatedRegionsAndSubregions() {
        this.server1.invoke(() -> RegionMembershipMBeanDUnitTestBase.setupDataRegionAndSubregions());
        this.server2.invoke(() -> RegionMembershipMBeanDUnitTestBase.setupDataRegionAndSubregions());
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_NAME_PATH, 2);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_NAME_CHILD_1_PATH, 2);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_NAME_CHILD_1_2_PATH, 2);
        Integer initialMemberSizeFromMBean = this.distributedRegionMembersSizeFromMBean(DATA_REGION_NAME_PATH);
        Integer initialMemberSizeFromFunction = this.distributedRegionMembersSizeFromFunction(DATA_REGION_NAME_PATH);
        Java6Assertions.assertThat((Integer)initialMemberSizeFromFunction).isEqualTo((Object)initialMemberSizeFromMBean);
        Integer initialMemberSizeChild1FromMBean = this.distributedRegionMembersSizeFromMBean(DATA_REGION_NAME_CHILD_1_PATH);
        Integer initialMemberSizeChild1FromFunction = this.distributedRegionMembersSizeFromFunction(DATA_REGION_NAME_CHILD_1_PATH);
        Java6Assertions.assertThat((Integer)initialMemberSizeChild1FromFunction).isEqualTo((Object)initialMemberSizeChild1FromMBean);
        Integer initialMemberSizeChild2FromMBean = this.distributedRegionMembersSizeFromMBean(DATA_REGION_NAME_CHILD_1_2_PATH);
        Integer initialMemberSizeChild2FromFunction = this.distributedRegionMembersSizeFromFunction(DATA_REGION_NAME_CHILD_1_2_PATH);
        Java6Assertions.assertThat((Integer)initialMemberSizeChild2FromFunction).isEqualTo((Object)initialMemberSizeChild2FromMBean);
        MemberVM server3 = this.cluster.startServerVM(3, this.locator.getPort());
        server3.invoke(() -> RegionMembershipMBeanDUnitTestBase.setupDataRegionAndSubregions());
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_NAME_PATH, 3);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_NAME_CHILD_1_PATH, 3);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_NAME_CHILD_1_2_PATH, 3);
        Integer intermediateMemberSizeFromMBean = this.distributedRegionMembersSizeFromMBean(DATA_REGION_NAME_PATH);
        Integer intermediateMemberSizeFromFunction = this.distributedRegionMembersSizeFromFunction(DATA_REGION_NAME_PATH);
        ((AbstractIntegerAssert)Java6Assertions.assertThat((Integer)intermediateMemberSizeFromFunction).isEqualTo((Object)intermediateMemberSizeFromMBean)).isEqualTo(initialMemberSizeFromFunction + 1);
        Integer intermediateMemberSizeChild1FromMBean = this.distributedRegionMembersSizeFromMBean(DATA_REGION_NAME_CHILD_1_PATH);
        Integer intermediateMemberSizeChild1FromFunction = this.distributedRegionMembersSizeFromFunction(DATA_REGION_NAME_CHILD_1_PATH);
        ((AbstractIntegerAssert)Java6Assertions.assertThat((Integer)intermediateMemberSizeChild1FromMBean).isEqualTo((Object)intermediateMemberSizeChild1FromFunction)).isEqualTo(initialMemberSizeChild1FromFunction + 1);
        Integer intermediateMemberSizeChild2FromMBean = this.distributedRegionMembersSizeFromMBean(DATA_REGION_NAME_CHILD_1_2_PATH);
        Integer intermediateMemberSizeChild2FromFunction = this.distributedRegionMembersSizeFromFunction(DATA_REGION_NAME_CHILD_1_2_PATH);
        ((AbstractIntegerAssert)Java6Assertions.assertThat((Integer)intermediateMemberSizeChild2FromFunction).isEqualTo((Object)intermediateMemberSizeChild2FromMBean)).isEqualTo(initialMemberSizeChild2FromMBean + 1);
        server3.stop(Boolean.TRUE);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_NAME_PATH, 2);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_NAME_CHILD_1_PATH, 2);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_NAME_CHILD_1_2_PATH, 2);
        Integer finalMemberSizeFromMBean = this.distributedRegionMembersSizeFromMBean(DATA_REGION_NAME_PATH);
        Integer finalMemberSizeFromFunction = this.distributedRegionMembersSizeFromFunction(DATA_REGION_NAME_PATH);
        ((AbstractIntegerAssert)Java6Assertions.assertThat((Integer)finalMemberSizeFromFunction).isEqualTo((Object)finalMemberSizeFromMBean)).isEqualTo((Object)initialMemberSizeFromFunction);
        Integer finalMemberSizeChild1FromMBean = this.distributedRegionMembersSizeFromMBean(DATA_REGION_NAME_CHILD_1_PATH);
        Integer finalMemberSizeChild1FromFunction = this.distributedRegionMembersSizeFromFunction(DATA_REGION_NAME_CHILD_1_PATH);
        ((AbstractIntegerAssert)Java6Assertions.assertThat((Integer)finalMemberSizeChild1FromMBean).isEqualTo((Object)finalMemberSizeChild1FromFunction)).isEqualTo((Object)initialMemberSizeChild1FromFunction);
        Integer finalMemberSizeChild2FromMBean = this.distributedRegionMembersSizeFromMBean(DATA_REGION_NAME_CHILD_1_2_PATH);
        Integer finalMemberSizeChild2FromFunction = this.distributedRegionMembersSizeFromFunction(DATA_REGION_NAME_CHILD_1_2_PATH);
        ((AbstractIntegerAssert)Java6Assertions.assertThat((Integer)finalMemberSizeChild2FromFunction).isEqualTo((Object)finalMemberSizeChild2FromMBean)).isEqualTo((Object)initialMemberSizeChild2FromMBean);
    }

    @Test
    public void testPartitionedRegionOnOneMember() {
        this.server1.invoke(() -> RegionMembershipMBeanDUnitTestBase.setupPartitionedRegion(DATA_PAR_REGION_NAME));
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_PAR_REGION_NAME_PATH, 1);
        Integer memSizeFromMBean = this.distributedRegionMembersSizeFromMBean(DATA_PAR_REGION_NAME_PATH);
        Integer memSizeFromFunctionCall = this.distributedRegionMembersSizeFromFunction(DATA_PAR_REGION_NAME_PATH);
        ((AbstractIntegerAssert)Java6Assertions.assertThat((Integer)memSizeFromFunctionCall).isEqualTo((Object)memSizeFromMBean)).isEqualTo(1);
    }

    @Test
    public void testMultiplePartitionedRegions() {
        this.server1.invoke(() -> RegionMembershipMBeanDUnitTestBase.setupPartitionedRegion(DATA_PAR_REGION_NAME));
        this.server1.invoke(() -> RegionMembershipMBeanDUnitTestBase.setupReplicatedRegion(DATA_PAR_REGION_NAME_VM1));
        this.server2.invoke(() -> RegionMembershipMBeanDUnitTestBase.setupPartitionedRegion(DATA_PAR_REGION_NAME));
        this.server2.invoke(() -> RegionMembershipMBeanDUnitTestBase.setupReplicatedRegion(DATA_PAR_REGION_NAME_VM2));
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_PAR_REGION_NAME_PATH, 2);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_PAR_REGION_NAME_VM1_PATH, 1);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_PAR_REGION_NAME_VM2_PATH, 1);
        Integer memSizeFromMBean = this.distributedRegionMembersSizeFromMBean(DATA_PAR_REGION_NAME_PATH);
        Integer memSizeFromFunctionCall = this.distributedRegionMembersSizeFromFunction(DATA_PAR_REGION_NAME_PATH);
        Java6Assertions.assertThat((Integer)memSizeFromFunctionCall).isEqualTo((Object)memSizeFromMBean);
        memSizeFromMBean = this.distributedRegionMembersSizeFromMBean(DATA_PAR_REGION_NAME_VM1_PATH);
        memSizeFromFunctionCall = this.distributedRegionMembersSizeFromFunction(DATA_PAR_REGION_NAME_VM1_PATH);
        Java6Assertions.assertThat((Integer)memSizeFromFunctionCall).isEqualTo((Object)memSizeFromMBean);
        memSizeFromMBean = this.distributedRegionMembersSizeFromMBean(DATA_PAR_REGION_NAME_VM2_PATH);
        memSizeFromFunctionCall = this.distributedRegionMembersSizeFromFunction(DATA_PAR_REGION_NAME_VM2_PATH);
        Java6Assertions.assertThat((Integer)memSizeFromFunctionCall).isEqualTo((Object)memSizeFromMBean);
    }

    @Test
    public void testAddRmNewMemberWithPartitionedRegions() {
        this.server1.invoke(() -> RegionMembershipMBeanDUnitTestBase.setupPartitionedRegion(DATA_PAR_REGION_NAME));
        this.server2.invoke(() -> RegionMembershipMBeanDUnitTestBase.setupPartitionedRegion(DATA_PAR_REGION_NAME));
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_PAR_REGION_NAME_PATH, 2);
        Integer initialMemberSizeFromMBean = this.distributedRegionMembersSizeFromMBean(DATA_PAR_REGION_NAME_PATH);
        Integer initialMemberSizeFromFunctionCall = this.distributedRegionMembersSizeFromFunction(DATA_PAR_REGION_NAME_PATH);
        Java6Assertions.assertThat((Integer)initialMemberSizeFromFunctionCall).isEqualTo((Object)initialMemberSizeFromMBean);
        MemberVM server3 = this.cluster.startServerVM(3, this.locator.getPort());
        server3.invoke(() -> RegionMembershipMBeanDUnitTestBase.setupPartitionedRegion(DATA_PAR_REGION_NAME));
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_PAR_REGION_NAME_PATH, 3);
        Integer intermediateMemberSizeFromMBean = this.distributedRegionMembersSizeFromMBean(DATA_PAR_REGION_NAME_PATH);
        Integer intermediateMemberSizeFromFunctionCall = this.distributedRegionMembersSizeFromFunction(DATA_PAR_REGION_NAME_PATH);
        ((AbstractIntegerAssert)Java6Assertions.assertThat((Integer)intermediateMemberSizeFromFunctionCall).isEqualTo((Object)intermediateMemberSizeFromMBean)).isEqualTo(initialMemberSizeFromMBean + 1);
        server3.stop(Boolean.TRUE);
        Integer finalMemberSizeFromMBean = this.distributedRegionMembersSizeFromMBean(DATA_PAR_REGION_NAME_PATH);
        Integer finalMemberSizeFromFunctionCall = this.distributedRegionMembersSizeFromFunction(DATA_PAR_REGION_NAME_PATH);
        ((AbstractIntegerAssert)Java6Assertions.assertThat((Integer)finalMemberSizeFromFunctionCall).isEqualTo((Object)finalMemberSizeFromMBean)).isEqualTo((Object)initialMemberSizeFromFunctionCall);
    }

    private Integer distributedRegionMembersSizeFromFunction(String regionName) {
        return (Integer)this.locator.invoke(() -> {
            InternalCache cache = ClusterStartupRule.getCache();
            Set distributedMembers = CliUtil.getRegionAssociatedMembers((String)regionName, (InternalCache)cache, (boolean)true);
            return distributedMembers.size();
        });
    }

    private Integer distributedRegionMembersSizeFromMBean(String regionPath) {
        return (Integer)this.locator.invoke(() -> {
            InternalCache cache = ClusterStartupRule.getCache();
            Awaitility.waitAtMost((long)20L, (TimeUnit)TimeUnit.SECONDS).untilAsserted(() -> RegionMembershipMBeanDUnitTestBase.lambda$null$0((Cache)cache, regionPath));
            DistributedRegionMXBean bean = ManagementService.getManagementService((Cache)cache).getDistributedRegionMXBean(regionPath);
            String[] membersName = bean.getMembers();
            return membersName.length;
        });
    }

    private Properties locatorProperties() {
        int jmxPort = AvailablePortHelper.getRandomAvailableTCPPort();
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("log-level", "fine");
        props.setProperty("jmx-manager-hostname-for-clients", "localhost");
        props.setProperty("jmx-manager-port", "" + jmxPort);
        return props;
    }

    private static /* synthetic */ void lambda$null$0(Cache cache, String regionPath) throws Throwable {
        DistributedRegionMXBean bean = ManagementService.getManagementService((Cache)cache).getDistributedRegionMXBean(regionPath);
        Java6Assertions.assertThat((Object)bean).isNotNull();
    }
}

