/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache30;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.Delta;
import org.apache.geode.Instantiator;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.AttributesMutator;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.CacheTransactionManager;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.EntryExistsException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.InterestPolicy;
import org.apache.geode.cache.LoaderHelper;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionEvent;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.SubscriptionAttributes;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.TransactionEvent;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.cache.TransactionListener;
import org.apache.geode.cache.partition.PartitionRegionHelper;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.apache.geode.cache.util.TxEventTestUtil;
import org.apache.geode.cache30.CacheSerializableRunnable;
import org.apache.geode.cache30.RegionTestCase;
import org.apache.geode.cache30.TestCacheListener;
import org.apache.geode.cache30.TestCacheLoader;
import org.apache.geode.cache30.TestCacheWriter;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.SerialAckedMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.AvailablePortHelper;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.InternalInstantiator;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryExpiryTask;
import org.apache.geode.internal.cache.ExpiryTask;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.TombstoneService;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.lang.ThrowableUtils;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.offheap.MemoryAllocatorImpl;
import org.apache.geode.internal.offheap.StoredObject;
import org.apache.geode.test.dunit.AsyncInvocation;
import org.apache.geode.test.dunit.DistributedTestUtils;
import org.apache.geode.test.dunit.IgnoredException;
import org.apache.geode.test.dunit.Invoke;
import org.apache.geode.test.dunit.SerializableCallable;
import org.apache.geode.test.dunit.SerializableRunnable;
import org.apache.geode.test.dunit.SerializableRunnableIF;
import org.apache.geode.test.dunit.ThreadUtils;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.Wait;
import org.apache.geode.test.dunit.cache.internal.JUnit4CacheTestCase;
import org.apache.geode.test.dunit.internal.JUnit4DistributedTestCase;
import org.apache.logging.log4j.Logger;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ProxyableObjectAssert;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Ignore;
import org.junit.Test;

public abstract class MultiVMRegionTestCase
extends RegionTestCase {
    private static final Logger logger = LogService.getLogger();
    private static final long POLL_INTERVAL_MILLIS = 50L;
    private static final int PUT_RANGE_1_START = 1;
    private static final int PUT_RANGE_1_END = 5;
    private static final int PUT_RANGE_2_START = 6;
    private static final int PUT_RANGE_2_END = 10;
    private static TestCacheListener testCacheListener;
    private static TestCacheLoader testCacheLoader;
    private static TestCacheWriter testCacheWriter;
    private static int afterCreates;
    static LocalRegion CCRegion;
    static int distributedSystemID;
    private static final int CHUNK_SIZE = 512000;
    private static final int NUM_ENTRIES = 100;
    private static final int VALUE_SIZE = 51200;
    private static TestCacheListener<Object, Object> destroyListener;
    private static final int NB1_CHUNK_SIZE = 512000;
    private static final int NB1_NUM_ENTRIES = 1000;
    private static final int NB1_VALUE_SIZE = 5120;

    private static <K, V> TestCacheListener<K, V> listener() {
        return testCacheListener;
    }

    private static <K, V> void setListener(TestCacheListener<K, V> listener) {
        testCacheListener = listener;
    }

    protected static <K, V> TestCacheLoader<K, V> loader() {
        return testCacheLoader;
    }

    protected static <K, V> void setLoader(TestCacheLoader<K, V> loader) {
        testCacheLoader = loader;
    }

    private static <K, V> TestCacheWriter<K, V> writer() {
        return testCacheWriter;
    }

    private static <K, V> void setWriter(TestCacheWriter<K, V> writer) {
        testCacheWriter = writer;
    }

    private static void cleanup() {
        testCacheListener = null;
        testCacheLoader = null;
        testCacheWriter = null;
        CCRegion = null;
    }

    @AfterClass
    public static void caseTearDown() {
        MultiVMRegionTestCase.disconnectAllFromDS();
    }

    @Override
    protected final void postTearDownRegionTestCase() throws Exception {
        MultiVMRegionTestCase.cleanup();
        Invoke.invokeInEveryVM(MultiVMRegionTestCase::cleanup);
    }

    @Override
    public Properties getDistributedSystemProperties() {
        Properties properties = super.getDistributedSystemProperties();
        properties.put("serializable-object-filter", "org.apache.geode.cache30.MultiVMRegionTestCase$DeltaValue");
        return properties;
    }

    @Test
    public void testConcurrentOperations() {
        CacheSerializableRunnable createRegion = new CacheSerializableRunnable("createRegion"){

            @Override
            public void run2() throws CacheException {
                InternalCache cache = MultiVMRegionTestCase.this.getCache();
                RegionAttributes regionAttribs = MultiVMRegionTestCase.this.getRegionAttributes();
                cache.createRegionFactory(regionAttribs).create("R1");
            }
        };
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        VM vm2 = VM.getVM(2);
        VM vm3 = VM.getVM(3);
        vm0.invoke(createRegion);
        vm1.invoke(createRegion);
        vm2.invoke(createRegion);
        vm3.invoke(createRegion);
        this.concurrentMapTest("/R1");
    }

    private void concurrentMapTest(final String rName) {
        VM vm0 = VM.getVM(0);
        vm0.invoke(new CacheSerializableRunnable("doConcurrentMapOperations"){

            @Override
            public void run2() throws CacheException {
                String expected1;
                int i;
                InternalCache cache = MultiVMRegionTestCase.this.getCache();
                Region pr = cache.getRegion(rName);
                ((MapAssert)Assertions.assertThat((Map)pr).describedAs(rName + " not created", new Object[0])).isNotNull();
                for (int i2 = 1; i2 <= 5; ++i2) {
                    Object putResult = pr.putIfAbsent((Object)Integer.toString(i2), (Object)Integer.toString(i2));
                    ((ObjectAssert)Assertions.assertThat((Object)putResult).describedAs("Expected null, but got " + putResult + " for key " + i2, new Object[0])).isNull();
                }
                int size = pr.size();
                ((AbstractIntegerAssert)Assertions.assertThat((int)size).describedAs("Size doesn't return expected value", new Object[0])).isEqualTo(5);
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)pr.isEmpty()).describedAs("isEmpty doesn't return proper state of the region", new Object[0])).isFalse();
                for (i = 1; i <= 5; ++i) {
                    Object putResult = pr.putIfAbsent((Object)Integer.toString(i), (Object)Integer.toString(i + 1));
                    ((ObjectAssert)Assertions.assertThat((Object)putResult).describedAs("for i=" + i, new Object[0])).isEqualTo((Object)Integer.toString(i));
                    ((AbstractCharSequenceAssert)Assertions.assertThat((String)((String)pr.get((Object)Integer.toString(i)))).describedAs("for i=" + i, new Object[0])).isEqualTo((Object)Integer.toString(i));
                }
                size = pr.size();
                ((AbstractIntegerAssert)Assertions.assertThat((int)size).describedAs("Size doesn't return expected value", new Object[0])).isEqualTo(5);
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)pr.isEmpty()).describedAs("isEmpty doesn't return proper state of the region", new Object[0])).isFalse();
                for (i = 1; i <= 5; ++i) {
                    boolean replaceSucceeded = pr.replace((Object)Integer.toString(i), (Object)Integer.toString(i), (Object)("replaced" + i));
                    ((AbstractBooleanAssert)Assertions.assertThat((boolean)replaceSucceeded).describedAs("for i=" + i, new Object[0])).isTrue();
                    ((AbstractCharSequenceAssert)Assertions.assertThat((String)((String)pr.get((Object)Integer.toString(i)))).describedAs("for i=" + i, new Object[0])).isEqualTo((Object)("replaced" + i));
                }
                size = pr.size();
                ((AbstractIntegerAssert)Assertions.assertThat((int)size).describedAs("Size doesn't return expected value", new Object[0])).isEqualTo(5);
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)pr.isEmpty()).describedAs("isEmpty doesn't return proper state of the region", new Object[0])).isFalse();
                for (i = 1; i <= 10; ++i) {
                    boolean replaceSucceeded = pr.replace((Object)Integer.toString(i), (Object)Integer.toString(i), (Object)("not" + i));
                    ((AbstractBooleanAssert)Assertions.assertThat((boolean)replaceSucceeded).describedAs("for i=" + i, new Object[0])).isFalse();
                    expected1 = i <= 5 ? "replaced" + i : null;
                    ((AbstractCharSequenceAssert)Assertions.assertThat((String)((String)pr.get((Object)Integer.toString(i)))).describedAs("for i=" + i, new Object[0])).isEqualTo((Object)expected1);
                }
                size = pr.size();
                ((AbstractIntegerAssert)Assertions.assertThat((int)size).describedAs("Size doesn't return expected value", new Object[0])).isEqualTo(5);
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)pr.isEmpty()).describedAs("isEmpty doesn't return proper state of the region", new Object[0])).isFalse();
                for (i = 1; i <= 5; ++i) {
                    Object replaceResult = pr.replace((Object)Integer.toString(i), (Object)("twice replaced" + i));
                    ((ObjectAssert)Assertions.assertThat((Object)replaceResult).describedAs("for i=" + i, new Object[0])).isEqualTo((Object)("replaced" + i));
                    ((AbstractCharSequenceAssert)Assertions.assertThat((String)((String)pr.get((Object)Integer.toString(i)))).describedAs("for i=" + i, new Object[0])).isEqualTo((Object)("twice replaced" + i));
                }
                size = pr.size();
                ((AbstractIntegerAssert)Assertions.assertThat((int)size).describedAs("Size doesn't return expected value", new Object[0])).isEqualTo(5);
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)pr.isEmpty()).describedAs("isEmpty doesn't return proper state of the region", new Object[0])).isFalse();
                for (i = 6; i <= 10; ++i) {
                    Object replaceResult = pr.replace((Object)Integer.toString(i), (Object)("thrice replaced" + i));
                    ((ObjectAssert)Assertions.assertThat((Object)replaceResult).describedAs("for i=" + i, new Object[0])).isNull();
                    ((AbstractCharSequenceAssert)Assertions.assertThat((String)((String)pr.get((Object)Integer.toString(i)))).describedAs("for i=" + i, new Object[0])).isNull();
                }
                size = pr.size();
                ((AbstractIntegerAssert)Assertions.assertThat((int)size).describedAs("Size doesn't return expected value", new Object[0])).isEqualTo(5);
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)pr.isEmpty()).describedAs("isEmpty doesn't return proper state of the region", new Object[0])).isFalse();
                for (i = 1; i <= 10; ++i) {
                    boolean removeResult = pr.remove((Object)Integer.toString(i), (Object)Integer.toString(-i));
                    ((AbstractBooleanAssert)Assertions.assertThat((boolean)removeResult).describedAs("for i=" + i, new Object[0])).isFalse();
                    expected1 = i <= 5 ? "twice replaced" + i : null;
                    ((AbstractCharSequenceAssert)Assertions.assertThat((String)((String)pr.get((Object)Integer.toString(i)))).describedAs("for i=" + i, new Object[0])).isEqualTo((Object)expected1);
                }
                size = pr.size();
                ((AbstractIntegerAssert)Assertions.assertThat((int)size).describedAs("Size doesn't return expected value", new Object[0])).isEqualTo(5);
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)pr.isEmpty()).describedAs("isEmpty doesn't return proper state of the region", new Object[0])).isFalse();
                for (i = 1; i <= 5; ++i) {
                    boolean removeResult = pr.remove((Object)Integer.toString(i), (Object)("twice replaced" + i));
                    ((AbstractBooleanAssert)Assertions.assertThat((boolean)removeResult).describedAs("for i=" + i, new Object[0])).isTrue();
                    ((AbstractCharSequenceAssert)Assertions.assertThat((String)((String)pr.get((Object)Integer.toString(i)))).describedAs("for i=" + i, new Object[0])).isNull();
                }
                size = pr.size();
                ((AbstractIntegerAssert)Assertions.assertThat((int)size).describedAs("Size doesn't return expected value", new Object[0])).isEqualTo(0);
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)pr.isEmpty()).describedAs("isEmpty doesn't return proper state of the region", new Object[0])).isTrue();
            }
        });
        vm0.invoke(new CacheSerializableRunnable("destroyRegionOp"){

            @Override
            public void run2() {
                InternalCache cache = MultiVMRegionTestCase.this.getCache();
                Region pr = cache.getRegion(rName);
                ((MapAssert)Assertions.assertThat((Map)pr).describedAs("Region already destroyed.", new Object[0])).isNotNull();
                pr.destroyRegion();
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)pr.isDestroyed()).describedAs("Region isDestroyed false", new Object[0])).isTrue();
                ((MapAssert)Assertions.assertThat((Map)cache.getRegion(rName)).describedAs("Region not destroyed.", new Object[0])).isNull();
            }
        });
    }

    @Test
    public void testDistributedUpdate() {
        boolean condition = this.getRegionAttributes().getScope().isDistributed();
        Assertions.assertThat((boolean)condition).isTrue();
        final String name = this.getUniqueName();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        final String key = "KEY";
        final String oldValue = "OLD_VALUE";
        final String newValue = "NEW_VALUE";
        CacheSerializableRunnable put = new CacheSerializableRunnable("Put key/value"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, oldValue);
                MultiVMRegionTestCase.this.flushIfNecessary(region);
            }
        };
        vm0.invoke(put);
        vm1.invoke(put);
        vm0.invoke(new CacheSerializableRunnable("Update"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, newValue);
                MultiVMRegionTestCase.this.flushIfNecessary(region);
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Validate update"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Region.Entry entry = region.getEntry(key);
                Assertions.assertThat((Object)entry).isNotNull();
                Assertions.assertThat((Object)entry.getValue()).isEqualTo(newValue);
            }
        });
    }

    @Test
    public void testOrderedUpdates() throws Exception {
        Assumptions.assumeThat((Object)this.getRegionAttributes().getScope()).isNotEqualTo((Object)Scope.DISTRIBUTED_NO_ACK);
        String regionName = this.getUniqueName();
        String key = "KEY";
        int lastValue = 10;
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        vm0.invoke("Create region", () -> this.createRegion(regionName));
        vm1.invoke("Create region and region entry", () -> {
            Region region = this.createRegion(regionName);
            region.create((Object)"KEY", null);
        });
        vm1.invoke("Set listener", () -> {
            Region region = this.getRootRegion().getSubregion(regionName);
            region.setUserAttribute(new LinkedBlockingQueue());
            region.getAttributesMutator().addCacheListener((CacheListener)new CacheListenerAdapter<String, Integer>(){

                public void afterUpdate(EntryEvent<String, Integer> event) {
                    Region region = event.getRegion();
                    BlockingQueue queue = (BlockingQueue)region.getUserAttribute();
                    int value = (Integer)event.getNewValue();
                    try {
                        queue.put(value);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            this.flushIfNecessary(region);
        });
        AsyncInvocation verify = vm1.invokeAsync("Verify", () -> {
            Region region = this.getRootRegion().getSubregion(regionName);
            BlockingQueue queue = (BlockingQueue)region.getUserAttribute();
            for (int i = 0; i <= 10; ++i) {
                try {
                    int value = (Integer)queue.take();
                    Assertions.assertThat((int)value).isEqualTo(i);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        AsyncInvocation populate = vm0.invokeAsync("Populate", () -> {
            Region region = this.getRootRegion().getSubregion(regionName);
            for (int i = 0; i <= 10; ++i) {
                region.put((Object)"KEY", (Object)i);
            }
        });
        populate.await();
        verify.await();
    }

    @Test
    public void testDistributedGet() {
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String value = "VALUE";
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        vm0.invoke(new CacheSerializableRunnable("Populate region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                region.put(key, value);
            }
        });
        CacheSerializableRunnable get = new CacheSerializableRunnable("Distributed get"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                Assertions.assertThat((Object)region.get(key)).isEqualTo(value);
            }
        };
        vm1.invoke(get);
    }

    @Test
    public void testDistributedPutNoUpdate() throws Exception {
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        final String name = this.getUniqueName();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        Thread.sleep(250L);
        final String key = "KEY";
        final String value = "VALUE";
        vm0.invoke(new CacheSerializableRunnable("Put key/value"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, value);
            }
        });
        Thread.sleep(250L);
        vm1.invoke(new CacheSerializableRunnable("Verify no update"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Region.Entry entry = region.getEntry(key);
                if (MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy().withReplication() || MultiVMRegionTestCase.this.getRegionAttributes().getPartitionAttributes() != null) {
                    Assertions.assertThat((Object)region.get(key)).isEqualTo(value);
                } else {
                    Assertions.assertThat((Object)entry).isNull();
                }
            }
        });
    }

    @Test
    public void testDefinedEntryUpdated() {
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String oldValue = "OLD_VALUE";
        final String newValue = "NEW_VALUE";
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        vm0.invoke(create);
        vm1.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Create and populate"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, oldValue);
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Define entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                if (!MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy().withReplication()) {
                    region.create(key, null);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Update entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, newValue);
            }
        });
        vm1.invoke(this.repeatingIfNecessary(new CacheSerializableRunnable("Get entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Assertions.assertThat((Object)region.get(key)).isEqualTo(newValue);
            }
        }));
    }

    @Test
    public void testDistributedDestroy() {
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        final String name = this.getUniqueName();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                Assertions.assertThat((boolean)region.isDestroyed()).isFalse();
                Region root = region.getParentRegion();
                Assertions.assertThat((boolean)root.isDestroyed()).isFalse();
            }
        };
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        VM vm2 = VM.getVM(2);
        vm0.invoke(create);
        vm1.invoke(create);
        vm2.invoke(create);
        final String key = "KEY";
        final String value = "VALUE";
        CacheSerializableRunnable put = new CacheSerializableRunnable("Put key/value"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, value);
                Assertions.assertThat((boolean)region.isDestroyed()).isFalse();
                Assertions.assertThat((boolean)region.getParentRegion().isDestroyed()).isFalse();
                MultiVMRegionTestCase.this.flushIfNecessary(region);
            }
        };
        vm0.invoke(put);
        vm1.invoke(put);
        vm2.invoke(put);
        CacheSerializableRunnable verifyPut = new CacheSerializableRunnable("Verify Put"){

            @Override
            public void run2() throws CacheException {
                Region root = MultiVMRegionTestCase.this.getRootRegion();
                Assertions.assertThat((boolean)root.isDestroyed()).isFalse();
                Region region = root.getSubregion(name);
                Assertions.assertThat((boolean)region.isDestroyed()).isFalse();
                Assertions.assertThat((Object)region.getEntry(key).getValue()).isEqualTo(value);
            }
        };
        vm0.invoke(verifyPut);
        vm1.invoke(verifyPut);
        vm2.invoke(verifyPut);
        vm0.invoke(new CacheSerializableRunnable("Destroy Entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.destroy(key);
                MultiVMRegionTestCase.this.flushIfNecessary(region);
            }
        });
        CacheSerializableRunnable verifyDestroy = new CacheSerializableRunnable("Verify entry destruction"){

            @Override
            public void run2() throws CacheException {
                Region root = MultiVMRegionTestCase.this.getRootRegion();
                Assertions.assertThat((boolean)root.isDestroyed()).isFalse();
                Region region = root.getSubregion(name);
                Assertions.assertThat((boolean)region.isDestroyed()).isFalse();
                Assertions.assertThat((Object)region.getEntry(key)).isNull();
            }
        };
        vm0.invoke(verifyDestroy);
        vm1.invoke(verifyDestroy);
        vm2.invoke(verifyDestroy);
    }

    @Test
    public void testDistributedRegionDestroy() {
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        final String name = this.getUniqueName();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        Invoke.invokeInEveryVM(create);
        VM vm0 = VM.getVM(0);
        vm0.invoke(new CacheSerializableRunnable("Destroy Region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.destroyRegion();
                MultiVMRegionTestCase.this.flushIfNecessary(region);
            }
        });
        Invoke.invokeInEveryVM(new CacheSerializableRunnable("Verify region destruction"){

            @Override
            public void run2() throws CacheException {
                Awaitility.waitAtMost((long)1L, (TimeUnit)TimeUnit.MINUTES).pollInterval(10L, TimeUnit.MILLISECONDS).until(() -> MultiVMRegionTestCase.this.getRootRegion().getSubregion(name) == null);
            }
        });
    }

    @Test
    public void testLocalDestroy() throws Exception {
        Assumptions.assumeThat((boolean)this.supportsLocalDestroyAndLocalInvalidate()).isTrue();
        if (this.getRegionAttributes().getDataPolicy().withPersistence()) {
            return;
        }
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        final String name = this.getUniqueName();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        Thread.sleep(250L);
        final String key = "KEY";
        final String value = "VALUE";
        CacheSerializableRunnable put = new CacheSerializableRunnable("Put key/value"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, value);
            }
        };
        vm0.invoke(put);
        vm1.invoke(put);
        Thread.sleep(250L);
        vm0.invoke(new CacheSerializableRunnable("Local Destroy Entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.localDestroy(key);
            }
        });
        Thread.sleep(250L);
        CacheSerializableRunnable verify = new CacheSerializableRunnable("Verify entry existence"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Assertions.assertThat((Object)region.getEntry(key)).isNotNull();
            }
        };
        vm1.invoke(verify);
    }

    @Test
    public void testLocalRegionDestroy() throws Exception {
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        final String name = this.getUniqueName();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        Thread.sleep(250L);
        vm0.invoke(new CacheSerializableRunnable("Local Destroy Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.getRootRegion().getSubregion(name).localDestroyRegion();
            }
        });
        Thread.sleep(250L);
        CacheSerializableRunnable verify = new CacheSerializableRunnable("Verify region existence"){

            @Override
            public void run2() throws CacheException {
                Assertions.assertThat((Map)MultiVMRegionTestCase.this.getRootRegion().getSubregion(name)).isNotNull();
            }
        };
        vm1.invoke(verify);
    }

    @Test
    public void testDistributedInvalidate() {
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        final String name = this.getUniqueName();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        VM vm2 = VM.getVM(2);
        vm0.invoke(create);
        vm1.invoke(create);
        vm2.invoke(create);
        final String key = "KEY";
        final String value = "VALUE";
        CacheSerializableRunnable put = new CacheSerializableRunnable("Put key/value"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, value);
                MultiVMRegionTestCase.this.flushIfNecessary(region);
            }
        };
        vm0.invoke(put);
        vm1.invoke(put);
        vm2.invoke(put);
        vm0.invoke(new CacheSerializableRunnable("Invalidate Entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.invalidate(key);
                MultiVMRegionTestCase.this.flushIfNecessary(region);
            }
        });
        CacheSerializableRunnable verify = new CacheSerializableRunnable("Verify entry invalidation"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Region.Entry entry = region.getEntry(key);
                Assertions.assertThat((Object)entry).isNotNull();
                if (entry.getValue() != null) {
                    logger.debug("invalidated entry has value of " + entry.getValue());
                }
                Assertions.assertThat((Object)entry.getValue()).isNull();
            }
        };
        vm1.invoke(verify);
        vm2.invoke(verify);
    }

    @Test
    public void testDistributedInvalidate4() {
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String value = "VALUE";
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        int vmCount = VM.getVMCount();
        for (int i = 0; i < vmCount; ++i) {
            VM vm0 = VM.getVM(i);
            vm0.invoke(create);
        }
        CacheSerializableRunnable put = new CacheSerializableRunnable("put entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, value);
                MultiVMRegionTestCase.this.flushIfNecessary(region);
            }
        };
        for (int i = 0; i < vmCount; ++i) {
            VM vm = VM.getVM(i);
            vm.invoke(put);
        }
        CacheSerializableRunnable invalidate = new CacheSerializableRunnable("Invalidate Entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.invalidate(key);
                MultiVMRegionTestCase.this.flushIfNecessary(region);
            }
        };
        for (int i = 0; i < vmCount; ++i) {
            VM vm = VM.getVM(i);
            vm.invoke(invalidate);
        }
        CacheSerializableRunnable verify = new CacheSerializableRunnable("Verify entry invalidation"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Region.Entry entry = region.getEntry(key);
                Assertions.assertThat((Object)entry).isNotNull();
                Assertions.assertThat((Object)entry.getValue()).isNull();
            }
        };
        for (int i = 0; i < vmCount; ++i) {
            VM vm0 = VM.getVM(i);
            vm0.invoke(verify);
        }
    }

    @Test
    public void testDistributedRegionInvalidate() {
        Assumptions.assumeThat((boolean)this.supportsSubregions()).isTrue();
        final String name = this.getUniqueName();
        String subname = "sub";
        final boolean useSubs = this.getRegionAttributes().getPartitionAttributes() == null;
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                if (useSubs) {
                    region.createSubregion("sub", region.getAttributes());
                }
            }
        };
        Invoke.invokeInEveryVM(create);
        final String key = "KEY";
        final String value = "VALUE";
        final String key2 = "KEY2";
        final String value2 = "VALUE2";
        CacheSerializableRunnable put = new CacheSerializableRunnable("Put key/value"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, value);
                region.put(key2, value2);
                MultiVMRegionTestCase.this.flushIfNecessary(region);
                if (useSubs) {
                    Region subregion = region.getSubregion("sub");
                    subregion.put(key, value);
                    subregion.put(key2, value2);
                    MultiVMRegionTestCase.this.flushIfNecessary(subregion);
                }
            }
        };
        Invoke.invokeInEveryVM(put);
        VM vm0 = VM.getVM(0);
        vm0.invoke(new CacheSerializableRunnable("Invalidate Region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.invalidateRegion();
            }
        });
        CacheSerializableRunnable verify = new CacheSerializableRunnable("Verify region invalidation"){

            @Override
            public void run2() {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Region.Entry entry = region.getEntry(key);
                Assertions.assertThat((Object)entry).isNotNull();
                Object v = entry.getValue();
                Assertions.assertThat((Object)v).isNull();
                entry = region.getEntry(key2);
                Assertions.assertThat((Object)entry).isNotNull();
                Assertions.assertThat((Object)entry.getValue()).isNull();
                if (useSubs) {
                    Region subregion = region.getSubregion("sub");
                    entry = subregion.getEntry(key);
                    Assertions.assertThat((Object)entry).isNotNull();
                    Assertions.assertThat((Object)entry.getValue()).isNull();
                    entry = subregion.getEntry(key2);
                    Assertions.assertThat((Object)entry).isNotNull();
                    Assertions.assertThat((Object)entry.getValue()).isNull();
                }
            }
        };
        Invoke.invokeInEveryVM(this.repeatingIfNecessary(verify));
    }

    @Test
    public void testRemoteCacheListener() {
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String oldValue = "OLD_VALUE";
        final String newValue = "NEW_VALUE";
        CacheSerializableRunnable populate = new CacheSerializableRunnable("Create Region and Put"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                region.put(key, oldValue);
            }
        };
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        vm0.invoke(populate);
        vm1.invoke(populate);
        vm1.invoke(new CacheSerializableRunnable("Set listener"){

            @Override
            public void run2() throws CacheException {
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                MultiVMRegionTestCase.setListener(new TestCacheListener<Object, Object>(){

                    @Override
                    public void afterUpdate2(EntryEvent<Object, Object> event) {
                        Assertions.assertThat((Object)event.getOperation()).isEqualTo((Object)Operation.UPDATE);
                        Assertions.assertThat((Map)event.getRegion()).isEqualTo((Object)region);
                        Assertions.assertThat((boolean)event.getOperation().isDistributed()).isTrue();
                        Assertions.assertThat((boolean)event.getOperation().isExpiration()).isFalse();
                        Assertions.assertThat((boolean)event.isOriginRemote()).isTrue();
                        Assertions.assertThat((Comparable)event.getDistributedMember()).isEqualTo(event.getCallbackArgument());
                        Assertions.assertThat((Object)event.getKey()).isEqualTo(key);
                        Assertions.assertThat((Object)event.getOldValue()).isEqualTo(oldValue);
                        Assertions.assertThat((Object)event.getNewValue()).isEqualTo(newValue);
                        Assertions.assertThat((boolean)event.getOperation().isLoad()).isFalse();
                        Assertions.assertThat((boolean)event.getOperation().isLocalLoad()).isFalse();
                        Assertions.assertThat((boolean)event.getOperation().isNetLoad()).isFalse();
                        Assertions.assertThat((boolean)event.getOperation().isNetSearch()).isFalse();
                        if (event.getRegion().getAttributes().getOffHeap()) {
                            Assertions.assertThat((Object)event.getSerializedOldValue().getDeserializedValue()).isEqualTo(oldValue);
                        } else {
                            Assertions.assertThat((Object)event.getSerializedOldValue()).isNull();
                        }
                        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(event.getSerializedNewValue().getSerializedValue()));
                        try {
                            Assertions.assertThat((Object)DataSerializer.readObject((DataInput)dis)).isEqualTo(newValue);
                        }
                        catch (Exception e) {
                            Assertions.fail((String)"Unexpected Exception", (Throwable)e);
                        }
                    }
                });
                region.getAttributesMutator().addCacheListener((CacheListener)MultiVMRegionTestCase.listener());
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Update"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, newValue, (Object)MultiVMRegionTestCase.this.getSystem().getDistributedMember());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Verify Update"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.listener().waitForInvocation(3000, 10L);
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                MultiVMRegionTestCase.setListener(new TestCacheListener<Object, Object>(){

                    @Override
                    public void afterInvalidate2(EntryEvent<Object, Object> event) {
                        Assertions.assertThat((Object)event.getOperation()).isEqualTo((Object)Operation.INVALIDATE);
                        Assertions.assertThat((Map)event.getRegion()).isEqualTo((Object)region);
                        Assertions.assertThat((boolean)event.getOperation().isDistributed()).isTrue();
                        Assertions.assertThat((boolean)event.getOperation().isExpiration()).isFalse();
                        Assertions.assertThat((boolean)event.isOriginRemote()).isTrue();
                        Assertions.assertThat((Comparable)event.getDistributedMember()).isEqualTo(event.getCallbackArgument());
                        Assertions.assertThat((Object)event.getKey()).isEqualTo(key);
                        Assertions.assertThat((Object)event.getOldValue()).isEqualTo(newValue);
                        Assertions.assertThat((Object)event.getNewValue()).isNull();
                        Assertions.assertThat((boolean)event.getOperation().isLoad()).isFalse();
                        Assertions.assertThat((boolean)event.getOperation().isLocalLoad()).isFalse();
                        Assertions.assertThat((boolean)event.getOperation().isNetLoad()).isFalse();
                        Assertions.assertThat((boolean)event.getOperation().isNetSearch()).isFalse();
                        Assertions.assertThat((Object)event.getSerializedNewValue()).isNull();
                        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(event.getSerializedOldValue().getSerializedValue()));
                        try {
                            Assertions.assertThat((Object)DataSerializer.readObject((DataInput)dis)).isEqualTo(newValue);
                        }
                        catch (Exception e) {
                            Assertions.fail((String)"Unexpected Exception", (Throwable)e);
                        }
                    }
                });
                region.getAttributesMutator().addCacheListener((CacheListener)MultiVMRegionTestCase.listener());
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Invalidate"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.invalidate(key, (Object)MultiVMRegionTestCase.this.getSystem().getDistributedMember());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Verify Invalidate"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.listener().waitForInvocation(3000, 10L);
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                MultiVMRegionTestCase.setListener(new TestCacheListener<Object, Object>(){

                    @Override
                    public void afterDestroy2(EntryEvent<Object, Object> event) {
                        Assertions.assertThat((boolean)event.getOperation().isDestroy()).isTrue();
                        Assertions.assertThat((Map)event.getRegion()).isEqualTo((Object)region);
                        Assertions.assertThat((boolean)event.getOperation().isDistributed()).isTrue();
                        Assertions.assertThat((boolean)event.getOperation().isExpiration()).isFalse();
                        Assertions.assertThat((boolean)event.isOriginRemote()).isTrue();
                        Assertions.assertThat((Comparable)event.getDistributedMember()).isEqualTo(event.getCallbackArgument());
                        Assertions.assertThat((Object)event.getKey()).isEqualTo(key);
                        Assertions.assertThat((Object)event.getOldValue()).isNull();
                        Assertions.assertThat((Object)event.getNewValue()).isNull();
                        Assertions.assertThat((boolean)event.getOperation().isLoad()).isFalse();
                        Assertions.assertThat((boolean)event.getOperation().isLocalLoad()).isFalse();
                        Assertions.assertThat((boolean)event.getOperation().isNetLoad()).isFalse();
                        Assertions.assertThat((boolean)event.getOperation().isNetSearch()).isFalse();
                        Assertions.assertThat((Object)event.getSerializedOldValue()).isNull();
                        Assertions.assertThat((Object)event.getSerializedNewValue()).isNull();
                    }
                });
                region.getAttributesMutator().addCacheListener((CacheListener)MultiVMRegionTestCase.listener());
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Destroy"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.destroy(key, (Object)MultiVMRegionTestCase.this.getSystem().getDistributedMember());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Verify Destroy"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.listener().waitForInvocation(3000, 10L);
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                MultiVMRegionTestCase.setListener(new TestCacheListener<Object, Object>(){

                    @Override
                    public void afterRegionInvalidate2(RegionEvent<Object, Object> event) {
                        Assertions.assertThat((Object)event.getOperation()).isEqualTo((Object)Operation.REGION_INVALIDATE);
                        Assertions.assertThat((Map)event.getRegion()).isEqualTo((Object)region);
                        Assertions.assertThat((boolean)event.getOperation().isDistributed()).isTrue();
                        Assertions.assertThat((boolean)event.getOperation().isExpiration()).isFalse();
                        Assertions.assertThat((boolean)event.isOriginRemote()).isTrue();
                        Assertions.assertThat((Comparable)event.getDistributedMember()).isEqualTo(event.getCallbackArgument());
                    }
                });
                region.getAttributesMutator().addCacheListener((CacheListener)MultiVMRegionTestCase.listener());
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Invalidate Region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.invalidateRegion((Object)MultiVMRegionTestCase.this.getSystem().getDistributedMember());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Verify Invalidate Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.listener().waitForInvocation(3000, 10L);
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                MultiVMRegionTestCase.setListener(new TestCacheListener<Object, Object>(){

                    @Override
                    public void afterRegionDestroy2(RegionEvent<Object, Object> event) {
                        Assertions.assertThat((Object)event.getOperation()).isEqualTo((Object)Operation.REGION_DESTROY);
                        Assertions.assertThat((Map)event.getRegion()).isEqualTo((Object)region);
                        Assertions.assertThat((boolean)event.getOperation().isDistributed()).isTrue();
                        Assertions.assertThat((boolean)event.getOperation().isExpiration()).isFalse();
                        Assertions.assertThat((boolean)event.isOriginRemote()).isTrue();
                        Assertions.assertThat((Comparable)event.getDistributedMember()).isEqualTo(event.getCallbackArgument());
                    }
                });
                region.getAttributesMutator().addCacheListener((CacheListener)MultiVMRegionTestCase.listener());
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Destroy Region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.destroyRegion((Object)MultiVMRegionTestCase.this.getSystem().getDistributedMember());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Verify Destroy Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.listener().waitForInvocation(3000, 10L);
            }
        });
    }

    @Test
    public void testRemoteCacheListenerInSubregion() {
        Assumptions.assumeThat((boolean)this.supportsSubregions()).isTrue();
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        final String name = this.getUniqueName();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        vm0.invoke(new CacheSerializableRunnable("Create Root"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRootRegion();
            }
        });
        vm1.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Set listener"){

            @Override
            public void run2() throws CacheException {
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                MultiVMRegionTestCase.setListener(new TestCacheListener<Object, Object>(){

                    @Override
                    public void afterRegionInvalidate2(RegionEvent<Object, Object> event) {
                        Assertions.assertThat((Object)event.getOperation()).isEqualTo((Object)Operation.REGION_INVALIDATE);
                        Assertions.assertThat((Map)event.getRegion()).isEqualTo((Object)region);
                        Assertions.assertThat((boolean)event.getOperation().isDistributed()).isTrue();
                        Assertions.assertThat((boolean)event.getOperation().isExpiration()).isFalse();
                        Assertions.assertThat((boolean)event.isOriginRemote()).isTrue();
                        Assertions.assertThat((Comparable)event.getDistributedMember()).isEqualTo(event.getCallbackArgument());
                    }
                });
                region.getAttributesMutator().addCacheListener((CacheListener)MultiVMRegionTestCase.listener());
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Invalidate Root Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.getRootRegion().invalidateRegion((Object)MultiVMRegionTestCase.this.getSystem().getDistributedMember());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Verify Invalidate Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.listener().waitForInvocation(3000, 10L);
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                MultiVMRegionTestCase.setListener(new TestCacheListener<Object, Object>(){

                    @Override
                    public void afterRegionDestroy2(RegionEvent<Object, Object> event) {
                        Assertions.assertThat((Object)event.getOperation()).isEqualTo((Object)Operation.REGION_DESTROY);
                        Assertions.assertThat((Map)event.getRegion()).isEqualTo((Object)region);
                        Assertions.assertThat((boolean)event.getOperation().isDistributed()).isTrue();
                        Assertions.assertThat((boolean)event.getOperation().isExpiration()).isFalse();
                        Assertions.assertThat((boolean)event.isOriginRemote()).isTrue();
                        Assertions.assertThat((Comparable)event.getDistributedMember()).isEqualTo(event.getCallbackArgument());
                    }
                });
                region.getAttributesMutator().addCacheListener((CacheListener)MultiVMRegionTestCase.listener());
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Destroy Root Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.getRootRegion().destroyRegion((Object)MultiVMRegionTestCase.this.getSystem().getDistributedMember());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Verify Destroy Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.listener().waitForInvocation(3000, 10L);
            }
        });
    }

    protected boolean supportsNetLoad() {
        return true;
    }

    @Test
    public void testRemoteCacheLoader() {
        Assumptions.assumeThat((boolean)this.supportsNetLoad()).isTrue();
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String value = "VALUE";
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Set CacheLoader"){

            @Override
            public void run2() throws CacheException {
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                MultiVMRegionTestCase.setLoader(new TestCacheLoader<Object, Object>(){

                    @Override
                    public Object load2(LoaderHelper<Object, Object> helper) throws CacheLoaderException {
                        Assertions.assertThat((Map)helper.getRegion()).isEqualTo((Object)region);
                        Assertions.assertThat((Object)helper.getKey()).isEqualTo(key);
                        Assertions.assertThat((Object)helper.getArgument()).isNull();
                        return value;
                    }
                });
                region.getAttributesMutator().setCacheLoader(MultiVMRegionTestCase.loader());
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Remote load"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Assertions.assertThat((Object)region.get(key)).isEqualTo(value);
            }
        });
        vm1.invoke(new SerializableRunnable("Verify loader"){

            @Override
            public void run() {
                Assertions.assertThat((boolean)MultiVMRegionTestCase.loader().wasInvoked()).isTrue();
            }
        });
    }

    @Test
    public void testRemoteCacheLoaderArg() {
        Assumptions.assumeThat((boolean)this.supportsNetLoad()).isTrue();
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String value = "VALUE";
        String arg = "ARG";
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Set CacheLoader"){

            @Override
            public void run2() throws CacheException {
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                MultiVMRegionTestCase.setLoader(new TestCacheLoader<Object, Object>(){

                    @Override
                    public Object load2(LoaderHelper<Object, Object> helper) throws CacheLoaderException {
                        Assertions.assertThat((Map)helper.getRegion()).isEqualTo((Object)region);
                        Assertions.assertThat((Object)helper.getKey()).isEqualTo(key);
                        Assertions.assertThat((Object)helper.getArgument()).isEqualTo((Object)"ARG");
                        return value;
                    }
                });
                region.getAttributesMutator().setCacheLoader(MultiVMRegionTestCase.loader());
                MultiVMRegionTestCase.this.flushIfNecessary(region);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Remote load"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                try {
                    region.get(key, new Object(){});
                    Assertions.fail((String)"Should have thrown an IllegalArgumentException");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                Assertions.assertThat((Object)region.getEntry(key)).isNull();
                try {
                    Assertions.assertThat((Object)region.get(key, (Object)"ARG")).isEqualTo(value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify loader"){

            @Override
            public void run() {
                Assertions.assertThat((boolean)MultiVMRegionTestCase.loader().wasInvoked()).isTrue();
            }
        });
    }

    @Test
    public void testRemoteCacheLoaderException() {
        Assumptions.assumeThat((boolean)this.supportsNetLoad()).isTrue();
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        final String name = this.getUniqueName();
        final String key = "KEY";
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Set CacheLoader"){

            @Override
            public void run2() throws CacheException {
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                MultiVMRegionTestCase.setLoader(new TestCacheLoader<Object, Object>(){

                    @Override
                    public Object load2(LoaderHelper<Object, Object> helper) throws CacheLoaderException {
                        Assertions.assertThat((Map)helper.getRegion()).isEqualTo((Object)region);
                        Assertions.assertThat((Object)helper.getKey()).isEqualTo(key);
                        Assertions.assertThat((Object)helper.getArgument()).isNull();
                        String s = "Test Exception";
                        throw new CacheLoaderException(s);
                    }
                });
                region.getAttributesMutator().setCacheLoader(MultiVMRegionTestCase.loader());
                MultiVMRegionTestCase.this.flushIfNecessary(region);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Remote load"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                try {
                    region.get(key);
                    Assertions.fail((String)"Should have thrown a CacheLoaderException");
                }
                catch (CacheLoaderException cacheLoaderException) {
                    // empty catch block
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify loader"){

            @Override
            public void run() {
                Assertions.assertThat((boolean)MultiVMRegionTestCase.loader().wasInvoked()).isTrue();
            }
        });
    }

    @Test
    public void testCacheLoaderWithNetSearch() {
        Assumptions.assumeThat((boolean)this.supportsNetLoad()).isTrue();
        Assumptions.assumeThat((boolean)this.getRegionAttributes().getDataPolicy().withReplication()).isFalse();
        Assumptions.assumeThat((boolean)this.getRegionAttributes().getDataPolicy().withPreloaded()).isFalse();
        final String name = this.getUniqueName();
        final String key = this.getUniqueName();
        final Integer value = 42;
        VM vm1 = VM.getVM(1);
        vm1.invoke(new CacheSerializableRunnable("set remote value"){

            @Override
            public void run2() throws CacheException {
                Region rgn = MultiVMRegionTestCase.this.createRegion(name);
                rgn.put(key, value);
                MultiVMRegionTestCase.this.flushIfNecessary(rgn);
            }
        });
        TestCacheLoader<Object, Object> loader1 = new TestCacheLoader<Object, Object>(){

            @Override
            public Object load2(LoaderHelper<Object, Object> helper) throws CacheLoaderException {
                Assertions.assertThat((Object)helper.getKey()).isEqualTo(key);
                Assertions.assertThat((String)helper.getRegion().getName()).isEqualTo((Object)name);
                try {
                    helper.getRegion().getAttributes();
                    Object result = helper.netSearch(false);
                    Assertions.assertThat((Object)result).isEqualTo(value);
                    return result;
                }
                catch (TimeoutException ex) {
                    Assertions.fail((String)"Why did I time out?", (Throwable)ex);
                    return null;
                }
            }
        };
        AttributesFactory f = new AttributesFactory(this.getRegionAttributes());
        f.setCacheLoader((CacheLoader)loader1);
        Region region = this.createRegion(name, f.create());
        loader1.wasInvoked();
        Region.Entry entry = region.getEntry((Object)key);
        Assertions.assertThat((Object)entry).isNull();
        region.create((Object)key, null);
        entry = region.getEntry((Object)key);
        Assertions.assertThat((Object)entry).isNotNull();
        Assertions.assertThat((Object)entry.getValue()).isNull();
        vm1.invoke(new CacheSerializableRunnable("verify remote value"){

            @Override
            public void run2() throws CacheException {
                Region rgn = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Assertions.assertThat((Object)rgn.getEntry(key).getValue()).isEqualTo(value);
            }
        });
        Assertions.assertThat((Object)region.get((Object)key)).isEqualTo((Object)value);
        if (region.getAttributes().getScope().isGlobal()) {
            Assertions.assertThat((boolean)loader1.wasInvoked()).isFalse();
        } else {
            Assertions.assertThat((boolean)loader1.wasInvoked()).isTrue();
        }
        Assertions.assertThat((Object)region.getEntry((Object)key).getValue()).isEqualTo((Object)value);
    }

    @Test
    public void testCacheLoaderWithNetLoad() {
        Assumptions.assumeThat((boolean)this.getRegionAttributes().getDataPolicy().withReplication()).isFalse();
        Assumptions.assumeThat((boolean)this.getRegionAttributes().getDataPolicy().withPreloaded()).isFalse();
        ((ProxyableObjectAssert)Assumptions.assumeThat((Object)this.getRegionAttributes().getPartitionAttributes()).withFailMessage("the region has partition attributes", new Object[0])).isNull();
        final String name = this.getUniqueName();
        final String key = this.getUniqueName();
        final Integer value = 42;
        VM vm1 = VM.getVM(1);
        vm1.invoke(new CacheSerializableRunnable("set up remote loader"){

            @Override
            public void run2() throws CacheException {
                TestCacheLoader<Object, Object> remoteloader = new TestCacheLoader<Object, Object>(){

                    @Override
                    public Object load2(LoaderHelper<Object, Object> helper) throws CacheLoaderException {
                        Assertions.assertThat((Object)helper.getKey()).isEqualTo(key);
                        Assertions.assertThat((String)helper.getRegion().getName()).isEqualTo((Object)name);
                        return value;
                    }
                };
                AttributesFactory factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                factory.setCacheLoader((CacheLoader)remoteloader);
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
            }
        });
        TestCacheLoader<Object, Object> loader1 = new TestCacheLoader<Object, Object>(){

            @Override
            public Object load2(LoaderHelper<Object, Object> helper) throws CacheLoaderException {
                Assertions.assertThat((Object)helper.getKey()).isEqualTo(key);
                Assertions.assertThat((String)helper.getRegion().getName()).isEqualTo((Object)name);
                try {
                    helper.getRegion().getAttributes();
                    Object result = helper.netSearch(true);
                    Assertions.assertThat((Object)result).isEqualTo(value);
                    return result;
                }
                catch (TimeoutException ex) {
                    Assertions.fail((String)"Why did I time out?", (Throwable)ex);
                    return null;
                }
            }
        };
        AttributesFactory f = new AttributesFactory(this.getRegionAttributes());
        f.setCacheLoader((CacheLoader)loader1);
        Region region = this.createRegion(name, f.create());
        loader1.wasInvoked();
        Region.Entry entry = region.getEntry((Object)key);
        Assertions.assertThat((Object)entry).isNull();
        region.create((Object)key, null);
        entry = region.getEntry((Object)key);
        Assertions.assertThat((Object)entry).isNotNull();
        Assertions.assertThat((Object)entry.getValue()).isNull();
        Assertions.assertThat((Object)region.get((Object)key)).isEqualTo((Object)value);
        Assertions.assertThat((boolean)loader1.wasInvoked()).isTrue();
        Assertions.assertThat((Object)region.getEntry((Object)key).getValue()).isEqualTo((Object)value);
    }

    @Test
    public void testNoRemoteCacheLoader() {
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        final String name = this.getUniqueName();
        final String key = "KEY";
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Remote load"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Assertions.assertThat((Object)region.get(key)).isNull();
            }
        });
    }

    @Test
    public void testNoLoaderWithInvalidEntry() {
        Assumptions.assumeThat((boolean)this.supportsNetLoad()).isTrue();
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String value = "VALUE";
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                MultiVMRegionTestCase.setLoader(new TestCacheLoader<Object, Object>(){

                    @Override
                    public Object load2(LoaderHelper<Object, Object> helper) throws CacheLoaderException {
                        return value;
                    }
                });
                region.getAttributesMutator().setCacheLoader(MultiVMRegionTestCase.loader());
            }
        };
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Create invalid entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.create(key, null);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Remote get"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Assertions.assertThat((Object)region.get(key)).isEqualTo(value);
                Assertions.assertThat((boolean)MultiVMRegionTestCase.loader().wasInvoked()).isTrue();
            }
        });
        vm1.invoke(new SerializableRunnable("Verify loader"){

            @Override
            public void run() {
                Assertions.assertThat((boolean)MultiVMRegionTestCase.loader().wasInvoked()).isFalse();
            }
        });
    }

    @Test
    public void testRemoteCacheWriter() {
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String oldValue = "OLD_VALUE";
        final String newValue = "NEW_VALUE";
        final String arg = "ARG";
        final String exception = "EXCEPTION";
        final String key2 = "KEY2";
        final String value2 = "VALUE2";
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                region.put(key2, value2);
                Assertions.assertThat((int)region.size()).isEqualTo(1);
                if (region.getAttributes().getOffHeap() && !(region instanceof PartitionedRegion)) {
                    GemFireCacheImpl gfc = (GemFireCacheImpl)MultiVMRegionTestCase.this.getCache();
                    MemoryAllocatorImpl ma = (MemoryAllocatorImpl)gfc.getOffHeapStore();
                    LocalRegion reRegion = (LocalRegion)region;
                    RegionEntry re = reRegion.getRegionEntry(key2);
                    StoredObject so = (StoredObject)re.getValue();
                    Assertions.assertThat((int)so.getRefCount()).isEqualTo(1);
                    Assertions.assertThat((int)ma.getStats().getObjects()).isEqualTo(1);
                }
            }
        };
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Set Writer"){

            @Override
            public void run2() throws CacheException {
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                MultiVMRegionTestCase.setWriter(new TestCacheWriter<Object, Object>(){

                    @Override
                    public void beforeCreate2(EntryEvent<Object, Object> event) throws CacheWriterException {
                        if (exception.equals(event.getCallbackArgument())) {
                            String s = "Test Exception";
                            throw new CacheWriterException(s);
                        }
                        Assertions.assertThat((Map)event.getRegion()).isEqualTo((Object)region);
                        Assertions.assertThat((boolean)event.getOperation().isCreate()).isTrue();
                        Assertions.assertThat((boolean)event.getOperation().isDistributed()).isTrue();
                        Assertions.assertThat((boolean)event.getOperation().isExpiration()).isFalse();
                        Assertions.assertThat((boolean)event.isOriginRemote()).isTrue();
                        Assertions.assertThat((Object)event.getKey()).isEqualTo(key);
                        Assertions.assertThat((Object)event.getOldValue()).isNull();
                        Assertions.assertThat((Object)event.getNewValue()).isEqualTo(oldValue);
                        Assertions.assertThat((boolean)event.getOperation().isLoad()).isFalse();
                        Assertions.assertThat((boolean)event.getOperation().isLocalLoad()).isFalse();
                        Assertions.assertThat((boolean)event.getOperation().isNetLoad()).isFalse();
                        Assertions.assertThat((boolean)event.getOperation().isNetSearch()).isFalse();
                    }
                });
                region.getAttributesMutator().setCacheWriter((CacheWriter)MultiVMRegionTestCase.writer());
                MultiVMRegionTestCase.this.flushIfNecessary(region);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create with Exception"){

            @Override
            public void run2() throws CacheException {
                block2: {
                    Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                    try {
                        region.put(key, oldValue, exception);
                        Assertions.fail((String)"Should have thrown a CacheWriterException");
                    }
                    catch (CacheWriterException ex) {
                        Assertions.assertThat((Object)region.getEntry(key)).isNull();
                        Assertions.assertThat((int)region.size()).isEqualTo(1);
                        if (!region.getAttributes().getOffHeap() || region instanceof PartitionedRegion) break block2;
                        GemFireCacheImpl gfc = (GemFireCacheImpl)MultiVMRegionTestCase.this.getCache();
                        MemoryAllocatorImpl ma = (MemoryAllocatorImpl)gfc.getOffHeapStore();
                        Assertions.assertThat((int)ma.getStats().getObjects()).isEqualTo(1);
                    }
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify callback"){

            @Override
            public void run() {
                Assertions.assertThat((boolean)MultiVMRegionTestCase.writer().wasInvoked()).isTrue();
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create with Argument"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, oldValue, arg);
                Assertions.assertThat((int)region.size()).isEqualTo(2);
                if (region.getAttributes().getOffHeap() && !(region instanceof PartitionedRegion)) {
                    GemFireCacheImpl gfc = (GemFireCacheImpl)MultiVMRegionTestCase.this.getCache();
                    MemoryAllocatorImpl ma = (MemoryAllocatorImpl)gfc.getOffHeapStore();
                    Assertions.assertThat((int)ma.getStats().getObjects()).isEqualTo(2);
                    LocalRegion reRegion = (LocalRegion)region;
                    StoredObject so = (StoredObject)reRegion.getRegionEntry(key).getValue();
                    Assertions.assertThat((int)so.getRefCount()).isEqualTo(1);
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify callback"){

            @Override
            public void run() {
                Assertions.assertThat((boolean)MultiVMRegionTestCase.writer().wasInvoked()).isTrue();
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Set Writer"){

            @Override
            public void run2() throws CacheException {
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                MultiVMRegionTestCase.setWriter(new TestCacheWriter<Object, Object>(){

                    @Override
                    public void beforeUpdate2(EntryEvent<Object, Object> event) throws CacheWriterException {
                        Object argument = event.getCallbackArgument();
                        if (exception.equals(argument)) {
                            String s = "Test Exception";
                            throw new CacheWriterException(s);
                        }
                        Assertions.assertThat((Object)argument).isEqualTo(arg);
                        Assertions.assertThat((Map)event.getRegion()).isEqualTo((Object)region);
                        Assertions.assertThat((boolean)event.getOperation().isUpdate()).isTrue();
                        Assertions.assertThat((boolean)event.getOperation().isDistributed()).isTrue();
                        Assertions.assertThat((boolean)event.getOperation().isExpiration()).isFalse();
                        Assertions.assertThat((boolean)event.isOriginRemote()).isTrue();
                        Assertions.assertThat((Object)event.getKey()).isEqualTo(key);
                        Assertions.assertThat((Object)event.getOldValue()).isEqualTo(oldValue);
                        Assertions.assertThat((Object)event.getNewValue()).isEqualTo(newValue);
                        Assertions.assertThat((boolean)event.getOperation().isLoad()).isFalse();
                        Assertions.assertThat((boolean)event.getOperation().isLocalLoad()).isFalse();
                        Assertions.assertThat((boolean)event.getOperation().isNetLoad()).isFalse();
                        Assertions.assertThat((boolean)event.getOperation().isNetSearch()).isFalse();
                    }
                });
                region.getAttributesMutator().setCacheWriter((CacheWriter)MultiVMRegionTestCase.writer());
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Update with Exception"){

            @Override
            public void run2() throws CacheException {
                block2: {
                    Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                    try {
                        region.put(key, newValue, exception);
                        Assertions.fail((String)"Should have thrown a CacheWriterException");
                    }
                    catch (CacheWriterException ex) {
                        Region.Entry entry = region.getEntry(key);
                        Assertions.assertThat((Object)entry.getValue()).isEqualTo(oldValue);
                        Assertions.assertThat((int)region.size()).isEqualTo(2);
                        if (!region.getAttributes().getOffHeap() || region instanceof PartitionedRegion) break block2;
                        GemFireCacheImpl gfc = (GemFireCacheImpl)MultiVMRegionTestCase.this.getCache();
                        MemoryAllocatorImpl ma = (MemoryAllocatorImpl)gfc.getOffHeapStore();
                        Assertions.assertThat((int)ma.getStats().getObjects()).isEqualTo(2);
                        LocalRegion reRegion = (LocalRegion)region;
                        StoredObject so = (StoredObject)reRegion.getRegionEntry(key).getValue();
                        Assertions.assertThat((int)so.getRefCount()).isEqualTo(1);
                    }
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify callback"){

            @Override
            public void run() {
                Assertions.assertThat((boolean)MultiVMRegionTestCase.writer().wasInvoked()).isTrue();
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Update with Argument"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, newValue, arg);
                Assertions.assertThat((int)region.size()).isEqualTo(2);
                if (region.getAttributes().getOffHeap() && !(region instanceof PartitionedRegion)) {
                    GemFireCacheImpl gfc = (GemFireCacheImpl)MultiVMRegionTestCase.this.getCache();
                    MemoryAllocatorImpl ma = (MemoryAllocatorImpl)gfc.getOffHeapStore();
                    Assertions.assertThat((int)ma.getStats().getObjects()).isEqualTo(2);
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify callback"){

            @Override
            public void run() {
                Assertions.assertThat((boolean)MultiVMRegionTestCase.writer().wasInvoked()).isTrue();
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Set Writer"){

            @Override
            public void run2() throws CacheException {
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                MultiVMRegionTestCase.setWriter(new TestCacheWriter<Object, Object>(){

                    @Override
                    public void beforeDestroy2(EntryEvent<Object, Object> event) throws CacheWriterException {
                        Object argument = event.getCallbackArgument();
                        if (exception.equals(argument)) {
                            String s = "Test Exception";
                            throw new CacheWriterException(s);
                        }
                        Assertions.assertThat((Object)argument).isEqualTo(arg);
                        Assertions.assertThat((Map)event.getRegion()).isEqualTo((Object)region);
                        Assertions.assertThat((boolean)event.getOperation().isDestroy()).isTrue();
                        Assertions.assertThat((boolean)event.getOperation().isDistributed()).isTrue();
                        Assertions.assertThat((boolean)event.getOperation().isExpiration()).isFalse();
                        Assertions.assertThat((boolean)event.isOriginRemote()).isTrue();
                        Assertions.assertThat((Object)event.getKey()).isEqualTo(key);
                        Assertions.assertThat((Object)event.getOldValue()).isEqualTo(newValue);
                        Assertions.assertThat((Object)event.getNewValue()).isNull();
                        Assertions.assertThat((boolean)event.getOperation().isLoad()).isFalse();
                        Assertions.assertThat((boolean)event.getOperation().isLocalLoad()).isFalse();
                        Assertions.assertThat((boolean)event.getOperation().isNetLoad()).isFalse();
                        Assertions.assertThat((boolean)event.getOperation().isNetSearch()).isFalse();
                    }
                });
                region.getAttributesMutator().setCacheWriter((CacheWriter)MultiVMRegionTestCase.writer());
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Destroy with Exception"){

            @Override
            public void run2() throws CacheException {
                block2: {
                    Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                    try {
                        region.destroy(key, exception);
                        Assertions.fail((String)"Should have thrown a CacheWriterException");
                    }
                    catch (CacheWriterException ex) {
                        Assertions.assertThat((Object)region.getEntry(key)).isNotNull();
                        Assertions.assertThat((int)region.size()).isEqualTo(2);
                        if (!region.getAttributes().getOffHeap() || region instanceof PartitionedRegion) break block2;
                        GemFireCacheImpl gfc = (GemFireCacheImpl)MultiVMRegionTestCase.this.getCache();
                        MemoryAllocatorImpl ma = (MemoryAllocatorImpl)gfc.getOffHeapStore();
                        Assertions.assertThat((int)ma.getStats().getObjects()).isEqualTo(2);
                    }
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify callback"){

            @Override
            public void run() {
                Assertions.assertThat((boolean)MultiVMRegionTestCase.writer().wasInvoked()).isTrue();
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Destroy with Argument"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.destroy(key, arg);
                Assertions.assertThat((int)region.size()).isEqualTo(1);
                if (region.getAttributes().getOffHeap() && !(region instanceof PartitionedRegion)) {
                    GemFireCacheImpl gfc = (GemFireCacheImpl)MultiVMRegionTestCase.this.getCache();
                    MemoryAllocatorImpl ma = (MemoryAllocatorImpl)gfc.getOffHeapStore();
                    Assertions.assertThat((int)ma.getStats().getObjects()).isEqualTo(1);
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify callback"){

            @Override
            public void run() {
                Assertions.assertThat((boolean)MultiVMRegionTestCase.writer().wasInvoked()).isTrue();
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Set Writer"){

            @Override
            public void run2() throws CacheException {
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                MultiVMRegionTestCase.setWriter(new TestCacheWriter<Object, Object>(){

                    @Override
                    public void beforeRegionDestroy2(RegionEvent<Object, Object> event) throws CacheWriterException {
                        Object argument = event.getCallbackArgument();
                        if (exception.equals(argument)) {
                            String s = "Test Exception";
                            throw new CacheWriterException(s);
                        }
                        Assertions.assertThat((Object)argument).isEqualTo(arg);
                        Assertions.assertThat((Map)event.getRegion()).isEqualTo((Object)region);
                        Assertions.assertThat((boolean)event.getOperation().isRegionDestroy()).isTrue();
                        Assertions.assertThat((boolean)event.getOperation().isDistributed()).isTrue();
                        Assertions.assertThat((boolean)event.getOperation().isExpiration()).isFalse();
                        Assertions.assertThat((boolean)event.isOriginRemote()).isTrue();
                    }
                });
                region.getAttributesMutator().setCacheWriter((CacheWriter)MultiVMRegionTestCase.writer());
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Destroy with Exception"){

            @Override
            public void run2() throws CacheException {
                block3: {
                    Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                    try {
                        region.destroyRegion(exception);
                        Assertions.fail((String)"Should have thrown a CacheWriterException");
                    }
                    catch (CacheWriterException ex) {
                        if (region.isDestroyed()) {
                            Assertions.fail((String)"should not have an exception if region is destroyed", (Throwable)ex);
                        }
                        Assertions.assertThat((int)region.size()).isEqualTo(1);
                        if (!region.getAttributes().getOffHeap() || region instanceof PartitionedRegion) break block3;
                        GemFireCacheImpl gfc = (GemFireCacheImpl)MultiVMRegionTestCase.this.getCache();
                        MemoryAllocatorImpl ma = (MemoryAllocatorImpl)gfc.getOffHeapStore();
                        Assertions.assertThat((int)ma.getStats().getObjects()).isEqualTo(1);
                    }
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify callback"){

            @Override
            public void run() {
                Assertions.assertThat((boolean)MultiVMRegionTestCase.writer().wasInvoked()).isTrue();
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Destroy with Argument"){

            @Override
            public void run2() throws CacheException {
                MemoryAllocatorImpl ma;
                GemFireCacheImpl gfc;
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Assertions.assertThat((int)region.size()).isEqualTo(1);
                if (region.getAttributes().getOffHeap() && !(region instanceof PartitionedRegion)) {
                    gfc = (GemFireCacheImpl)MultiVMRegionTestCase.this.getCache();
                    ma = (MemoryAllocatorImpl)gfc.getOffHeapStore();
                    Assertions.assertThat((int)ma.getStats().getObjects()).isEqualTo(1);
                }
                region.destroyRegion(arg);
                if (region.getAttributes().getOffHeap() && !(region instanceof PartitionedRegion)) {
                    gfc = (GemFireCacheImpl)MultiVMRegionTestCase.this.getCache();
                    ma = (MemoryAllocatorImpl)gfc.getOffHeapStore();
                    Awaitility.await((String)"waiting for off-heap object count go to zero").atMost(3L, TimeUnit.SECONDS).pollInterval(10L, TimeUnit.MILLISECONDS).until(() -> ma.getStats().getObjects(), Matchers.equalTo((Object)0));
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify callback"){

            @Override
            public void run() {
                Assertions.assertThat((boolean)MultiVMRegionTestCase.writer().wasInvoked()).isTrue();
            }
        });
    }

    @Test
    public void testLocalAndRemoteCacheWriters() {
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String oldValue = "OLD_VALUE";
        final String newValue = "NEW_VALUE";
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        vm0.invoke(new CacheSerializableRunnable("Create \"Local\" Region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                MultiVMRegionTestCase.setWriter(new TestCacheWriter<Object, Object>(){

                    @Override
                    public void beforeUpdate2(EntryEvent<Object, Object> event) throws CacheWriterException {
                    }

                    @Override
                    public void beforeCreate2(EntryEvent<Object, Object> event) throws CacheWriterException {
                    }

                    @Override
                    public void beforeDestroy2(EntryEvent<Object, Object> event) throws CacheWriterException {
                    }

                    @Override
                    public void beforeRegionDestroy2(RegionEvent<Object, Object> event) throws CacheWriterException {
                    }
                });
                region.getAttributesMutator().setCacheWriter((CacheWriter)MultiVMRegionTestCase.writer());
            }
        });
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create \"Local\" Region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                MultiVMRegionTestCase.setWriter(new TestCacheWriter<Object, Object>(){});
                region.getAttributesMutator().setCacheWriter((CacheWriter)MultiVMRegionTestCase.writer());
            }
        };
        vm1.invoke(create);
        SerializableRunnable verify = new SerializableRunnable("Verify no callback"){

            @Override
            public void run() {
                Assertions.assertThat((boolean)MultiVMRegionTestCase.writer().wasInvoked()).isFalse();
            }
        };
        vm0.invoke(new CacheSerializableRunnable("Create entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, oldValue);
                Assertions.assertThat((boolean)MultiVMRegionTestCase.writer().wasInvoked()).isTrue();
            }
        });
        vm1.invoke(verify);
        vm0.invoke(new CacheSerializableRunnable("Update entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, newValue);
                Assertions.assertThat((boolean)MultiVMRegionTestCase.writer().wasInvoked()).isTrue();
            }
        });
        vm1.invoke(verify);
        vm0.invoke(new CacheSerializableRunnable("Destroy entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.destroy(key);
                Assertions.assertThat((boolean)MultiVMRegionTestCase.writer().wasInvoked()).isTrue();
            }
        });
        vm1.invoke(verify);
        vm0.invoke(new CacheSerializableRunnable("Destroy region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.destroyRegion();
                Assertions.assertThat((boolean)MultiVMRegionTestCase.writer().wasInvoked()).isTrue();
            }
        });
        vm1.invoke(verify);
    }

    @Test
    public void testCacheLoaderModifyingArgument() {
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String value = "VALUE";
        final String one = "ONE";
        final String two = "TWO";
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        CacheSerializableRunnable setLoader = new CacheSerializableRunnable("Set CacheLoader"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                MultiVMRegionTestCase.setLoader(new TestCacheLoader<Object, Object>(){

                    @Override
                    public Object load2(LoaderHelper<Object, Object> helper) throws CacheLoaderException {
                        Object[] array = (Object[])helper.getArgument();
                        Assertions.assertThat((Object)array[0]).isEqualTo(one);
                        array[0] = two;
                        return value;
                    }
                });
                region.getAttributesMutator().setCacheLoader(MultiVMRegionTestCase.loader());
                MultiVMRegionTestCase.this.flushIfNecessary(region);
            }
        };
        vm0.invoke(setLoader);
        vm1.invoke(new CacheSerializableRunnable("Conditionally create second loader"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                if (region.getAttributes().getPartitionAttributes() != null) {
                    MultiVMRegionTestCase.setLoader(new TestCacheLoader<Object, Object>(){

                        @Override
                        public Object load2(LoaderHelper<Object, Object> helper) throws CacheLoaderException {
                            Object[] array = (Object[])helper.getArgument();
                            Assertions.assertThat((Object)array[0]).isEqualTo(one);
                            array[0] = two;
                            return value;
                        }
                    });
                    region.getAttributesMutator().setCacheLoader(MultiVMRegionTestCase.loader());
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Set CacheWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                MultiVMRegionTestCase.setWriter(new TestCacheWriter<Object, Object>(){

                    @Override
                    public void beforeCreate2(EntryEvent<Object, Object> event) throws CacheWriterException {
                        Object[] array = (Object[])event.getCallbackArgument();
                        Assertions.assertThat((Object)array[0]).isEqualTo(two);
                    }
                });
                region.getAttributesMutator().setCacheWriter((CacheWriter)MultiVMRegionTestCase.writer());
                MultiVMRegionTestCase.this.flushIfNecessary(region);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Object[] array = new Object[]{one};
                Object result = region.get(key, (Object)array);
                Assertions.assertThat((boolean)MultiVMRegionTestCase.loader().wasInvoked()).isTrue();
                Assertions.assertThat((Object)result).isEqualTo(value);
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Validate callback"){

            @Override
            public void run2() throws CacheException {
                Assertions.assertThat((boolean)MultiVMRegionTestCase.writer().wasInvoked()).isTrue();
            }
        });
    }

    @Test
    public void testRemoteLoaderNetSearch() {
        Assumptions.assumeThat((boolean)this.supportsNetLoad()).isTrue();
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String value = "VALUE";
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Get value"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                Assertions.assertThat((Object)region.get(key)).isEqualTo(value);
            }
        };
        vm0.invoke(new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                region.getAttributesMutator().setCacheLoader((CacheLoader)new TestCacheLoader<Object, Object>(){

                    @Override
                    public Object load2(LoaderHelper<Object, Object> helper) throws CacheLoaderException {
                        try {
                            Assertions.assertThat((Object)helper.netSearch(true)).isNull();
                        }
                        catch (TimeoutException ex) {
                            Assertions.fail((String)"Why did I time out?", (Throwable)ex);
                        }
                        return value;
                    }
                });
            }
        });
        vm1.invoke(create);
    }

    @Test
    public void testLocalCacheLoader() {
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String value = "VALUE";
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create \"remote\" region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                MultiVMRegionTestCase.setLoader(new TestCacheLoader<Object, Object>(){

                    @Override
                    public Object load2(LoaderHelper<Object, Object> helper) throws CacheLoaderException {
                        if (helper.getRegion().getAttributes().getPartitionAttributes() == null) {
                            Assertions.fail((String)"Should not be invoked");
                            return null;
                        }
                        return value;
                    }
                });
                region.getAttributesMutator().setCacheLoader(MultiVMRegionTestCase.loader());
            }
        };
        vm0.invoke(new CacheSerializableRunnable("Create \"local\" region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                region.getAttributesMutator().setCacheLoader((CacheLoader)new TestCacheLoader<Object, Object>(){

                    @Override
                    public Object load2(LoaderHelper<Object, Object> helper) throws CacheLoaderException {
                        return value;
                    }
                });
            }
        });
        vm1.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Get"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Assertions.assertThat((Object)region.get(key)).isEqualTo(value);
            }
        });
        vm1.invoke(new SerializableRunnable("Verify loader not invoked"){

            @Override
            public void run() {
                Assertions.assertThat((boolean)MultiVMRegionTestCase.loader().wasInvoked()).isFalse();
            }
        });
    }

    @Test
    public void testDistributedPut() {
        final String rgnName = this.getUniqueName();
        SerializableRunnable create = new SerializableRunnable("testDistributedPut: Create Region"){

            @Override
            public void run() {
                try {
                    MultiVMRegionTestCase.this.createRegion(rgnName);
                    MultiVMRegionTestCase.this.getSystem().getLogWriter().info("testDistributedPut: Created Region");
                }
                catch (CacheException e) {
                    Assertions.fail((String)"While creating region", (Throwable)e);
                }
            }
        };
        SerializableRunnable newKey = new SerializableRunnable("testDistributedPut: Create Key"){

            @Override
            public void run() {
                try {
                    if (!MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy().withReplication() && MultiVMRegionTestCase.this.getRegionAttributes().getPartitionAttributes() == null) {
                        Region root = MultiVMRegionTestCase.this.getRootRegion("root");
                        Region rgn = root.getSubregion(rgnName);
                        rgn.create((Object)"key", null);
                        MultiVMRegionTestCase.this.getSystem().getLogWriter().info("testDistributedPut: Created Key");
                    }
                }
                catch (CacheException e) {
                    Assertions.fail((String)"While creating region", (Throwable)e);
                }
            }
        };
        VM vm0 = VM.getVM(0);
        vm0.invoke(create);
        vm0.invoke(newKey);
        int vmCount = VM.getVMCount();
        for (int i = 1; i < vmCount; ++i) {
            VM vm = VM.getVM(i);
            vm.invoke(create);
            if (this.getRegionAttributes().getDataPolicy().withPreloaded()) continue;
            vm.invoke(newKey);
        }
        try {
            Region rgn = this.createRegion(rgnName);
            rgn.put((Object)"key", (Object)"value");
            this.getSystem().getLogWriter().info("testDistributedPut: Put Value");
            Invoke.invokeInEveryVM(this.repeatingIfNecessary(new CacheSerializableRunnable("testDistributedPut: Verify Received Value"){

                @Override
                public void run2() {
                    Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                    String description = "Could not find entry for 'key'";
                    Region.Entry actual = rgn1.getEntry((Object)"key");
                    ((ObjectAssert)Assertions.assertThat((Object)actual).describedAs(description, new Object[0])).isNotNull();
                    Assertions.assertThat((String)((String)rgn1.getEntry((Object)"key").getValue())).isEqualTo((Object)"value");
                }
            }));
        }
        catch (Exception e) {
            this.getCache().close();
            this.getSystem().getLogWriter().fine("testDistributedPut: Caused exception in createRegion");
            throw e;
        }
    }

    protected boolean supportsReplication() {
        return true;
    }

    @Test
    public void testReplicate() {
        Assumptions.assumeThat((boolean)this.supportsReplication()).isTrue();
        final String name = this.getUniqueName();
        final String key1 = "KEY1";
        final String value1 = "VALUE1";
        final String key2 = "KEY2";
        Object[] v = new Object[3000];
        Arrays.fill(v, (Object)51966);
        final List<Object> value2 = Arrays.asList(v);
        final String key3 = "KEY3";
        final String value3 = "VALUE3";
        VM vm0 = VM.getVM(0);
        VM vm2 = VM.getVM(2);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Mirrored Region"){

            @Override
            public void run2() throws CacheException {
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory factory = new AttributesFactory(ra);
                if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                    factory.setDiskStoreName(null);
                }
                factory.setDataPolicy(DataPolicy.REPLICATE);
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
            }
        };
        vm0.invoke(create);
        vm2.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Put data"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key1, value1);
                region.put(key2, value2);
                region.put(key3, value3);
                MultiVMRegionTestCase.this.flushIfNecessary(region);
            }
        });
        vm2.invoke(this.repeatingIfNecessary(new CacheSerializableRunnable("Wait for update"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Assertions.assertThat((Object)region.getEntry(key1)).isNotNull();
                Assertions.assertThat((Object)region.getEntry(key2)).isNotNull();
                Assertions.assertThat((Object)region.getEntry(key3)).isNotNull();
            }
        }));
        vm0.invoke(new CacheSerializableRunnable("Remove local entries"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
                MultiVMRegionTestCase.this.flushIfNecessary(region);
            }
        });
        vm2.invoke(this.repeatingIfNecessary(new CacheSerializableRunnable("Verify keys"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Region.Entry entry1 = region.getEntry(key1);
                Assertions.assertThat((Object)entry1).isNotNull();
                Assertions.assertThat((Object)entry1.getValue()).isEqualTo(value1);
                Region.Entry entry2 = region.getEntry(key2);
                Assertions.assertThat((Object)entry2).isNotNull();
                Assertions.assertThat((Object)entry2.getValue()).isEqualTo(value2);
                Region.Entry entry3 = region.getEntry(key3);
                Assertions.assertThat((Object)entry3).isNotNull();
                Assertions.assertThat((Object)entry3.getValue()).isEqualTo(value3);
            }
        }));
    }

    @Test
    public void testGetInitialImage() {
        Assumptions.assumeThat((boolean)this.supportsReplication()).isTrue();
        final String name = this.getUniqueName();
        final String key1 = "KEY1";
        final String value1 = "VALUE1";
        final String key2 = "KEY2";
        final String value2 = "VALUE2";
        final String key3 = "KEY3";
        final String value3 = "VALUE3";
        VM vm0 = VM.getVM(0);
        VM vm2 = VM.getVM(2);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Mirrored Region"){

            @Override
            public void run2() throws CacheException {
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory factory = new AttributesFactory(ra);
                if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                    factory.setDiskStoreName(null);
                }
                factory.setDataPolicy(DataPolicy.REPLICATE);
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
            }
        };
        vm0.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Put data"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key1, value1);
                region.put(key2, value2);
                region.put(key3, value3);
            }
        });
        vm2.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Remove local entries"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Verify keys/values"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Region.Entry entry1 = region.getEntry(key1);
                Assertions.assertThat((Object)entry1).isNotNull();
                Assertions.assertThat((Object)entry1.getValue()).isEqualTo(value1);
                Region.Entry entry2 = region.getEntry(key2);
                Assertions.assertThat((Object)entry2).isNotNull();
                Assertions.assertThat((Object)entry2.getValue()).isEqualTo(value2);
                Region.Entry entry3 = region.getEntry(key3);
                Assertions.assertThat((Object)entry3).isNotNull();
                Assertions.assertThat((Object)entry3.getValue()).isEqualTo(value3);
            }
        });
    }

    @Test
    public void testLargeGetInitialImage() {
        Assumptions.assumeThat((boolean)this.supportsReplication()).isTrue();
        final String name = this.getUniqueName();
        final Integer[] keys = new Integer[100];
        final byte[][] values = new byte[100][];
        for (int i = 0; i < 100; ++i) {
            keys[i] = i;
            values[i] = new byte[51200];
            Arrays.fill(values[i], (byte)66);
        }
        VM vm0 = VM.getVM(0);
        VM vm2 = VM.getVM(2);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Mirrored Region"){

            @Override
            public void run2() throws CacheException {
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory factory = new AttributesFactory(ra);
                if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                    factory.setDiskStoreName(null);
                }
                factory.setDataPolicy(DataPolicy.REPLICATE);
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
            }
        };
        vm0.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Put data"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)keys[i], (Object)values[i]);
                }
            }
        });
        vm2.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Remove local entries"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Verify keys/values"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Assertions.assertThat((int)region.entrySet(false).size()).isEqualTo(100);
                for (int i = 0; i < 100; ++i) {
                    Region.Entry entry = region.getEntry((Object)keys[i]);
                    Assertions.assertThat((Object)entry).isNotNull();
                    if (!(entry.getValue() instanceof byte[])) {
                        Assertions.fail((String)("getValue returned a " + entry.getValue().getClass() + " instead of the expected byte[]"));
                    }
                    Assertions.assertThat((boolean)Arrays.equals(values[i], (byte[])entry.getValue())).isTrue();
                }
            }
        });
    }

    @Test
    public void testMirroredDataFromNonMirrored() {
        Assumptions.assumeThat((boolean)this.supportsReplication()).isTrue();
        final String name = this.getUniqueName();
        final String key1 = "KEY1";
        final String value1 = "VALUE1";
        final String key2 = "KEY2";
        final String value2 = "VALUE2";
        final String key3 = "KEY3";
        final String value3 = "VALUE3";
        VM vm0 = VM.getVM(0);
        VM vm2 = VM.getVM(2);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Populate non-mirrored region"){

            @Override
            public void run2() throws CacheException {
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory fac = new AttributesFactory(ra);
                if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                    fac.setDiskStoreName(null);
                }
                fac.setDataPolicy(DataPolicy.NORMAL);
                Region region = MultiVMRegionTestCase.this.createRegion(name, fac.create());
                region.put(key1, value1);
                region.put(key2, value2);
                region.put(key3, value3);
                MultiVMRegionTestCase.this.flushIfNecessary(region);
            }
        };
        vm0.invoke(new CacheSerializableRunnable("Create Mirrored Region"){

            @Override
            public void run2() throws CacheException {
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory factory = new AttributesFactory(ra);
                if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                    factory.setDiskStoreName(null);
                }
                factory.setDataPolicy(DataPolicy.REPLICATE);
                class MirroredDataFromNonMirroredListener
                extends TestCacheListener<Object, Object> {
                    final List<Object> expectedKeys;
                    final List<Object> expectedValues;
                    final /* synthetic */ Object val$key1;
                    final /* synthetic */ Object val$key2;
                    final /* synthetic */ Object val$key3;
                    final /* synthetic */ Object val$value1;
                    final /* synthetic */ Object val$value2;
                    final /* synthetic */ Object val$value3;

                    MirroredDataFromNonMirroredListener() {
                        this.val$key1 = object;
                        this.val$key2 = object2;
                        this.val$key3 = object3;
                        this.val$value1 = object4;
                        this.val$value2 = object5;
                        this.val$value3 = object6;
                        this.expectedKeys = new ArrayList<Object>(Arrays.asList(this.val$key1, this.val$key2, this.val$key3));
                        this.expectedValues = new ArrayList<Object>(Arrays.asList(this.val$value1, this.val$value2, this.val$value3));
                    }

                    @Override
                    public synchronized void afterCreate2(EntryEvent<Object, Object> event) {
                        int index = this.expectedKeys.indexOf(event.getKey());
                        Assertions.assertThat((index >= 0 ? 1 : 0) != 0).isTrue();
                        Assertions.assertThat((Object)event.getNewValue()).isEqualTo(this.expectedValues.remove(index));
                        this.expectedKeys.remove(index);
                        logger.info("afterCreate called in MirroredDataFromNonMirroredListener for key:" + event.getKey());
                    }
                }
                factory.addCacheListener((CacheListener)new MirroredDataFromNonMirroredListener(MultiVMRegionTestCase.this, key1, key2, key3, value1, value2, value3));
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
            }
        });
        vm2.invoke(create);
        vm2.invoke(new CacheSerializableRunnable("Remove local entries"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.localDestroy(key1);
                region.localDestroy(key2);
                region.localDestroy(key3);
                MultiVMRegionTestCase.this.flushIfNecessary(region);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Verify keys/values and listener"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Region.Entry entry1 = region.getEntry(key1);
                Assertions.assertThat((Object)entry1).isNotNull();
                Assertions.assertThat((Object)entry1.getValue()).isEqualTo(value1);
                Region.Entry entry2 = region.getEntry(key2);
                Assertions.assertThat((Object)entry2).isNotNull();
                Assertions.assertThat((Object)entry2.getValue()).isEqualTo(value2);
                Region.Entry entry3 = region.getEntry(key3);
                Assertions.assertThat((Object)entry3).isNotNull();
                Assertions.assertThat((Object)entry3.getValue()).isEqualTo(value3);
                MirroredDataFromNonMirroredListener lsnr = (MirroredDataFromNonMirroredListener)region.getAttributes().getCacheListeners()[0];
                Assertions.assertThat((boolean)lsnr.wasInvoked()).isTrue();
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)lsnr.expectedKeys.isEmpty()).describedAs("expectedKeys should be empty, but was: " + lsnr.expectedKeys, new Object[0])).isTrue();
            }
        });
    }

    @Test
    public void testNoMirroredDataToNonMirrored() {
        Assumptions.assumeThat((boolean)this.supportsReplication()).isTrue();
        final String name = this.getUniqueName();
        final String key1 = "KEY1";
        final String value1 = "VALUE1";
        final String key2 = "KEY2";
        final String value2 = "VALUE2";
        final String key3 = "KEY3";
        final String value3 = "VALUE3";
        VM vm0 = VM.getVM(0);
        VM vm2 = VM.getVM(2);
        vm0.invoke(new CacheSerializableRunnable("Create Non-mirrored Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name, MultiVMRegionTestCase.this.getRegionAttributes());
            }
        });
        CacheSerializableRunnable create = new CacheSerializableRunnable("Populate mirrored region"){

            @Override
            public void run2() throws CacheException {
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory factory = new AttributesFactory(ra);
                if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                    factory.setDiskStoreName(null);
                }
                factory.setDataPolicy(DataPolicy.REPLICATE);
                Region region = MultiVMRegionTestCase.this.createRegion(name, factory.create());
                region.put(key1, value1);
                region.put(key2, value2);
                region.put(key3, value3);
                MultiVMRegionTestCase.this.flushIfNecessary(region);
            }
        };
        vm2.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Verify keys/values"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Region.Entry entry1 = region.getEntry(key1);
                if (!MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy().withReplication()) {
                    if (entry1 != null) {
                        logger.info("found entry " + entry1);
                    }
                    Assertions.assertThat((Object)entry1).isNull();
                } else {
                    Assertions.assertThat((Object)entry1).isNotNull();
                }
                Region.Entry entry2 = region.getEntry(key2);
                if (!MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy().withReplication()) {
                    Assertions.assertThat((Object)entry2).isNull();
                } else {
                    Assertions.assertThat((Object)entry2).isNotNull();
                }
                Region.Entry entry3 = region.getEntry(key3);
                if (!MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy().withReplication()) {
                    Assertions.assertThat((Object)entry3).isNull();
                } else {
                    Assertions.assertThat((Object)entry3).isNotNull();
                }
            }
        });
    }

    @Test
    public void testMirroredLocalLoad() {
        Assumptions.assumeThat((boolean)this.supportsReplication()).isTrue();
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String value = "VALUE";
        VM vm0 = VM.getVM(0);
        VM vm2 = VM.getVM(2);
        vm0.invoke(new CacheSerializableRunnable("Create region with loader"){

            @Override
            public void run2() throws CacheException {
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory factory = new AttributesFactory(ra);
                if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                    factory.setDiskStoreName(null);
                }
                factory.setDataPolicy(DataPolicy.REPLICATE);
                factory.setCacheLoader((CacheLoader)new TestCacheLoader<Object, Object>(){

                    @Override
                    public Object load2(LoaderHelper<Object, Object> helper) throws CacheLoaderException {
                        return value;
                    }
                });
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
            }
        });
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region with bad loader"){

            @Override
            public void run2() throws CacheException {
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory factory = new AttributesFactory(ra);
                if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                    factory.setDiskStoreName(null);
                }
                factory.setDataPolicy(DataPolicy.REPLICATE);
                MultiVMRegionTestCase.setLoader(new TestCacheLoader<Object, Object>(){

                    @Override
                    public Object load2(LoaderHelper<Object, Object> helper) throws CacheLoaderException {
                        Assertions.fail((String)"Should not be invoked");
                        return null;
                    }
                });
                factory.setCacheLoader(MultiVMRegionTestCase.loader());
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
            }
        };
        vm2.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Get"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Assertions.assertThat((Object)region.get(key)).isEqualTo(value);
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Verify no load"){

            @Override
            public void run2() throws CacheException {
                Assertions.assertThat((boolean)MultiVMRegionTestCase.loader().wasInvoked()).isFalse();
            }
        });
    }

    @Test
    public void testMirroredNetLoad() {
        Assumptions.assumeThat((boolean)this.supportsReplication()).isTrue();
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String value = "VALUE";
        VM vm0 = VM.getVM(0);
        VM vm2 = VM.getVM(2);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region with loader"){

            @Override
            public void run2() throws CacheException {
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory factory = new AttributesFactory(ra);
                if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                    factory.setDiskStoreName(null);
                }
                factory.setDataPolicy(DataPolicy.REPLICATE);
                factory.setCacheLoader((CacheLoader)new TestCacheLoader<Object, Object>(){

                    @Override
                    public Object load2(LoaderHelper<Object, Object> helper) throws CacheLoaderException {
                        return value;
                    }
                });
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
            }
        };
        vm0.invoke(new CacheSerializableRunnable("Create region with bad loader"){

            @Override
            public void run2() throws CacheException {
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory factory = new AttributesFactory(ra);
                if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                    factory.setDiskStoreName(null);
                }
                factory.setDataPolicy(DataPolicy.REPLICATE);
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
            }
        });
        vm2.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Get"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Assertions.assertThat((Object)region.get(key)).isEqualTo(value);
            }
        });
    }

    @Test
    public void testNoRegionKeepAlive() {
        final String name = this.getUniqueName();
        final String key = "KEEP_ALIVE_KEY";
        final String value = "VALUE";
        VM vm0 = VM.getVM(0);
        vm0.invoke(new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Populate region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, value);
                Assertions.assertThat((Object)region.get(key)).isEqualTo(value);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Close cache"){

            @Override
            public void run2() throws CacheException {
                JUnit4CacheTestCase.closeCache();
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Re-create cache"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                if (region.getAttributes().getDataPolicy().withPersistence()) {
                    Assertions.assertThat((Object)region.get(key)).isEqualTo(value);
                } else {
                    Assertions.assertThat((Object)region.get(key)).isNull();
                }
            }
        });
    }

    @Test
    public void testNetSearchObservesTtl() {
        ((ProxyableObjectAssert)Assumptions.assumeThat((Object)this.getRegionAttributes().getPartitionAttributes()).withFailMessage("the region has partition attributes", new Object[0])).isNull();
        final String name = this.getUniqueName();
        int shortTimeout = 10;
        int longTimeout = 1000000;
        final String key = "KEY";
        final String value = "VALUE";
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(2);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create with TTL"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                factory.setStatisticsEnabled(true);
                ExpirationAttributes expire = new ExpirationAttributes(1000000, ExpirationAction.DESTROY);
                factory.setEntryTimeToLive(expire);
                System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
                try {
                    Region region = MultiVMRegionTestCase.this.createRegion(name, factory.create());
                    region.create(key, value);
                }
                finally {
                    System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                }
            }
        };
        vm1.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Create with TTL"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                boolean partitioned;
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory factory = new AttributesFactory(ra);
                boolean bl = partitioned = ra.getPartitionAttributes() != null || ra.getDataPolicy().withPartitioning();
                if (!partitioned) {
                    if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                        factory.setDiskStoreName(null);
                    }
                    factory.setDataPolicy(DataPolicy.NORMAL);
                }
                factory.setStatisticsEnabled(true);
                ExpirationAttributes expire = new ExpirationAttributes(10, ExpirationAction.DESTROY);
                factory.setEntryTimeToLive(expire);
                System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
                try {
                    MultiVMRegionTestCase.this.createRegion(name, factory.create());
                }
                finally {
                    System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                }
            }
        });
        Wait.pause(100);
        vm0.invoke(new CacheSerializableRunnable("get(key), expect null"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Object got = region.get(key);
                Assertions.assertThat((Object)got).isNull();
            }
        });
        vm1.invoke(new CacheSerializableRunnable("get(key), expect value"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Object got = region.get(key);
                Assertions.assertThat((Object)got).isEqualTo(value);
            }
        });
    }

    @Test
    public void testNetSearchObservesIdleTime() {
        ((ProxyableObjectAssert)Assumptions.assumeThat((Object)this.getRegionAttributes().getPartitionAttributes()).withFailMessage("the region has partition attributes", new Object[0])).isNull();
        final String name = this.getUniqueName();
        int shortTimeout = 10;
        int longTimeout = 10000;
        final String key = "KEY";
        final String value = "VALUE";
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(2);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create with IdleTimeout"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                factory.setStatisticsEnabled(true);
                ExpirationAttributes expire = new ExpirationAttributes(10000, ExpirationAction.DESTROY);
                factory.setEntryIdleTimeout(expire);
                System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
                try {
                    Region region = MultiVMRegionTestCase.this.createRegion(name, factory.create());
                    region.create(key, value);
                }
                finally {
                    System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                }
            }
        };
        vm1.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Create with IdleTimeout"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                boolean partitioned;
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory factory = new AttributesFactory(ra);
                boolean bl = partitioned = ra.getPartitionAttributes() != null || ra.getDataPolicy().withPartitioning();
                if (!partitioned) {
                    if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                        factory.setDiskStoreName(null);
                    }
                    factory.setDataPolicy(DataPolicy.NORMAL);
                }
                factory.setStatisticsEnabled(true);
                ExpirationAttributes expire = new ExpirationAttributes(10, ExpirationAction.DESTROY);
                factory.setEntryIdleTimeout(expire);
                System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
                try {
                    MultiVMRegionTestCase.this.createRegion(name, factory.create());
                }
                finally {
                    System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                }
            }
        });
        Wait.pause(20);
        vm0.invoke(new CacheSerializableRunnable("get(key), expect null"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Object got = region.get(key);
                Assertions.assertThat((Object)got).isNull();
            }
        });
        vm1.invoke(new CacheSerializableRunnable("get(key), expect value"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Object got = region.get(key);
                Assertions.assertThat((Object)got).isEqualTo(value);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEntryTtlDestroyEvent() {
        ((ProxyableObjectAssert)Assumptions.assumeThat((Object)this.getRegionAttributes().getPartitionAttributes()).withFailMessage("the region has partition attributes", new Object[0])).isNull();
        final String name = this.getUniqueName();
        int timeout = 22;
        final String key = "KEY";
        final String value = "VALUE";
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        CacheSerializableRunnable createRegion = new CacheSerializableRunnable("Create with Listener"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory fac = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                class DestroyListener
                extends TestCacheListener<Object, Object> {
                    boolean eventIsExpiration = false;
                    final /* synthetic */ Object val$value;

                    DestroyListener() {
                        this.val$value = object;
                    }

                    @Override
                    public void afterDestroyBeforeAddEvent(EntryEvent<Object, Object> event) {
                        this.eventIsExpiration = event.getOperation().isExpiration();
                    }

                    @Override
                    public void afterDestroy2(EntryEvent<Object, Object> event) {
                        if (event.isOriginRemote()) {
                            Assertions.assertThat((boolean)event.getDistributedMember().equals(MultiVMRegionTestCase.this.getSystem().getDistributedMember())).isFalse();
                        } else {
                            Assertions.assertThat((Comparable)event.getDistributedMember()).isEqualTo((Object)MultiVMRegionTestCase.this.getSystem().getDistributedMember());
                        }
                        Assertions.assertThat((Object)event.getOperation()).isEqualTo((Object)Operation.EXPIRE_DESTROY);
                        Assertions.assertThat((Object)event.getOldValue()).isEqualTo(this.val$value);
                        this.eventIsExpiration = event.getOperation().isExpiration();
                    }

                    @Override
                    public void afterCreate2(EntryEvent<Object, Object> ignored) {
                    }

                    @Override
                    public void afterUpdate2(EntryEvent<Object, Object> ignored) {
                    }
                }
                fac.addCacheListener((CacheListener)(destroyListener = new DestroyListener(MultiVMRegionTestCase.this, value)));
                MultiVMRegionTestCase.this.createRegion(name, fac.create());
            }
        };
        vm1.invoke(createRegion);
        vm0.invoke(new CacheSerializableRunnable("Create with TTL"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                factory.setStatisticsEnabled(true);
                ExpirationAttributes expire = new ExpirationAttributes(22, ExpirationAction.DESTROY);
                factory.setEntryTimeToLive(expire);
                if (!MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy().withReplication()) {
                    factory.setDataPolicy(DataPolicy.NORMAL);
                    factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                }
                System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
                try {
                    MultiVMRegionTestCase.this.createRegion(name, factory.create());
                    ExpiryTask.suspendExpiration();
                }
                finally {
                    System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                }
            }
        });
        try {
            vm1.invoke(new SerializableCallable<Object>(){

                @Override
                public Object call() {
                    Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                    DestroyListener dl = (DestroyListener)region.getAttributes().getCacheListeners()[0];
                    dl.enableEventHistory();
                    region.put(key, value);
                    Assertions.assertThat((boolean)dl.wasInvoked()).isTrue();
                    List history = dl.getEventHistory();
                    CacheEvent ce = history.get(0);
                    dl.disableEventHistory();
                    Assertions.assertThat((Object)ce.getOperation()).isEqualTo((Object)Operation.CREATE);
                    return null;
                }
            });
            vm0.invoke(new CacheSerializableRunnable("Check create received from vm1"){

                @Override
                public void run2() throws CacheException {
                    Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                    Awaitility.await((String)("never saw create of " + key)).atMost(3L, TimeUnit.SECONDS).pollInterval(10L, TimeUnit.MILLISECONDS).until(() -> region.getEntry(key) != null);
                }
            });
            vm0.invoke(new CacheSerializableRunnable("resume expiration"){

                @Override
                public void run2() throws CacheException {
                    ExpiryTask.permitExpiration();
                }
            });
        }
        catch (Throwable throwable) {
            vm0.invoke(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        vm0.invoke(new CacheSerializableRunnable("Check local destroy"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Awaitility.await((String)("never saw expire of " + key)).atMost(4L, TimeUnit.SECONDS).pollInterval(10L, TimeUnit.MILLISECONDS).until(() -> region.getEntry(key) == null);
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Verify destroyed and event"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Awaitility.await((String)("never saw expire of " + key)).atMost(4L, TimeUnit.SECONDS).pollInterval(10L, TimeUnit.MILLISECONDS).until(() -> region.getEntry(key) == null);
                Assertions.assertThat((boolean)destroyListener.waitForInvocation(555)).isTrue();
                Assertions.assertThat((boolean)((DestroyListener)destroyListener).eventIsExpiration).isTrue();
            }
        });
    }

    @Test
    public void testEntryTtlLocalDestroy() throws Exception {
        boolean partitioned;
        ((ProxyableObjectAssert)Assumptions.assumeThat((Object)this.getRegionAttributes().getPartitionAttributes()).withFailMessage("the region has partition attributes", new Object[0])).isNull();
        final boolean mirrored = this.getRegionAttributes().getDataPolicy().withReplication();
        boolean bl = partitioned = this.getRegionAttributes().getPartitionAttributes() != null || this.getRegionAttributes().getDataPolicy().withPartitioning();
        if (!mirrored) {
            MultiVMRegionTestCase.disconnectAllFromDS();
        }
        final String name = this.getUniqueName();
        int timeout = 10;
        String key = "KEY";
        String value = "VALUE";
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Populate"){

            @Override
            public void run2() throws CacheException {
                System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
                try {
                    MultiVMRegionTestCase.this.createRegion(name);
                }
                finally {
                    System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                }
            }
        };
        vm1.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Create with TTL"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                factory.setStatisticsEnabled(true);
                ExpirationAttributes expire = new ExpirationAttributes(10, ExpirationAction.LOCAL_DESTROY);
                factory.setEntryTimeToLive(expire);
                if (!mirrored) {
                    if (!partitioned) {
                        factory.setDataPolicy(DataPolicy.NORMAL);
                    }
                    factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                    factory.addCacheListener(new CountingDistCacheListener());
                }
                System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
                try {
                    MultiVMRegionTestCase.this.createRegion(name, factory.create());
                    if (mirrored) {
                        Assertions.fail((String)"Should have thrown an IllegalStateException");
                    }
                }
                catch (IllegalStateException e) {
                    if (!mirrored) {
                        throw e;
                    }
                }
                finally {
                    System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                }
            }
        });
        if (mirrored) {
            return;
        }
        vm1.invoke(new SerializableCallable<Object>(){

            @Override
            public Object call() {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put((Object)"KEY", (Object)"VALUE");
                return null;
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Check local destroy"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                CountingDistCacheListener l = (CountingDistCacheListener)region.getAttributes().getCacheListeners()[0];
                Awaitility.waitAtMost((long)1L, (TimeUnit)TimeUnit.SECONDS).pollInterval(1L, TimeUnit.MILLISECONDS).untilAsserted(() -> l.assertCount(1, 0, 0, 0));
                try {
                    Awaitility.waitAtMost((long)30L, (TimeUnit)TimeUnit.SECONDS).pollInterval(1L, TimeUnit.MILLISECONDS).until(() -> {
                        Region.Entry re = region.getEntry((Object)"KEY");
                        if (re != null) {
                            EntryExpiryTask eet = MultiVMRegionTestCase.getEntryExpiryTask(region, "KEY");
                            if (eet != null) {
                                long stopTime = MultiVMRegionTestCase.this.getCache().getInternalDistributedSystem().getClock().getStopTime();
                                logger.info("DEBUG: waiting for expire destroy expirationTime= " + eet.getExpirationTime() + " now=" + eet.calculateNow() + " stopTime=" + stopTime + " currentTimeMillis=" + System.currentTimeMillis());
                            } else {
                                logger.info("DEBUG: waiting for expire destroy but expiry task is null");
                            }
                        }
                        return re == null;
                    });
                }
                catch (ConditionTimeoutException timeout) {
                    Assertions.fail((String)MultiVMRegionTestCase.this.determineExpiryFailureMessage(region, "KEY"), (Throwable)timeout);
                }
                Assertions.assertThat((Object)region.getEntry((Object)"KEY")).isNull();
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Verify local"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Region.Entry entry = region.getEntry((Object)"KEY");
                Assertions.assertThat((Object)entry.getValue()).isEqualTo((Object)"VALUE");
            }
        });
    }

    private String determineExpiryFailureMessage(Region region, String key) {
        String expiryInfo = "";
        try {
            EntryExpiryTask eet = MultiVMRegionTestCase.getEntryExpiryTask(region, key);
            if (eet != null) {
                expiryInfo = "expirationTime= " + eet.getExpirationTime() + " now=" + eet.calculateNow() + " currentTimeMillis=" + System.currentTimeMillis();
            }
        }
        catch (EntryNotFoundException ex) {
            expiryInfo = "EntryNotFoundException when getting expiry task";
        }
        return "Entry for key " + key + " never expired (since it still exists) " + expiryInfo;
    }

    private static EntryExpiryTask getEntryExpiryTask(Region r, Object key) {
        EntryExpiryTask result = null;
        try {
            LocalRegion lr = (LocalRegion)r;
            result = lr.getEntryExpiryTask(key);
        }
        catch (EntryNotFoundException entryNotFoundException) {
            // empty catch block
        }
        return result;
    }

    @Test
    public void testUpdateResetsIdleTime() {
        final String name = this.getUniqueName();
        int timeout = 90;
        final String key = "KEY";
        final String value = "VALUE";
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        vm0.invoke(new CacheSerializableRunnable("Create with Idle"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                factory.setStatisticsEnabled(true);
                ExpirationAttributes expire = new ExpirationAttributes(90, ExpirationAction.DESTROY);
                factory.setEntryIdleTimeout(expire);
                LocalRegion region = (LocalRegion)MultiVMRegionTestCase.this.createRegion(name, factory.create());
                if (region.getDataPolicy().withPartitioning()) {
                    PartitionRegionHelper.assignBucketsToPartitions((Region)region);
                }
                region.create(key, null);
                EntryExpiryTask eet = region.getEntryExpiryTask(key);
                region.create((Object)"createExpiryTime", (Object)eet.getExpirationTime());
                Wait.waitForExpiryClockToChange(region);
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create Region " + name){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                factory.setStatisticsEnabled(true);
                ExpirationAttributes expire = new ExpirationAttributes(90, ExpirationAction.DESTROY);
                factory.setEntryIdleTimeout(expire);
                if (MultiVMRegionTestCase.this.getRegionAttributes().getPartitionAttributes() != null) {
                    MultiVMRegionTestCase.this.createRegion(name, factory.create());
                } else {
                    MultiVMRegionTestCase.this.createRegion(name);
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Update entry"){

            @Override
            public void run2() throws CacheException {
                Region r = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Assertions.assertThat((Map)r).isNotNull();
                r.put(key, value);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Verify reset"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Awaitility.await((String)("never saw key " + key + "equal to value " + value)).atMost(3L, TimeUnit.SECONDS).pollInterval(10L, TimeUnit.MILLISECONDS).until(() -> value.equals(region.get(key)));
                EntryExpiryTask eet = region.getEntryExpiryTask(key);
                long createExpiryTime = (Long)region.get((Object)"createExpiryTime");
                long updateExpiryTime = eet.getExpirationTime();
                if (updateExpiryTime - createExpiryTime <= 0L) {
                    Assertions.fail((String)("update did not reset the expiration time. createExpiryTime=" + createExpiryTime + " updateExpiryTime=" + updateExpiryTime));
                }
            }
        });
    }

    @Test
    public void testNonblockingGetInitialImage() {
        Assumptions.assumeThat((boolean)this.supportsReplication()).isTrue();
        Assumptions.assumeThat((boolean)this.getRegionAttributes().getScope().isGlobal()).isFalse();
        final String name = this.getUniqueName();
        final byte[][] values = new byte[1000][];
        for (int i = 0; i < 1000; ++i) {
            values[i] = new byte[5120];
            Arrays.fill(values[i], (byte)66);
        }
        VM vm0 = VM.getVM(0);
        VM vm2 = VM.getVM(2);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Mirrored Region"){

            @Override
            public void run2() throws CacheException {
                JUnit4CacheTestCase.beginCacheXml();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.NORMAL);
                factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                logger.info("MJT DEBUG: attrs0 are " + factory.create());
                MultiVMRegionTestCase.this.createRootRegion(factory.create());
                factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                if (MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy() == DataPolicy.NORMAL) {
                    factory.setDataPolicy(DataPolicy.PRELOADED);
                }
                logger.info("MJT DEBUG: attrs1 are " + factory.create());
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
                MultiVMRegionTestCase.this.finishCacheXml(name);
                InitialImageOperation.slowImageProcessing = 0;
            }
        };
        vm0.invoke(new CacheSerializableRunnable("Create Nonmirrored Region"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.EMPTY);
                MultiVMRegionTestCase.this.createRootRegion(factory.create());
                factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
                InitialImageOperation.slowImageProcessing = 0;
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Put initial data"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 1000; ++i) {
                    region.put((Object)i, (Object)values[i]);
                }
                Assertions.assertThat((int)region.keySet().size()).isEqualTo(1000);
            }
        });
        AsyncInvocation async = vm0.invokeAsync(new CacheSerializableRunnable("Do Nonblocking Operations"){

            @Override
            public void run2() throws CacheException {
                int i;
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                CacheDistributionAdvisor adv = ((DistributedRegion)region).getCacheDistributionAdvisor();
                boolean expectedProfiles = true;
                Awaitility.await((String)"replicate count never reached 1").atMost(60L, TimeUnit.SECONDS).pollInterval(200L, TimeUnit.MILLISECONDS).until(() -> {
                    DataPolicy currentPolicy = MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy();
                    if (currentPolicy == DataPolicy.PRELOADED) {
                        return adv.advisePreloadeds().size() + adv.adviseReplicates().size() >= 1;
                    }
                    return adv.adviseReplicates().size() >= 1;
                });
                DataPolicy currentPolicy = MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy();
                int numProfiles = currentPolicy == DataPolicy.PRELOADED ? adv.advisePreloadeds().size() + adv.adviseReplicates().size() : adv.adviseReplicates().size();
                Assertions.assertThat((numProfiles >= 1 ? 1 : 0) != 0).isTrue();
                block5: for (i = 1; i < 1000; i += 2) {
                    Integer key = i;
                    logger.info("Operation #" + i + " on key " + key);
                    switch (i % 6) {
                        case 1: {
                            Long value = System.currentTimeMillis();
                            region.put((Object)key, (Object)value);
                            continue block5;
                        }
                        case 3: {
                            region.invalidate((Object)key);
                            if (!MultiVMRegionTestCase.this.getRegionAttributes().getScope().isDistributedAck()) continue block5;
                            Assertions.assertThat((Object)region.get((Object)key)).isNull();
                            continue block5;
                        }
                        case 5: {
                            region.destroy((Object)key);
                            if (!MultiVMRegionTestCase.this.getRegionAttributes().getScope().isDistributedAck()) continue block5;
                            Assertions.assertThat((Object)region.get((Object)key)).isNull();
                            continue block5;
                        }
                        default: {
                            Assertions.fail((String)("unexpected modulus result: " + i));
                        }
                    }
                }
                for (i = 1000; i < 1200; ++i) {
                    region.create((Object)i, (Object)System.currentTimeMillis());
                }
                MultiVMRegionTestCase.this.getRootRegion().put((Object)"DONE", (Object)"FLUSH_OPS");
            }
        });
        if (!this.getRegionAttributes().getScope().isGlobal()) {
            vm2.invoke(new SerializableRunnable("Set slow image processing"){

                @Override
                public void run() {
                    InitialImageOperation.slowImageProcessing = 200;
                }
            });
        }
        logger.info("Before GetInitialImage, data policy is " + this.getRegionAttributes().getDataPolicy() + ", scope is " + this.getRegionAttributes().getScope());
        AsyncInvocation asyncGII = vm2.invokeAsync(create);
        if (!this.getRegionAttributes().getScope().isGlobal()) {
            ThreadUtils.join(async, 30000L);
            vm2.invoke(new SerializableRunnable("Set fast image processing"){

                @Override
                public void run() {
                    InitialImageOperation.slowImageProcessing = 0;
                }
            });
            logger.info("after async nonblocking ops complete");
        }
        ThreadUtils.join(asyncGII, 30000L);
        final long iiComplete = System.currentTimeMillis();
        logger.info("Complete GetInitialImage at: " + System.currentTimeMillis());
        if (this.getRegionAttributes().getScope().isGlobal()) {
            ThreadUtils.join(async, 30000L);
        }
        if (async.exceptionOccurred()) {
            Assertions.fail((String)"async failed", (Throwable)async.getException());
        }
        if (asyncGII.exceptionOccurred()) {
            Assertions.fail((String)"asyncGII failed", (Throwable)asyncGII.getException());
        }
        vm0.invoke(new CacheSerializableRunnable("Locally destroy region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        });
        logger.info("after localDestroyRegion");
        vm2.invoke(MultiVMRegionTestCase.repeatingIfNecessary(5000L, new CacheSerializableRunnable("Verify entryCount"){
            boolean entriesDumped;
            {
                super(name2);
                this.entriesDumped = false;
            }

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                int entryCount = 1034;
                int actualCount = region.entrySet(false).size();
                if (actualCount == 1200) {
                    this.dumpDestroyedEntries(region);
                }
                Assertions.assertThat((int)actualCount).isEqualTo(entryCount);
            }

            private void dumpDestroyedEntries(Region region) throws EntryNotFoundException {
                if (this.entriesDumped) {
                    return;
                }
                this.entriesDumped = true;
                logger.info("DUMPING Entries with values in VM that should have been destroyed:");
                for (int i = 5; i < 1000; i += 6) {
                    try {
                        logger.info(i + "-->" + ((LocalRegion)region).getValueInVM((Object)i));
                        continue;
                    }
                    catch (EntryNotFoundException expected) {
                        logger.info(i + "-->CORRECTLY DESTROYED");
                    }
                }
            }
        }));
        logger.info("after verify entryCount");
        vm2.invoke(new CacheSerializableRunnable("Verify keys/values & Nonblocking"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                int entryCount = 1034;
                Assertions.assertThat((int)region.entrySet(false).size()).isEqualTo(entryCount);
                int numConcurrent = 0;
                numConcurrent = MultiVMRegionTestCase.this.verifyEntryUpdateCounts((Region<Object, Object>)region, numConcurrent, values, iiComplete);
                logger.info(name + ": " + numConcurrent + " entries out of " + entryCount + " were updated concurrently with getInitialImage");
                if (region.getAttributes().getScope().isGlobal()) {
                    ((AbstractBooleanAssert)Assertions.assertThat((numConcurrent < 10 ? 1 : 0) != 0).describedAs("Too many concurrent updates when expected to block: " + numConcurrent, new Object[0])).isTrue();
                } else {
                    int min = 30;
                    ((AbstractBooleanAssert)Assertions.assertThat((numConcurrent >= min ? 1 : 0) != 0).describedAs("Not enough updates concurrent with getInitialImage occurred to my liking. " + numConcurrent + " entries out of " + entryCount + " were updated concurrently with getInitialImage, and I'd expect at least " + min + " or so", new Object[0])).isTrue();
                }
            }
        });
        logger.info("after verify key/values");
    }

    @Test
    public void testTXNonblockingGetInitialImage() {
        Assumptions.assumeThat((boolean)this.supportsReplication()).isTrue();
        Assumptions.assumeThat((boolean)this.supportsTransactions()).isTrue();
        Assumptions.assumeThat((boolean)this.getRegionAttributes().getScope().isGlobal()).isFalse();
        Assumptions.assumeThat((boolean)this.getRegionAttributes().getDataPolicy().withPersistence()).isFalse();
        final String name = this.getUniqueName();
        final byte[][] values = new byte[1000][];
        for (int i = 0; i < 1000; ++i) {
            values[i] = new byte[5120];
            Arrays.fill(values[i], (byte)66);
        }
        VM vm0 = VM.getVM(0);
        VM vm2 = VM.getVM(2);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Mirrored Region"){

            @Override
            public void run2() throws CacheException {
                JUnit4CacheTestCase.beginCacheXml();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.NORMAL);
                factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                MultiVMRegionTestCase.this.createRootRegion(factory.create());
                factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                if (MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy() == DataPolicy.NORMAL) {
                    factory.setDataPolicy(DataPolicy.PRELOADED);
                }
                factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
                MultiVMRegionTestCase.this.finishCacheXml(name);
                InitialImageOperation.slowImageProcessing = 0;
            }
        };
        vm0.invoke(new CacheSerializableRunnable("Create Nonmirrored Region"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.EMPTY);
                MultiVMRegionTestCase.this.createRootRegion(factory.create());
                factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
                InitialImageOperation.slowImageProcessing = 0;
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Put initial data"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 1000; ++i) {
                    region.put((Object)i, (Object)values[i]);
                }
                Assertions.assertThat((int)region.keySet().size()).isEqualTo(1000);
            }
        });
        AsyncInvocation async = vm0.invokeAsync(new CacheSerializableRunnable("Do Nonblocking Operations"){

            @Override
            public void run2() throws CacheException {
                int i;
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                CacheDistributionAdvisor adv = ((DistributedRegion)region).getCacheDistributionAdvisor();
                boolean expectedProfiles = true;
                Awaitility.await((String)"replicate count never reached 1").atMost(100L, TimeUnit.SECONDS).pollInterval(200L, TimeUnit.MILLISECONDS).until(() -> {
                    DataPolicy currentPolicy = MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy();
                    if (currentPolicy == DataPolicy.PRELOADED) {
                        return adv.advisePreloadeds().size() + adv.adviseReplicates().size() >= 1;
                    }
                    return adv.adviseReplicates().size() >= 1;
                });
                CacheTransactionManager txMgr = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                block5: for (i = 1; i < 1000; i += 2) {
                    Integer key = i;
                    switch (i % 6) {
                        case 1: {
                            Long value = System.currentTimeMillis();
                            txMgr.begin();
                            region.put((Object)key, (Object)value);
                            txMgr.commit();
                            continue block5;
                        }
                        case 3: {
                            txMgr.begin();
                            region.invalidate((Object)key);
                            txMgr.commit();
                            if (!MultiVMRegionTestCase.this.getRegionAttributes().getScope().isDistributedAck()) continue block5;
                            Assertions.assertThat((Object)region.get((Object)key)).isNull();
                            continue block5;
                        }
                        case 5: {
                            txMgr.begin();
                            region.destroy((Object)key);
                            txMgr.commit();
                            if (!MultiVMRegionTestCase.this.getRegionAttributes().getScope().isDistributedAck()) continue block5;
                            Assertions.assertThat((Object)region.get((Object)key)).isNull();
                            continue block5;
                        }
                        default: {
                            Assertions.fail((String)("unexpected modulus result: " + i));
                        }
                    }
                }
                for (i = 1000; i < 1200; ++i) {
                    txMgr.begin();
                    region.create((Object)i, (Object)System.currentTimeMillis());
                    txMgr.commit();
                }
                MultiVMRegionTestCase.this.getRootRegion().put((Object)"DONE", (Object)"FLUSH_OPS");
            }
        });
        if (!this.getRegionAttributes().getScope().isGlobal()) {
            vm2.invoke(new SerializableRunnable("Set slow image processing"){

                @Override
                public void run() {
                    InitialImageOperation.slowImageProcessing = 200;
                }
            });
        }
        AsyncInvocation asyncGII = vm2.invokeAsync(create);
        if (!this.getRegionAttributes().getScope().isGlobal()) {
            ThreadUtils.join(async, 30000L);
            vm2.invoke(new SerializableRunnable("Set fast image processing"){

                @Override
                public void run() {
                    InitialImageOperation.slowImageProcessing = 0;
                }
            });
            logger.info("after async nonblocking ops complete");
        }
        ThreadUtils.join(asyncGII, 30000L);
        final long iiComplete = System.currentTimeMillis();
        logger.info("Complete GetInitialImage at: " + System.currentTimeMillis());
        if (this.getRegionAttributes().getScope().isGlobal()) {
            ThreadUtils.join(async, 30000L);
        }
        if (async.exceptionOccurred()) {
            Assertions.fail((String)"async failed", (Throwable)async.getException());
        }
        if (asyncGII.exceptionOccurred()) {
            Assertions.fail((String)"asyncGII failed", (Throwable)asyncGII.getException());
        }
        vm0.invoke(new CacheSerializableRunnable("Locally destroy region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        });
        vm2.invoke(MultiVMRegionTestCase.repeatingIfNecessary(5000L, new CacheSerializableRunnable("Verify entryCount"){
            boolean entriesDumped;
            {
                super(name2);
                this.entriesDumped = false;
            }

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                int entryCount = 1034;
                int actualCount = region.entrySet(false).size();
                if (actualCount == 1200) {
                    this.dumpDestroyedEntries(region);
                }
                Assertions.assertThat((int)actualCount).isEqualTo(entryCount);
            }

            private void dumpDestroyedEntries(Region region) throws EntryNotFoundException {
                if (this.entriesDumped) {
                    return;
                }
                this.entriesDumped = true;
                logger.info("DUMPING Entries with values in VM that should have been destroyed:");
                for (int i = 5; i < 1000; i += 6) {
                    logger.info(i + "-->" + ((LocalRegion)region).getValueInVM((Object)i));
                }
            }
        }));
        vm2.invoke(new CacheSerializableRunnable("Verify keys/values & Nonblocking"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                int entryCount = 1034;
                Assertions.assertThat((int)region.entrySet(false).size()).isEqualTo(entryCount);
                int numConcurrent = 0;
                numConcurrent = MultiVMRegionTestCase.this.verifyEntryUpdateCounts((Region<Object, Object>)region, numConcurrent, values, iiComplete);
                logger.info(name + ": " + numConcurrent + " entries out of " + entryCount + " were updated concurrently with getInitialImage");
                int min = 30;
                String description = "Not enough updates concurrent with getInitialImage occurred to my liking. " + numConcurrent + " entries out of " + entryCount + " were updated concurrently with getInitialImage, and I'd expect at least " + min + " or so";
                ((AbstractBooleanAssert)Assertions.assertThat((numConcurrent >= min ? 1 : 0) != 0).describedAs(description, new Object[0])).isTrue();
            }
        });
    }

    private int verifyEntryUpdateCounts(Region<Object, Object> region, int numConcurrent, byte[][] values, long iiComplete) {
        block6: for (int i = 0; i < 1200; ++i) {
            Long timestamp;
            boolean condition;
            Object v;
            Region.Entry entry = region.getEntry((Object)i);
            Object object = v = entry == null ? null : entry.getValue();
            if (i < 1000) {
                switch (i % 6) {
                    case 0: 
                    case 2: 
                    case 4: {
                        Assertions.assertThat((Object)entry).isNotNull();
                        Assertions.assertThat((boolean)Arrays.equals(values[i], (byte[])v)).isTrue();
                        break;
                    }
                    case 1: {
                        Assertions.assertThat((Object)v).isNotNull();
                        condition = v instanceof Long;
                        ((AbstractBooleanAssert)Assertions.assertThat((boolean)condition).describedAs("Value for key " + i + " is not a Long, is a " + v.getClass().getName(), new Object[0])).isTrue();
                        timestamp = (Long)entry.getValue();
                        if (timestamp >= iiComplete) continue block6;
                        ++numConcurrent;
                        break;
                    }
                    case 3: {
                        Assertions.assertThat((Object)entry).isNotNull();
                        ((ObjectAssert)Assertions.assertThat((Object)v).describedAs("Expected value for " + i + " to be null, but was " + v, new Object[0])).isNull();
                        break;
                    }
                    case 5: {
                        Assertions.assertThat((Object)entry).isNull();
                        break;
                    }
                    default: {
                        Assertions.fail((String)("unexpected modulus result: " + i % 6));
                        break;
                    }
                }
                continue;
            }
            Assertions.assertThat((Object)v).isNotNull();
            condition = v instanceof Long;
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)condition).describedAs("Value for key " + i + " is not a Long, is a " + v.getClass().getName(), new Object[0])).isTrue();
            timestamp = (Long)entry.getValue();
            if (timestamp >= iiComplete) continue;
            ++numConcurrent;
        }
        return numConcurrent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="TODO: test is disabled for 51542")
    @Test
    public void testNBRegionInvalidationDuringGetInitialImage() throws Exception {
        Assumptions.assumeThat((boolean)this.supportsReplication()).isTrue();
        MultiVMRegionTestCase.disconnectAllFromDS();
        if (this.getRegionAttributes().getScope().isDistributedNoAck()) {
            return;
        }
        final String name = this.getUniqueName();
        final byte[][] values = new byte[1000][];
        for (int i = 0; i < 1000; ++i) {
            values[i] = new byte[5120];
            Arrays.fill(values[i], (byte)66);
        }
        VM vm0 = VM.getVM(0);
        VM vm2 = VM.getVM(2);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Mirrored Region"){

            @Override
            public void run2() throws CacheException {
                JUnit4CacheTestCase.beginCacheXml();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.NORMAL);
                factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                MultiVMRegionTestCase.this.createRootRegion(factory.create());
                factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                factory.setDataPolicy(DataPolicy.REPLICATE);
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
                MultiVMRegionTestCase.this.finishCacheXml(name);
                InitialImageOperation.slowImageProcessing = 0;
            }
        };
        vm0.invoke(new CacheSerializableRunnable("Create Nonmirrored Region"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.EMPTY);
                MultiVMRegionTestCase.this.createRootRegion(factory.create());
                factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                factory.setDataPolicy(DataPolicy.REPLICATE);
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
                InitialImageOperation.slowImageProcessing = 0;
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Put initial data"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 1000; ++i) {
                    region.put((Object)i, (Object)values[i]);
                }
                Assertions.assertThat((int)region.keySet().size()).isEqualTo(1000);
            }
        });
        AsyncInvocation async = vm0.invokeAsync(new CacheSerializableRunnable("Do Nonblocking Operations"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                CacheDistributionAdvisor adv = ((DistributedRegion)region).getCacheDistributionAdvisor();
                boolean expectedProfiles = true;
                Awaitility.await((String)"profile count never reached 1").atMost(30L, TimeUnit.SECONDS).pollInterval(200L, TimeUnit.MILLISECONDS).until(() -> adv.adviseReplicates().size(), Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
                block5: for (int i = 1; i < 1000; i += 2) {
                    if (i == 301) {
                        MultiVMRegionTestCase.this.flushIfNecessary(region);
                        region.invalidateRegion();
                        MultiVMRegionTestCase.this.flushIfNecessary(region);
                    }
                    Integer key = i;
                    switch (i % 6) {
                        case 1: {
                            Object value = System.currentTimeMillis();
                            region.put((Object)key, value);
                            continue block5;
                        }
                        case 3: {
                            region.invalidate((Object)key);
                            if (!MultiVMRegionTestCase.this.getRegionAttributes().getScope().isDistributedAck()) continue block5;
                            Object value = region.get((Object)key);
                            ((ObjectAssert)Assertions.assertThat((Object)value).describedAs("Expected null value for key: " + i + " but got " + value, new Object[0])).isNull();
                            continue block5;
                        }
                        case 5: {
                            region.destroy((Object)key);
                            if (!MultiVMRegionTestCase.this.getRegionAttributes().getScope().isDistributedAck()) continue block5;
                            Assertions.assertThat((Object)region.get((Object)key)).isNull();
                            continue block5;
                        }
                        default: {
                            Assertions.fail((String)("unexpected modulus result: " + i));
                        }
                    }
                }
                MultiVMRegionTestCase.this.getRootRegion().put((Object)"DONE", (Object)"FLUSH_OPS");
            }
        });
        if (!this.getRegionAttributes().getScope().isGlobal()) {
            vm2.invoke(new SerializableRunnable("Set slow image processing"){

                @Override
                public void run() {
                    MultiVMRegionTestCase.this.getRootRegion();
                    InitialImageOperation.slowImageProcessing = 100;
                }
            });
        }
        AsyncInvocation asyncGII = vm2.invokeAsync(create);
        if (!this.getRegionAttributes().getScope().isGlobal()) {
            try {
                ThreadUtils.join(async, 30000L);
                vm2.invoke(new SerializableRunnable("Set fast image processing"){

                    @Override
                    public void run() {
                        InitialImageOperation.slowImageProcessing = 0;
                    }
                });
            }
            catch (Throwable throwable) {
                vm2.invoke(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            logger.info("after async nonblocking ops complete");
        }
        ThreadUtils.join(asyncGII, 30000L);
        final long iiComplete = System.currentTimeMillis();
        logger.info("Complete GetInitialImage at: " + System.currentTimeMillis());
        if (this.getRegionAttributes().getScope().isGlobal()) {
            ThreadUtils.join(async, 30000L);
        }
        if (asyncGII.exceptionOccurred()) {
            throw new Error("asyncGII failed", asyncGII.getException());
        }
        if (async.exceptionOccurred()) {
            throw new Error("async failed", async.getException());
        }
        vm0.invoke(new CacheSerializableRunnable("Locally destroy region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        });
        vm2.invoke(MultiVMRegionTestCase.repeatingIfNecessary(3000L, new CacheSerializableRunnable("Verify entryCount"){
            private boolean entriesDumped;
            {
                super(name2);
                this.entriesDumped = false;
            }

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                int entryCount = 834;
                int actualCount = region.entrySet(false).size();
                if (actualCount == 1000) {
                    this.dumpDestroyedEntries(region);
                }
                Assertions.assertThat((int)actualCount).isEqualTo(entryCount);
            }

            private void dumpDestroyedEntries(Region region) throws EntryNotFoundException {
                if (this.entriesDumped) {
                    return;
                }
                this.entriesDumped = true;
                logger.info("DUMPING Entries with values in VM that should have been destroyed:");
                for (int i = 5; i < 1000; i += 6) {
                    logger.info(i + "-->" + ((LocalRegion)region).getValueInVM((Object)i));
                }
            }
        }));
        vm2.invoke(new CacheSerializableRunnable("Verify keys/values & Nonblocking"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                int entryCount = 834;
                Assertions.assertThat((int)region.entrySet(false).size()).isEqualTo(entryCount);
                int numConcurrent = 0;
                block6: for (int i = 0; i < 1000; ++i) {
                    Object v;
                    Region.Entry entry = region.getEntry((Object)i);
                    if (i < 301) {
                        if (i % 6 == 5) {
                            ((ObjectAssert)Assertions.assertThat((Object)entry).describedAs("Expected entry for " + i + " to be destroyed but it is " + entry, new Object[0])).isNull();
                            continue;
                        }
                        Assertions.assertThat((Object)entry).isNotNull();
                        v = entry.getValue();
                        ((ObjectAssert)Assertions.assertThat((Object)v).describedAs("Expected value for " + i + " to be null, but was " + v, new Object[0])).isNull();
                        continue;
                    }
                    v = entry == null ? null : entry.getValue();
                    switch (i % 6) {
                        case 0: 
                        case 2: 
                        case 4: {
                            Assertions.assertThat((Object)entry).isNotNull();
                            ((ObjectAssert)Assertions.assertThat((Object)v).describedAs("Expected value for " + i + " to be null, but was " + v, new Object[0])).isNull();
                            continue block6;
                        }
                        case 1: {
                            ((ObjectAssert)Assertions.assertThat((Object)entry).describedAs("Expected to find an entry for #" + i, new Object[0])).isNotNull();
                            ((ObjectAssert)Assertions.assertThat((Object)v).describedAs("Expected to find a value for #" + i, new Object[0])).isNotNull();
                            boolean condition = v instanceof Long;
                            ((AbstractBooleanAssert)Assertions.assertThat((boolean)condition).describedAs("Value for key " + i + " is not a Long, is a " + v.getClass().getName(), new Object[0])).isTrue();
                            Long timestamp = (Long)entry.getValue();
                            if (timestamp >= iiComplete) continue block6;
                            ++numConcurrent;
                            continue block6;
                        }
                        case 3: {
                            ((ObjectAssert)Assertions.assertThat((Object)entry).describedAs("Expected to find an entry for #" + i, new Object[0])).isNotNull();
                            ((ObjectAssert)Assertions.assertThat((Object)v).describedAs("Expected value for " + i + " to be null, but was " + v, new Object[0])).isNull();
                            continue block6;
                        }
                        case 5: {
                            ((ObjectAssert)Assertions.assertThat((Object)entry).describedAs("Expected to not find an entry for #" + i, new Object[0])).isNull();
                            continue block6;
                        }
                        default: {
                            Assertions.fail((String)("unexpected modulus result: " + i % 6));
                        }
                    }
                }
                logger.info(name + ": " + numConcurrent + " entries out of " + entryCount + " were updated concurrently with getInitialImage");
                if (MultiVMRegionTestCase.this.getRegionAttributes().getScope().isGlobal()) {
                    ((AbstractBooleanAssert)Assertions.assertThat((numConcurrent < 300 ? 1 : 0) != 0).describedAs("Too many concurrent updates when expected to block: " + numConcurrent, new Object[0])).isTrue();
                } else {
                    ((AbstractBooleanAssert)Assertions.assertThat((numConcurrent >= 30 ? 1 : 0) != 0).describedAs("Not enough updates concurrent with getInitialImage occurred to my liking. " + numConcurrent + " entries out of " + entryCount + " were updated concurrently with getInitialImage, and I'd expect at least 50 or so", new Object[0])).isTrue();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNBRegionDestructionDuringGetInitialImage() {
        Assumptions.assumeThat((boolean)this.supportsReplication()).isTrue();
        final String name = this.getUniqueName();
        final byte[][] values = new byte[1000][];
        for (int i = 0; i < 1000; ++i) {
            values[i] = new byte[5120];
            Arrays.fill(values[i], (byte)66);
        }
        VM vm0 = VM.getVM(0);
        VM vm2 = VM.getVM(2);
        vm0.invoke(new CacheSerializableRunnable("Create Nonmirrored Region"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.EMPTY);
                MultiVMRegionTestCase.this.createRootRegion(factory.create());
                factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
                InitialImageOperation.slowImageProcessing = 0;
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Put initial data"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 1000; ++i) {
                    region.put((Object)i, (Object)values[i]);
                }
                Assertions.assertThat((int)region.keySet().size()).isEqualTo(1000);
            }
        });
        AsyncInvocation async = vm0.invokeAsync(new CacheSerializableRunnable("Do Nonblocking Operations"){

            @Override
            public void run2() throws CacheException {
                Wait.pause(200);
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                CacheDistributionAdvisor adv = ((DistributedRegion)region).getCacheDistributionAdvisor();
                boolean expectedProfiles = true;
                Awaitility.await((String)"profile count never became exactly 1").atMost(1L, TimeUnit.MINUTES).pollInterval(200L, TimeUnit.MILLISECONDS).until(() -> adv.adviseReplicates().size(), Matchers.equalTo((Object)1));
                block5: for (int i = 1; i < 301; i += 2) {
                    Integer key = i;
                    switch (i % 6) {
                        case 1: {
                            Object value = System.currentTimeMillis();
                            region.put((Object)key, value);
                            continue block5;
                        }
                        case 3: {
                            region.invalidate((Object)key);
                            if (!region.getAttributes().getScope().isDistributedAck()) continue block5;
                            Object value = region.get((Object)key);
                            ((ObjectAssert)Assertions.assertThat((Object)value).describedAs("Expected null value for key: " + i + " but got " + value, new Object[0])).isNull();
                            continue block5;
                        }
                        case 5: {
                            region.destroy((Object)key);
                            if (!region.getAttributes().getScope().isDistributedAck()) continue block5;
                            Assertions.assertThat((Object)region.get((Object)key)).isNull();
                            continue block5;
                        }
                        default: {
                            Assertions.fail((String)("unexpected modulus result: " + i));
                        }
                    }
                }
                region.destroyRegion();
                Region rr = MultiVMRegionTestCase.this.getRootRegion();
                if (rr != null) {
                    rr.put((Object)"DONE", (Object)"FLUSH_OPS");
                }
            }
        });
        IgnoredException ex = IgnoredException.addIgnoredException("RegionDestroyedException");
        try {
            AsyncInvocation asyncGII = vm2.invokeAsync(new CacheSerializableRunnable("Create Mirrored Region"){

                @Override
                public void run2() throws CacheException {
                    if (!MultiVMRegionTestCase.this.getRegionAttributes().getScope().isGlobal()) {
                        InitialImageOperation.slowImageProcessing = 200;
                    }
                    JUnit4CacheTestCase.beginCacheXml();
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.NORMAL);
                    factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                    MultiVMRegionTestCase.this.createRootRegion(factory.create());
                    RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                    AttributesFactory factory2 = new AttributesFactory(ra);
                    if (ra.getDataPolicy().withPersistence()) {
                        factory2.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    } else {
                        factory2.setDataPolicy(DataPolicy.REPLICATE);
                    }
                    MultiVMRegionTestCase.this.createRegion(name, factory2.create());
                    MultiVMRegionTestCase.this.finishCacheXml(name);
                    InitialImageOperation.slowImageProcessing = 0;
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException ie) {
                        Assertions.fail((String)"interrupted");
                    }
                    Assertions.assertThat((MultiVMRegionTestCase.this.getRootRegion().getSubregion(name) == null || MultiVMRegionTestCase.this.getRegionAttributes().getScope().isGlobal() ? 1 : 0) != 0).isTrue();
                }
            });
            if (this.getRegionAttributes().getScope().isGlobal()) {
                ThreadUtils.join(async, 30000L);
                if (async.exceptionOccurred()) {
                    Assertions.fail((String)"async invocation failed", (Throwable)async.getException());
                }
                vm2.invoke(new SerializableRunnable("Set fast image processing"){

                    @Override
                    public void run() {
                        InitialImageOperation.slowImageProcessing = 0;
                    }
                });
                logger.info("after async nonblocking ops complete");
            }
            ThreadUtils.join(asyncGII, 30000L);
            logger.info("Complete GetInitialImage at: " + System.currentTimeMillis());
            if (this.getRegionAttributes().getScope().isGlobal()) {
                ThreadUtils.join(async, 30000L);
            }
            if (async.exceptionOccurred()) {
                Assertions.fail((String)"async failed", (Throwable)async.getException());
            }
            if (asyncGII.exceptionOccurred()) {
                Assertions.fail((String)"asyncGII failed", (Throwable)asyncGII.getException());
            }
        }
        finally {
            ex.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoDataSerializer() {
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        final String name = this.getUniqueName();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        VM vm2 = VM.getVM(2);
        logger.info(name + ": before creates");
        vm0.invoke(create);
        vm1.invoke(create);
        logger.info(name + ": after creates");
        final String key = "KEY";
        final String key2 = "KEY2";
        int intValue = 3452;
        long longValue = 213421L;
        vm2.invoke(new SerializableRunnable("Disconnect from DS"){

            @Override
            public void run() {
                JUnit4DistributedTestCase.disconnectFromDS();
            }
        });
        logger.info(name + ": after vm2 disconnect");
        try {
            vm0.invoke(new CacheSerializableRunnable("Put int"){

                @Override
                public void run2() throws CacheException {
                    Class<IntWrapper.IntWrapperSerializer> c = IntWrapper.IntWrapperSerializer.class;
                    IntWrapper.IntWrapperSerializer serializer = (IntWrapper.IntWrapperSerializer)DataSerializer.register(c);
                    logger.info("Registered serializer id:" + serializer.getId() + " class:" + c.getName());
                    Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                    region.put(key, (Object)new IntWrapper(3452));
                    MultiVMRegionTestCase.this.flushIfNecessary(region);
                    Assertions.assertThat((boolean)serializer.wasInvoked).isTrue();
                }
            });
            logger.info(name + ": after vm0 put");
            CacheSerializableRunnable get = new CacheSerializableRunnable("Get int"){

                @Override
                public void run2() throws CacheException {
                    Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                    int savVal = InternalDataSerializer.GetMarker.WAIT_MS;
                    InternalDataSerializer.GetMarker.WAIT_MS = 1;
                    try {
                        Awaitility.await((String)"DataSerializer with id 120 was never registered").atMost(30L, TimeUnit.SECONDS).pollInterval(10L, TimeUnit.MILLISECONDS).until(() -> InternalDataSerializer.getSerializer((int)120) != null);
                    }
                    finally {
                        InternalDataSerializer.GetMarker.WAIT_MS = savVal;
                    }
                    IntWrapper value = (IntWrapper)region.get(key);
                    Assertions.assertThat((Object)InternalDataSerializer.getSerializer((int)120)).isNotNull();
                    Assertions.assertThat((Object)value).isNotNull();
                    Assertions.assertThat((int)value.intValue).isEqualTo(3452);
                }
            };
            vm1.invoke(get);
            logger.info(name + ": after vm1 get");
            vm2.invoke(new SerializableRunnable("Connect to DS"){

                @Override
                public void run() {
                    Class<LongWrapper.LongWrapperSerializer> c = LongWrapper.LongWrapperSerializer.class;
                    DataSerializer.register(c);
                    MultiVMRegionTestCase.this.getSystem();
                }
            });
            vm2.invoke(create);
            logger.info(name + ": after vm2 create");
            vm2.invoke(new CacheSerializableRunnable("Put long"){

                @Override
                public void run2() throws CacheException {
                    Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                    region.put(key2, (Object)new LongWrapper(213421L));
                    MultiVMRegionTestCase.this.flushIfNecessary(region);
                    LongWrapper.LongWrapperSerializer serializer = (LongWrapper.LongWrapperSerializer)InternalDataSerializer.getSerializer((int)121);
                    Assertions.assertThat((boolean)serializer.wasInvoked).isTrue();
                }
            });
            logger.info(name + ": after vm2 put");
            vm2.invoke(get);
            logger.info(name + ": after vm2 get");
            CacheSerializableRunnable get2 = new CacheSerializableRunnable("Get long"){

                @Override
                public void run2() throws CacheException {
                    Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                    LongWrapper value = (LongWrapper)region.get(key2);
                    Assertions.assertThat((Object)InternalDataSerializer.getSerializer((int)121)).isNotNull();
                    Assertions.assertThat((Object)value).isNotNull();
                    Assertions.assertThat((long)value.longValue).isEqualTo(213421L);
                }
            };
            vm0.invoke(get2);
            logger.info(name + ": after vm0 get2");
            vm1.invoke(get2);
            logger.info(name + ": after vm1 get2");
        }
        finally {
            Wait.pause(1500);
            MultiVMRegionTestCase.unregisterAllSerializers();
            logger.info(name + ": after unregister");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoInstantiator() {
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        final String name = this.getUniqueName();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        VM vm2 = VM.getVM(2);
        vm0.invoke(create);
        vm1.invoke(create);
        final String key = "KEY";
        final String key2 = "KEY2";
        int intValue = 7201;
        long longValue = 123612L;
        vm2.invoke(new SerializableRunnable("Disconnect from DS"){

            @Override
            public void run() {
                JUnit4DistributedTestCase.disconnectFromDS();
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Put int"){

            @Override
            public void run2() throws CacheException {
                Instantiator.register((Instantiator)new DSIntWrapper.DSIntWrapperInstantiator());
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, (Object)new DSIntWrapper(7201));
                MultiVMRegionTestCase.this.flushIfNecessary(region);
            }
        });
        CacheSerializableRunnable get = new CacheSerializableRunnable("Get int"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                DSIntWrapper.DSIntWrapperInstantiator inst = new DSIntWrapper.DSIntWrapperInstantiator();
                Assertions.assertThat((Object)InternalInstantiator.getInstantiator((int)inst.getId())).isNotNull();
                DSIntWrapper value = (DSIntWrapper)region.get(key);
                Assertions.assertThat((Object)value).isNotNull();
                Assertions.assertThat((int)value.intValue).isEqualTo(7201);
            }
        };
        try {
            vm1.invoke(get);
            vm2.invoke(new SerializableRunnable("Connect to DS"){

                @Override
                public void run() {
                    Instantiator.register((Instantiator)new DSLongWrapper.DSLongWrapperInstantiator());
                    MultiVMRegionTestCase.this.getSystem();
                }
            });
            vm2.invoke(create);
            vm2.invoke(new CacheSerializableRunnable("Put long"){

                @Override
                public void run2() throws CacheException {
                    Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                    region.put(key2, (Object)new DSLongWrapper(123612L));
                    MultiVMRegionTestCase.this.flushIfNecessary(region);
                }
            });
            vm2.invoke(get);
            CacheSerializableRunnable get2 = new CacheSerializableRunnable("Get long"){

                @Override
                public void run2() throws CacheException {
                    Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                    DSLongWrapper.DSLongWrapperInstantiator inst = new DSLongWrapper.DSLongWrapperInstantiator();
                    Assertions.assertThat((Object)InternalInstantiator.getInstantiator((int)inst.getId())).isNotNull();
                    LongWrapper value = (LongWrapper)region.get(key2);
                    Assertions.assertThat((Object)value).isNotNull();
                    Assertions.assertThat((long)value.longValue).isEqualTo(123612L);
                    inst = (DSLongWrapper.DSLongWrapperInstantiator)InternalInstantiator.getInstantiator((int)inst.getId());
                    Assertions.assertThat((Object)((Object)inst)).isNotNull();
                    Assertions.assertThat((boolean)inst.wasInvoked).isTrue();
                }
            };
            vm0.invoke(get2);
            vm1.invoke(get2);
        }
        finally {
            Wait.pause(1500);
            MultiVMRegionTestCase.unregisterAllSerializers();
        }
    }

    private static void unregisterAllSerializers() {
        DistributedTestUtils.unregisterAllDataSerializersFromAllVms();
    }

    private void assertCacheCallbackEvents(String regionName, TransactionId txId, Object key, Object oldValue, Object newValue) {
        Region re = this.getCache().getRegion("root").getSubregion(regionName);
        MyTransactionListener tl = (MyTransactionListener)MultiVMRegionTestCase.firstTransactionListenerFrom(this.getCache().getCacheTransactionManager());
        tl.expectedTxId = txId;
        ((MapAssert)Assertions.assertThat((Map)re).describedAs("Cannot assert TX Callout Events with a null Region: " + regionName, new Object[0])).isNotNull();
        CountingDistCacheListener cdcl = (CountingDistCacheListener)re.getAttributes().getCacheListeners()[0];
        Awaitility.await((String)"retry event = null where it should not be").atMost(1L, TimeUnit.MINUTES).pollInterval(200L, TimeUnit.MILLISECONDS).until(() -> cdcl.getEntryEvent() != null);
        EntryEvent listenEvent = cdcl.getEntryEvent();
        ((ObjectAssert)Assertions.assertThat(listenEvent).describedAs("Cannot assert TX CacheListener Events with a null Entry Event", new Object[0])).isNotNull();
        Assertions.assertThat((Map)listenEvent.getRegion()).isEqualTo((Object)re);
        Assertions.assertThat((Object)listenEvent.getTransactionId()).isEqualTo((Object)txId);
        Assertions.assertThat((Object)listenEvent.getKey()).isEqualTo(key);
        Assertions.assertThat((Object)listenEvent.getOldValue()).isEqualTo(oldValue);
        Assertions.assertThat((Object)listenEvent.getNewValue()).isEqualTo(newValue);
        Assertions.assertThat((Object)listenEvent.getCallbackArgument()).isNull();
        Assertions.assertThat((boolean)listenEvent.isCallbackArgumentAvailable()).isTrue();
        Assertions.assertThat((boolean)listenEvent.getOperation().isLoad()).isFalse();
        Assertions.assertThat((boolean)listenEvent.getOperation().isNetLoad()).isFalse();
        Assertions.assertThat((boolean)listenEvent.getOperation().isNetSearch()).isFalse();
        Assertions.assertThat((boolean)listenEvent.getOperation().isLocalLoad()).isFalse();
        Assertions.assertThat((boolean)listenEvent.getOperation().isDistributed()).isTrue();
        Assertions.assertThat((boolean)listenEvent.getOperation().isExpiration()).isFalse();
        Assertions.assertThat((boolean)listenEvent.isOriginRemote()).isTrue();
        cdcl.setEntryEvent(null);
    }

    @Test
    public void testTXSimpleOps() {
        Assumptions.assumeThat((boolean)this.supportsTransactions()).isTrue();
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        CacheTransactionManager txMgr = this.getCache().getCacheTransactionManager();
        if (this.getRegionAttributes().getScope().isGlobal() || this.getRegionAttributes().getDataPolicy().withPersistence()) {
            Region rgn = this.createRegion(this.getUniqueName());
            txMgr.begin();
            Assertions.assertThatThrownBy(() -> {
                String cfr_ignored_0 = (String)rgn.put((Object)"testTXSimpleOpsKey1", (Object)"val");
            }).isInstanceOf(UnsupportedOperationException.class);
            txMgr.rollback();
            rgn.localDestroyRegion();
            return;
        }
        final String rgnName = this.getUniqueName();
        SerializableRunnable create = new SerializableRunnable("testTXSimpleOps: Create Region"){

            @Override
            public void run() {
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = new MyTransactionListener();
                MultiVMRegionTestCase.setTxListener(txMgr2, tl);
                Assertions.assertThat((Object)tl.lastEvent).isNull();
                Assertions.assertThat((int)tl.afterCommitCount).isEqualTo(0);
                Assertions.assertThat((int)tl.afterFailedCommitCount).isEqualTo(0);
                Assertions.assertThat((int)tl.afterRollbackCount).isEqualTo(0);
                Assertions.assertThat((int)tl.closeCount).isEqualTo(0);
                try {
                    Region rgn = MultiVMRegionTestCase.this.createRegion(rgnName);
                    CountingDistCacheListener cacheListener = new CountingDistCacheListener();
                    rgn.getAttributesMutator().addCacheListener(cacheListener);
                    cacheListener.assertCount(0, 0, 0, 0);
                    MultiVMRegionTestCase.this.getSystem().getLogWriter().info("testTXSimpleOps: Created region");
                }
                catch (CacheException e) {
                    Assertions.fail((String)"While creating region", (Throwable)e);
                }
            }
        };
        SerializableRunnable newKey = new SerializableRunnable("testTXSimpleOps: Create Region & Create Key"){

            @Override
            public void run() {
                try {
                    Region root = MultiVMRegionTestCase.this.getRootRegion();
                    Region rgn = root.getSubregion(rgnName);
                    rgn.create((Object)"key", null);
                    CountingDistCacheListener cacheListener = (CountingDistCacheListener)rgn.getAttributes().getCacheListeners()[0];
                    cacheListener.assertCount(0, 0, 0, 0);
                    MultiVMRegionTestCase.this.getSystem().getLogWriter().info("testTXSimpleOps: Created Key");
                }
                catch (CacheException e) {
                    Assertions.fail((String)"While creating region", (Throwable)e);
                }
            }
        };
        VM vm = VM.getVM(0);
        vm.invoke(create);
        vm.invoke(newKey);
        int vmCount = VM.getVMCount();
        for (int i = 1; i < vmCount; ++i) {
            vm = VM.getVM(i);
            vm.invoke(create);
            if (this.getRegionAttributes().getDataPolicy().withReplication() || this.getRegionAttributes().getDataPolicy().withPreloaded()) continue;
            vm.invoke(newKey);
        }
        try {
            Region rgn = this.createRegion(rgnName);
            DMStats dmStats = this.getSystem().getDistributionManager().getStats();
            long cmtMsgs = dmStats.getSentCommitMessages();
            long commitWaits = dmStats.getCommitWaits();
            txMgr.begin();
            rgn.put((Object)"key", (Object)"value");
            final TransactionId txId = txMgr.getTransactionId();
            txMgr.commit();
            Assertions.assertThat((long)dmStats.getSentCommitMessages()).isEqualTo(cmtMsgs + 1L);
            if (rgn.getAttributes().getScope().isAck()) {
                Assertions.assertThat((long)dmStats.getCommitWaits()).isEqualTo(commitWaits + 1L);
            } else {
                Assertions.assertThat((long)dmStats.getCommitWaits()).isEqualTo(commitWaits);
            }
            this.getSystem().getLogWriter().info("testTXSimpleOps: Create/Put Value");
            Invoke.invokeInEveryVM(new SerializableRunnable(){

                @Override
                public void run() {
                    MultiVMRegionTestCase.this.assertCacheCallbackEvents(rgnName, txId, "key", null, "value");
                }
            });
            Invoke.invokeInEveryVM(this.repeatingIfNecessary(new CacheSerializableRunnable("testTXSimpleOps: Verify Received Value"){

                @Override
                public void run2() {
                    Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                    ((ObjectAssert)Assertions.assertThat((Object)rgn1.getEntry((Object)"key")).describedAs("Could not find entry for 'key'", new Object[0])).isNotNull();
                    Assertions.assertThat((String)((String)rgn1.getEntry((Object)"key").getValue())).isEqualTo((Object)"value");
                    CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                    MyTransactionListener tl = (MyTransactionListener)MultiVMRegionTestCase.firstTransactionListenerFrom(txMgr2);
                    tl.checkAfterCommitCount(1);
                    Assertions.assertThat((int)tl.afterFailedCommitCount).isEqualTo(0);
                    Assertions.assertThat((int)tl.afterRollbackCount).isEqualTo(0);
                    Assertions.assertThat((int)tl.closeCount).isEqualTo(0);
                    Assertions.assertThat((Object)tl.lastEvent.getCache()).isEqualTo((Object)rgn1.getRegionService());
                    RegionAttributes attr = MultiVMRegionTestCase.this.getRegionAttributes();
                    List events = !attr.getDataPolicy().withReplication() || attr.getConcurrencyChecksEnabled() ? TxEventTestUtil.getPutEvents((List)tl.lastEvent.getEvents()) : TxEventTestUtil.getCreateEvents((List)tl.lastEvent.getEvents());
                    Assertions.assertThat((int)events.size()).isEqualTo(1);
                    EntryEvent ev = (EntryEvent)events.iterator().next();
                    Assertions.assertThat((Object)ev.getTransactionId()).isEqualTo((Object)tl.expectedTxId);
                    Assertions.assertThat((Map)rgn1).isSameAs((Object)ev.getRegion());
                    Assertions.assertThat((Object)ev.getKey()).isEqualTo((Object)"key");
                    Assertions.assertThat((Object)ev.getNewValue()).isEqualTo((Object)"value");
                    Assertions.assertThat((Object)ev.getOldValue()).isNull();
                    Assertions.assertThat((boolean)ev.getOperation().isLocalLoad()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isNetLoad()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isLoad()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isNetSearch()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isExpiration()).isFalse();
                    Assertions.assertThat((Object)ev.getCallbackArgument()).isNull();
                    Assertions.assertThat((boolean)ev.isCallbackArgumentAvailable()).isTrue();
                    Assertions.assertThat((boolean)ev.isOriginRemote()).isTrue();
                    Assertions.assertThat((boolean)ev.getOperation().isDistributed()).isTrue();
                    CountingDistCacheListener cdcL = (CountingDistCacheListener)rgn1.getAttributes().getCacheListeners()[0];
                    cdcL.assertCount(0, 1, 0, 0);
                }
            }));
            txMgr.begin();
            rgn.put((Object)"key", (Object)"value2");
            txId = txMgr.getTransactionId();
            txMgr.commit();
            this.getSystem().getLogWriter().info("testTXSimpleOps: Put(update) Value2");
            Invoke.invokeInEveryVM(new SerializableRunnable(){

                @Override
                public void run() {
                    MultiVMRegionTestCase.this.assertCacheCallbackEvents(rgnName, txId, "key", "value", "value2");
                }
            });
            Invoke.invokeInEveryVM(this.repeatingIfNecessary(new CacheSerializableRunnable("testTXSimpleOps: Verify Received Value"){

                @Override
                public void run2() {
                    Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                    ((ObjectAssert)Assertions.assertThat((Object)rgn1.getEntry((Object)"key")).describedAs("Could not find entry for 'key'", new Object[0])).isNotNull();
                    Assertions.assertThat((String)((String)rgn1.getEntry((Object)"key").getValue())).isEqualTo((Object)"value2");
                    CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                    MyTransactionListener tl = (MyTransactionListener)MultiVMRegionTestCase.firstTransactionListenerFrom(txMgr2);
                    tl.checkAfterCommitCount(2);
                    Assertions.assertThat((Object)tl.lastEvent.getCache()).isEqualTo((Object)rgn1.getRegionService());
                    List events = TxEventTestUtil.getPutEvents((List)tl.lastEvent.getEvents());
                    Assertions.assertThat((int)events.size()).isEqualTo(1);
                    EntryEvent ev = (EntryEvent)events.iterator().next();
                    Assertions.assertThat((Object)ev.getTransactionId()).isEqualTo((Object)tl.expectedTxId);
                    Assertions.assertThat((Map)rgn1).isSameAs((Object)ev.getRegion());
                    Assertions.assertThat((String)((String)ev.getKey())).isEqualTo((Object)"key");
                    Assertions.assertThat((String)((String)ev.getNewValue())).isEqualTo((Object)"value2");
                    Assertions.assertThat((String)((String)ev.getOldValue())).isEqualTo((Object)"value");
                    Assertions.assertThat((boolean)ev.getOperation().isLocalLoad()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isNetLoad()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isLoad()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isNetSearch()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isExpiration()).isFalse();
                    Assertions.assertThat((Object)ev.getCallbackArgument()).isNull();
                    Assertions.assertThat((boolean)ev.isCallbackArgumentAvailable()).isTrue();
                    Assertions.assertThat((boolean)ev.isOriginRemote()).isTrue();
                    Assertions.assertThat((boolean)ev.getOperation().isDistributed()).isTrue();
                    CountingDistCacheListener cdcL = (CountingDistCacheListener)rgn1.getAttributes().getCacheListeners()[0];
                    cdcL.assertCount(0, 2, 0, 0);
                }
            }));
            txMgr.begin();
            rgn.invalidate((Object)"key");
            txId = txMgr.getTransactionId();
            txMgr.commit();
            this.getSystem().getLogWriter().info("testTXSimpleOps: invalidate key");
            Invoke.invokeInEveryVM(new SerializableRunnable(){

                @Override
                public void run() {
                    MultiVMRegionTestCase.this.assertCacheCallbackEvents(rgnName, txId, "key", "value2", null);
                }
            });
            Invoke.invokeInEveryVM(this.repeatingIfNecessary(new CacheSerializableRunnable("testTXSimpleOps: Verify Received Value"){

                @Override
                public void run2() {
                    Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                    ((ObjectAssert)Assertions.assertThat((Object)rgn1.getEntry((Object)"key")).describedAs("entry for 'key'", new Object[0])).isNotNull();
                    Assertions.assertThat((boolean)rgn1.containsKey((Object)"key")).isTrue();
                    Assertions.assertThat((boolean)rgn1.containsValueForKey((Object)"key")).isFalse();
                    CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                    MyTransactionListener tl = (MyTransactionListener)MultiVMRegionTestCase.firstTransactionListenerFrom(txMgr2);
                    tl.checkAfterCommitCount(3);
                    Assertions.assertThat((Object)tl.lastEvent.getCache()).isEqualTo((Object)rgn1.getRegionService());
                    List events = TxEventTestUtil.getInvalidateEvents((List)tl.lastEvent.getEvents());
                    Assertions.assertThat((int)events.size()).isEqualTo(1);
                    EntryEvent ev = (EntryEvent)events.get(0);
                    Assertions.assertThat((Object)ev.getTransactionId()).isEqualTo((Object)tl.expectedTxId);
                    Assertions.assertThat((Map)rgn1).isSameAs((Object)ev.getRegion());
                    Assertions.assertThat((String)((String)ev.getKey())).isEqualTo((Object)"key");
                    Assertions.assertThat((String)((String)ev.getNewValue())).isNull();
                    Assertions.assertThat((String)((String)ev.getOldValue())).isEqualTo((Object)"value2");
                    Assertions.assertThat((boolean)ev.getOperation().isLocalLoad()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isNetLoad()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isLoad()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isNetSearch()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isExpiration()).isFalse();
                    Assertions.assertThat((Object)ev.getCallbackArgument()).isNull();
                    Assertions.assertThat((boolean)ev.isCallbackArgumentAvailable()).isTrue();
                    Assertions.assertThat((boolean)ev.isOriginRemote()).isTrue();
                    Assertions.assertThat((boolean)ev.getOperation().isDistributed()).isTrue();
                    CountingDistCacheListener cdcL = (CountingDistCacheListener)rgn1.getAttributes().getCacheListeners()[0];
                    cdcL.assertCount(0, 2, 1, 0);
                }
            }));
            txMgr.begin();
            rgn.destroy((Object)"key");
            txId = txMgr.getTransactionId();
            txMgr.commit();
            this.getSystem().getLogWriter().info("testTXSimpleOps: destroy key");
            Invoke.invokeInEveryVM(new SerializableRunnable(){

                @Override
                public void run() {
                    MultiVMRegionTestCase.this.assertCacheCallbackEvents(rgnName, txId, "key", null, null);
                }
            });
            Invoke.invokeInEveryVM(this.repeatingIfNecessary(new CacheSerializableRunnable("testTXSimpleOps: Verify Received Value"){

                @Override
                public void run2() {
                    Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                    Assertions.assertThat((boolean)rgn1.containsKey((Object)"key")).isFalse();
                    CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                    MyTransactionListener tl = (MyTransactionListener)MultiVMRegionTestCase.firstTransactionListenerFrom(txMgr2);
                    tl.checkAfterCommitCount(4);
                    Assertions.assertThat((Object)tl.lastEvent.getCache()).isEqualTo((Object)rgn1.getRegionService());
                    List events = TxEventTestUtil.getDestroyEvents((List)tl.lastEvent.getEvents());
                    Assertions.assertThat((int)events.size()).isEqualTo(1);
                    EntryEvent ev = (EntryEvent)events.iterator().next();
                    Assertions.assertThat((Object)ev.getTransactionId()).isEqualTo((Object)tl.expectedTxId);
                    Assertions.assertThat((Map)rgn1).isSameAs((Object)ev.getRegion());
                    Assertions.assertThat((String)((String)ev.getKey())).isEqualTo((Object)"key");
                    Assertions.assertThat((String)((String)ev.getNewValue())).isNull();
                    Assertions.assertThat((String)((String)ev.getOldValue())).isNull();
                    Assertions.assertThat((boolean)ev.getOperation().isLocalLoad()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isNetLoad()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isLoad()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isNetSearch()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isExpiration()).isFalse();
                    Assertions.assertThat((Object)ev.getCallbackArgument()).isNull();
                    Assertions.assertThat((boolean)ev.isCallbackArgumentAvailable()).isTrue();
                    Assertions.assertThat((boolean)ev.isOriginRemote()).isTrue();
                    Assertions.assertThat((boolean)ev.getOperation().isDistributed()).isTrue();
                    CountingDistCacheListener cdcL = (CountingDistCacheListener)rgn1.getAttributes().getCacheListeners()[0];
                    cdcL.assertCount(0, 2, 1, 1);
                }
            }));
        }
        catch (Exception e) {
            this.getCache().close();
            this.getSystem().getLogWriter().fine("testTXSimpleOps: Caused exception in createRegion");
            throw e;
        }
    }

    protected boolean supportsTransactions() {
        return true;
    }

    @Ignore(value="TODO: this test always hits early out")
    @Test
    public void testTXUpdateLoadNoConflict() {
        Assumptions.assumeThat((boolean)this.supportsTransactions()).isTrue();
        Assumptions.assumeThat((boolean)this.getRegionAttributes().getScope().isGlobal()).isFalse();
        Assumptions.assumeThat((boolean)this.getRegionAttributes().getDataPolicy().withPersistence()).isFalse();
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        CacheTransactionManager txMgr = this.getCache().getCacheTransactionManager();
        final String rgnName = this.getUniqueName();
        SerializableRunnable create = new SerializableRunnable("testTXUpdateLoadNoConflict: Create Region & Load value"){

            @Override
            public void run() {
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = new MyTransactionListener();
                MultiVMRegionTestCase.setTxListener(txMgr2, tl);
                try {
                    Region rgn = MultiVMRegionTestCase.this.createRegion(rgnName);
                    AttributesMutator mutator = rgn.getAttributesMutator();
                    mutator.setCacheLoader((CacheLoader)new CacheLoader<String, String>(){
                        int count = 0;

                        public String load(LoaderHelper<String, String> helper) throws CacheLoaderException {
                            ++this.count;
                            return "LV " + this.count;
                        }

                        public void close() {
                        }
                    });
                    Object value = rgn.get((Object)"key");
                    Assertions.assertThat((Object)value).isEqualTo((Object)"LV 1");
                    MultiVMRegionTestCase.this.getSystem().getLogWriter().info("testTXUpdateLoadNoConflict: loaded Key");
                    MultiVMRegionTestCase.this.flushIfNecessary(rgn);
                }
                catch (CacheException e) {
                    Assertions.fail((String)"While creating region", (Throwable)e);
                }
            }
        };
        VM vm0 = VM.getVM(0);
        try {
            MyTransactionListener tl = new MyTransactionListener();
            MultiVMRegionTestCase.setTxListener(txMgr, tl);
            AttributesFactory rgnAtts = new AttributesFactory(this.getRegionAttributes());
            rgnAtts.setDataPolicy(DataPolicy.REPLICATE);
            Region rgn = this.createRegion(rgnName, rgnAtts.create());
            txMgr.begin();
            TransactionId myTXId = txMgr.getTransactionId();
            rgn.create((Object)"key", (Object)"txValue");
            vm0.invoke(create);
            TXStateProxy tx = ((TXManagerImpl)txMgr).pauseTransaction();
            Assertions.assertThat((boolean)rgn.containsKey((Object)"key")).isTrue();
            Assertions.assertThat((String)((String)rgn.getEntry((Object)"key").getValue())).isEqualTo((Object)"LV 1");
            ((TXManagerImpl)txMgr).unpauseTransaction(tx);
            Assertions.assertThat((String)((String)rgn.getEntry((Object)"key").getValue())).isEqualTo((Object)"txValue");
            txMgr.commit();
            this.getSystem().getLogWriter().info("testTXUpdateLoadNoConflict: did commit");
            Assertions.assertThat((String)((String)rgn.getEntry((Object)"key").getValue())).isEqualTo((Object)"txValue");
            List events = TxEventTestUtil.getCreateEvents((List)tl.lastEvent.getEvents());
            Assertions.assertThat((int)events.size()).isEqualTo(1);
            EntryEvent ev = (EntryEvent)events.iterator().next();
            Assertions.assertThat((Object)ev.getTransactionId()).isEqualTo((Object)myTXId);
            Assertions.assertThat(rgn).isSameAs((Object)ev.getRegion());
            Assertions.assertThat((String)((String)ev.getKey())).isEqualTo((Object)"key");
            Assertions.assertThat((String)((String)ev.getNewValue())).isEqualTo((Object)"txValue");
            Assertions.assertThat((String)((String)ev.getOldValue())).isNull();
            Assertions.assertThat((boolean)ev.getOperation().isLocalLoad()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isNetLoad()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isLoad()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isNetSearch()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isExpiration()).isFalse();
            Assertions.assertThat((Object)ev.getCallbackArgument()).isNull();
            Assertions.assertThat((boolean)ev.isCallbackArgumentAvailable()).isTrue();
            Assertions.assertThat((boolean)ev.isOriginRemote()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isDistributed()).isTrue();
            rgn.localDestroyRegion();
            rgnAtts.setDataPolicy(DataPolicy.NORMAL);
            rgn = this.createRegion(rgnName, rgnAtts.create());
            Object v2 = rgn.get((Object)"key2");
            Assertions.assertThat((Object)v2).isEqualTo((Object)"LV 2");
            txMgr.begin();
            myTXId = txMgr.getTransactionId();
            rgn.create((Object)"key3", (Object)"txValue3");
            TXStateProxy tx2 = ((TXManagerImpl)txMgr).pauseTransaction();
            Object v3 = rgn.get((Object)"key3");
            Assertions.assertThat((Object)v3).isEqualTo((Object)"LV 3");
            ((TXManagerImpl)txMgr).unpauseTransaction(tx2);
            Assertions.assertThat((String)((String)rgn.getEntry((Object)"key3").getValue())).isEqualTo((Object)"txValue3");
            txMgr.commit();
            this.getSystem().getLogWriter().info("testTXUpdateLoadNoConflict: did commit");
            Assertions.assertThat((String)((String)rgn.getEntry((Object)"key3").getValue())).isEqualTo((Object)"txValue3");
            List events2 = TxEventTestUtil.getCreateEvents((List)tl.lastEvent.getEvents());
            Assertions.assertThat((int)events2.size()).isEqualTo(1);
            EntryEvent ev2 = (EntryEvent)events2.iterator().next();
            Assertions.assertThat((Object)ev2.getTransactionId()).isEqualTo((Object)myTXId);
            Assertions.assertThat(rgn).isSameAs((Object)ev2.getRegion());
            Assertions.assertThat((String)((String)ev2.getKey())).isEqualTo((Object)"key3");
            Assertions.assertThat((String)((String)ev2.getNewValue())).isEqualTo((Object)"txValue3");
            Assertions.assertThat((String)((String)ev2.getOldValue())).isNull();
            Assertions.assertThat((boolean)ev2.getOperation().isLocalLoad()).isFalse();
            Assertions.assertThat((boolean)ev2.getOperation().isNetLoad()).isFalse();
            Assertions.assertThat((boolean)ev2.getOperation().isLoad()).isFalse();
            Assertions.assertThat((boolean)ev2.getOperation().isNetSearch()).isFalse();
            Assertions.assertThat((boolean)ev2.getOperation().isExpiration()).isFalse();
            Assertions.assertThat((Object)ev2.getCallbackArgument()).isNull();
            Assertions.assertThat((boolean)ev2.isCallbackArgumentAvailable()).isTrue();
            Assertions.assertThat((boolean)ev2.isOriginRemote()).isFalse();
            Assertions.assertThat((boolean)ev2.getOperation().isDistributed()).isTrue();
            txMgr.begin();
            Object v4 = rgn.get((Object)"key4");
            Assertions.assertThat((Object)v4).isEqualTo((Object)"LV 4");
            Assertions.assertThat((String)((String)rgn.get((Object)"key4"))).isEqualTo((Object)"LV 4");
            Assertions.assertThat((String)((String)rgn.getEntry((Object)"key4").getValue())).isEqualTo((Object)"LV 4");
            txMgr.rollback();
            Assertions.assertThat((String)((String)rgn.get((Object)"key4"))).isEqualTo((Object)"LV 5");
            Assertions.assertThat((String)((String)rgn.getEntry((Object)"key4").getValue())).isEqualTo((Object)"LV 5");
            Assertions.assertThat((String)((String)rgn.get((Object)"key"))).isEqualTo((Object)"txValue");
            Assertions.assertThat((String)((String)rgn.getEntry((Object)"key").getValue())).isEqualTo((Object)"txValue");
            rgn.localInvalidate((Object)"key");
            txMgr.begin();
            myTXId = txMgr.getTransactionId();
            rgn.put((Object)"key", (Object)"new txValue");
            TXStateProxy tx3 = ((TXManagerImpl)txMgr).pauseTransaction();
            Assertions.assertThat((String)((String)rgn.get((Object)"key"))).isEqualTo((Object)"txValue");
            Assertions.assertThat((String)((String)rgn.getEntry((Object)"key").getValue())).isEqualTo((Object)"txValue");
            ((TXManagerImpl)txMgr).unpauseTransaction(tx3);
            Assertions.assertThat((String)((String)rgn.getEntry((Object)"key").getValue())).isEqualTo((Object)"new txValue");
            txMgr.commit();
            this.flushIfNecessary(rgn);
            this.getSystem().getLogWriter().info("testTXUpdateLoadNoConflict: did commit");
            Assertions.assertThat((String)((String)rgn.getEntry((Object)"key").getValue())).isEqualTo((Object)"new txValue");
            List events3 = TxEventTestUtil.getPutEvents((List)tl.lastEvent.getEvents());
            Assertions.assertThat((int)events3.size()).isEqualTo(1);
            EntryEvent ev3 = (EntryEvent)events3.iterator().next();
            Assertions.assertThat((Object)ev3.getTransactionId()).isEqualTo((Object)myTXId);
            Assertions.assertThat(rgn).isSameAs((Object)ev3.getRegion());
            Assertions.assertThat((String)((String)ev3.getKey())).isEqualTo((Object)"key");
            Assertions.assertThat((String)((String)ev3.getNewValue())).isEqualTo((Object)"new txValue");
            Assertions.assertThat((String)((String)ev3.getOldValue())).isNull();
            Assertions.assertThat((boolean)ev3.getOperation().isLocalLoad()).isFalse();
            Assertions.assertThat((boolean)ev3.getOperation().isNetLoad()).isFalse();
            Assertions.assertThat((boolean)ev3.getOperation().isLoad()).isFalse();
            Assertions.assertThat((boolean)ev3.getOperation().isNetSearch()).isFalse();
            Assertions.assertThat((boolean)ev3.getOperation().isExpiration()).isFalse();
            Assertions.assertThat((Object)ev3.getCallbackArgument()).isNull();
            Assertions.assertThat((boolean)ev3.isCallbackArgumentAvailable()).isTrue();
            Assertions.assertThat((boolean)ev3.isOriginRemote()).isFalse();
            Assertions.assertThat((boolean)ev3.getOperation().isDistributed()).isTrue();
            Object localCmtValue = rgn.getEntry((Object)"key").getValue();
            txMgr.begin();
            Assertions.assertThat((String)((String)rgn.getEntry((Object)"key").getValue())).isSameAs(localCmtValue);
            rgn.localInvalidate((Object)"key");
            Assertions.assertThat((String)((String)rgn.getEntry((Object)"key").getValue())).isNull();
            Object txValue = rgn.get((Object)"key");
            Assertions.assertThat((Object)txValue).isNotSameAs(localCmtValue);
            Assertions.assertThat((String)((String)rgn.get((Object)"key"))).isSameAs(txValue);
            Assertions.assertThat((String)((String)rgn.getEntry((Object)"key").getValue())).isNotSameAs(localCmtValue);
            Assertions.assertThat((String)((String)rgn.getEntry((Object)"key").getValue())).isEqualTo(localCmtValue);
            rgn.invalidate((Object)"key");
            Assertions.assertThat((String)((String)rgn.getEntry((Object)"key").getValue())).isNull();
            txValue = rgn.get((Object)"key");
            Assertions.assertThat((Object)txValue).isEqualTo((Object)"LV 6");
            Assertions.assertThat((String)((String)rgn.get((Object)"key"))).isSameAs(txValue);
            Assertions.assertThat((String)((String)rgn.getEntry((Object)"key").getValue())).isEqualTo((Object)"LV 6");
            txMgr.rollback();
            Assertions.assertThat((String)((String)rgn.getEntry((Object)"key").getValue())).isSameAs(localCmtValue);
        }
        catch (Exception e) {
            this.getCache().close();
            this.getSystem().getLogWriter().fine("testTXUpdateLoadNoConflict: Caused exception in createRegion");
            throw e;
        }
    }

    @Test
    public void testTXMultiRegion() {
        Assumptions.assumeThat((boolean)this.supportsTransactions()).isTrue();
        Assumptions.assumeThat((boolean)this.getRegionAttributes().getScope().isGlobal()).isFalse();
        Assumptions.assumeThat((boolean)this.getRegionAttributes().getDataPolicy().withPersistence()).isFalse();
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        CacheTransactionManager txMgr = this.getCache().getCacheTransactionManager();
        final String rgnName1 = this.getUniqueName() + "MR1";
        final String rgnName2 = this.getUniqueName() + "MR2";
        final String rgnName3 = this.getUniqueName() + "MR3";
        SerializableRunnable create1 = new SerializableRunnable("testTXMultiRegion: Create Region"){

            @Override
            public void run() {
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = new MyTransactionListener();
                MultiVMRegionTestCase.setTxListener(txMgr2, tl);
                try {
                    MultiVMRegionTestCase.this.createRegion(rgnName1);
                    MultiVMRegionTestCase.this.getSystem().getLogWriter().info("testTXMultiRegion: Created region1");
                }
                catch (CacheException e) {
                    Assertions.fail((String)"While creating region", (Throwable)e);
                }
            }
        };
        SerializableRunnable newKey1 = new SerializableRunnable("testTXMultiRegion: Create Key"){

            @Override
            public void run() {
                try {
                    Region rgn = MultiVMRegionTestCase.this.getRootRegion("root").getSubregion(rgnName1);
                    rgn.create((Object)"key", null);
                    MultiVMRegionTestCase.this.getSystem().getLogWriter().info("testTXMultiRegion: Created key");
                }
                catch (CacheException e) {
                    Assertions.fail((String)"While creating region", (Throwable)e);
                }
            }
        };
        SerializableRunnable create2 = new SerializableRunnable("testTXMultiRegion: Create Region"){

            @Override
            public void run() {
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = new MyTransactionListener();
                MultiVMRegionTestCase.setTxListener(txMgr2, tl);
                try {
                    MultiVMRegionTestCase.this.createRegion(rgnName2);
                    MultiVMRegionTestCase.this.getSystem().getLogWriter().info("testTXMultiRegion: Created region2");
                }
                catch (CacheException e) {
                    Assertions.fail((String)"While creating region", (Throwable)e);
                }
            }
        };
        SerializableRunnable newKey2 = new SerializableRunnable("testTXMultiRegion: Create Key"){

            @Override
            public void run() {
                try {
                    Region root = MultiVMRegionTestCase.this.getRootRegion("root");
                    Region rgn = root.getSubregion(rgnName2);
                    rgn.create((Object)"key", null);
                    MultiVMRegionTestCase.this.getSystem().getLogWriter().info("testTXMultiRegion: Created Key");
                }
                catch (CacheException e) {
                    Assertions.fail((String)"While creating region", (Throwable)e);
                }
            }
        };
        SerializableRunnable create3 = new SerializableRunnable("testTXMultiRegion: Create Region"){

            @Override
            public void run() {
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = new MyTransactionListener();
                MultiVMRegionTestCase.setTxListener(txMgr2, tl);
                try {
                    MultiVMRegionTestCase.this.createRegion(rgnName3);
                    MultiVMRegionTestCase.this.getSystem().getLogWriter().info("testTXMultiRegion: Created Region");
                }
                catch (CacheException e) {
                    Assertions.fail((String)"While creating region", (Throwable)e);
                }
            }
        };
        SerializableRunnable newKey3 = new SerializableRunnable("testTXMultiRegion: Create Key"){

            @Override
            public void run() {
                try {
                    Region root = MultiVMRegionTestCase.this.getRootRegion("root");
                    Region rgn = root.getSubregion(rgnName3);
                    rgn.create((Object)"key", null);
                    MultiVMRegionTestCase.this.getSystem().getLogWriter().info("testTXMultiRegion: Created Key");
                }
                catch (CacheException e) {
                    Assertions.fail((String)"While creating region", (Throwable)e);
                }
            }
        };
        SerializableRunnable check1_3 = new SerializableRunnable("testTXMultiRegion: check"){

            @Override
            public void run() {
                Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName1);
                ((ObjectAssert)Assertions.assertThat((Object)rgn1.getEntry((Object)"key")).describedAs("Could not find entry for 'key'", new Object[0])).isNotNull();
                Assertions.assertThat((String)((String)rgn1.getEntry((Object)"key").getValue())).isEqualTo((Object)"value1");
                Region rgn3 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName3);
                ((ObjectAssert)Assertions.assertThat((Object)rgn3.getEntry((Object)"key")).describedAs("Could not find entry for 'key'", new Object[0])).isNotNull();
                Assertions.assertThat((String)((String)rgn3.getEntry((Object)"key").getValue())).isEqualTo((Object)"value3");
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = (MyTransactionListener)MultiVMRegionTestCase.firstTransactionListenerFrom(txMgr2);
                tl.checkAfterCommitCount(1);
                Assertions.assertThat((int)tl.afterFailedCommitCount).isEqualTo(0);
                Assertions.assertThat((int)tl.afterRollbackCount).isEqualTo(0);
                Assertions.assertThat((int)tl.closeCount).isEqualTo(0);
                Assertions.assertThat((Object)tl.lastEvent.getCache()).isEqualTo((Object)rgn1.getRegionService());
                RegionAttributes attr = MultiVMRegionTestCase.this.getRegionAttributes();
                List events = !attr.getDataPolicy().withReplication() || attr.getConcurrencyChecksEnabled() ? TxEventTestUtil.getPutEvents((List)tl.lastEvent.getEvents()) : TxEventTestUtil.getCreateEvents((List)tl.lastEvent.getEvents());
                Assertions.assertThat((int)events.size()).isEqualTo(2);
                ArrayList eventList = new ArrayList(events);
                eventList.sort((o1, o2) -> {
                    String s1 = o1.getRegion().getFullPath() + (String)o1.getKey();
                    String s2 = o2.getRegion().getFullPath() + (String)o2.getKey();
                    return s1.compareTo(s2);
                });
                MultiVMRegionTestCase.this.verifyMirrorRegionEventsMatch((EntryEvent<String, String>)((EntryEvent)eventList.get(0)), rgn1, "value1");
                MultiVMRegionTestCase.this.verifyMirrorRegionEventsMatch((EntryEvent<String, String>)((EntryEvent)eventList.get(1)), rgn3, "value3");
            }
        };
        SerializableRunnable check2_3 = new SerializableRunnable("testTXMultiRegion: check"){

            @Override
            public void run() {
                Region rgn2 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName2);
                ((ObjectAssert)Assertions.assertThat((Object)rgn2.getEntry((Object)"key")).describedAs("Could not find entry for 'key'", new Object[0])).isNotNull();
                Assertions.assertThat((Object)rgn2.getEntry((Object)"key").getValue()).isEqualTo((Object)"value2");
                Region rgn3 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName3);
                ((ObjectAssert)Assertions.assertThat((Object)rgn3.getEntry((Object)"key")).describedAs("Could not find entry for 'key'", new Object[0])).isNotNull();
                Assertions.assertThat((Object)rgn3.getEntry((Object)"key").getValue()).isEqualTo((Object)"value3");
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = (MyTransactionListener)MultiVMRegionTestCase.firstTransactionListenerFrom(txMgr2);
                tl.checkAfterCommitCount(1);
                Assertions.assertThat((int)tl.afterFailedCommitCount).isEqualTo(0);
                Assertions.assertThat((int)tl.afterRollbackCount).isEqualTo(0);
                Assertions.assertThat((int)tl.closeCount).isEqualTo(0);
                Assertions.assertThat((Object)tl.lastEvent.getCache()).isEqualTo((Object)rgn2.getRegionService());
                RegionAttributes attr = MultiVMRegionTestCase.this.getRegionAttributes();
                List events = !attr.getDataPolicy().withReplication() || attr.getConcurrencyChecksEnabled() ? TxEventTestUtil.getPutEvents((List)tl.lastEvent.getEvents()) : TxEventTestUtil.getCreateEvents((List)tl.lastEvent.getEvents());
                Assertions.assertThat((int)events.size()).isEqualTo(2);
                ArrayList eventList = new ArrayList(events);
                eventList.sort((o1, o2) -> {
                    String s1 = o1.getRegion().getFullPath() + (String)o1.getKey();
                    String s2 = o2.getRegion().getFullPath() + (String)o2.getKey();
                    return s1.compareTo(s2);
                });
                MultiVMRegionTestCase.this.verifyMirrorRegionEventsMatch((EntryEvent<String, String>)((EntryEvent)eventList.get(0)), rgn2, "value2");
                MultiVMRegionTestCase.this.verifyMirrorRegionEventsMatch((EntryEvent<String, String>)((EntryEvent)eventList.get(1)), rgn3, "value3");
            }
        };
        SerializableRunnable check1 = new SerializableRunnable("testTXMultiRegion: check"){

            @Override
            public void run() {
                Region rgn = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName1);
                ((ObjectAssert)Assertions.assertThat((Object)rgn.getEntry((Object)"key")).describedAs("Could not find entry for 'key'", new Object[0])).isNotNull();
                Assertions.assertThat((String)((String)rgn.getEntry((Object)"key").getValue())).isEqualTo((Object)"value1");
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = (MyTransactionListener)MultiVMRegionTestCase.firstTransactionListenerFrom(txMgr2);
                tl.checkAfterCommitCount(1);
                Assertions.assertThat((int)tl.afterFailedCommitCount).isEqualTo(0);
                Assertions.assertThat((int)tl.afterRollbackCount).isEqualTo(0);
                Assertions.assertThat((int)tl.closeCount).isEqualTo(0);
                Assertions.assertThat((Object)tl.lastEvent.getCache()).isEqualTo((Object)rgn.getRegionService());
                RegionAttributes attr = MultiVMRegionTestCase.this.getRegionAttributes();
                List events = !attr.getDataPolicy().withReplication() || attr.getConcurrencyChecksEnabled() ? TxEventTestUtil.getPutEvents((List)tl.lastEvent.getEvents()) : TxEventTestUtil.getCreateEvents((List)tl.lastEvent.getEvents());
                Assertions.assertThat((int)events.size()).isEqualTo(1);
                EntryEvent ev = (EntryEvent)events.iterator().next();
                Assertions.assertThat((Map)rgn).isSameAs((Object)ev.getRegion());
                Assertions.assertThat((String)((String)ev.getKey())).isEqualTo((Object)"key");
                Assertions.assertThat((String)((String)ev.getNewValue())).isEqualTo((Object)"value1");
                Assertions.assertThat((String)((String)ev.getOldValue())).isNull();
                Assertions.assertThat((boolean)ev.getOperation().isLocalLoad()).isFalse();
                Assertions.assertThat((boolean)ev.getOperation().isNetLoad()).isFalse();
                Assertions.assertThat((boolean)ev.getOperation().isLoad()).isFalse();
                Assertions.assertThat((boolean)ev.getOperation().isNetSearch()).isFalse();
                Assertions.assertThat((boolean)ev.getOperation().isExpiration()).isFalse();
                Assertions.assertThat((Object)ev.getCallbackArgument()).isNull();
                Assertions.assertThat((boolean)ev.isCallbackArgumentAvailable()).isTrue();
                Assertions.assertThat((boolean)ev.isOriginRemote()).isTrue();
                Assertions.assertThat((boolean)ev.getOperation().isDistributed()).isTrue();
            }
        };
        SerializableRunnable check2 = new SerializableRunnable("testTXMultiRegion: check"){

            @Override
            public void run() {
                Region rgn = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName2);
                ((ObjectAssert)Assertions.assertThat((Object)rgn.getEntry((Object)"key")).describedAs("Could not find entry for 'key'", new Object[0])).isNotNull();
                Assertions.assertThat((String)((String)rgn.getEntry((Object)"key").getValue())).isEqualTo((Object)"value2");
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = (MyTransactionListener)MultiVMRegionTestCase.firstTransactionListenerFrom(txMgr2);
                tl.checkAfterCommitCount(1);
                Assertions.assertThat((int)tl.afterFailedCommitCount).isEqualTo(0);
                Assertions.assertThat((int)tl.afterRollbackCount).isEqualTo(0);
                Assertions.assertThat((int)tl.closeCount).isEqualTo(0);
                Assertions.assertThat((Object)tl.lastEvent.getCache()).isEqualTo((Object)rgn.getRegionService());
                RegionAttributes attr = MultiVMRegionTestCase.this.getRegionAttributes();
                List events = !attr.getDataPolicy().withReplication() || attr.getConcurrencyChecksEnabled() ? TxEventTestUtil.getPutEvents((List)tl.lastEvent.getEvents()) : TxEventTestUtil.getCreateEvents((List)tl.lastEvent.getEvents());
                Assertions.assertThat((int)events.size()).isEqualTo(1);
                EntryEvent ev = (EntryEvent)events.iterator().next();
                Assertions.assertThat((Map)rgn).isSameAs((Object)ev.getRegion());
                Assertions.assertThat((String)((String)ev.getKey())).isEqualTo((Object)"key");
                Assertions.assertThat((String)((String)ev.getNewValue())).isEqualTo((Object)"value2");
                Assertions.assertThat((String)((String)ev.getOldValue())).isNull();
                Assertions.assertThat((boolean)ev.getOperation().isLocalLoad()).isFalse();
                Assertions.assertThat((boolean)ev.getOperation().isNetLoad()).isFalse();
                Assertions.assertThat((boolean)ev.getOperation().isLoad()).isFalse();
                Assertions.assertThat((boolean)ev.getOperation().isNetSearch()).isFalse();
                Assertions.assertThat((boolean)ev.getOperation().isExpiration()).isFalse();
                Assertions.assertThat((Object)ev.getCallbackArgument()).isNull();
                Assertions.assertThat((boolean)ev.isCallbackArgumentAvailable()).isTrue();
                Assertions.assertThat((boolean)ev.isOriginRemote()).isTrue();
                Assertions.assertThat((boolean)ev.getOperation().isDistributed()).isTrue();
            }
        };
        SerializableRunnable check3 = new SerializableRunnable("testTXMultiRegion: check"){

            @Override
            public void run() {
                Region rgn = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName3);
                ((ObjectAssert)Assertions.assertThat((Object)rgn.getEntry((Object)"key")).describedAs("Could not find entry for 'key'", new Object[0])).isNotNull();
                Assertions.assertThat((String)((String)rgn.getEntry((Object)"key").getValue())).isEqualTo((Object)"value3");
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = (MyTransactionListener)MultiVMRegionTestCase.firstTransactionListenerFrom(txMgr2);
                tl.checkAfterCommitCount(1);
                Assertions.assertThat((int)tl.afterFailedCommitCount).isEqualTo(0);
                Assertions.assertThat((int)tl.afterRollbackCount).isEqualTo(0);
                Assertions.assertThat((int)tl.closeCount).isEqualTo(0);
                Assertions.assertThat((Object)tl.lastEvent.getCache()).isEqualTo((Object)rgn.getRegionService());
                RegionAttributes attr = MultiVMRegionTestCase.this.getRegionAttributes();
                List events = !attr.getDataPolicy().withReplication() || attr.getConcurrencyChecksEnabled() ? TxEventTestUtil.getPutEvents((List)tl.lastEvent.getEvents()) : TxEventTestUtil.getCreateEvents((List)tl.lastEvent.getEvents());
                Assertions.assertThat((int)events.size()).isEqualTo(1);
                EntryEvent ev = (EntryEvent)events.iterator().next();
                Assertions.assertThat((Map)rgn).isSameAs((Object)ev.getRegion());
                Assertions.assertThat((String)((String)ev.getKey())).isEqualTo((Object)"key");
                Assertions.assertThat((String)((String)ev.getNewValue())).isEqualTo((Object)"value3");
                Assertions.assertThat((String)((String)ev.getOldValue())).isNull();
                Assertions.assertThat((boolean)ev.getOperation().isLocalLoad()).isFalse();
                Assertions.assertThat((boolean)ev.getOperation().isNetLoad()).isFalse();
                Assertions.assertThat((boolean)ev.getOperation().isLoad()).isFalse();
                Assertions.assertThat((boolean)ev.getOperation().isNetSearch()).isFalse();
                Assertions.assertThat((boolean)ev.getOperation().isExpiration()).isFalse();
                Assertions.assertThat((Object)ev.getCallbackArgument()).isNull();
                Assertions.assertThat((boolean)ev.isCallbackArgumentAvailable()).isTrue();
                Assertions.assertThat((boolean)ev.isOriginRemote()).isTrue();
                Assertions.assertThat((boolean)ev.getOperation().isDistributed()).isTrue();
            }
        };
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        VM vm2 = VM.getVM(2);
        VM vm3 = VM.getVM(3);
        try {
            DMStats dmStats = this.getSystem().getDistributionManager().getStats();
            vm0.invoke(create1);
            vm0.invoke(newKey1);
            vm0.invoke(create3);
            vm0.invoke(newKey3);
            vm1.invoke(create1);
            vm1.invoke(create3);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && !this.getRegionAttributes().getDataPolicy().withPreloaded()) {
                vm1.invoke(newKey1);
                vm1.invoke(newKey3);
            }
            vm2.invoke(create2);
            vm2.invoke(newKey2);
            vm3.invoke(create2);
            vm3.invoke(create3);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && !this.getRegionAttributes().getDataPolicy().withPreloaded()) {
                vm3.invoke(newKey2);
                vm3.invoke(newKey3);
            }
            Region rgn1 = this.createRegion(rgnName1);
            Region rgn2 = this.createRegion(rgnName2);
            Region rgn3 = this.createRegion(rgnName3);
            long cmtMsgs = dmStats.getSentCommitMessages();
            long commitWaits = dmStats.getCommitWaits();
            txMgr.begin();
            rgn1.put((Object)"key", (Object)"value1");
            rgn2.put((Object)"key", (Object)"value2");
            rgn3.put((Object)"key", (Object)"value3");
            this.getSystem().getLogWriter().info("testTXMultiRegion: vm0->R1,R3 vm1->R1,R3 vm2->R2 vm3->R2,R3");
            txMgr.commit();
            Assertions.assertThat((long)dmStats.getSentCommitMessages()).isEqualTo(cmtMsgs + 3L);
            if (rgn1.getAttributes().getScope().isAck() || rgn2.getAttributes().getScope().isAck() || rgn3.getAttributes().getScope().isAck()) {
                Assertions.assertThat((long)dmStats.getCommitWaits()).isEqualTo(commitWaits + 1L);
            } else {
                Assertions.assertThat((long)dmStats.getCommitWaits()).isEqualTo(commitWaits);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException chomp) {
                    Assertions.fail((String)"interrupted");
                }
            }
            vm0.invoke(check1_3);
            vm1.invoke(check1_3);
            vm2.invoke(check2);
            vm3.invoke(check2_3);
            rgn1.destroyRegion();
            rgn2.destroyRegion();
            rgn3.destroyRegion();
            vm0.invoke(create1);
            vm0.invoke(newKey1);
            vm0.invoke(create3);
            vm0.invoke(newKey3);
            vm1.invoke(create1);
            vm1.invoke(create3);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && !this.getRegionAttributes().getDataPolicy().withPreloaded()) {
                vm1.invoke(newKey1);
                vm1.invoke(newKey3);
            }
            vm2.invoke(create2);
            vm2.invoke(newKey2);
            vm2.invoke(create3);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && !this.getRegionAttributes().getDataPolicy().withPreloaded()) {
                vm2.invoke(newKey3);
            }
            vm3.invoke(create2);
            vm3.invoke(create3);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && !this.getRegionAttributes().getDataPolicy().withPreloaded()) {
                vm3.invoke(newKey2);
                vm3.invoke(newKey3);
            }
            rgn1 = this.createRegion(rgnName1);
            rgn2 = this.createRegion(rgnName2);
            rgn3 = this.createRegion(rgnName3);
            cmtMsgs = dmStats.getSentCommitMessages();
            commitWaits = dmStats.getCommitWaits();
            txMgr.begin();
            rgn1.put((Object)"key", (Object)"value1");
            rgn2.put((Object)"key", (Object)"value2");
            rgn3.put((Object)"key", (Object)"value3");
            this.getSystem().getLogWriter().info("testTXMultiRegion: vm0->R1,R3 vm1->R1,R3 vm2->R2,R3 vm3->R2,R3");
            txMgr.commit();
            Assertions.assertThat((long)dmStats.getSentCommitMessages()).isEqualTo(cmtMsgs + 2L);
            if (rgn1.getAttributes().getScope().isAck() || rgn2.getAttributes().getScope().isAck() || rgn3.getAttributes().getScope().isAck()) {
                Assertions.assertThat((long)dmStats.getCommitWaits()).isEqualTo(commitWaits + 1L);
            } else {
                Assertions.assertThat((long)dmStats.getCommitWaits()).isEqualTo(commitWaits);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException chomp) {
                    Assertions.fail((String)"interrupted");
                }
            }
            vm0.invoke(check1_3);
            vm1.invoke(check1_3);
            vm2.invoke(check2_3);
            vm3.invoke(check2_3);
            rgn1.destroyRegion();
            rgn2.destroyRegion();
            rgn3.destroyRegion();
            vm0.invoke(create1);
            vm0.invoke(newKey1);
            vm0.invoke(create3);
            vm0.invoke(newKey3);
            vm1.invoke(create1);
            vm1.invoke(create3);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && !this.getRegionAttributes().getDataPolicy().withPreloaded()) {
                vm1.invoke(newKey1);
                vm1.invoke(newKey3);
            }
            vm2.invoke(create2);
            vm2.invoke(newKey2);
            vm3.invoke(create1);
            vm3.invoke(create3);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && !this.getRegionAttributes().getDataPolicy().withPreloaded()) {
                vm3.invoke(newKey1);
                vm3.invoke(newKey3);
            }
            rgn1 = this.createRegion(rgnName1);
            rgn2 = this.createRegion(rgnName2);
            rgn3 = this.createRegion(rgnName3);
            cmtMsgs = dmStats.getSentCommitMessages();
            commitWaits = dmStats.getCommitWaits();
            txMgr.begin();
            rgn1.put((Object)"key", (Object)"value1");
            rgn2.put((Object)"key", (Object)"value2");
            rgn3.put((Object)"key", (Object)"value3");
            this.getSystem().getLogWriter().info("testTXMultiRegion: vm0->R1,R3 vm1->R1,R3 vm2->R2 vm3->R1,R3");
            txMgr.commit();
            Assertions.assertThat((long)dmStats.getSentCommitMessages()).isEqualTo(cmtMsgs + 2L);
            if (rgn1.getAttributes().getScope().isAck() || rgn2.getAttributes().getScope().isAck() || rgn3.getAttributes().getScope().isAck()) {
                Assertions.assertThat((long)dmStats.getCommitWaits()).isEqualTo(commitWaits + 1L);
            } else {
                Assertions.assertThat((long)dmStats.getCommitWaits()).isEqualTo(commitWaits);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException chomp) {
                    Assertions.fail((String)"interrupted");
                }
            }
            vm0.invoke(check1_3);
            vm1.invoke(check1_3);
            vm2.invoke(check2);
            vm3.invoke(check1_3);
            rgn1.destroyRegion();
            rgn2.destroyRegion();
            rgn3.destroyRegion();
            vm0.invoke(create1);
            vm0.invoke(newKey1);
            vm1.invoke(create1);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && !this.getRegionAttributes().getDataPolicy().withPreloaded()) {
                vm1.invoke(newKey1);
            }
            vm2.invoke(create2);
            vm2.invoke(newKey2);
            vm3.invoke(create3);
            vm3.invoke(newKey3);
            rgn1 = this.createRegion(rgnName1);
            rgn2 = this.createRegion(rgnName2);
            rgn3 = this.createRegion(rgnName3);
            cmtMsgs = dmStats.getSentCommitMessages();
            commitWaits = dmStats.getCommitWaits();
            txMgr.begin();
            rgn1.put((Object)"key", (Object)"value1");
            rgn2.put((Object)"key", (Object)"value2");
            rgn3.put((Object)"key", (Object)"value3");
            this.getSystem().getLogWriter().info("testTXMultiRegion: vm0->R1 vm1->R1 vm2->R2 vm3->R3");
            txMgr.commit();
            Assertions.assertThat((long)dmStats.getSentCommitMessages()).isEqualTo(cmtMsgs + 3L);
            if (rgn1.getAttributes().getScope().isAck() || rgn2.getAttributes().getScope().isAck() || rgn3.getAttributes().getScope().isAck()) {
                Assertions.assertThat((long)dmStats.getCommitWaits()).isEqualTo(commitWaits + 1L);
            } else {
                Assertions.assertThat((long)dmStats.getCommitWaits()).isEqualTo(commitWaits);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException chomp) {
                    Assertions.fail((String)"interrupted");
                }
            }
            vm0.invoke(check1);
            vm1.invoke(check1);
            vm2.invoke(check2);
            vm3.invoke(check3);
            rgn1.destroyRegion();
            rgn2.destroyRegion();
            rgn3.destroyRegion();
            vm0.invoke(create1);
            vm0.invoke(newKey1);
            vm0.invoke(create3);
            vm0.invoke(newKey3);
            vm1.invoke(create2);
            vm1.invoke(newKey2);
            vm1.invoke(create3);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && !this.getRegionAttributes().getDataPolicy().withPreloaded()) {
                vm1.invoke(newKey3);
            }
            vm2.invoke(create2);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && !this.getRegionAttributes().getDataPolicy().withPreloaded()) {
                vm2.invoke(newKey2);
            }
            vm3.invoke(create3);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && !this.getRegionAttributes().getDataPolicy().withPreloaded()) {
                vm3.invoke(newKey3);
            }
            rgn1 = this.createRegion(rgnName1);
            rgn2 = this.createRegion(rgnName2);
            rgn3 = this.createRegion(rgnName3);
            cmtMsgs = dmStats.getSentCommitMessages();
            commitWaits = dmStats.getCommitWaits();
            txMgr.begin();
            rgn1.put((Object)"key", (Object)"value1");
            rgn2.put((Object)"key", (Object)"value2");
            rgn3.put((Object)"key", (Object)"value3");
            this.getSystem().getLogWriter().info("testTXMultiRegion: vm0->R1,R3 vm1->R2,R3 vm2->R2 vm3->R3");
            txMgr.commit();
            Assertions.assertThat((long)dmStats.getSentCommitMessages()).isEqualTo(cmtMsgs + 4L);
            if (rgn1.getAttributes().getScope().isAck() || rgn2.getAttributes().getScope().isAck() || rgn3.getAttributes().getScope().isAck()) {
                Assertions.assertThat((long)dmStats.getCommitWaits()).isEqualTo(commitWaits + 1L);
            } else {
                Assertions.assertThat((long)dmStats.getCommitWaits()).isEqualTo(commitWaits);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException chomp) {
                    Assertions.fail((String)"interrupted");
                }
            }
            vm0.invoke(check1_3);
            vm1.invoke(check2_3);
            vm2.invoke(check2);
            vm3.invoke(check3);
            rgn1.destroyRegion();
            rgn2.destroyRegion();
            rgn3.destroyRegion();
            vm0.invoke(create1);
            vm0.invoke(newKey1);
            vm0.invoke(create3);
            vm0.invoke(newKey3);
            vm1.invoke(create1);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && !this.getRegionAttributes().getDataPolicy().withPreloaded()) {
                vm1.invoke(newKey1);
            }
            vm1.invoke(create3);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && !this.getRegionAttributes().getDataPolicy().withPreloaded()) {
                vm1.invoke(newKey3);
            }
            vm2.invoke(create1);
            vm2.invoke(create3);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && !this.getRegionAttributes().getDataPolicy().withPreloaded()) {
                vm2.invoke(newKey1);
                vm2.invoke(newKey3);
            }
            vm3.invoke(create1);
            vm3.invoke(create3);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && !this.getRegionAttributes().getDataPolicy().withPreloaded()) {
                vm3.invoke(newKey1);
                vm3.invoke(newKey3);
            }
            rgn1 = this.createRegion(rgnName1);
            rgn2 = this.createRegion(rgnName2);
            rgn3 = this.createRegion(rgnName3);
            cmtMsgs = dmStats.getSentCommitMessages();
            commitWaits = dmStats.getCommitWaits();
            txMgr.begin();
            rgn1.put((Object)"key", (Object)"value1");
            rgn2.put((Object)"key", (Object)"value2");
            rgn3.put((Object)"key", (Object)"value3");
            this.getSystem().getLogWriter().info("testTXMultiRegion: vm0->R1,R3 vm1->R1,R3 vm2->R1,R3 vm3->R1,R3");
            txMgr.commit();
            Assertions.assertThat((long)dmStats.getSentCommitMessages()).isEqualTo(cmtMsgs + 1L);
            if (rgn1.getAttributes().getScope().isAck() || rgn2.getAttributes().getScope().isAck() || rgn3.getAttributes().getScope().isAck()) {
                Assertions.assertThat((long)dmStats.getCommitWaits()).isEqualTo(commitWaits + 1L);
            } else {
                Assertions.assertThat((long)dmStats.getCommitWaits()).isEqualTo(commitWaits);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException chomp) {
                    Assertions.fail((String)"interrupted");
                }
            }
            vm0.invoke(check1_3);
            vm1.invoke(check1_3);
            vm2.invoke(check1_3);
            vm3.invoke(check1_3);
            rgn1.destroyRegion();
            rgn2.destroyRegion();
            rgn3.destroyRegion();
        }
        catch (Exception e) {
            this.getCache().close();
            this.getSystem().getLogWriter().fine("testTXMultiRegion: Caused exception in createRegion");
            throw e;
        }
    }

    private static <K, V> void setTxListener(CacheTransactionManager manager, TransactionListener<K, V> listener) {
        Stream.of(manager.getListeners()).forEach(arg_0 -> ((CacheTransactionManager)manager).removeListener(arg_0));
        manager.addListener(listener);
    }

    private void verifyMirrorRegionEventsMatch(EntryEvent<String, String> event, Region region, String expectedValue) {
        Assertions.assertThat((Map)event.getRegion()).isSameAs((Object)region);
        Assertions.assertThat((String)((String)event.getKey())).isEqualTo((Object)"key");
        Assertions.assertThat((String)((String)event.getNewValue())).isEqualTo((Object)expectedValue);
        Assertions.assertThat((String)((String)event.getOldValue())).isNull();
        Assertions.assertThat((boolean)event.getOperation().isLocalLoad()).isFalse();
        Assertions.assertThat((boolean)event.getOperation().isNetLoad()).isFalse();
        Assertions.assertThat((boolean)event.getOperation().isLoad()).isFalse();
        Assertions.assertThat((boolean)event.getOperation().isNetSearch()).isFalse();
        Assertions.assertThat((boolean)event.getOperation().isExpiration()).isFalse();
        Assertions.assertThat((Object)event.getCallbackArgument()).isNull();
        Assertions.assertThat((boolean)event.isCallbackArgumentAvailable()).isTrue();
        Assertions.assertThat((boolean)event.isOriginRemote()).isTrue();
        Assertions.assertThat((boolean)event.getOperation().isDistributed()).isTrue();
    }

    @Test
    public void testTXRmtMirror() {
        Assumptions.assumeThat((boolean)this.supportsTransactions()).isTrue();
        Assumptions.assumeThat((boolean)this.getRegionAttributes().getScope().isGlobal()).isFalse();
        Assumptions.assumeThat((boolean)this.getRegionAttributes().getDataPolicy().withPersistence()).isFalse();
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        CacheTransactionManager txMgr = this.getCache().getCacheTransactionManager();
        final String rgnName = this.getUniqueName();
        SerializableRunnable createMirror = new SerializableRunnable("textTXRmtMirror: Create Mirrored Region"){

            @Override
            public void run() {
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = new MyTransactionListener();
                MultiVMRegionTestCase.setTxListener(txMgr2, tl);
                try {
                    AttributesFactory rgnAtts = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                    rgnAtts.setDataPolicy(DataPolicy.REPLICATE);
                    MultiVMRegionTestCase.this.createRegion(rgnName, rgnAtts.create());
                }
                catch (CacheException e) {
                    Assertions.fail((String)"While creating region", (Throwable)e);
                }
            }
        };
        SerializableRunnable createNonMirror = new SerializableRunnable("textTXRmtMirror: Create Mirrored Region"){

            @Override
            public void run() {
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = new MyTransactionListener();
                MultiVMRegionTestCase.setTxListener(txMgr2, tl);
                try {
                    AttributesFactory rgnAtts = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                    rgnAtts.setDataPolicy(DataPolicy.NORMAL);
                    MultiVMRegionTestCase.this.createRegion(rgnName, rgnAtts.create());
                }
                catch (CacheException e) {
                    Assertions.fail((String)"While creating region", (Throwable)e);
                }
            }
        };
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        vm0.invoke(createMirror);
        vm1.invoke(createNonMirror);
        Region region = this.createRegion(rgnName);
        txMgr.begin();
        region.create((Object)"key", (Object)"value");
        this.getSystem().getLogWriter().info("textTXRmtMirror: create mirror and non-mirror");
        txMgr.commit();
        if (!region.getAttributes().getScope().isAck()) {
            Awaitility.waitAtMost((long)5L, (TimeUnit)TimeUnit.MINUTES).untilAsserted(() -> this.validateTXRmtMirror(rgnName, vm0, vm1));
        } else {
            this.validateTXRmtMirror(rgnName, vm0, vm1);
        }
    }

    private void validateTXRmtMirror(final String rgnName, VM vm0, VM vm1) {
        SerializableRunnable checkExists = new SerializableRunnable("textTXRmtMirror: checkExists"){

            @Override
            public void run() {
                Region rgn = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                ((ObjectAssert)Assertions.assertThat((Object)rgn.getEntry((Object)"key")).describedAs("Could not find entry for 'key'", new Object[0])).isNotNull();
                Assertions.assertThat((String)((String)rgn.getEntry((Object)"key").getValue())).isEqualTo((Object)"value");
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = (MyTransactionListener)MultiVMRegionTestCase.firstTransactionListenerFrom(txMgr2);
                tl.checkAfterCommitCount(1);
                Assertions.assertThat((int)tl.afterFailedCommitCount).isEqualTo(0);
                Assertions.assertThat((int)tl.afterRollbackCount).isEqualTo(0);
                Assertions.assertThat((int)tl.closeCount).isEqualTo(0);
                Assertions.assertThat((Object)tl.lastEvent.getCache()).isEqualTo((Object)rgn.getRegionService());
                List events = TxEventTestUtil.getCreateEvents((List)tl.lastEvent.getEvents());
                Assertions.assertThat((int)events.size()).isEqualTo(1);
                EntryEvent ev = (EntryEvent)events.iterator().next();
                Assertions.assertThat((Map)rgn).isSameAs((Object)ev.getRegion());
                Assertions.assertThat((String)((String)ev.getKey())).isEqualTo((Object)"key");
                Assertions.assertThat((String)((String)ev.getNewValue())).isEqualTo((Object)"value");
                Assertions.assertThat((String)((String)ev.getOldValue())).isNull();
                Assertions.assertThat((boolean)ev.getOperation().isLocalLoad()).isFalse();
                Assertions.assertThat((boolean)ev.getOperation().isNetLoad()).isFalse();
                Assertions.assertThat((boolean)ev.getOperation().isLoad()).isFalse();
                Assertions.assertThat((boolean)ev.getOperation().isNetSearch()).isFalse();
                Assertions.assertThat((boolean)ev.getOperation().isExpiration()).isFalse();
                Assertions.assertThat((Object)ev.getCallbackArgument()).isNull();
                Assertions.assertThat((boolean)ev.isCallbackArgumentAvailable()).isTrue();
                Assertions.assertThat((boolean)ev.isOriginRemote()).isTrue();
                Assertions.assertThat((boolean)ev.getOperation().isDistributed()).isTrue();
            }
        };
        SerializableRunnable checkNoKey = new SerializableRunnable("textTXRmtMirror: checkNoKey"){

            @Override
            public void run() {
                Region rgn = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                Assertions.assertThat((Object)rgn.getEntry((Object)"key")).isNull();
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = (MyTransactionListener)MultiVMRegionTestCase.firstTransactionListenerFrom(txMgr2);
                tl.checkAfterCommitCount(1);
                Assertions.assertThat((int)tl.afterFailedCommitCount).isEqualTo(0);
                Assertions.assertThat((int)tl.afterRollbackCount).isEqualTo(0);
                Assertions.assertThat((int)tl.closeCount).isEqualTo(0);
                Assertions.assertThat((int)TxEventTestUtil.getCreateEvents((List)tl.lastEvent.getEvents()).size()).isEqualTo(0L);
                Assertions.assertThat((int)TxEventTestUtil.getPutEvents((List)tl.lastEvent.getEvents()).size()).isEqualTo(0L);
                Assertions.assertThat((Object)tl.lastEvent.getCache()).isEqualTo((Object)rgn.getRegionService());
            }
        };
        vm0.invoke(checkExists);
        vm1.invoke(checkNoKey);
    }

    @Ignore(value="TODO: test is disabled")
    @Test
    public void testTXAlgebra() {
        Assumptions.assumeThat((boolean)this.getRegionAttributes().getScope().isGlobal()).isFalse();
        Assumptions.assumeThat((boolean)this.getRegionAttributes().getDataPolicy().withPersistence()).isFalse();
        Assertions.assertThat((boolean)this.getRegionAttributes().getScope().isDistributed()).isTrue();
        CacheTransactionManager txMgr = this.getCache().getCacheTransactionManager();
        MyTransactionListener localTl = new MyTransactionListener();
        MultiVMRegionTestCase.setTxListener(txMgr, localTl);
        Assertions.assertThat((Object)localTl.lastEvent).isNull();
        localTl.assertCounts(0, 0, 0, 0);
        final String rgnName = this.getUniqueName();
        SerializableRunnable create = new SerializableRunnable("testTXAlgebra: Create Region"){

            @Override
            public void run() {
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = new MyTransactionListener();
                MultiVMRegionTestCase.setTxListener(txMgr2, tl);
                Assertions.assertThat((Object)tl.lastEvent).isNull();
                tl.assertCounts(0, 0, 0, 0);
                try {
                    Region rgn = MultiVMRegionTestCase.this.createRegion(rgnName);
                    if (!MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy().withReplication()) {
                        rgn.create((Object)"key", null);
                        MultiVMRegionTestCase.this.getSystem().getLogWriter().info("testTXAlgebra: Created Key");
                    }
                }
                catch (CacheException e) {
                    Assertions.fail((String)"While creating region", (Throwable)e);
                }
            }
        };
        Invoke.invokeInEveryVM(create);
        try {
            AttributesFactory rgnAtts = new AttributesFactory(this.getRegionAttributes());
            rgnAtts.setDataPolicy(DataPolicy.NORMAL);
            Region rgn = this.createRegion(rgnName, rgnAtts.create());
            txMgr.begin();
            TransactionId myTXId = txMgr.getTransactionId();
            rgn.create((Object)"key", (Object)"value1");
            Assertions.assertThatThrownBy(() -> rgn.create((Object)"key", (Object)"value2")).isInstanceOf(EntryExistsException.class);
            rgn.put((Object)"key", (Object)"value2");
            Assertions.assertThat((String)((String)rgn.getEntry((Object)"key").getValue())).isEqualTo((Object)"value2");
            txMgr.commit();
            Invoke.invokeInEveryVM(new CacheSerializableRunnable("testTXAlgebra: check: C+P->C"){

                @Override
                public void run2() {
                    Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                    CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                    MyTransactionListener tl = (MyTransactionListener)MultiVMRegionTestCase.firstTransactionListenerFrom(txMgr2);
                    Assertions.assertThat((String)((String)rgn1.getEntry((Object)"key").getValue())).isEqualTo((Object)"value2");
                    tl.assertCounts(1, 0, 0, 0);
                    RegionAttributes attr = MultiVMRegionTestCase.this.getRegionAttributes();
                    List events = !attr.getDataPolicy().withReplication() || attr.getConcurrencyChecksEnabled() ? TxEventTestUtil.getPutEvents((List)tl.lastEvent.getEvents()) : TxEventTestUtil.getCreateEvents((List)tl.lastEvent.getEvents());
                    Assertions.assertThat((int)events.size()).isEqualTo(1);
                    EntryEvent ev = (EntryEvent)events.iterator().next();
                    Assertions.assertThat((Map)rgn1).isSameAs((Object)ev.getRegion());
                    Assertions.assertThat((String)((String)ev.getKey())).isEqualTo((Object)"key");
                    Assertions.assertThat((String)((String)ev.getNewValue())).isEqualTo((Object)"value2");
                    Assertions.assertThat((String)((String)ev.getOldValue())).isNull();
                    Assertions.assertThat((boolean)ev.getOperation().isLocalLoad()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isNetLoad()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isLoad()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isNetSearch()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isExpiration()).isFalse();
                    Assertions.assertThat((Object)ev.getCallbackArgument()).isNull();
                    Assertions.assertThat((boolean)ev.isCallbackArgumentAvailable()).isTrue();
                    Assertions.assertThat((boolean)ev.isOriginRemote()).isTrue();
                    Assertions.assertThat((boolean)ev.getOperation().isDistributed()).isTrue();
                }
            });
            Assertions.assertThat((String)((String)rgn.getEntry((Object)"key").getValue())).isEqualTo((Object)"value2");
            localTl.assertCounts(1, 0, 0, 0);
            List events = TxEventTestUtil.getCreateEvents((List)localTl.lastEvent.getEvents());
            Assertions.assertThat((Object)localTl.lastEvent.getTransactionId()).isEqualTo((Object)myTXId);
            Assertions.assertThat((int)events.size()).isEqualTo(1);
            EntryEvent ev = (EntryEvent)events.iterator().next();
            Assertions.assertThat((Object)ev.getTransactionId()).isEqualTo((Object)myTXId);
            Assertions.assertThat(rgn).isSameAs((Object)ev.getRegion());
            Assertions.assertThat((String)((String)ev.getKey())).isEqualTo((Object)"key");
            Assertions.assertThat((String)((String)ev.getNewValue())).isEqualTo((Object)"value2");
            Assertions.assertThat((String)((String)ev.getOldValue())).isNull();
            Assertions.assertThat((boolean)ev.getOperation().isLocalLoad()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isNetLoad()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isLoad()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isNetSearch()).isFalse();
            Assertions.assertThat((Object)ev.getCallbackArgument()).isNull();
            Assertions.assertThat((boolean)ev.isCallbackArgumentAvailable()).isTrue();
            Assertions.assertThat((boolean)ev.isOriginRemote()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isExpiration()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isDistributed()).isTrue();
            if (!this.getRegionAttributes().getDataPolicy().withReplication()) {
                rgn.invalidate((Object)"key");
                rgn.localDestroy((Object)"key");
            } else {
                rgn.destroy((Object)"key");
            }
            txMgr.begin();
            myTXId = txMgr.getTransactionId();
            rgn.create((Object)"key", (Object)"value1");
            rgn.invalidate((Object)"key");
            Assertions.assertThat((boolean)rgn.containsKey((Object)"key")).isTrue();
            Assertions.assertThat((boolean)rgn.containsValueForKey((Object)"key")).isFalse();
            txMgr.commit();
            Invoke.invokeInEveryVM(new CacheSerializableRunnable("testTXAlgebra: check: C+DI->C (invalid value)"){

                @Override
                public void run2() {
                    Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                    CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                    MyTransactionListener tl = (MyTransactionListener)MultiVMRegionTestCase.firstTransactionListenerFrom(txMgr2);
                    Assertions.assertThat((boolean)rgn1.containsKey((Object)"key")).isTrue();
                    Assertions.assertThat((boolean)rgn1.containsValueForKey((Object)"key")).isFalse();
                    tl.assertCounts(2, 0, 0, 0);
                    RegionAttributes attr = MultiVMRegionTestCase.this.getRegionAttributes();
                    List events = !attr.getDataPolicy().withReplication() || attr.getConcurrencyChecksEnabled() ? TxEventTestUtil.getPutEvents((List)tl.lastEvent.getEvents()) : TxEventTestUtil.getCreateEvents((List)tl.lastEvent.getEvents());
                    Assertions.assertThat((int)events.size()).isEqualTo(1);
                    EntryEvent ev = (EntryEvent)events.iterator().next();
                    Assertions.assertThat((Map)rgn1).isSameAs((Object)ev.getRegion());
                    Assertions.assertThat((String)((String)ev.getKey())).isEqualTo((Object)"key");
                    Assertions.assertThat((Object)ev.getNewValue()).isNull();
                    Assertions.assertThat((Object)ev.getOldValue()).isNull();
                    Assertions.assertThat((boolean)ev.getOperation().isLocalLoad()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isNetLoad()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isLoad()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isNetSearch()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isExpiration()).isFalse();
                    Assertions.assertThat((Object)ev.getCallbackArgument()).isNull();
                    Assertions.assertThat((boolean)ev.isCallbackArgumentAvailable()).isTrue();
                    Assertions.assertThat((boolean)ev.isOriginRemote()).isTrue();
                    Assertions.assertThat((boolean)ev.getOperation().isDistributed()).isTrue();
                }
            });
            Assertions.assertThat((boolean)rgn.containsKey((Object)"key")).isTrue();
            Assertions.assertThat((boolean)rgn.containsValueForKey((Object)"key")).isFalse();
            localTl.assertCounts(2, 0, 0, 0);
            events = TxEventTestUtil.getCreateEvents((List)localTl.lastEvent.getEvents());
            Assertions.assertThat((Object)localTl.lastEvent.getTransactionId()).isEqualTo((Object)myTXId);
            Assertions.assertThat((int)events.size()).isEqualTo(1);
            ev = (EntryEvent)events.iterator().next();
            Assertions.assertThat((Object)ev.getTransactionId()).isEqualTo((Object)myTXId);
            Assertions.assertThat(rgn).isSameAs((Object)ev.getRegion());
            Assertions.assertThat((String)((String)ev.getKey())).isEqualTo((Object)"key");
            Assertions.assertThat((String)((String)ev.getNewValue())).isNull();
            Assertions.assertThat((String)((String)ev.getOldValue())).isNull();
            Assertions.assertThat((boolean)ev.getOperation().isLocalLoad()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isNetLoad()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isLoad()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isNetSearch()).isFalse();
            Assertions.assertThat((Object)ev.getCallbackArgument()).isNull();
            Assertions.assertThat((boolean)ev.isCallbackArgumentAvailable()).isTrue();
            Assertions.assertThat((boolean)ev.isOriginRemote()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isExpiration()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isDistributed()).isTrue();
            Assertions.assertThat((boolean)rgn.containsKey((Object)"key")).isTrue();
            Assertions.assertThat((boolean)rgn.containsValueForKey((Object)"key")).isFalse();
            txMgr.begin();
            rgn.invalidate((Object)"key");
            Assertions.assertThat((boolean)rgn.containsKey((Object)"key")).isTrue();
            Assertions.assertThat((boolean)rgn.containsValueForKey((Object)"key")).isFalse();
            txMgr.commit();
            Invoke.invokeInEveryVM(new CacheSerializableRunnable("testTXAlgebra: check: committed LI + TX DI-> NOOP"){

                @Override
                public void run2() {
                    Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                    CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                    MyTransactionListener tl = (MyTransactionListener)MultiVMRegionTestCase.firstTransactionListenerFrom(txMgr2);
                    Assertions.assertThat((Object)rgn1.getEntry((Object)"key").getValue()).isEqualTo((Object)"value1");
                    tl.assertCounts(2, 0, 0, 0);
                }
            });
            Assertions.assertThat((boolean)rgn.containsKey((Object)"key")).isTrue();
            Assertions.assertThat((boolean)rgn.containsValueForKey((Object)"key")).isFalse();
            localTl.assertCounts(2, 0, 0, 0);
            if (!this.getRegionAttributes().getDataPolicy().withReplication()) {
                rgn.put((Object)"key", (Object)"value1");
                Assertions.assertThat((boolean)rgn.containsKey((Object)"key")).isTrue();
                Assertions.assertThat((String)((String)rgn.getEntry((Object)"key").getValue())).isEqualTo((Object)"value1");
                txMgr.begin();
                myTXId = txMgr.getTransactionId();
                rgn.localInvalidate((Object)"key");
                rgn.invalidate((Object)"key");
                Assertions.assertThat((boolean)rgn.containsKey((Object)"key")).isTrue();
                Assertions.assertThat((boolean)rgn.containsValueForKey((Object)"key")).isFalse();
                txMgr.commit();
                Invoke.invokeInEveryVM(new CacheSerializableRunnable("testTXAlgebra: check: TX LI + TX DI -> LI"){

                    @Override
                    public void run2() {
                        Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                        CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                        MyTransactionListener tl = (MyTransactionListener)MultiVMRegionTestCase.firstTransactionListenerFrom(txMgr2);
                        Assertions.assertThat((boolean)rgn1.containsKey((Object)"key")).isTrue();
                        Assertions.assertThat((boolean)rgn1.containsValueForKey((Object)"key")).isTrue();
                        Assertions.assertThat((Object)rgn1.getEntry((Object)"key").getValue()).isEqualTo((Object)"value1");
                        tl.assertCounts(2, 0, 0, 0);
                    }
                });
                Assertions.assertThat((boolean)rgn.containsKey((Object)"key")).isTrue();
                Assertions.assertThat((boolean)rgn.containsValueForKey((Object)"key")).isFalse();
                Assertions.assertThat((String)((String)rgn.getEntry((Object)"key").getValue())).isNull();
                localTl.assertCounts(3, 0, 0, 0);
                events = TxEventTestUtil.getInvalidateEvents((List)localTl.lastEvent.getEvents());
                Assertions.assertThat((int)events.size()).isEqualTo(1);
                ev = (EntryEvent)events.iterator().next();
                Assertions.assertThat((Object)ev.getTransactionId()).isEqualTo((Object)myTXId);
                Assertions.assertThat(rgn).isSameAs((Object)ev.getRegion());
                Assertions.assertThat((String)((String)ev.getKey())).isEqualTo((Object)"key");
                Assertions.assertThat((String)((String)ev.getNewValue())).isNull();
                Assertions.assertThat((String)((String)ev.getOldValue())).isEqualTo((Object)"value1");
                Assertions.assertThat((boolean)ev.getOperation().isLocalLoad()).isFalse();
                Assertions.assertThat((boolean)ev.getOperation().isNetLoad()).isFalse();
                Assertions.assertThat((boolean)ev.getOperation().isLoad()).isFalse();
                Assertions.assertThat((boolean)ev.getOperation().isNetSearch()).isFalse();
                Assertions.assertThat((Object)ev.getCallbackArgument()).isNull();
                Assertions.assertThat((boolean)ev.isCallbackArgumentAvailable()).isTrue();
                Assertions.assertThat((boolean)ev.isOriginRemote()).isFalse();
                Assertions.assertThat((boolean)ev.getOperation().isExpiration()).isFalse();
                Assertions.assertThat((boolean)ev.getOperation().isDistributed()).isTrue();
                rgn.invalidate((Object)"key");
                rgn.localDestroy((Object)"key");
            } else {
                rgn.destroy((Object)"key");
            }
            txMgr.begin();
            rgn.create((Object)"key", (Object)"value0");
            rgn.destroy((Object)"key");
            Assertions.assertThat((boolean)rgn.containsKey((Object)"key")).isFalse();
            txMgr.commit();
            Invoke.invokeInEveryVM(new CacheSerializableRunnable("testTXAlgebra: check: C+DD->DD"){

                @Override
                public void run2() {
                    Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                    CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                    MyTransactionListener tl = (MyTransactionListener)MultiVMRegionTestCase.firstTransactionListenerFrom(txMgr2);
                    Assertions.assertThat((boolean)rgn1.containsKey((Object)"key")).isFalse();
                    Assertions.assertThat((boolean)rgn1.containsValueForKey((Object)"key")).isFalse();
                    tl.assertCounts(3, 0, 0, 0);
                    List events = TxEventTestUtil.getDestroyEvents((List)tl.lastEvent.getEvents());
                    Assertions.assertThat((int)events.size()).isEqualTo(1);
                    EntryEvent ev = (EntryEvent)events.iterator().next();
                    Assertions.assertThat((Map)rgn1).isSameAs((Object)ev.getRegion());
                    Assertions.assertThat((String)((String)ev.getKey())).isNull();
                    Assertions.assertThat((Object)ev.getNewValue()).isNull();
                    Assertions.assertThat((Object)ev.getOldValue()).isNull();
                    Assertions.assertThat((boolean)ev.getOperation().isLocalLoad()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isNetLoad()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isLoad()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isNetSearch()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isExpiration()).isFalse();
                    Assertions.assertThat((Object)ev.getCallbackArgument()).isNull();
                    Assertions.assertThat((boolean)ev.isCallbackArgumentAvailable()).isTrue();
                    Assertions.assertThat((boolean)ev.isOriginRemote()).isTrue();
                    Assertions.assertThat((boolean)ev.getOperation().isDistributed()).isTrue();
                }
            });
            Assertions.assertThat((boolean)rgn.containsKey((Object)"key")).isFalse();
            localTl.assertCounts(3, 0, 0, 0);
            if (!this.getRegionAttributes().getDataPolicy().withReplication()) {
                Invoke.invokeInEveryVM(new CacheSerializableRunnable("testTXAlgebra: C+LI-> entry creation"){

                    @Override
                    public void run2() {
                        Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                        try {
                            rgn1.create((Object)"key", null);
                        }
                        catch (CacheException e) {
                            Assertions.fail((String)"While creating key", (Throwable)e);
                        }
                    }
                });
            }
            Assertions.assertThat((boolean)rgn.containsKey((Object)"key")).isFalse();
            txMgr.begin();
            myTXId = txMgr.getTransactionId();
            rgn.create((Object)"key", (Object)"value1");
            rgn.localInvalidate((Object)"key");
            Assertions.assertThat((boolean)rgn.containsKey((Object)"key")).isTrue();
            Assertions.assertThat((boolean)rgn.containsValueForKey((Object)"key")).isFalse();
            txMgr.commit();
            Invoke.invokeInEveryVM(new CacheSerializableRunnable("testTXAlgebra: check: C+LI->C (with value)"){

                @Override
                public void run2() {
                    Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                    CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                    MyTransactionListener tl = (MyTransactionListener)MultiVMRegionTestCase.firstTransactionListenerFrom(txMgr2);
                    tl.assertCounts(4, 0, 0, 0);
                    Assertions.assertThat((boolean)rgn1.containsKey((Object)"key")).isTrue();
                    Assertions.assertThat((String)((String)rgn1.getEntry((Object)"key").getValue())).isEqualTo((Object)"value1");
                    RegionAttributes attr = MultiVMRegionTestCase.this.getRegionAttributes();
                    List events = !attr.getDataPolicy().withReplication() || attr.getConcurrencyChecksEnabled() ? TxEventTestUtil.getPutEvents((List)tl.lastEvent.getEvents()) : TxEventTestUtil.getCreateEvents((List)tl.lastEvent.getEvents());
                    Assertions.assertThat((int)events.size()).isEqualTo(1);
                    EntryEvent ev = (EntryEvent)events.iterator().next();
                    Assertions.assertThat((Map)rgn1).isSameAs((Object)ev.getRegion());
                    Assertions.assertThat((String)((String)ev.getKey())).isEqualTo((Object)"key");
                    Assertions.assertThat((String)((String)ev.getNewValue())).isEqualTo((Object)"value1");
                    Assertions.assertThat((String)((String)ev.getOldValue())).isNull();
                    Assertions.assertThat((boolean)ev.getOperation().isLocalLoad()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isNetLoad()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isLoad()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isNetSearch()).isFalse();
                    Assertions.assertThat((boolean)ev.getOperation().isExpiration()).isFalse();
                    Assertions.assertThat((Object)ev.getCallbackArgument()).isNull();
                    Assertions.assertThat((boolean)ev.isCallbackArgumentAvailable()).isTrue();
                    Assertions.assertThat((boolean)ev.isOriginRemote()).isTrue();
                    Assertions.assertThat((boolean)ev.getOperation().isDistributed()).isTrue();
                }
            });
            Assertions.assertThat((boolean)rgn.containsKey((Object)"key")).isTrue();
            Assertions.assertThat((boolean)rgn.containsValueForKey((Object)"key")).isFalse();
            localTl.assertCounts(4, 0, 0, 0);
            events = TxEventTestUtil.getCreateEvents((List)localTl.lastEvent.getEvents());
            Assertions.assertThat((Object)localTl.lastEvent.getTransactionId()).isEqualTo((Object)myTXId);
            Assertions.assertThat((int)events.size()).isEqualTo(1);
            ev = (EntryEvent)events.iterator().next();
            Assertions.assertThat((Object)ev.getTransactionId()).isEqualTo((Object)myTXId);
            Assertions.assertThat(rgn).isSameAs((Object)ev.getRegion());
            Assertions.assertThat((String)((String)ev.getKey())).isEqualTo((Object)"key");
            Assertions.assertThat((String)((String)ev.getNewValue())).isNull();
            Assertions.assertThat((String)((String)ev.getOldValue())).isNull();
            Assertions.assertThat((boolean)ev.getOperation().isLocalLoad()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isNetLoad()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isLoad()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isNetSearch()).isFalse();
            Assertions.assertThat((Object)ev.getCallbackArgument()).isNull();
            Assertions.assertThat((boolean)ev.isCallbackArgumentAvailable()).isTrue();
            Assertions.assertThat((boolean)ev.isOriginRemote()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isExpiration()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isDistributed()).isTrue();
            rgn.destroy((Object)"key");
            txMgr.begin();
            myTXId = txMgr.getTransactionId();
            rgn.create((Object)"key", (Object)"value1");
            rgn.localInvalidate((Object)"key");
            Assertions.assertThatThrownBy(() -> rgn.create((Object)"key", (Object)"ex")).isInstanceOf(EntryExistsException.class);
            rgn.put((Object)"key", (Object)"value2");
            Assertions.assertThat((boolean)rgn.containsKey((Object)"key")).isTrue();
            Assertions.assertThat((String)((String)rgn.getEntry((Object)"key").getValue())).isEqualTo((Object)"value2");
            txMgr.commit();
            Assertions.assertThat((boolean)rgn.containsKey((Object)"key")).isTrue();
            Assertions.assertThat((String)((String)rgn.getEntry((Object)"key").getValue())).isEqualTo((Object)"value2");
            localTl.assertCounts(5, 0, 0, 0);
            events = TxEventTestUtil.getCreateEvents((List)localTl.lastEvent.getEvents());
            Assertions.assertThat((Object)localTl.lastEvent.getTransactionId()).isEqualTo((Object)myTXId);
            Assertions.assertThat((int)events.size()).isEqualTo(1);
            ev = (EntryEvent)events.iterator().next();
            Assertions.assertThat((Object)ev.getTransactionId()).isEqualTo((Object)myTXId);
            Assertions.assertThat(rgn).isSameAs((Object)ev.getRegion());
            Assertions.assertThat((String)((String)ev.getKey())).isEqualTo((Object)"key");
            Assertions.assertThat((String)((String)ev.getNewValue())).isEqualTo((Object)"value2");
            Assertions.assertThat((String)((String)ev.getOldValue())).isNull();
            Assertions.assertThat((boolean)ev.getOperation().isLocalLoad()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isNetLoad()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isLoad()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isNetSearch()).isFalse();
            Assertions.assertThat((Object)ev.getCallbackArgument()).isNull();
            Assertions.assertThat((boolean)ev.isCallbackArgumentAvailable()).isTrue();
            Assertions.assertThat((boolean)ev.isOriginRemote()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isExpiration()).isFalse();
            Assertions.assertThat((boolean)ev.getOperation().isDistributed()).isTrue();
            rgn.localDestroy((Object)"key");
        }
        catch (Exception e) {
            this.getCache().close();
            this.getSystem().getLogWriter().fine("testTXAlgebra: Caused exception in createRegion");
            throw e;
        }
    }

    protected <K, V> RegionAttributes<K, V> getRegionAttributes(String type) {
        throw new IllegalStateException("subclass must reimplement this method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void versionTestGIISendsTombstones() {
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        final int serverPort = AvailablePortHelper.getRandomAvailableTCPPort();
        final String name = this.getUniqueName() + "-CC";
        SerializableRunnable createRegion = new SerializableRunnable("Create Region"){

            @Override
            public void run() {
                try {
                    RegionFactory f = MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                    CCRegion = (LocalRegion)f.create(name);
                    if (VM.getCurrentVMNum() == 0) {
                        CacheServer bridge = CCRegion.getCache().addCacheServer();
                        bridge.setPort(serverPort);
                        try {
                            bridge.start();
                        }
                        catch (IOException ex) {
                            Assertions.fail((String)"While creating bridge", (Throwable)ex);
                        }
                    }
                }
                catch (CacheException ex) {
                    Assertions.fail((String)"While creating region", (Throwable)ex);
                }
            }
        };
        SerializableRunnable asserter = new SerializableRunnable("ensure tombstone has been received"){

            @Override
            public void run() {
                RegionEntry entry = CCRegion.getRegionEntry((Object)"object2");
                Assertions.assertThat((Object)entry).isNotNull();
                Assertions.assertThat((boolean)entry.isTombstone()).isTrue();
            }
        };
        vm0.invoke(createRegion);
        vm0.invoke(new SerializableRunnable("create some tombstones"){

            @Override
            public void run() {
                CCRegion.put((Object)"object1", (Object)"value1");
                CCRegion.put((Object)"object2", (Object)"value2");
                CCRegion.put((Object)"object3", (Object)"value3");
                CCRegion.destroy((Object)"object2");
            }
        });
        try {
            vm0.invoke(asserter);
            vm1.invoke(createRegion);
            vm1.invoke(asserter);
        }
        finally {
            MultiVMRegionTestCase.disconnectAllFromDS();
        }
    }

    public void versionTestConcurrentEvents() throws Exception {
        Object subkey;
        int subi;
        String key;
        int i;
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        VM vm2 = VM.getVM(2);
        final String name = this.getUniqueName() + "-CC";
        SerializableRunnable createRegion = new SerializableRunnable("Create Region"){

            @Override
            public void run() {
                try {
                    RegionFactory f = MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                    CCRegion = (LocalRegion)f.create(name);
                }
                catch (CacheException ex) {
                    Assertions.fail((String)"While creating region", (Throwable)ex);
                }
            }
        };
        vm0.invoke(createRegion);
        vm1.invoke(createRegion);
        SerializableRunnable performOps = new SerializableRunnable("perform concurrent ops"){

            @Override
            public void run() {
                try {
                    MultiVMRegionTestCase.this.doOpsLoop(5000, false);
                    long events = CCRegion.getCachePerfStats().getConflatedEventsCount();
                    if (!CCRegion.getScope().isGlobal()) {
                        ((AbstractBooleanAssert)Assertions.assertThat((events > 0L ? 1 : 0) != 0).describedAs("expected some event conflation", new Object[0])).isTrue();
                    }
                }
                catch (CacheException e) {
                    Assertions.fail((String)"while performing concurrent operations", (Throwable)e);
                }
            }
        };
        AsyncInvocation a0 = vm0.invokeAsync(performOps);
        AsyncInvocation a1 = vm1.invokeAsync(performOps);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Assertions.fail((String)"sleep was interrupted");
        }
        vm2.invoke(createRegion);
        boolean a0failed = this.waitForAsyncProcessing(a0, "expected some event conflation");
        boolean a1failed = this.waitForAsyncProcessing(a1, "expected some event conflation");
        if (a0failed && a1failed) {
            Assertions.fail((String)("neither member saw event conflation - check stats for " + name));
        }
        Map r0Contents = (Map)vm0.invoke(MultiVMRegionTestCase::getCCRegionContents);
        Map r1Contents = (Map)vm1.invoke(MultiVMRegionTestCase::getCCRegionContents);
        Map r2Contents = (Map)vm2.invoke(MultiVMRegionTestCase::getCCRegionContents);
        for (i = 0; i < 10; ++i) {
            key = "cckey" + i;
            ((ObjectAssert)Assertions.assertThat(r1Contents.get(key)).describedAs("region contents are not consistent for " + key, new Object[0])).isEqualTo(r0Contents.get(key));
            ((ObjectAssert)Assertions.assertThat(r2Contents.get(key)).describedAs("region contents are not consistent for " + key, new Object[0])).isEqualTo(r1Contents.get(key));
            for (subi = 1; subi < 3; ++subi) {
                subkey = key + "-" + subi;
                if (r0Contents.containsKey(subkey)) {
                    ((ObjectAssert)Assertions.assertThat(r1Contents.get(subkey)).describedAs("region contents are not consistent for " + (String)subkey, new Object[0])).isEqualTo(r0Contents.get(subkey));
                    ((ObjectAssert)Assertions.assertThat(r2Contents.get(subkey)).describedAs("region contents are not consistent for " + (String)subkey, new Object[0])).isEqualTo(r1Contents.get(subkey));
                    continue;
                }
                Assertions.assertThat((boolean)r1Contents.containsKey(subkey)).isFalse();
            }
        }
        if (!this.getRegionAttributes().getScope().isDistributedNoAck()) {
            vm0.invoke(MultiVMRegionTestCase::clearCCRegion);
            performOps = new SerializableRunnable("perform concurrent delta ops"){

                @Override
                public void run() {
                    try {
                        long stopTime = System.currentTimeMillis() + 5000L;
                        Random ran = new Random(System.currentTimeMillis());
                        while (System.currentTimeMillis() < stopTime) {
                            for (int i = 0; i < 10; ++i) {
                                CCRegion.put((Object)("cckey" + i), (Object)new DeltaValue("ccvalue" + ran.nextInt()));
                            }
                        }
                        long events = CCRegion.getCachePerfStats().getDeltaFailedUpdates();
                        ((AbstractBooleanAssert)Assertions.assertThat((events > 0L ? 1 : 0) != 0).describedAs("expected some failed deltas", new Object[0])).isTrue();
                    }
                    catch (CacheException e) {
                        Assertions.fail((String)"while performing concurrent operations", (Throwable)e);
                    }
                }
            };
            a0 = vm0.invokeAsync(performOps);
            a1 = vm1.invokeAsync(performOps);
            a0failed = this.waitForAsyncProcessing(a0, "expected some failed deltas");
            a1failed = this.waitForAsyncProcessing(a1, "expected some failed deltas");
            if (a0failed && a1failed) {
                Assertions.fail((String)("neither member saw failed deltas - check stats for " + name));
            }
            r0Contents = (Map)vm0.invoke(MultiVMRegionTestCase::getCCRegionContents);
            r1Contents = (Map)vm1.invoke(MultiVMRegionTestCase::getCCRegionContents);
            r2Contents = (Map)vm2.invoke(MultiVMRegionTestCase::getCCRegionContents);
            for (i = 0; i < 10; ++i) {
                key = "cckey" + i;
                ((ObjectAssert)Assertions.assertThat(r1Contents.get(key)).describedAs("region contents are not consistent", new Object[0])).isEqualTo(r0Contents.get(key));
                ((ObjectAssert)Assertions.assertThat(r2Contents.get(key)).describedAs("region contents are not consistent", new Object[0])).isEqualTo(r1Contents.get(key));
                for (subi = 1; subi < 3; ++subi) {
                    subkey = key + "-" + subi;
                    if (r0Contents.containsKey(subkey)) {
                        ((ObjectAssert)Assertions.assertThat(r1Contents.get(subkey)).describedAs("region contents are not consistent", new Object[0])).isEqualTo(r0Contents.get(subkey));
                        ((ObjectAssert)Assertions.assertThat(r2Contents.get(subkey)).describedAs("region contents are not consistent", new Object[0])).isEqualTo(r1Contents.get(subkey));
                        continue;
                    }
                    Assertions.assertThat((boolean)r1Contents.containsKey(subkey)).isFalse();
                }
            }
            ArrayList versionVectors = new ArrayList();
            ArrayList<InternalDistributedMember> vmIds = new ArrayList<InternalDistributedMember>();
            ArrayList versions = new ArrayList();
            for (VM vm : Arrays.asList(vm0, vm1, vm2)) {
                vmIds.add((InternalDistributedMember)vm.invoke(MultiVMRegionTestCase::getMemberId));
                versionVectors.add(this.getVersionVector(vm));
                versions.add(vm.invoke(MultiVMRegionTestCase::getCCRegionVersions));
            }
            for (int i2 = 0; i2 < versions.size(); ++i2) {
                this.compareVersions((Map)versions.get(0), (InternalDistributedMember)vmIds.get(0), vmIds, versionVectors);
            }
        }
    }

    private void compareVersions(Map<String, VersionTag<VersionSource<?>>> versions, InternalDistributedMember defaultID, List<InternalDistributedMember> vmIds, List<RegionVersionVector<VersionSource<?>>> versionVectors) {
        for (Map.Entry<String, VersionTag<VersionSource<?>>> entry : versions.entrySet()) {
            VersionTag<VersionSource<?>> tag = entry.getValue();
            tag.replaceNullIDs((VersionSource)defaultID);
            for (int i = 0; i < vmIds.size(); ++i) {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)versionVectors.get(i).contains(tag.getMemberID(), tag.getRegionVersion())).describedAs(vmIds.get(i) + " should contain " + tag, new Object[0])).isTrue();
            }
        }
    }

    private RegionVersionVector<VersionSource<?>> getVersionVector(VM vm) throws Exception {
        byte[] serializedForm = (byte[])vm.invoke(MultiVMRegionTestCase::getCCRegionVersionVector);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(serializedForm));
        return (RegionVersionVector)DataSerializer.readObject((DataInput)dis);
    }

    private AsyncInvocation performOps4ClearWithConcurrentEvents(VM vm, final int msToRun) {
        SerializableRunnable performOps = new SerializableRunnable("perform concurrent ops"){

            @Override
            public void run() {
                try {
                    MultiVMRegionTestCase.this.doOpsLoop(msToRun, true);
                }
                catch (CacheException e) {
                    Assertions.fail((String)"while performing concurrent operations", (Throwable)e);
                }
            }
        };
        return vm.invokeAsync(performOps);
    }

    protected void createRegionWithAttribute(VM vm, final String name, final boolean syncDiskWrite) {
        SerializableRunnable createRegion = new SerializableRunnable("Create Region"){

            @Override
            public void run() {
                try {
                    RegionFactory f = MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                    f.setDiskSynchronous(syncDiskWrite);
                    CCRegion = (LocalRegion)f.create(name);
                }
                catch (CacheException ex) {
                    Assertions.fail((String)"While creating region", (Throwable)ex);
                }
            }
        };
        vm.invoke(createRegion);
    }

    public void versionTestClearWithConcurrentEvents() {
        this.versionTestClearWithConcurrentEvents(true);
    }

    public void versionTestClearWithConcurrentEventsAsync() {
        this.versionTestClearWithConcurrentEvents(false);
    }

    private void versionTestClearWithConcurrentEvents(boolean syncDiskWrite) {
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        VM vm2 = VM.getVM(2);
        String name = this.getUniqueName() + "-CC";
        this.createRegionWithAttribute(vm0, name, syncDiskWrite);
        this.createRegionWithAttribute(vm1, name, syncDiskWrite);
        AsyncInvocation a0 = this.performOps4ClearWithConcurrentEvents(vm0, 5000);
        AsyncInvocation a1 = this.performOps4ClearWithConcurrentEvents(vm1, 5000);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Assertions.fail((String)"sleep was interrupted");
        }
        this.createRegionWithAttribute(vm2, name, syncDiskWrite);
        this.waitForAsyncProcessing(a0, "");
        this.waitForAsyncProcessing(a1, "");
        Map r0Contents = (Map)vm0.invoke(MultiVMRegionTestCase::getCCRegionContents);
        Map r1Contents = (Map)vm1.invoke(MultiVMRegionTestCase::getCCRegionContents);
        Map r2Contents = (Map)vm2.invoke(MultiVMRegionTestCase::getCCRegionContents);
        for (int i = 0; i < 10; ++i) {
            String key = "cckey" + i;
            ((ObjectAssert)Assertions.assertThat(r1Contents.get(key)).describedAs("region contents are not consistent", new Object[0])).isEqualTo(r0Contents.get(key));
            ((ObjectAssert)Assertions.assertThat(r2Contents.get(key)).describedAs("region contents are not consistent", new Object[0])).isEqualTo(r1Contents.get(key));
            for (int subi = 1; subi < 3; ++subi) {
                String subkey = key + "-" + subi;
                if (r0Contents.containsKey(subkey)) {
                    ((ObjectAssert)Assertions.assertThat(r1Contents.get(subkey)).describedAs("region contents are not consistent", new Object[0])).isEqualTo(r0Contents.get(subkey));
                    ((ObjectAssert)Assertions.assertThat(r2Contents.get(subkey)).describedAs("region contents are not consistent", new Object[0])).isEqualTo(r1Contents.get(subkey));
                    continue;
                }
                boolean condition = !r1Contents.containsKey(subkey);
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)condition).describedAs("expected containsKey(" + subkey + ") to return false", new Object[0])).isTrue();
            }
        }
        vm0.invoke(MultiVMRegionTestCase::assertNoClearTimeouts);
        vm1.invoke(MultiVMRegionTestCase::assertNoClearTimeouts);
        vm2.invoke(MultiVMRegionTestCase::assertNoClearTimeouts);
    }

    public void versionTestClearOnNonReplicateWithConcurrentEvents() {
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        VM vm2 = VM.getVM(2);
        VM vm3 = VM.getVM(3);
        final String name = this.getUniqueName() + "-CC";
        SerializableRunnable createRegion = new SerializableRunnable("Create Region"){

            @Override
            public void run() {
                try {
                    RegionFactory f;
                    if (VM.getCurrentVMNum() == 0) {
                        f = MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes(RegionShortcut.REPLICATE_PROXY.toString()));
                    } else if (VM.getCurrentVMNum() == 1) {
                        f = MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                        f.setDataPolicy(DataPolicy.NORMAL);
                    } else {
                        f = MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                    }
                    CCRegion = (LocalRegion)f.create(name);
                }
                catch (CacheException ex) {
                    Assertions.fail((String)"While creating region", (Throwable)ex);
                }
            }
        };
        vm0.invoke(createRegion);
        vm1.invoke(createRegion);
        vm2.invoke(createRegion);
        vm3.invoke(createRegion);
        SerializableRunnable performOps = new SerializableRunnable("perform concurrent ops"){

            @Override
            public void run() {
                try {
                    MultiVMRegionTestCase.this.doOpsLoop(5000, true);
                }
                catch (CacheException e) {
                    Assertions.fail((String)"while performing concurrent operations", (Throwable)e);
                }
                if (CCRegion.getScope().isDistributedNoAck()) {
                    MultiVMRegionTestCase.this.sendSerialMessageToAll();
                }
            }
        };
        AsyncInvocation a0 = vm0.invokeAsync(performOps);
        AsyncInvocation a1 = vm1.invokeAsync(performOps);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Assertions.fail((String)"sleep was interrupted");
        }
        this.waitForAsyncProcessing(a0, "");
        this.waitForAsyncProcessing(a1, "");
        Map r2Contents = (Map)vm2.invoke(MultiVMRegionTestCase::getCCRegionContents);
        Map r3Contents = (Map)vm3.invoke(MultiVMRegionTestCase::getCCRegionContents);
        for (int i = 0; i < 10; ++i) {
            String key = "cckey" + i;
            ((ObjectAssert)Assertions.assertThat(r3Contents.get(key)).describedAs("region contents are not consistent for " + key, new Object[0])).isEqualTo(r2Contents.get(key));
            for (int subi = 1; subi < 3; ++subi) {
                String subkey = key + "-" + subi;
                if (!r2Contents.containsKey(subkey)) continue;
                ((ObjectAssert)Assertions.assertThat(r3Contents.get(subkey)).describedAs("region contents are not consistent for " + subkey, new Object[0])).isEqualTo(r2Contents.get(subkey));
            }
        }
        vm1.invoke(MultiVMRegionTestCase::assertNoClearTimeouts);
        vm2.invoke(MultiVMRegionTestCase::assertNoClearTimeouts);
        vm3.invoke(MultiVMRegionTestCase::assertNoClearTimeouts);
    }

    private void checkCCRegionTombstoneCount(String msg, int expected) {
        int actual = CCRegion.getTombstoneCount();
        if (expected != actual) {
            ((AbstractIntegerAssert)Assertions.assertThat((int)actual).describedAs(msg + " region tombstone count was " + actual + " expected=" + expected + " TombstoneService=" + CCRegion.getCache().getTombstoneService(), new Object[0])).isEqualTo(expected);
        }
    }

    private void waitForAllTombstonesToExpire(int initialTombstoneCount) {
        try {
            Awaitility.waitAtMost((long)(TombstoneService.REPLICATE_TOMBSTONE_TIMEOUT + TombstoneService.MAX_SLEEP_TIME * 9L), (TimeUnit)TimeUnit.MILLISECONDS).pollInterval(100L, TimeUnit.MILLISECONDS).until(() -> CCRegion.getTombstoneCount() == 0);
        }
        catch (ConditionTimeoutException timeout) {
            Assertions.fail((String)("Timed out waiting for all tombstones to expire.  There are now " + CCRegion.getTombstoneCount() + " tombstones left out of " + initialTombstoneCount + " initial tombstones. " + CCRegion.getCache().getTombstoneService()), (Throwable)timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void versionTestTombstones() {
        MultiVMRegionTestCase.disconnectAllFromDS();
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        int numEntries = 100;
        long oldServerTimeout = TombstoneService.REPLICATE_TOMBSTONE_TIMEOUT;
        long oldClientTimeout = TombstoneService.NON_REPLICATE_TOMBSTONE_TIMEOUT;
        int oldExpiredTombstoneLimit = TombstoneService.EXPIRED_TOMBSTONE_LIMIT;
        boolean oldIdleExpiration = TombstoneService.IDLE_EXPIRATION;
        double oldLimit = TombstoneService.GC_MEMORY_THRESHOLD;
        long oldMaxSleepTime = TombstoneService.MAX_SLEEP_TIME;
        try {
            SerializableRunnable setTimeout = new SerializableRunnable(){

                @Override
                public void run() {
                    TombstoneService.REPLICATE_TOMBSTONE_TIMEOUT = 1000L;
                    TombstoneService.NON_REPLICATE_TOMBSTONE_TIMEOUT = 900L;
                    TombstoneService.EXPIRED_TOMBSTONE_LIMIT = 100;
                    TombstoneService.IDLE_EXPIRATION = true;
                    TombstoneService.GC_MEMORY_THRESHOLD = 0.0;
                    TombstoneService.MAX_SLEEP_TIME = 500L;
                }
            };
            vm0.invoke(setTimeout);
            vm1.invoke(setTimeout);
            final String name = this.getUniqueName() + "-CC";
            SerializableRunnable createRegion = new SerializableRunnable("Create Region"){

                @Override
                public void run() {
                    try {
                        RegionFactory f = MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                        CCRegion = (LocalRegion)f.create(name);
                        for (int i = 0; i < 100; ++i) {
                            CCRegion.put((Object)("cckey" + i), (Object)"ccvalue");
                        }
                        if (CCRegion.getScope().isDistributedNoAck()) {
                            MultiVMRegionTestCase.this.sendSerialMessageToAll();
                        }
                    }
                    catch (CacheException ex) {
                        Assertions.fail((String)"While creating region", (Throwable)ex);
                    }
                }
            };
            vm0.invoke(createRegion);
            vm1.invoke(createRegion);
            vm0.invoke(new SerializableRunnable("destroy entries and check tombstone count"){

                @Override
                public void run() {
                    try {
                        for (int i = 0; i < 100; ++i) {
                            CCRegion.destroy((Object)("cckey" + i));
                            boolean condition1 = !CCRegion.containsKey((Object)("cckey" + i));
                            ((AbstractBooleanAssert)Assertions.assertThat((boolean)condition1).describedAs("entry should not exist", new Object[0])).isTrue();
                            boolean condition = !CCRegion.containsValueForKey((Object)("cckey" + i));
                            ((AbstractBooleanAssert)Assertions.assertThat((boolean)condition).describedAs("entry should not contain a value", new Object[0])).isTrue();
                        }
                        MultiVMRegionTestCase.this.checkCCRegionTombstoneCount("after destroys in this vm ", 100);
                        boolean condition = !CCRegion.containsValue((Object)Token.TOMBSTONE);
                        ((AbstractBooleanAssert)Assertions.assertThat((boolean)condition).describedAs("region should not contain a tombstone", new Object[0])).isTrue();
                        if (CCRegion.getScope().isDistributedNoAck()) {
                            MultiVMRegionTestCase.this.sendSerialMessageToAll();
                        }
                    }
                    catch (CacheException e) {
                        Assertions.fail((String)"while performing destroy operations", (Throwable)e);
                    }
                }
            });
            vm1.invoke(new SerializableRunnable("check tombstone count(2)"){

                @Override
                public void run() {
                    MultiVMRegionTestCase.this.checkCCRegionTombstoneCount("after destroys in other vm ", 100);
                    try {
                        MultiVMRegionTestCase.this.waitForAllTombstonesToExpire(100);
                    }
                    catch (ConditionTimeoutException e) {
                        CCRegion.dumpBackingMap();
                        logger.info("tombstone service state: " + CCRegion.getCache().getTombstoneService());
                        throw e;
                    }
                }
            });
            vm0.invoke(new SerializableRunnable("create/destroy entries and check tombstone count"){

                @Override
                public void run() {
                    int origCount = CCRegion.getTombstoneCount();
                    try {
                        MultiVMRegionTestCase.this.waitForAllTombstonesToExpire(origCount);
                        logger.debug("creating tombstones.  current count={}", (Object)CCRegion.getTombstoneCount());
                        for (int i = 0; i < 100; ++i) {
                            CCRegion.create((Object)("cckey" + i), (Object)i);
                            CCRegion.destroy((Object)("cckey" + i));
                        }
                        logger.debug("done creating tombstones.  current count={}", (Object)CCRegion.getTombstoneCount());
                        MultiVMRegionTestCase.this.checkCCRegionTombstoneCount("after create+destroy in this vm ", 100);
                        Assertions.assertThat((int)CCRegion.size()).isEqualTo(0);
                        afterCreates = 0;
                        AttributesMutator m = MultiVMRegionTestCase.attributesMutatorFor(CCRegion);
                        m.addCacheListener((CacheListener)new CacheListenerAdapter<Object, Object>(){

                            public void afterCreate(EntryEvent<Object, Object> event) {
                                afterCreates++;
                            }
                        });
                        if (CCRegion.getScope().isDistributedNoAck()) {
                            MultiVMRegionTestCase.this.sendSerialMessageToAll();
                        }
                    }
                    catch (AssertionError e) {
                        CCRegion.dumpBackingMap();
                        logger.info("tombstone service state: " + CCRegion.getCache().getTombstoneService());
                        throw e;
                    }
                    catch (CacheException e) {
                        Assertions.fail((String)"while performing create/destroy operations", (Throwable)e);
                    }
                }
            });
            vm1.invoke(new SerializableRunnable("check tombstone count and install listener"){

                @Override
                public void run() {
                    MultiVMRegionTestCase.this.checkCCRegionTombstoneCount("after create+destroy in other vm ", 100);
                    afterCreates = 0;
                    AttributesMutator m = MultiVMRegionTestCase.attributesMutatorFor(CCRegion);
                    m.addCacheListener((CacheListener)new CacheListenerAdapter<Object, Object>(){

                        public void afterCreate(EntryEvent<Object, Object> event) {
                            afterCreates++;
                        }
                    });
                }
            });
            vm0.invoke(new SerializableRunnable("create entries and check afterCreate and tombstone count"){

                @Override
                public void run() {
                    try {
                        for (int i = 0; i < 100; ++i) {
                            CCRegion.create((Object)("cckey" + i), (Object)i);
                        }
                        MultiVMRegionTestCase.this.checkCCRegionTombstoneCount("after create in this vm", 0);
                        ((AbstractIntegerAssert)Assertions.assertThat((int)afterCreates).describedAs("expected 100 afterCreates", new Object[0])).isEqualTo(100);
                        Assertions.assertThat((int)CCRegion.size()).isEqualTo(100);
                        if (CCRegion.getScope().isDistributedNoAck()) {
                            MultiVMRegionTestCase.this.sendSerialMessageToAll();
                        }
                        Awaitility.waitAtMost((long)(TombstoneService.REPLICATE_TOMBSTONE_TIMEOUT * 5L), (TimeUnit)TimeUnit.MILLISECONDS).pollInterval(100L, TimeUnit.MILLISECONDS).until(() -> CCRegion.getCache().getTombstoneService().getScheduledTombstoneCount() == 0L);
                    }
                    catch (CacheException e) {
                        Assertions.fail((String)"while performing create operations", (Throwable)e);
                    }
                    catch (ConditionTimeoutException timeout) {
                        Assertions.fail((String)("Timed out waiting for all scheduled tombstones to be removed.  There are now " + CCRegion.getCache().getTombstoneService().getScheduledTombstoneCount() + " tombstones left out of " + 100 + " initial tombstones. " + CCRegion.getCache().getTombstoneService()), (Throwable)timeout);
                    }
                }
            });
            vm1.invoke(new SerializableRunnable("check afterCreate and tombstone count"){

                @Override
                public void run() {
                    MultiVMRegionTestCase.this.checkCCRegionTombstoneCount("after create in other vm", 0);
                    ((AbstractIntegerAssert)Assertions.assertThat((int)afterCreates).describedAs("expected 100 afterCreates", new Object[0])).isEqualTo(100);
                    Assertions.assertThat((int)CCRegion.size()).isEqualTo(100);
                    try {
                        Awaitility.waitAtMost((long)(TombstoneService.REPLICATE_TOMBSTONE_TIMEOUT * 5L), (TimeUnit)TimeUnit.MILLISECONDS).pollInterval(100L, TimeUnit.MILLISECONDS).until(() -> CCRegion.getCache().getTombstoneService().getScheduledTombstoneCount() == 0L);
                    }
                    catch (ConditionTimeoutException timeout) {
                        String message = "Timed out waiting for all scheduled tombstones to be removed.  There are now " + CCRegion.getCache().getTombstoneService().getScheduledTombstoneCount() + " tombstones left out of " + 100 + " initial tombstones. " + CCRegion.getCache().getTombstoneService();
                        Assertions.fail((String)message, (Throwable)timeout);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            SerializableRunnable resetTimeout = new SerializableRunnable(oldServerTimeout, oldClientTimeout, oldExpiredTombstoneLimit, oldIdleExpiration, oldLimit, oldMaxSleepTime){
                final /* synthetic */ long val$oldServerTimeout;
                final /* synthetic */ long val$oldClientTimeout;
                final /* synthetic */ int val$oldExpiredTombstoneLimit;
                final /* synthetic */ boolean val$oldIdleExpiration;
                final /* synthetic */ double val$oldLimit;
                final /* synthetic */ long val$oldMaxSleepTime;
                {
                    this.val$oldServerTimeout = l;
                    this.val$oldClientTimeout = l2;
                    this.val$oldExpiredTombstoneLimit = n;
                    this.val$oldIdleExpiration = bl;
                    this.val$oldLimit = d;
                    this.val$oldMaxSleepTime = l3;
                }

                @Override
                public void run() {
                    TombstoneService.REPLICATE_TOMBSTONE_TIMEOUT = this.val$oldServerTimeout;
                    TombstoneService.NON_REPLICATE_TOMBSTONE_TIMEOUT = this.val$oldClientTimeout;
                    TombstoneService.EXPIRED_TOMBSTONE_LIMIT = this.val$oldExpiredTombstoneLimit;
                    TombstoneService.IDLE_EXPIRATION = this.val$oldIdleExpiration;
                    TombstoneService.GC_MEMORY_THRESHOLD = this.val$oldLimit;
                    TombstoneService.MAX_SLEEP_TIME = this.val$oldMaxSleepTime;
                }
            };
            vm0.invoke(resetTimeout);
            vm1.invoke(resetTimeout);
            throw throwable;
        }
        SerializableRunnable resetTimeout = new /* invalid duplicate definition of identical inner class */;
        vm0.invoke(resetTimeout);
        vm1.invoke(resetTimeout);
    }

    public void versionTestConcurrentEventsOnEmptyRegion() {
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        VM vm2 = VM.getVM(2);
        VM vm3 = VM.getVM(3);
        final String name = this.getUniqueName() + "-CC";
        SerializableRunnable createRegion = new SerializableRunnable("Create Region"){

            @Override
            public void run() {
                try {
                    RegionFactory f = VM.getCurrentVMNum() == 0 ? MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes(RegionShortcut.REPLICATE_PROXY.toString())) : MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                    CCRegion = (LocalRegion)f.create(name);
                }
                catch (CacheException ex) {
                    Assertions.fail((String)"While creating region", (Throwable)ex);
                }
            }
        };
        vm0.invoke(createRegion);
        vm1.invoke(createRegion);
        vm3.invoke(createRegion);
        SerializableRunnable performOps = new SerializableRunnable("perform concurrent ops"){

            @Override
            public void run() {
                try {
                    MultiVMRegionTestCase.this.doOpsLoop(5000, false);
                    MultiVMRegionTestCase.this.sendSerialMessageToAll();
                    if (CCRegion.getAttributes().getDataPolicy().withReplication()) {
                        long events = CCRegion.getCachePerfStats().getConflatedEventsCount();
                        ((AbstractBooleanAssert)Assertions.assertThat((events > 0L ? 1 : 0) != 0).describedAs("expected some event conflation", new Object[0])).isTrue();
                    }
                }
                catch (CacheException e) {
                    Assertions.fail((String)"while performing concurrent operations", (Throwable)e);
                }
            }
        };
        AsyncInvocation a0 = vm0.invokeAsync(performOps);
        AsyncInvocation a1 = vm1.invokeAsync(performOps);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Assertions.fail((String)"sleep was interrupted");
        }
        vm2.invoke(createRegion);
        boolean a0failed = this.waitForAsyncProcessing(a0, "expected some event conflation");
        boolean a1failed = this.waitForAsyncProcessing(a1, "expected some event conflation");
        if (a0failed && a1failed) {
            Assertions.fail((String)("neither member saw event conflation - check stats for " + name));
        }
        Awaitility.waitAtMost((long)5L, (TimeUnit)TimeUnit.MINUTES).until(() -> {
            Map r1Contents = (Map)vm1.invoke(MultiVMRegionTestCase::getCCRegionContents);
            Map r2Contents = (Map)vm2.invoke(MultiVMRegionTestCase::getCCRegionContents);
            Map r3Contents = (Map)vm3.invoke(MultiVMRegionTestCase::getCCRegionContents);
            try {
                for (int i = 0; i < 10; ++i) {
                    String key = "cckey" + i;
                    ((ObjectAssert)Assertions.assertThat(r2Contents.get(key)).describedAs("1 region contents are not consistent for i " + key, new Object[0])).isEqualTo(r1Contents.get(key));
                    ((ObjectAssert)Assertions.assertThat(r3Contents.get(key)).describedAs("2 region contents are not consistent for i " + key, new Object[0])).isEqualTo(r2Contents.get(key));
                    for (int subi = 1; subi < 3; ++subi) {
                        String subkey = key + "-" + subi;
                        if (r1Contents.containsKey(subkey)) {
                            ((ObjectAssert)Assertions.assertThat(r2Contents.get(subkey)).describedAs("3 region contents are not consistent for " + subkey, new Object[0])).isEqualTo(r1Contents.get(subkey));
                            ((ObjectAssert)Assertions.assertThat(r3Contents.get(subkey)).describedAs("4 region contents are not consistent for " + subkey, new Object[0])).isEqualTo(r2Contents.get(subkey));
                            continue;
                        }
                        boolean condition1 = !r2Contents.containsKey(subkey);
                        ((AbstractBooleanAssert)Assertions.assertThat((boolean)condition1).describedAs("5 r2contents", new Object[0])).isTrue();
                        boolean condition = !r3Contents.containsKey(subkey);
                        ((AbstractBooleanAssert)Assertions.assertThat((boolean)condition).describedAs("6 r3contents", new Object[0])).isTrue();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            return true;
        });
    }

    private void doOpsLoop(int runTimeMs, boolean includeClear) {
        MultiVMRegionTestCase.doOpsLoopNoFlush(runTimeMs, includeClear, true);
        if (CCRegion.getScope().isDistributedNoAck()) {
            this.sendSerialMessageToAll();
        }
    }

    public static void doOpsLoopNoFlush(int runTimeMs, boolean includeClear, boolean includePutAll) {
        long stopTime = System.currentTimeMillis() + (long)runTimeMs;
        Random ran = new Random(System.currentTimeMillis());
        String key = null;
        String value = null;
        while (System.currentTimeMillis() < stopTime) {
            for (int i = 0; i < 10; ++i) {
                String oldkey = key;
                String oldvalue = value;
                int v = ran.nextInt();
                key = "cckey" + i;
                value = "ccvalue" + v;
                try {
                    switch (v & 7) {
                        case 0: {
                            CCRegion.put((Object)key, (Object)value);
                            break;
                        }
                        case 1: {
                            if (CCRegion.getAttributes().getDataPolicy().withReplication()) {
                                if (oldkey == null) break;
                                CCRegion.replace((Object)oldkey, (Object)oldvalue, (Object)value);
                                break;
                            }
                        }
                        case 2: {
                            v = ran.nextInt();
                            if (includePutAll && (v & 7) < 3) {
                                HashMap<String, String> map = new HashMap<String, String>();
                                map.put(key, value);
                                map.put(key + "-1", value);
                                map.put(key + "-2", value);
                                CCRegion.putAll(map, (Object)"putAllCallback");
                                break;
                            }
                            CCRegion.put((Object)key, (Object)value);
                            break;
                        }
                        case 3: {
                            if (CCRegion.getAttributes().getDataPolicy().withReplication()) {
                                if (oldkey == null) break;
                                CCRegion.remove((Object)oldkey, (Object)oldvalue);
                                break;
                            }
                        }
                        case 4: {
                            CCRegion.destroy((Object)key);
                            break;
                        }
                        case 5: {
                            if (includeClear) {
                                CCRegion.clear();
                                break;
                            }
                            if (CCRegion.getAttributes().getDataPolicy().withReplication()) {
                                if (oldkey == null) break;
                                CCRegion.putIfAbsent((Object)oldkey, (Object)value);
                                break;
                            }
                        }
                        case 6: {
                            CCRegion.invalidate((Object)key);
                        }
                    }
                    continue;
                }
                catch (EntryNotFoundException entryNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    public void versionTestConcurrentEventsOnNonReplicatedRegion() {
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        VM vm2 = VM.getVM(2);
        VM vm3 = VM.getVM(3);
        final boolean noAck = !this.getRegionAttributes().getScope().isAck();
        final String name = this.getUniqueName() + "-CC";
        SerializableRunnable createRegion = new SerializableRunnable("Create Region"){

            @Override
            public void run() {
                try {
                    RegionFactory f;
                    if (VM.getCurrentVMNum() == 0) {
                        f = MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes(RegionShortcut.LOCAL.toString()));
                        f.setScope(MultiVMRegionTestCase.this.getRegionAttributes().getScope());
                    } else {
                        f = MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                    }
                    CCRegion = (LocalRegion)f.create(name);
                }
                catch (CacheException ex) {
                    Assertions.fail((String)"While creating region", (Throwable)ex);
                }
            }
        };
        vm0.invoke(createRegion);
        vm1.invoke(createRegion);
        vm3.invoke(createRegion);
        SerializableRunnable performOps = new SerializableRunnable("perform concurrent ops"){

            @Override
            public void run() {
                try {
                    MultiVMRegionTestCase.this.doOpsLoop(5000, false);
                    MultiVMRegionTestCase.this.sendSerialMessageToAll();
                    if (CCRegion.getAttributes().getDataPolicy().withReplication()) {
                        long events = CCRegion.getCachePerfStats().getConflatedEventsCount();
                        ((AbstractBooleanAssert)Assertions.assertThat((events > 0L ? 1 : 0) != 0).describedAs("expected some event conflation", new Object[0])).isTrue();
                    }
                }
                catch (CacheException e) {
                    Assertions.fail((String)"while performing concurrent operations", (Throwable)e);
                }
            }
        };
        AsyncInvocation a0 = vm0.invokeAsync(performOps);
        AsyncInvocation a1 = vm1.invokeAsync(performOps);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Assertions.fail((String)"sleep was interrupted");
        }
        vm2.invoke(createRegion);
        boolean a0failed = this.waitForAsyncProcessing(a0, "expected some event conflation");
        boolean a1failed = this.waitForAsyncProcessing(a1, "expected some event conflation");
        if (a0failed && a1failed) {
            Assertions.fail((String)("neither member saw event conflation - check stats for " + name));
        }
        Map r0Contents = (Map)vm0.invoke(MultiVMRegionTestCase::getCCRegionContents);
        Map r1Contents = (Map)vm1.invoke(MultiVMRegionTestCase::getCCRegionContents);
        Map r2Contents = (Map)vm2.invoke(MultiVMRegionTestCase::getCCRegionContents);
        Map r3Contents = (Map)vm3.invoke(MultiVMRegionTestCase::getCCRegionContents);
        for (int i = 0; i < 10; ++i) {
            String key = "cckey" + i;
            ((ObjectAssert)Assertions.assertThat(r2Contents.get(key)).describedAs("region contents are not consistent", new Object[0])).isEqualTo(r1Contents.get(key));
            ((ObjectAssert)Assertions.assertThat(r3Contents.get(key)).describedAs("region contents are not consistent", new Object[0])).isEqualTo(r2Contents.get(key));
            for (int subi = 1; subi < 3; ++subi) {
                String subkey = key + "-" + subi;
                if (r1Contents.containsKey(subkey)) {
                    ((ObjectAssert)Assertions.assertThat(r2Contents.get(subkey)).describedAs("region contents are not consistent", new Object[0])).isEqualTo(r1Contents.get(subkey));
                    ((ObjectAssert)Assertions.assertThat(r3Contents.get(subkey)).describedAs("region contents are not consistent", new Object[0])).isEqualTo(r2Contents.get(subkey));
                    if (!r0Contents.containsKey(subkey)) continue;
                    ((ObjectAssert)Assertions.assertThat(r0Contents.get(subkey)).describedAs("region contents are not consistent", new Object[0])).isEqualTo(r1Contents.get(subkey));
                    continue;
                }
                Assertions.assertThat((boolean)r2Contents.containsKey(subkey)).isFalse();
                Assertions.assertThat((boolean)r3Contents.containsKey(subkey)).isFalse();
                Assertions.assertThat((boolean)r0Contents.containsKey(subkey)).isFalse();
            }
        }
        String loadKey = "loadKey";
        vm0.invoke(new SerializableRunnable("add cache loader and create destroyed entry"){

            @Override
            public void run() {
                AttributesMutator attributesMutator = MultiVMRegionTestCase.attributesMutatorFor(CCRegion);
                attributesMutator.setCacheLoader((CacheLoader)new CacheLoader<Object, Object>(){

                    public void close() {
                    }

                    public Object load(LoaderHelper<Object, Object> helper) throws CacheLoaderException {
                        logger.info("The test CacheLoader has been invoked for key '" + helper.getKey() + "'");
                        return "loadedValue";
                    }
                });
                CCRegion.put((Object)"loadKey", (Object)"willbeLoadedInitialValue");
                CCRegion.destroy((Object)"loadKey");
                if (noAck) {
                    MultiVMRegionTestCase.this.sendSerialMessageToAll();
                }
            }
        });
        vm1.invoke(new SerializableRunnable("confirm tombstone"){

            @Override
            public void run() {
                Assertions.assertThat((Object)CCRegion.getRegionEntry((Object)"loadKey").getValueInVM((RegionEntryContext)CCRegion)).isSameAs((Object)Token.TOMBSTONE);
            }
        });
        vm0.invoke(new SerializableRunnable("use cache loader"){

            @Override
            public void run() {
                Assertions.assertThat((Object)CCRegion.get((Object)"loadKey")).isEqualTo((Object)"loadedValue");
                Assertions.assertThat((int)CCRegion.getRegionEntry((Object)"loadKey").getVersionStamp().getEntryVersion()).isEqualTo(3L);
            }
        });
        if (!noAck) {
            vm1.invoke(new SerializableRunnable("verify version number"){

                @Override
                public void run() {
                    Assertions.assertThat((Object)CCRegion.get((Object)"loadKey")).isEqualTo((Object)"loadedValue");
                    Assertions.assertThat((int)CCRegion.getRegionEntry((Object)"loadKey").getVersionStamp().getEntryVersion()).isEqualTo(3L);
                }
            });
        }
    }

    public void versionTestGetAllWithVersions() {
        Assumptions.assumeThat((boolean)this.getRegionAttributes().getScope().isAck()).isTrue();
        VM vm0 = VM.getVM(0);
        VM vm1 = VM.getVM(1);
        final String regionName = this.getUniqueName() + "CCRegion";
        SerializableRunnable createRegion = new SerializableRunnable("Create Region"){

            @Override
            public void run() {
                try {
                    RegionFactory f;
                    if (VM.getCurrentVMNum() == 0) {
                        f = MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes(RegionShortcut.LOCAL.toString()));
                        f.setScope(MultiVMRegionTestCase.this.getRegionAttributes().getScope());
                    } else {
                        f = MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                    }
                    CCRegion = (LocalRegion)f.create(regionName);
                }
                catch (CacheException ex) {
                    Assertions.fail((String)"While creating region", (Throwable)ex);
                }
            }
        };
        vm0.invoke(createRegion);
        vm1.invoke(createRegion);
        vm1.invoke(new SerializableRunnable("Populate region and perform some ops"){

            @Override
            public void run() {
                int i;
                for (i = 0; i < 100; ++i) {
                    CCRegion.put((Object)("cckey" + i), (Object)i);
                }
                for (i = 0; i < 100; ++i) {
                    CCRegion.put((Object)("cckey" + i), (Object)(i + 1));
                }
            }
        });
        vm0.invoke(new SerializableRunnable("Perform getAll"){

            @Override
            public void run() {
                LinkedList<String> keys = new LinkedList<String>();
                for (int i = 0; i < 100; ++i) {
                    keys.add("cckey" + i);
                }
                Map result = CCRegion.getAll(keys);
                Assertions.assertThat((int)keys.size()).isEqualTo(result.size());
                LocalRegion r = CCRegion;
                for (int i = 0; i < 100; ++i) {
                    RegionEntry entry = r.getRegionEntry((Object)("cckey" + i));
                    int stamp = entry.getVersionStamp().getEntryVersion();
                    logger.info("checking key cckey" + i + " having version " + stamp + " entry=" + entry);
                    Assertions.assertThat((int)stamp).isEqualTo(2);
                    Assertions.assertThat((int)(i + 1)).isEqualTo(result.get("cckey" + i));
                }
            }
        });
    }

    boolean waitForAsyncProcessing(AsyncInvocation async, String expectedError) {
        try {
            async.getResult();
        }
        catch (Throwable e) {
            Assertions.assertThat((boolean)ThrowableUtils.hasCauseMessage((Throwable)e, (String)expectedError)).isTrue();
        }
        return false;
    }

    protected long getRepeatTimeoutMs() {
        return 0L;
    }

    private static void assertNoClearTimeouts() {
        ((AbstractIntegerAssert)Assertions.assertThat((int)CCRegion.getCachePerfStats().getClearTimeouts()).describedAs("expected there to be no timeouts - something is broken", new Object[0])).isEqualTo(0);
    }

    private static void clearCCRegion() {
        CCRegion.clear();
    }

    public static Map getCCRegionContents() {
        return new HashMap(CCRegion);
    }

    private static byte[] getCCRegionVersionVector() throws Exception {
        InternalDistributedMember id = MultiVMRegionTestCase.getMemberId();
        int vm = VM.getCurrentVMNum();
        logger.info("vm" + vm + " with id " + id + " copying " + CCRegion.getVersionVector().fullToString());
        RegionVersionVector vector = CCRegion.getVersionVector().getCloneForTransmission();
        logger.info("clone is " + vector);
        HeapDataOutputStream dos = new HeapDataOutputStream(3000, Version.CURRENT);
        DataSerializer.writeObject((Object)vector, (DataOutput)dos);
        byte[] bytes = dos.toByteArray();
        logger.info("serialized size is " + bytes.length);
        return bytes;
    }

    private static Map<String, VersionTag<VersionSource<?>>> getCCRegionVersions() {
        HashMap result = new HashMap();
        LocalRegion regionAsMap = CCRegion;
        for (String key : regionAsMap.keySet()) {
            result.put(key, CCRegion.getRegionEntry((Object)key).getVersionStamp().asVersionTag());
        }
        return result;
    }

    private static InternalDistributedMember getMemberId() {
        return CCRegion.getDistributionManager().getDistributionManagerId();
    }

    private void sendSerialMessageToAll() {
        if (this.getCache() instanceof GemFireCacheImpl) {
            try {
                SerialAckedMessage msg = new SerialAckedMessage();
                msg.send(this.getCache().getDistributionManager().getNormalDistributionManagerIds(), false);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to send serial message due to exception", e);
            }
        }
    }

    private static <L extends TransactionListener> L firstTransactionListenerFrom(CacheTransactionManager transactionManager) {
        return (L)transactionManager.getListeners()[0];
    }

    private static <A extends AttributesMutator> A attributesMutatorFor(LocalRegion region) {
        return (A)region.getAttributesMutator();
    }

    private SerializableRunnableIF repeatingIfNecessary(SerializableRunnableIF runnable) {
        return MultiVMRegionTestCase.repeatingIfNecessary(this.getRepeatTimeoutMs(), runnable);
    }

    private static SerializableRunnableIF repeatingIfNecessary(long timeoutMillis, SerializableRunnableIF runnable) {
        if (timeoutMillis > 50L) {
            return () -> Awaitility.waitAtMost((long)timeoutMillis, (TimeUnit)TimeUnit.MILLISECONDS).pollInterval(50L, TimeUnit.MILLISECONDS).pollDelay(0L, TimeUnit.MILLISECONDS).untilAsserted(runnable::run);
        }
        return runnable;
    }

    static {
        destroyListener = null;
    }

    static class DeltaValue
    implements Delta,
    Serializable {
        private String value;

        public DeltaValue() {
        }

        DeltaValue(String value) {
            this.value = value;
        }

        public boolean hasDelta() {
            return true;
        }

        public void toDelta(DataOutput out) throws IOException {
            out.writeUTF(this.value);
        }

        public void fromDelta(DataInput in) throws IOException, InvalidDeltaException {
            this.value = in.readUTF();
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeltaValue)) {
                return false;
            }
            return this.value.equals(((DeltaValue)obj).value);
        }

        public String toString() {
            return this.value;
        }
    }

    private static class CountingDistCacheListener<K, V>
    extends CacheListenerAdapter<K, V> {
        private int aCreateCalls;
        private int aUpdateCalls;
        private int aInvalidateCalls;
        private int aDestroyCalls;
        private int regionOps;
        private EntryEvent<K, V> lastEvent;

        private CountingDistCacheListener() {
        }

        public void close() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCreate(EntryEvent<K, V> e) {
            if (e.isOriginRemote()) {
                CountingDistCacheListener countingDistCacheListener = this;
                synchronized (countingDistCacheListener) {
                    ++this.aCreateCalls;
                    this.lastEvent = e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterUpdate(EntryEvent<K, V> e) {
            if (e.isOriginRemote()) {
                CountingDistCacheListener countingDistCacheListener = this;
                synchronized (countingDistCacheListener) {
                    ++this.aUpdateCalls;
                    this.lastEvent = e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterInvalidate(EntryEvent<K, V> e) {
            if (e.isOriginRemote()) {
                CountingDistCacheListener countingDistCacheListener = this;
                synchronized (countingDistCacheListener) {
                    ++this.aInvalidateCalls;
                    this.lastEvent = e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterDestroy(EntryEvent<K, V> e) {
            if (e.isOriginRemote()) {
                CountingDistCacheListener countingDistCacheListener = this;
                synchronized (countingDistCacheListener) {
                    ++this.aDestroyCalls;
                    this.lastEvent = e;
                }
            }
        }

        public synchronized void afterRegionInvalidate(RegionEvent<K, V> e) {
            ++this.regionOps;
        }

        public synchronized void afterRegionDestroy(RegionEvent<K, V> e) {
            ++this.regionOps;
        }

        synchronized void assertCount(int expectedCreate, int expectedUpdate, int expectedInvalidate, int expectedDestroy) {
            Assertions.assertThat((int)this.aCreateCalls).isEqualTo(expectedCreate);
            Assertions.assertThat((int)this.aUpdateCalls).isEqualTo(expectedUpdate);
            Assertions.assertThat((int)this.aInvalidateCalls).isEqualTo(expectedInvalidate);
            Assertions.assertThat((int)this.aDestroyCalls).isEqualTo(expectedDestroy);
            Assertions.assertThat((int)this.regionOps).isEqualTo(0);
        }

        synchronized EntryEvent<K, V> getEntryEvent() {
            return this.lastEvent;
        }

        synchronized void setEntryEvent(EntryEvent<K, V> event) {
            this.lastEvent = event;
        }
    }

    private static class MyTransactionListener<K, V>
    implements TransactionListener<K, V> {
        private volatile TransactionId expectedTxId;
        private volatile TransactionEvent<K, V> lastEvent;
        private volatile int afterCommitCount;
        private volatile int afterFailedCommitCount;
        private volatile int afterRollbackCount;
        private volatile int closeCount;

        private MyTransactionListener() {
        }

        public synchronized void afterCommit(TransactionEvent<K, V> event) {
            this.lastEvent = event;
            ++this.afterCommitCount;
        }

        public synchronized void afterFailedCommit(TransactionEvent<K, V> event) {
            this.lastEvent = event;
            ++this.afterFailedCommitCount;
        }

        public synchronized void afterRollback(TransactionEvent<K, V> event) {
            this.lastEvent = event;
            ++this.afterRollbackCount;
        }

        public synchronized void close() {
            ++this.closeCount;
        }

        synchronized void checkAfterCommitCount(int expected) {
            Assertions.assertThat((int)this.afterCommitCount).isEqualTo(expected);
        }

        synchronized void assertCounts(int commitCount, int failedCommitCount, int rollbackCount, int closeCount1) {
            Assertions.assertThat((int)this.afterCommitCount).isEqualTo(commitCount);
            Assertions.assertThat((int)this.afterFailedCommitCount).isEqualTo(failedCommitCount);
            Assertions.assertThat((int)this.afterRollbackCount).isEqualTo(rollbackCount);
            Assertions.assertThat((int)this.closeCount).isEqualTo(closeCount1);
        }
    }

    static class DSLongWrapper
    extends LongWrapper
    implements DataSerializable {
        DSLongWrapper(long longValue) {
            super(longValue);
        }

        DSLongWrapper() {
            super(0L);
        }

        public void toData(DataOutput out) throws IOException {
            out.writeLong(this.longValue);
        }

        public void fromData(DataInput in) throws IOException {
            this.longValue = in.readLong();
        }

        static class DSLongWrapperInstantiator
        extends Instantiator {
            boolean wasInvoked = false;

            DSLongWrapperInstantiator(Class<? extends DSLongWrapper> c, byte id) {
                super(c, (int)id);
            }

            DSLongWrapperInstantiator() {
                this(DSLongWrapper.class, 99);
            }

            public DataSerializable newInstance() {
                this.wasInvoked = true;
                return new DSLongWrapper();
            }
        }
    }

    static class LongWrapper {
        long longValue;

        LongWrapper(long longValue) {
            this.longValue = longValue;
        }

        public boolean equals(Object o) {
            if (o instanceof LongWrapper) {
                return ((LongWrapper)o).longValue == this.longValue;
            }
            return false;
        }

        static class LongWrapperSerializer
        extends DataSerializer {
            boolean wasInvoked = false;

            LongWrapperSerializer() {
            }

            public int getId() {
                return 121;
            }

            public Class[] getSupportedClasses() {
                return new Class[]{LongWrapper.class};
            }

            public boolean toData(Object o, DataOutput out) throws IOException {
                if (o instanceof LongWrapper) {
                    this.wasInvoked = true;
                    LongWrapper iw = (LongWrapper)o;
                    out.writeLong(iw.longValue);
                    return true;
                }
                return false;
            }

            public Object fromData(DataInput in) throws IOException {
                return new LongWrapper(in.readLong());
            }
        }
    }

    static class DSIntWrapper
    extends IntWrapper
    implements DataSerializable {
        DSIntWrapper(int intValue) {
            super(intValue);
        }

        DSIntWrapper() {
            super(0);
        }

        public void toData(DataOutput out) throws IOException {
            out.writeInt(this.intValue);
        }

        public void fromData(DataInput in) throws IOException {
            this.intValue = in.readInt();
        }

        static class DSIntWrapperInstantiator
        extends Instantiator {
            DSIntWrapperInstantiator() {
                this(DSIntWrapper.class, 76);
            }

            DSIntWrapperInstantiator(Class<? extends DSIntWrapper> c, byte id) {
                super(c, (int)id);
            }

            public DataSerializable newInstance() {
                return new DSIntWrapper();
            }
        }
    }

    static class IntWrapper {
        int intValue;

        IntWrapper(int intValue) {
            this.intValue = intValue;
        }

        public boolean equals(Object o) {
            if (o instanceof IntWrapper) {
                return ((IntWrapper)o).intValue == this.intValue;
            }
            return false;
        }

        static class IntWrapperSerializer
        extends DataSerializer {
            boolean wasInvoked = false;

            IntWrapperSerializer() {
            }

            public int getId() {
                return 120;
            }

            public Class[] getSupportedClasses() {
                return new Class[]{IntWrapper.class};
            }

            public boolean toData(Object o, DataOutput out) throws IOException {
                if (o instanceof IntWrapper) {
                    this.wasInvoked = true;
                    IntWrapper iw = (IntWrapper)o;
                    out.writeInt(iw.intValue);
                    return true;
                }
                return false;
            }

            public Object fromData(DataInput in) throws IOException {
                return new IntWrapper(in.readInt());
            }
        }
    }
}

