/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache30;

import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.CacheRuntimeException;
import org.apache.geode.test.dunit.RepeatableRunnable;
import org.apache.geode.test.dunit.SerializableRunnable;

public abstract class CacheSerializableRunnable
extends SerializableRunnable
implements RepeatableRunnable {
    public CacheSerializableRunnable(String name) {
        super(name);
    }

    public CacheSerializableRunnable(String name, Object[] args) {
        super(name);
        this.args = args;
    }

    @Override
    public void run() {
        try {
            if (this.args == null) {
                this.run2();
            } else {
                this.run3();
            }
        }
        catch (CacheException ex) {
            String s = "While invoking \"" + this + "\"";
            throw new CacheSerializableRunnableException(s, ex);
        }
    }

    @Override
    public void runRepeatingIfNecessary(long repeatTimeoutMs) {
        long start = System.currentTimeMillis();
        AssertionError lastErr = null;
        do {
            try {
                lastErr = null;
                this.run();
            }
            catch (AssertionError err) {
                lastErr = err;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException("interrupted", ex);
                }
            }
        } while (lastErr != null && System.currentTimeMillis() - start < repeatTimeoutMs);
        if (lastErr != null) {
            throw lastErr;
        }
    }

    public abstract void run2() throws CacheException;

    public void run3() throws CacheException {
    }

    public static class CacheSerializableRunnableException
    extends CacheRuntimeException {
        public CacheSerializableRunnableException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

