/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security.query;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.geode.security.TestSecurityManager;
import org.apache.geode.security.query.UserPermissions;
import org.apache.geode.test.dunit.rules.ClientVM;
import org.apache.geode.test.dunit.rules.ClusterStartupRule;
import org.apache.geode.test.dunit.rules.MemberVM;
import org.apache.geode.test.junit.rules.ServerStarterRule;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Rule;

public abstract class AbstractQuerySecurityDistributedTest
implements Serializable {
    protected Object[] keys;
    protected Object[] values;
    protected MemberVM server;
    protected ClientVM superUserClient;
    protected ClientVM specificUserClient;
    protected final String regionName = "region";
    private final transient UserPermissions userPerms = new UserPermissions();
    @Rule
    public ClusterStartupRule cluster = new ClusterStartupRule();

    protected void setUpSuperUserClientAndServer(RegionShortcut regionShortcut) throws Exception {
        this.server = this.cluster.startServerVM(1, cf -> ((ServerStarterRule)((ServerStarterRule)((ServerStarterRule)cf.withSecurityManager(TestSecurityManager.class)).withProperty("security-json", "org/apache/geode/management/internal/security/clientServer.json")).withProperty("serializable-object-filter", "org.apache.geode.security.query.data.*")).withRegion(regionShortcut, "region"));
        String superUserPassword = this.userPerms.getUserPassword("super-user");
        this.superUserClient = this.cluster.startClientVM(2, ccf -> ccf.withCredential("super-user", superUserPassword).withPoolSubscription(true).withServerConnection(this.server.getPort()).withProperty("serializable-object-filter", "org.apache.geode.security.query.data.*"));
        this.superUserClient.invoke(() -> {
            Assertions.assertThat((Object)ClusterStartupRule.getClientCache()).isNotNull();
            ClusterStartupRule.getClientCache().createClientRegionFactory(ClientRegionShortcut.PROXY).create("region");
        });
    }

    protected void setUpSpecificClient(String specificUser) throws Exception {
        String specificUserPassword = this.userPerms.getUserPassword(specificUser);
        this.specificUserClient = this.cluster.startClientVM(3, ccf -> ccf.withCredential(specificUser, specificUserPassword).withPoolSubscription(true).withServerConnection(this.server.getPort()).withProperty("serializable-object-filter", "org.apache.geode.security.query.data.*"));
        this.specificUserClient.invoke(() -> {
            Assertions.assertThat((Object)ClusterStartupRule.getClientCache()).isNotNull();
            ClusterStartupRule.getClientCache().createClientRegionFactory(ClientRegionShortcut.PROXY).create("region");
        });
    }

    public void setUp(String specificUser, RegionShortcut regionShortcut) throws Exception {
        this.setUpSuperUserClientAndServer(regionShortcut);
        this.setUpSpecificClient(specificUser);
    }

    public ClientCache getClientCache() {
        return ClusterStartupRule.clientCacheRule.getCache();
    }

    protected void putIntoRegion(ClientVM vm, Object[] keys, Object[] values, String regionName) {
        vm.invoke(() -> {
            Region region = this.getClientCache().getRegion(regionName);
            ((AbstractIntegerAssert)Assertions.assertThat((int)values.length).as("The list of keys does not have the same length as the list of values.", new Object[0])).isEqualTo(keys.length);
            IntStream.range(0, keys.length).forEach(i -> region.put(keys[i], values[i]));
        });
    }

    private void assertExceptionOccurred(QueryService qs, String query, String authErrorRegexp) {
        Assertions.assertThatThrownBy(() -> qs.newQuery(query).execute()).hasMessageMatching(authErrorRegexp).hasCauseInstanceOf(NotAuthorizedException.class);
    }

    protected void assertQueryResults(ClientCache clientCache, String queryString, Object[] bindParameters, List<Object> expectedResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Query query = clientCache.getQueryService().newQuery(queryString);
        Collection results = bindParameters == null ? (Collection)query.execute() : (Collection)query.execute(bindParameters);
        Assertions.assertThat((Collection)results).isNotNull();
        ((AbstractIntegerAssert)Assertions.assertThat((int)results.size()).as("Query results size did not match expected for " + query, new Object[0])).isEqualTo(expectedResults.size());
        results.forEach(i -> ((AbstractBooleanAssert)Assertions.assertThat((boolean)expectedResults.contains(i)).as("Result:" + i + " was not found in the expectedResults", new Object[0])).isTrue());
    }

    private void assertQueryResults(ClientCache clientCache, String query, List<Object> expectedResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        this.assertQueryResults(clientCache, query, null, expectedResults);
    }

    protected void assertRegionData(ClientVM vm, List<Object> expectedRegionResults) {
        vm.invoke(() -> this.assertQueryResults(this.getClientCache(), "SELECT * FROM /region", expectedRegionResults));
    }

    protected void executeQueryAndAssertExpectedResults(ClientVM vm, String query, List<Object> expectedSuccessfulQueryResults) {
        vm.invoke(() -> this.assertQueryResults(this.getClientCache(), query, expectedSuccessfulQueryResults));
    }

    protected void executeQueryAndAssertThatNoAuthorizedExceptionWasThrown(ClientVM vm, String query, String regexForExpectedExceptions) {
        vm.invoke(() -> {
            Region region = this.getClientCache().getRegion("region");
            this.assertExceptionOccurred(this.getClientCache().getQueryService(), query, regexForExpectedExceptions);
            Pool pool = PoolManager.find((Region)region);
            this.assertExceptionOccurred(pool.getQueryService(), query, regexForExpectedExceptions);
        });
    }
}

