/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import org.apache.geode.pdx.Employee;
import org.apache.geode.pdx.TestObjectForJSONFormatter;
import org.junit.Assert;

public class JSONFormatVerifyUtility {
    static void verifyJsonWithJavaObject(String json, TestObjectForJSONFormatter testObject) throws IOException {
        JsonNode jsonObject = new ObjectMapper().readTree(json);
        Assert.assertEquals((String)"VerifyPdxInstanceToJson: Int type values are not matched", (long)testObject.getP_int(), (long)jsonObject.get(testObject.getP_intFN()).asInt());
        Assert.assertEquals((String)"VerifyPdxInstanceToJson: long type values are not matched", (long)testObject.getP_long(), (long)jsonObject.get(testObject.getP_longFN()).asLong());
        Assert.assertEquals((String)"VerifyPdxInstanceToJson: Boolean type values are not matched", (Object)testObject.getW_bool(), (Object)jsonObject.get(testObject.getW_boolFN()).asBoolean());
        Assert.assertEquals((String)"VerifyPdxInstanceToJson: Float type values are not matched", (double)testObject.getW_double(), (double)jsonObject.get(testObject.getW_doubleFN()).asDouble(), (double)0.0);
        Assert.assertEquals((String)"VerifyPdxInstanceToJson: bigDec type values are not matched", (long)testObject.getW_bigDec().longValue(), (long)jsonObject.get(testObject.getW_bigDecFN()).asLong());
        Assert.assertEquals((String)"VerifyPdxInstanceToJson: Byte[] type values are not matched", (long)testObject.getW_byteArray()[1].byteValue(), (long)jsonObject.get(testObject.getW_byteArrayFN()).get(1).asInt());
        Assert.assertEquals((String)"VerifyPdxInstanceToJson: Double[] type values are not matched", (double)testObject.getW_doubleArray()[0], (double)jsonObject.get(testObject.getW_doubleArrayFN()).get(0).asDouble(0.0), (double)0.0);
        Assert.assertEquals((String)"VerifyPdxInstanceToJson: String[] type values are not matched", (Object)testObject.getW_strArray()[2], (Object)jsonObject.get(testObject.getW_strArrayFN()).get(2).textValue());
        Assert.assertEquals((String)"VerifyPdxInstanceToJson: list type values are not matched", testObject.getC_list().get(0), (Object)jsonObject.get(testObject.getC_listFN()).get(0).textValue());
        Assert.assertEquals((String)"VerifyPdxInstanceToJson: stack type values are not matched", testObject.getC_stack().get(2), (Object)jsonObject.get(testObject.getC_stackFN()).get(2).textValue());
        Assert.assertEquals((String)"VerifyPdxInstanceToJson: Map type values are not matched", (Object)((Employee)((List)testObject.getM_empByCity().get("Ahmedabad")).get(0)).getFname(), (Object)jsonObject.get(testObject.getM_empByCityFN()).get("Ahmedabad").get(0).get("fname").asText());
        Assert.assertEquals((String)"VerifyPdxInstanceToJson: Enum type values are not matched", (Object)testObject.getDay().toString(), (Object)jsonObject.get(testObject.getDayFN()).asText());
    }
}

